/*
 * Decompiled with CFR 0.152.
 */
package kafka.shaded.api;

import java.nio.ByteBuffer;
import java.nio.channels.GatheringByteChannel;
import kafka.shaded.common.KafkaException;
import org.apache.kafka.shaded.common.network.TransportLayer;
import scala.Tuple2;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class ApiUtils$ {
    public static final ApiUtils$ MODULE$;
    private final String ProtocolEncoding;

    static {
        new ApiUtils$();
    }

    public String ProtocolEncoding() {
        return this.ProtocolEncoding;
    }

    public String readShortString(ByteBuffer buffer) {
        short size2 = buffer.getShort();
        if (size2 < 0) {
            return null;
        }
        byte[] bytes = new byte[size2];
        buffer.get(bytes);
        return new String(bytes, this.ProtocolEncoding());
    }

    public void writeShortString(ByteBuffer buffer, String string2) {
        if (string2 == null) {
            buffer.putShort((short)-1);
        } else {
            byte[] encodedString = string2.getBytes(this.ProtocolEncoding());
            if (encodedString.length > Short.MAX_VALUE) {
                throw new KafkaException(new StringBuilder().append((Object)"String exceeds the maximum size of ").append(BoxesRunTime.boxToShort((short)Short.MAX_VALUE)).append((Object)".").toString());
            }
            buffer.putShort((short)encodedString.length);
            buffer.put(encodedString);
        }
    }

    public int shortStringLength(String string2) {
        int n;
        if (string2 == null) {
            n = 2;
        } else {
            byte[] encodedString = string2.getBytes(this.ProtocolEncoding());
            if (encodedString.length > Short.MAX_VALUE) {
                throw new KafkaException(new StringBuilder().append((Object)"String exceeds the maximum size of ").append(BoxesRunTime.boxToShort((short)Short.MAX_VALUE)).append((Object)".").toString());
            }
            n = 2 + encodedString.length;
        }
        return n;
    }

    public int readIntInRange(ByteBuffer buffer, String name, Tuple2<Object, Object> range2) {
        int value2 = buffer.getInt();
        if (value2 < range2._1$mcI$sp() || value2 > range2._2$mcI$sp()) {
            throw new KafkaException(new StringBuilder().append((Object)name).append((Object)" has value ").append(BoxesRunTime.boxToInteger(value2)).append((Object)" which is not in the range ").append(range2).append((Object)".").toString());
        }
        return value2;
    }

    public short readShortInRange(ByteBuffer buffer, String name, Tuple2<Object, Object> range2) {
        short value2 = buffer.getShort();
        if (value2 < BoxesRunTime.unboxToShort(range2._1()) || value2 > BoxesRunTime.unboxToShort(range2._2())) {
            throw new KafkaException(new StringBuilder().append((Object)name).append((Object)" has value ").append(BoxesRunTime.boxToShort(value2)).append((Object)" which is not in the range ").append(range2).append((Object)".").toString());
        }
        return value2;
    }

    public long readLongInRange(ByteBuffer buffer, String name, Tuple2<Object, Object> range2) {
        long value2 = buffer.getLong();
        if (value2 < range2._1$mcJ$sp() || value2 > range2._2$mcJ$sp()) {
            throw new KafkaException(new StringBuilder().append((Object)name).append((Object)" has value ").append(BoxesRunTime.boxToLong(value2)).append((Object)" which is not in the range ").append(range2).append((Object)".").toString());
        }
        return value2;
    }

    public boolean hasPendingWrites(GatheringByteChannel channel) {
        boolean bl;
        GatheringByteChannel gatheringByteChannel = channel;
        if (gatheringByteChannel instanceof TransportLayer) {
            TransportLayer transportLayer = (TransportLayer)gatheringByteChannel;
            bl = transportLayer.hasPendingWrites();
        } else {
            bl = false;
        }
        return bl;
    }

    private ApiUtils$() {
        MODULE$ = this;
        this.ProtocolEncoding = "UTF-8";
    }
}

