/*
 * Decompiled with CFR 0.152.
 */
package kafka.shaded.admin;

import joptsimple.OptionSpec;
import joptsimple.OptionSpecBuilder;
import kafka.shaded.admin.AdminUtils$;
import kafka.shaded.admin.BrokerMetadata;
import kafka.shaded.admin.RackAwareMode;
import kafka.shaded.admin.RackAwareMode$Disabled$;
import kafka.shaded.admin.RackAwareMode$Enforced$;
import kafka.shaded.admin.ReassignPartitionsCommand;
import kafka.shaded.admin.ReassignmentCompleted$;
import kafka.shaded.admin.ReassignmentFailed$;
import kafka.shaded.admin.ReassignmentInProgress$;
import kafka.shaded.admin.ReassignmentStatus;
import kafka.shaded.common.AdminCommandFailedException;
import kafka.shaded.common.TopicAndPartition;
import kafka.shaded.controller.ReassignedPartitionsContext;
import kafka.shaded.utils.CommandLineUtils$;
import kafka.shaded.utils.CoreUtils$;
import kafka.shaded.utils.Log4jController$;
import kafka.shaded.utils.Logging;
import kafka.shaded.utils.Logging$class;
import kafka.shaded.utils.ZkUtils;
import kafka.shaded.utils.ZkUtils$;
import org.I0Itec.zkclient.ZkClient;
import org.apache.kafka.shaded.common.security.JaasUtils;
import org.apache.kafka.shaded.common.utils.Utils;
import org.apache.log4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class ReassignPartitionsCommand$
implements Logging {
    public static final ReassignPartitionsCommand$ MODULE$;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    static {
        new ReassignPartitionsCommand$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ReassignPartitionsCommand$ reassignPartitionsCommand$ = this;
        synchronized (reassignPartitionsCommand$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void main(String[] args) {
        ZkClient zkClient2;
        ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts = new ReassignPartitionsCommand.ReassignPartitionsCommandOptions(args);
        int actions = ((TraversableOnce)Seq$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new OptionSpecBuilder[]{opts.generateOpt(), opts.executeOpt(), opts.verifyOpt()}))).count(new Serializable(opts){
            public static final long serialVersionUID = 0L;
            private final ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts$1;

            public final boolean apply(OptionSpec<?> x$1) {
                return this.opts$1.options().has(x$1);
            }
            {
                this.opts$1 = opts$1;
            }
        });
        if (actions != 1) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "Command must include exactly one action: --generate, --execute or --verify");
        }
        CommandLineUtils$.MODULE$.checkRequiredArgs(opts.parser(), opts.options(), Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{opts.zkConnectOpt()}));
        String zkConnect = opts.options().valueOf(opts.zkConnectOpt());
        ZkUtils zkUtils = ZkUtils$.MODULE$.apply(zkConnect, 30000, 30000, JaasUtils.isZkSecurityEnabled());
        try {
            if (opts.options().has(opts.verifyOpt())) {
                this.verifyAssignment(zkUtils, opts);
            } else if (opts.options().has(opts.generateOpt())) {
                this.generateAssignment(zkUtils, opts);
            } else if (opts.options().has(opts.executeOpt())) {
                this.executeAssignment(zkUtils, opts);
            }
            zkClient2 = zkUtils.zkClient();
            if (zkClient2 == null) return;
        }
        catch (Throwable throwable) {
            try {
                Predef$.MODULE$.println(new StringBuilder().append((Object)"Partitions reassignment failed due to ").append((Object)throwable.getMessage()).toString());
                Predef$.MODULE$.println(Utils.stackTrace(throwable));
            }
            finally {
                ZkClient zkClient2 = zkUtils.zkClient();
                if (zkClient2 == null) return;
                zkClient2.close();
            }
        }
        zkClient2.close();
    }

    public void verifyAssignment(ZkUtils zkUtils, ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts) {
        if (opts.options().has(opts.reassignmentJsonFileOpt())) {
            String jsonFile = opts.options().valueOf(opts.reassignmentJsonFileOpt());
            String jsonString = Utils.readFileAsString(jsonFile);
            Map<TopicAndPartition, Seq<Object>> partitionsToBeReassigned = zkUtils.parsePartitionReassignmentData(jsonString);
            Predef$.MODULE$.println("Status of partition reassignment:");
            Map<TopicAndPartition, ReassignmentStatus> reassignedPartitionsStatus = this.checkIfReassignmentSucceeded(zkUtils, partitionsToBeReassigned);
            reassignedPartitionsStatus.foreach(new Serializable(){
                public static final long serialVersionUID = 0L;

                public final void apply(Tuple2<TopicAndPartition, ReassignmentStatus> partition2) {
                    ReassignmentStatus reassignmentStatus;
                    block5: {
                        block3: {
                            block4: {
                                block2: {
                                    reassignmentStatus = partition2._2();
                                    ReassignmentCompleted$ reassignmentCompleted$ = ReassignmentCompleted$.MODULE$;
                                    ReassignmentStatus reassignmentStatus2 = reassignmentStatus;
                                    if (reassignmentCompleted$ != null ? !reassignmentCompleted$.equals(reassignmentStatus2) : reassignmentStatus2 != null) break block2;
                                    Predef$.MODULE$.println(new StringOps(Predef$.MODULE$.augmentString("Reassignment of partition %s completed successfully")).format(Predef$.MODULE$.genericWrapArray(new Object[]{partition2._1()})));
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                    break block3;
                                }
                                ReassignmentFailed$ reassignmentFailed$ = ReassignmentFailed$.MODULE$;
                                ReassignmentStatus reassignmentStatus3 = reassignmentStatus;
                                if (reassignmentFailed$ != null ? !reassignmentFailed$.equals(reassignmentStatus3) : reassignmentStatus3 != null) break block4;
                                Predef$.MODULE$.println(new StringOps(Predef$.MODULE$.augmentString("Reassignment of partition %s failed")).format(Predef$.MODULE$.genericWrapArray(new Object[]{partition2._1()})));
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                break block3;
                            }
                            ReassignmentInProgress$ reassignmentInProgress$ = ReassignmentInProgress$.MODULE$;
                            ReassignmentStatus reassignmentStatus4 = reassignmentStatus;
                            if (reassignmentInProgress$ != null ? !reassignmentInProgress$.equals(reassignmentStatus4) : reassignmentStatus4 != null) break block5;
                            Predef$.MODULE$.println(new StringOps(Predef$.MODULE$.augmentString("Reassignment of partition %s is still in progress")).format(Predef$.MODULE$.genericWrapArray(new Object[]{partition2._1()})));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                        return;
                    }
                    throw new MatchError(reassignmentStatus);
                }
            });
            return;
        }
        throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "If --verify option is used, command must include --reassignment-json-file that was used during the --execute option");
    }

    public void generateAssignment(ZkUtils zkUtils, ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts) {
        if (opts.options().has(opts.topicsToMoveJsonFileOpt()) && opts.options().has(opts.brokerListOpt())) {
            String topicsToMoveJsonFile = opts.options().valueOf(opts.topicsToMoveJsonFileOpt());
            int[] brokerListToReassign = (int[])Predef$.MODULE$.refArrayOps((Object[])new StringOps(Predef$.MODULE$.augmentString(opts.options().valueOf(opts.brokerListOpt()))).split(',')).map(new Serializable(){
                public static final long serialVersionUID = 0L;

                public final int apply(String x$1) {
                    return new StringOps(Predef$.MODULE$.augmentString(x$1)).toInt();
                }
            }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()));
            Iterable<Object> duplicateReassignments = CoreUtils$.MODULE$.duplicates(Predef$.MODULE$.wrapIntArray(brokerListToReassign));
            if (duplicateReassignments.nonEmpty()) {
                throw new AdminCommandFailedException(new StringOps(Predef$.MODULE$.augmentString("Broker list contains duplicate entries: %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{duplicateReassignments.mkString(",")})));
            }
            String topicsToMoveJsonString = Utils.readFileAsString(topicsToMoveJsonFile);
            boolean disableRackAware = opts.options().has(opts.disableRackAware());
            Tuple2<Map<TopicAndPartition, Seq<Object>>, Map<TopicAndPartition, Seq<Object>>> tuple2 = this.generateAssignment(zkUtils, Predef$.MODULE$.wrapIntArray(brokerListToReassign), topicsToMoveJsonString, disableRackAware);
            if (tuple2 != null) {
                Tuple2<Map<TopicAndPartition, Seq<Object>>, Map<TopicAndPartition, Seq<Object>>> tuple22;
                Map<TopicAndPartition, Seq<Object>> proposedAssignments = tuple2._1();
                Map<TopicAndPartition, Seq<Object>> currentAssignments = tuple2._2();
                Tuple2<Map<TopicAndPartition, Seq<Object>>, Map<TopicAndPartition, Seq<Object>>> tuple23 = tuple22 = new Tuple2<Map<TopicAndPartition, Seq<Object>>, Map<TopicAndPartition, Seq<Object>>>(proposedAssignments, currentAssignments);
                Map<TopicAndPartition, Seq<Object>> proposedAssignments2 = tuple23._1();
                Map<TopicAndPartition, Seq<Object>> currentAssignments2 = tuple23._2();
                Predef$.MODULE$.println(new StringOps(Predef$.MODULE$.augmentString("Current partition replica assignment\n\n%s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{zkUtils.formatAsReassignmentJson(currentAssignments2)})));
                Predef$.MODULE$.println(new StringOps(Predef$.MODULE$.augmentString("Proposed partition reassignment configuration\n\n%s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{zkUtils.formatAsReassignmentJson(proposedAssignments2)})));
                return;
            }
            throw new MatchError(tuple2);
        }
        throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "If --generate option is used, command must include both --topics-to-move-json-file and --broker-list options");
    }

    public Tuple2<Map<TopicAndPartition, Seq<Object>>, Map<TopicAndPartition, Seq<Object>>> generateAssignment(ZkUtils zkUtils, Seq<Object> brokerListToReassign, String topicsToMoveJsonString, boolean disableRackAware) {
        Seq<String> topicsToReassign = zkUtils.parseTopicsData(topicsToMoveJsonString);
        Iterable<String> duplicateTopicsToReassign = CoreUtils$.MODULE$.duplicates(topicsToReassign);
        if (duplicateTopicsToReassign.nonEmpty()) {
            throw new AdminCommandFailedException(new StringOps(Predef$.MODULE$.augmentString("List of topics to reassign contains duplicate entries: %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{duplicateTopicsToReassign.mkString(",")})));
        }
        scala.collection.mutable.Map<TopicAndPartition, Seq<Object>> currentAssignment = zkUtils.getReplicaAssignmentForTopics(topicsToReassign);
        scala.collection.immutable.Map groupedByTopic = currentAssignment.groupBy(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<TopicAndPartition, Seq<Object>> x0$1) {
                Tuple2<TopicAndPartition, Seq<Object>> tuple2 = x0$1;
                if (tuple2 != null) {
                    TopicAndPartition tp = tuple2._1();
                    String string2 = tp.topic();
                    return string2;
                }
                throw new MatchError(tuple2);
            }
        });
        Serializable rackAwareMode = disableRackAware ? RackAwareMode$Disabled$.MODULE$ : RackAwareMode$Enforced$.MODULE$;
        Seq<BrokerMetadata> brokerMetadatas = AdminUtils$.MODULE$.getBrokerMetadatas(zkUtils, (RackAwareMode)((Object)rackAwareMode), (Option<Seq<Object>>)new Some<Seq<Object>>(brokerListToReassign));
        scala.collection.mutable.Map partitionsToBeReassigned = (scala.collection.mutable.Map)Map$.MODULE$.apply(Nil$.MODULE$);
        groupedByTopic.foreach(new Serializable(brokerMetadatas, partitionsToBeReassigned){
            public static final long serialVersionUID = 0L;
            private final Seq brokerMetadatas$1;
            private final scala.collection.mutable.Map partitionsToBeReassigned$2;

            public final scala.collection.mutable.Map<TopicAndPartition, Seq<Object>> apply(Tuple2<String, scala.collection.mutable.Map<TopicAndPartition, Seq<Object>>> x0$2) {
                Tuple2<String, scala.collection.mutable.Map<TopicAndPartition, Seq<Object>>> tuple2 = x0$2;
                if (tuple2 != null) {
                    String topic = tuple2._1();
                    scala.collection.mutable.Map<TopicAndPartition, Seq<Object>> assignment = tuple2._2();
                    Tuple2 tuple22 = (Tuple2)assignment.head();
                    if (tuple22 != null) {
                        Seq replicas;
                        Seq seq;
                        Seq replicas2 = seq = (replicas = (Seq)tuple22._2());
                        Map<Object, Seq<Object>> assignedReplicas = AdminUtils$.MODULE$.assignReplicasToBrokers(this.brokerMetadatas$1, assignment.size(), replicas2.size(), AdminUtils$.MODULE$.assignReplicasToBrokers$default$4(), AdminUtils$.MODULE$.assignReplicasToBrokers$default$5());
                        scala.collection.mutable.Map map2 = (scala.collection.mutable.Map)this.partitionsToBeReassigned$2.$plus$plus$eq((TraversableOnce)assignedReplicas.map((Function1<Object, Seq<Object>>)((Object)new Serializable(this, topic){
                            public static final long serialVersionUID = 0L;
                            private final String topic$1;

                            public final Tuple2<TopicAndPartition, Seq<Object>> apply(Tuple2<Object, Seq<Object>> x0$3) {
                                Tuple2<Object, Seq<Object>> tuple2 = x0$3;
                                if (tuple2 != null) {
                                    int partition2 = tuple2._1$mcI$sp();
                                    Seq<Object> replicas = tuple2._2();
                                    Tuple2<TopicAndPartition, Seq<Object>> tuple22 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc(new TopicAndPartition(this.topic$1, partition2)), replicas);
                                    return tuple22;
                                }
                                throw new MatchError(tuple2);
                            }
                            {
                                this.topic$1 = topic$1;
                            }
                        }), scala.collection.Map$.MODULE$.canBuildFrom()));
                        return map2;
                    }
                    throw new MatchError(tuple22);
                }
                throw new MatchError(tuple2);
            }
            {
                this.brokerMetadatas$1 = brokerMetadatas$1;
                this.partitionsToBeReassigned$2 = partitionsToBeReassigned$2;
            }
        });
        return new Tuple2<Map<TopicAndPartition, Seq<Object>>, Map<TopicAndPartition, Seq<Object>>>(partitionsToBeReassigned, currentAssignment);
    }

    public void executeAssignment(ZkUtils zkUtils, ReassignPartitionsCommand.ReassignPartitionsCommandOptions opts) {
        if (opts.options().has(opts.reassignmentJsonFileOpt())) {
            String reassignmentJsonFile = opts.options().valueOf(opts.reassignmentJsonFileOpt());
            String reassignmentJsonString = Utils.readFileAsString(reassignmentJsonFile);
            this.executeAssignment(zkUtils, reassignmentJsonString);
            return;
        }
        throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "If --execute option is used, command must include --reassignment-json-file that was output during the --generate option");
    }

    public void executeAssignment(ZkUtils zkUtils, String reassignmentJsonString) {
        Seq<Tuple2<TopicAndPartition, Seq<Object>>> partitionsToBeReassigned = zkUtils.parsePartitionReassignmentDataWithoutDedup(reassignmentJsonString);
        if (partitionsToBeReassigned.isEmpty()) {
            throw new AdminCommandFailedException("Partition reassignment data file is empty");
        }
        Iterable duplicateReassignedPartitions = CoreUtils$.MODULE$.duplicates(partitionsToBeReassigned.map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final TopicAndPartition apply(Tuple2<TopicAndPartition, Seq<Object>> x0$4) {
                Tuple2<TopicAndPartition, Seq<Object>> tuple2 = x0$4;
                if (tuple2 != null) {
                    TopicAndPartition tp;
                    TopicAndPartition topicAndPartition = tp = tuple2._1();
                    return topicAndPartition;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom()));
        if (duplicateReassignedPartitions.nonEmpty()) {
            throw new AdminCommandFailedException(new StringOps(Predef$.MODULE$.augmentString("Partition reassignment contains duplicate topic partitions: %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{duplicateReassignedPartitions.mkString(",")})));
        }
        Seq duplicateEntries = (Seq)((TraversableLike)partitionsToBeReassigned.map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Tuple2<TopicAndPartition, Iterable<Object>> apply(Tuple2<TopicAndPartition, Seq<Object>> x0$5) {
                Tuple2<TopicAndPartition, Seq<Object>> tuple2 = x0$5;
                if (tuple2 != null) {
                    TopicAndPartition tp = tuple2._1();
                    Seq<Object> replicas = tuple2._2();
                    Tuple2<TopicAndPartition, Iterable<Object>> tuple22 = new Tuple2<TopicAndPartition, Iterable<Object>>(tp, CoreUtils$.MODULE$.duplicates(replicas));
                    return tuple22;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom())).filter(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<TopicAndPartition, Iterable<Object>> x0$6) {
                Tuple2<TopicAndPartition, Iterable<Object>> tuple2 = x0$6;
                if (tuple2 != null) {
                    Iterable<Object> duplicatedReplicas = tuple2._2();
                    boolean bl = duplicatedReplicas.nonEmpty();
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        });
        if (duplicateEntries.nonEmpty()) {
            String duplicatesMsg = ((TraversableOnce)duplicateEntries.map(new Serializable(){
                public static final long serialVersionUID = 0L;

                public final String apply(Tuple2<TopicAndPartition, Iterable<Object>> x0$7) {
                    Tuple2<TopicAndPartition, Iterable<Object>> tuple2 = x0$7;
                    if (tuple2 != null) {
                        TopicAndPartition tp = tuple2._1();
                        Iterable<Object> duplicateReplicas = tuple2._2();
                        String string2 = new StringOps(Predef$.MODULE$.augmentString("%s contains multiple entries for %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{tp, duplicateReplicas.mkString(",")}));
                        return string2;
                    }
                    throw new MatchError(tuple2);
                }
            }, Seq$.MODULE$.canBuildFrom())).mkString(". ");
            throw new AdminCommandFailedException(new StringOps(Predef$.MODULE$.augmentString("Partition replica lists may not contain duplicate entries: %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{duplicatesMsg})));
        }
        ReassignPartitionsCommand reassignPartitionsCommand = new ReassignPartitionsCommand(zkUtils, partitionsToBeReassigned.toMap(Predef$.MODULE$.conforms()));
        scala.collection.mutable.Map<TopicAndPartition, Seq<Object>> currentPartitionReplicaAssignment = zkUtils.getReplicaAssignmentForTopics(partitionsToBeReassigned.map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<TopicAndPartition, Seq<Object>> x$3) {
                return x$3._1().topic();
            }
        }, Seq$.MODULE$.canBuildFrom()));
        Predef$.MODULE$.println(new StringOps(Predef$.MODULE$.augmentString("Current partition replica assignment\n\n%s\n\nSave this to use as the --reassignment-json-file option during rollback")).format(Predef$.MODULE$.genericWrapArray(new Object[]{zkUtils.formatAsReassignmentJson(currentPartitionReplicaAssignment)})));
        if (reassignPartitionsCommand.reassignPartitions()) {
            Predef$.MODULE$.println(new StringOps(Predef$.MODULE$.augmentString("Successfully started reassignment of partitions %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{zkUtils.formatAsReassignmentJson(partitionsToBeReassigned.toMap(Predef$.MODULE$.conforms()))})));
        } else {
            Predef$.MODULE$.println(new StringOps(Predef$.MODULE$.augmentString("Failed to reassign partitions %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{partitionsToBeReassigned})));
        }
    }

    private Map<TopicAndPartition, ReassignmentStatus> checkIfReassignmentSucceeded(ZkUtils zkUtils, Map<TopicAndPartition, Seq<Object>> partitionsToBeReassigned) {
        Map partitionsBeingReassigned = zkUtils.getPartitionsBeingReassigned().mapValues(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Seq<Object> apply(ReassignedPartitionsContext x$4) {
                return x$4.newReplicas();
            }
        });
        return partitionsToBeReassigned.map((Function1<TopicAndPartition, Seq<Object>>)((Object)new Serializable(zkUtils, partitionsToBeReassigned, partitionsBeingReassigned){
            public static final long serialVersionUID = 0L;
            private final ZkUtils zkUtils$1;
            private final Map partitionsToBeReassigned$1;
            private final Map partitionsBeingReassigned$1;

            public final Tuple2<TopicAndPartition, ReassignmentStatus> apply(Tuple2<TopicAndPartition, Seq<Object>> topicAndPartition) {
                return new Tuple2<TopicAndPartition, ReassignmentStatus>(topicAndPartition._1(), ReassignPartitionsCommand$.MODULE$.checkIfPartitionReassignmentSucceeded(this.zkUtils$1, topicAndPartition._1(), topicAndPartition._2(), this.partitionsToBeReassigned$1, this.partitionsBeingReassigned$1));
            }
            {
                this.zkUtils$1 = zkUtils$1;
                this.partitionsToBeReassigned$1 = partitionsToBeReassigned$1;
                this.partitionsBeingReassigned$1 = partitionsBeingReassigned$1;
            }
        }), scala.collection.Map$.MODULE$.canBuildFrom());
    }

    public ReassignmentStatus checkIfPartitionReassignmentSucceeded(ZkUtils zkUtils, TopicAndPartition topicAndPartition, Seq<Object> reassignedReplicas, Map<TopicAndPartition, Seq<Object>> partitionsToBeReassigned, Map<TopicAndPartition, Seq<Object>> partitionsBeingReassigned) {
        Option option;
        block7: {
            Serializable serializable2;
            block6: {
                Serializable serializable3;
                Seq<Object> assignedReplicas;
                Seq newReplicas;
                block5: {
                    newReplicas = (Seq)partitionsToBeReassigned.apply(topicAndPartition);
                    option = partitionsBeingReassigned.get(topicAndPartition);
                    if (!(option instanceof Some)) break block5;
                    serializable2 = ReassignmentInProgress$.MODULE$;
                    break block6;
                }
                None$ none$ = None$.MODULE$;
                Option option2 = option;
                if (none$ != null ? !none$.equals(option2) : option2 != null) break block7;
                Seq<Object> seq = assignedReplicas = zkUtils.getReplicasForPartition(topicAndPartition.topic(), topicAndPartition.partition());
                Seq seq2 = newReplicas;
                if (!(seq != null ? !seq.equals(seq2) : seq2 != null)) {
                    serializable3 = ReassignmentCompleted$.MODULE$;
                } else {
                    Predef$.MODULE$.println(new StringOps(Predef$.MODULE$.augmentString("ERROR: Assigned replicas (%s) don't match the list of replicas for reassignment (%s) for partition %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{assignedReplicas.mkString(","), newReplicas.mkString(","), topicAndPartition})));
                    serializable3 = ReassignmentFailed$.MODULE$;
                }
                serializable2 = serializable3;
            }
            return serializable2;
        }
        throw new MatchError(option);
    }

    private ReassignPartitionsCommand$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

