/*
 * Decompiled with CFR 0.152.
 */
package kafka.shaded.admin;

import java.net.InetSocketAddress;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.shaded.admin.AdminClient;
import org.apache.kafka.shaded.clients.ClientUtils;
import org.apache.kafka.shaded.clients.CommonClientConfigs;
import org.apache.kafka.shaded.clients.Metadata;
import org.apache.kafka.shaded.clients.NetworkClient;
import org.apache.kafka.shaded.clients.consumer.internals.ConsumerNetworkClient;
import org.apache.kafka.shaded.common.Cluster;
import org.apache.kafka.shaded.common.config.ConfigDef;
import org.apache.kafka.shaded.common.metrics.Metrics;
import org.apache.kafka.shaded.common.network.ChannelBuilder;
import org.apache.kafka.shaded.common.network.Selectable;
import org.apache.kafka.shaded.common.network.Selector;
import org.apache.kafka.shaded.common.utils.SystemTime;
import org.apache.kafka.shaded.common.utils.Time;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxesRunTime;

public final class AdminClient$ {
    public static final AdminClient$ MODULE$;
    private final int DefaultConnectionMaxIdleMs;
    private final int DefaultRequestTimeoutMs;
    private final int DefaultMaxInFlightRequestsPerConnection;
    private final int DefaultReconnectBackoffMs;
    private final int DefaultSendBufferBytes;
    private final int DefaultReceiveBufferBytes;
    private final int DefaultRetryBackoffMs;
    private final AtomicInteger AdminClientIdSequence;
    private final ConfigDef AdminConfigDef;

    static {
        new AdminClient$();
    }

    public int DefaultConnectionMaxIdleMs() {
        return this.DefaultConnectionMaxIdleMs;
    }

    public int DefaultRequestTimeoutMs() {
        return this.DefaultRequestTimeoutMs;
    }

    public int DefaultMaxInFlightRequestsPerConnection() {
        return this.DefaultMaxInFlightRequestsPerConnection;
    }

    public int DefaultReconnectBackoffMs() {
        return this.DefaultReconnectBackoffMs;
    }

    public int DefaultSendBufferBytes() {
        return this.DefaultSendBufferBytes;
    }

    public int DefaultReceiveBufferBytes() {
        return this.DefaultReceiveBufferBytes;
    }

    public int DefaultRetryBackoffMs() {
        return this.DefaultRetryBackoffMs;
    }

    public AtomicInteger AdminClientIdSequence() {
        return this.AdminClientIdSequence;
    }

    public ConfigDef AdminConfigDef() {
        return this.AdminConfigDef;
    }

    public AdminClient createSimplePlaintext(String brokerUrl) {
        Map config = (Map)Predef$.MODULE$.Map().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc("bootstrap.servers"), brokerUrl)}));
        return this.create(new AdminClient.AdminConfig(config));
    }

    public AdminClient create(Properties props) {
        return this.create(((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()).toMap(Predef$.MODULE$.conforms()));
    }

    public AdminClient create(Map<String, Object> props) {
        return this.create(new AdminClient.AdminConfig(props));
    }

    public AdminClient create(AdminClient.AdminConfig config) {
        SystemTime time = new SystemTime();
        Metrics metrics = new Metrics(time);
        Metadata metadata = new Metadata();
        ChannelBuilder channelBuilder = ClientUtils.createChannelBuilder(config.values());
        List<String> brokerUrls = config.getList("bootstrap.servers");
        List<InetSocketAddress> brokerAddresses = ClientUtils.parseAndValidateAddresses(brokerUrls);
        Cluster bootstrapCluster = Cluster.bootstrap(brokerAddresses);
        metadata.update(bootstrapCluster, 0L);
        Selector selector = new Selector(this.DefaultConnectionMaxIdleMs(), metrics, time, "admin", channelBuilder);
        NetworkClient networkClient = new NetworkClient((Selectable)selector, metadata, new StringBuilder().append((Object)"admin-").append(BoxesRunTime.boxToInteger(this.AdminClientIdSequence().getAndIncrement())).toString(), this.DefaultMaxInFlightRequestsPerConnection(), (long)this.DefaultReconnectBackoffMs(), this.DefaultSendBufferBytes(), this.DefaultReceiveBufferBytes(), this.DefaultRequestTimeoutMs(), (Time)time);
        ConsumerNetworkClient highLevelClient = new ConsumerNetworkClient(networkClient, metadata, time, this.DefaultRetryBackoffMs(), this.DefaultRequestTimeoutMs());
        return new AdminClient(time, this.DefaultRequestTimeoutMs(), highLevelClient, ((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(bootstrapCluster.nodes()).asScala()).toList());
    }

    /*
     * WARNING - void declaration
     */
    private AdminClient$() {
        void var1_1;
        MODULE$ = this;
        this.DefaultConnectionMaxIdleMs = 540000;
        this.DefaultRequestTimeoutMs = 5000;
        this.DefaultMaxInFlightRequestsPerConnection = 100;
        this.DefaultReconnectBackoffMs = 50;
        this.DefaultSendBufferBytes = 131072;
        this.DefaultReceiveBufferBytes = 32768;
        this.DefaultRetryBackoffMs = 100;
        this.AdminClientIdSequence = new AtomicInteger(1);
        ConfigDef config = new ConfigDef().define("bootstrap.servers", ConfigDef.Type.LIST, ConfigDef.Importance.HIGH, "A list of host/port pairs to use for establishing the initial connection to the Kafka cluster. The client will make use of all servers irrespective of which servers are specified here for bootstrapping&mdash;this list only impacts the initial hosts used to discover the full set of servers. This list should be in the form <code>host1:port1,host2:port2,...</code>. Since these servers are just used for the initial connection to discover the full cluster membership (which may change dynamically), this list need not contain the full set of servers (you may want more than one, though, in case a server is down).").define("security.protocol", ConfigDef.Type.STRING, "PLAINTEXT", ConfigDef.Importance.MEDIUM, CommonClientConfigs.SECURITY_PROTOCOL_DOC).withClientSslSupport().withClientSaslSupport();
        this.AdminConfigDef = var1_1;
    }
}

