/*
 * Decompiled with CFR 0.152.
 */
package kafka.shaded.admin;

import java.util.Properties;
import joptsimple.ArgumentAcceptingOptionSpec;
import kafka.shaded.admin.AclCommand;
import kafka.shaded.admin.AclCommand$;
import kafka.shaded.admin.AclCommand$$anonfun$getAcls$1$;
import kafka.shaded.admin.AclCommand$$anonfun$upgradeAclsToNewFormat$1$$anonfun$apply$11$;
import kafka.shaded.admin.AclCommand$$anonfun$upgradeAclsToNewFormat$1$$anonfun$apply$11$$anonfun$apply$12$;
import kafka.shaded.admin.AclCommand$$anonfun$upgradeAclsToNewFormat$1$$anonfun$apply$11$$anonfun$apply$12$$anonfun$apply$13$;
import kafka.shaded.security.auth.Acl;
import kafka.shaded.security.auth.Acl$;
import kafka.shaded.security.auth.All$;
import kafka.shaded.security.auth.Allow$;
import kafka.shaded.security.auth.Alter$;
import kafka.shaded.security.auth.Authorizer;
import kafka.shaded.security.auth.Cluster$;
import kafka.shaded.security.auth.ClusterAction$;
import kafka.shaded.security.auth.Create$;
import kafka.shaded.security.auth.Delete$;
import kafka.shaded.security.auth.Deny$;
import kafka.shaded.security.auth.Describe$;
import kafka.shaded.security.auth.Group$;
import kafka.shaded.security.auth.Operation;
import kafka.shaded.security.auth.Operation$;
import kafka.shaded.security.auth.PermissionType;
import kafka.shaded.security.auth.Read$;
import kafka.shaded.security.auth.Resource;
import kafka.shaded.security.auth.Resource$;
import kafka.shaded.security.auth.ResourceType;
import kafka.shaded.security.auth.ResourceType$;
import kafka.shaded.security.auth.SimpleAclAuthorizer$;
import kafka.shaded.security.auth.Topic$;
import kafka.shaded.security.auth.Write$;
import kafka.shaded.server.KafkaConfig;
import kafka.shaded.server.KafkaConfig$;
import kafka.shaded.utils.CommandLineUtils$;
import kafka.shaded.utils.CoreUtils$;
import kafka.shaded.utils.Json$;
import kafka.shaded.utils.ZkUtils;
import kafka.shaded.utils.ZkUtils$;
import org.apache.kafka.shaded.common.security.JaasUtils;
import org.apache.kafka.shaded.common.security.auth.KafkaPrincipal;
import org.apache.kafka.shaded.common.utils.Utils;
import scala.Console$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenMap;
import scala.collection.GenTraversable;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.generic.Subtractable;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.collection.immutable.Set;
import scala.collection.immutable.Set$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.Properties$;

public final class AclCommand$ {
    public static final AclCommand$ MODULE$;
    private final String Newline;
    private final Map<ResourceType, Set<Operation>> ResourceTypeToValidOperations;

    static {
        new AclCommand$();
    }

    public String Newline() {
        return this.Newline;
    }

    public Map<ResourceType, Set<Operation>> ResourceTypeToValidOperations() {
        return this.ResourceTypeToValidOperations;
    }

    public void main(String[] args) {
        AclCommand.AclCommandOptions opts = new AclCommand.AclCommandOptions(args);
        if (opts.options().has(opts.helpOpt())) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "Usage:");
        }
        opts.checkArgs();
        try {
            if (opts.options().has(opts.addOpt())) {
                this.addAcl(opts);
            } else if (opts.options().has(opts.removeOpt())) {
                this.removeAcl(opts);
            } else if (opts.options().has(opts.listOpt())) {
                this.kafka$admin$AclCommand$$listAcl(opts);
            }
        }
        catch (Throwable throwable) {
            Predef$.MODULE$.println(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Error while executing ACL command: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{throwable.getMessage()})));
            Predef$.MODULE$.println(Utils.stackTrace(throwable));
            System.exit(-1);
        }
    }

    public void withAuthorizer(AclCommand.AclCommandOptions opts, Function1<Authorizer, BoxedUnit> f) {
        GenMap authorizerProperties;
        GenMap genMap;
        if (opts.options().has(opts.authorizerPropertiesOpt())) {
            Buffer<String> authorizerProperties2 = JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(opts.authorizerPropertiesOpt())).asScala();
            genMap = JavaConverters$.MODULE$.propertiesAsScalaMapConverter(CommandLineUtils$.MODULE$.parseKeyValueArgs(authorizerProperties2, false)).asScala();
        } else {
            genMap = authorizerProperties = Map$.MODULE$.empty();
        }
        if (opts.options().has(opts.upgradeAclsOpt())) {
            this.upgradeAclsToNewFormat((Map<String, Object>)authorizerProperties);
        }
        String authorizerClass = opts.options().valueOf(opts.authorizerOpt());
        Authorizer authZ = (Authorizer)CoreUtils$.MODULE$.createObject(authorizerClass, Predef$.MODULE$.wrapRefArray(new Object[0]));
        try {
            authZ.configure(JavaConverters$.MODULE$.mapAsJavaMapConverter(authorizerProperties).asJava());
            f.apply(authZ);
            if (opts.options().has(opts.downgradeAclsOpt())) {
                this.downgradeAclsToOldFormat((Map<String, Object>)authorizerProperties, authZ);
            }
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)((Object)new Serializable(authZ){
                public static final long serialVersionUID = 0L;
                private final Authorizer authZ$1;

                public final void apply() {
                    this.apply$mcV$sp();
                }

                public void apply$mcV$sp() {
                    this.authZ$1.close();
                }
                {
                    this.authZ$1 = authZ$1;
                }
            }));
            return;
        }
        catch (Throwable throwable) {
            CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)((Object)new /* invalid duplicate definition of identical inner class */));
            throw throwable;
        }
    }

    private void addAcl(AclCommand.AclCommandOptions opts) {
        this.withAuthorizer(opts, (Function1<Authorizer, BoxedUnit>)((Object)new Serializable(opts){
            public static final long serialVersionUID = 0L;
            private final AclCommand.AclCommandOptions opts$1;

            public final void apply(Authorizer authorizer) {
                Map<Resource, Set<Acl>> resourceToAcl = AclCommand$.MODULE$.kafka$admin$AclCommand$$getResourceToAcls(this.opts$1);
                if (resourceToAcl.values().exists(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Set<Acl> x$1) {
                        return x$1.isEmpty();
                    }
                })) {
                    throw CommandLineUtils$.MODULE$.printUsageAndDie(this.opts$1.parser(), "You must specify one of: --allow-principal, --deny-principal when trying to add ACLs.");
                }
                resourceToAcl.withFilter((Function1<Resource, Object>)((Object)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<Resource, Set<Acl>> check$ifrefutable$1) {
                        Tuple2<Resource, Set<Acl>> tuple2 = check$ifrefutable$1;
                        boolean bl = tuple2 != null;
                        return bl;
                    }
                })).foreach(new Serializable(this, authorizer, resourceToAcl){
                    public static final long serialVersionUID = 0L;
                    private final Authorizer authorizer$1;
                    private final Map resourceToAcl$1;

                    public final void apply(Tuple2<Resource, Set<Acl>> x$3) {
                        Tuple2<Resource, Set<Acl>> tuple2 = x$3;
                        if (tuple2 != null) {
                            Resource resource = tuple2._1();
                            Set acls = (Set)this.resourceToAcl$1.apply(resource);
                            Predef$.MODULE$.println(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Adding ACLs for resource `", "`: ", " ", " ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{resource, AclCommand$.MODULE$.Newline(), ((TraversableOnce)acls.map(new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply(Acl x$2) {
                                    return new StringBuilder().append((Object)"\t").append(x$2).toString();
                                }
                            }, Set$.MODULE$.canBuildFrom())).mkString(AclCommand$.MODULE$.Newline()), AclCommand$.MODULE$.Newline()})));
                            this.authorizer$1.addAcls(acls, resource);
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.authorizer$1 = authorizer$1;
                        this.resourceToAcl$1 = resourceToAcl$1;
                    }
                });
                AclCommand$.MODULE$.kafka$admin$AclCommand$$listAcl(this.opts$1);
            }
            {
                this.opts$1 = opts$1;
            }
        }));
    }

    private void removeAcl(AclCommand.AclCommandOptions opts) {
        this.withAuthorizer(opts, (Function1<Authorizer, BoxedUnit>)((Object)new Serializable(opts){
            public static final long serialVersionUID = 0L;
            private final AclCommand.AclCommandOptions opts$2;

            public final void apply(Authorizer authorizer) {
                Map<Resource, Set<Acl>> resourceToAcl = AclCommand$.MODULE$.kafka$admin$AclCommand$$getResourceToAcls(this.opts$2);
                resourceToAcl.withFilter((Function1<Resource, Object>)((Object)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<Resource, Set<Acl>> check$ifrefutable$2) {
                        Tuple2<Resource, Set<Acl>> tuple2 = check$ifrefutable$2;
                        boolean bl = tuple2 != null;
                        return bl;
                    }
                })).foreach(new Serializable(this, authorizer){
                    public static final long serialVersionUID = 0L;
                    private final Authorizer authorizer$2;

                    public final Object apply(Tuple2<Resource, Set<Acl>> x$5) {
                        Tuple2<Resource, Set<Acl>> tuple2 = x$5;
                        if (tuple2 != null) {
                            Resource resource = tuple2._1();
                            Set<Acl> acls = tuple2._2();
                            BoxedUnit boxedUnit = acls.isEmpty() ? (AclCommand$.MODULE$.kafka$admin$AclCommand$$confirmAction(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Are you sure you want to delete all ACLs for resource `", "`? (y/n)"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{resource}))) ? BoxesRunTime.boxToBoolean(this.authorizer$2.removeAcls(resource)) : BoxedUnit.UNIT) : (AclCommand$.MODULE$.kafka$admin$AclCommand$$confirmAction(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Are you sure you want to remove ACLs: ", " ", " ", " from resource `", "`? (y/n)"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{AclCommand$.MODULE$.Newline(), ((TraversableOnce)acls.map(new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply(Acl x$4) {
                                    return new StringBuilder().append((Object)"\t").append(x$4).toString();
                                }
                            }, Set$.MODULE$.canBuildFrom())).mkString(AclCommand$.MODULE$.Newline()), AclCommand$.MODULE$.Newline(), resource}))) ? BoxesRunTime.boxToBoolean(this.authorizer$2.removeAcls(acls, resource)) : BoxedUnit.UNIT);
                            return boxedUnit;
                        }
                        throw new MatchError(tuple2);
                    }
                    {
                        this.authorizer$2 = authorizer$2;
                    }
                });
                AclCommand$.MODULE$.kafka$admin$AclCommand$$listAcl(this.opts$2);
            }
            {
                this.opts$2 = opts$2;
            }
        }));
    }

    public void kafka$admin$AclCommand$$listAcl(AclCommand.AclCommandOptions opts) {
        this.withAuthorizer(opts, (Function1<Authorizer, BoxedUnit>)((Object)new Serializable(opts){
            public static final long serialVersionUID = 0L;
            private final AclCommand.AclCommandOptions opts$3;

            public final void apply(Authorizer authorizer) {
                Set<Resource> resources = AclCommand$.MODULE$.kafka$admin$AclCommand$$getResource(this.opts$3, false);
                scala.collection.immutable.Map<Resource, Set<Acl>> resourceToAcls = resources.isEmpty() ? authorizer.getAcls() : (Iterable)resources.map(new Serializable(this, authorizer){
                    public static final long serialVersionUID = 0L;
                    private final Authorizer authorizer$3;

                    public final Tuple2<Resource, Set<Acl>> apply(Resource resource) {
                        return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc(resource), this.authorizer$3.getAcls(resource));
                    }
                    {
                        this.authorizer$3 = authorizer$3;
                    }
                }, Set$.MODULE$.canBuildFrom());
                resourceToAcls.withFilter((Function1<Resource, Object>)((Object)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Tuple2<Resource, Set<Acl>> check$ifrefutable$3) {
                        Tuple2<Resource, Set<Acl>> tuple2 = check$ifrefutable$3;
                        boolean bl = tuple2 != null;
                        return bl;
                    }
                })).foreach(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final void apply(Tuple2<Resource, Set<Acl>> x$7) {
                        Tuple2<Resource, Set<Acl>> tuple2 = x$7;
                        if (tuple2 != null) {
                            Resource resource = tuple2._1();
                            Set<Acl> acls = tuple2._2();
                            Predef$.MODULE$.println(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Current ACLs for resource `", "`: ", " ", " ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{resource, AclCommand$.MODULE$.Newline(), ((TraversableOnce)acls.map(new Serializable(this){
                                public static final long serialVersionUID = 0L;

                                public final String apply(Acl x$6) {
                                    return new StringBuilder().append((Object)"\t").append(x$6).toString();
                                }
                            }, Set$.MODULE$.canBuildFrom())).mkString(AclCommand$.MODULE$.Newline()), AclCommand$.MODULE$.Newline()})));
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                            return;
                        }
                        throw new MatchError(tuple2);
                    }
                });
            }
            {
                this.opts$3 = opts$3;
            }
        }));
    }

    private void upgradeAclsToNewFormat(Map<String, Object> configs) {
        ZkUtils zkUtils = this.getZkUtil(configs);
        Seq newResourceTypeNames = ResourceType$.MODULE$.values().map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(ResourceType x$8) {
                return x$8.name();
            }
        }, Seq$.MODULE$.canBuildFrom());
        Seq oldResourceTypes = (Seq)zkUtils.getChildrenParentMayNotExist(SimpleAclAuthorizer$.MODULE$.AclZkPath()).filter((Function1<String, Object>)((Object)new Serializable(newResourceTypeNames){
            public static final long serialVersionUID = 0L;
            private final Seq newResourceTypeNames$1;

            public final boolean apply(String resourceType) {
                return !this.newResourceTypeNames$1.contains(resourceType);
            }
            {
                this.newResourceTypeNames$1 = newResourceTypeNames$1;
            }
        }));
        oldResourceTypes.foreach(new Serializable(zkUtils){
            public static final long serialVersionUID = 0L;
            public final ZkUtils zkUtils$1;

            public final void apply(String oldResourceType) {
                Seq<String> resourceNames = this.zkUtils$1.getChildrenParentMayNotExist(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{SimpleAclAuthorizer$.MODULE$.AclZkPath(), oldResourceType})));
                ResourceType resourceType = AclCommand$.MODULE$.kafka$admin$AclCommand$$getUpgradeResourceType(oldResourceType);
                resourceNames.foreach(new Serializable(this, oldResourceType, resourceType){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.upgradeAclsToNewFormat.1 $outer;
                    private final String oldResourceType$1;
                    private final ResourceType resourceType$1;

                    public final void apply(String resourceName) {
                        ObjectRef<GenTraversable> acls = new ObjectRef<GenTraversable>(Predef$.MODULE$.Set().empty());
                        Predef$.MODULE$.println(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"migration of acls for ", "-", " is in progress"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.oldResourceType$1, resourceName})));
                        String aclJson = this.$outer.zkUtils$1.readData(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", "/", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{SimpleAclAuthorizer$.MODULE$.AclZkPath(), this.oldResourceType$1, resourceName})))._1();
                        List aclList = (List)((Map)Json$.MODULE$.parseFull(aclJson).get()).apply(Acl$.MODULE$.AclsKey());
                        aclList.foreach(new Serializable(this, acls){
                            public static final long serialVersionUID = 0L;
                            public final ObjectRef acls$1;

                            public final void apply(Map<String, Object> aclMap) {
                                List hosts = (List)aclMap.apply("hosts");
                                List operations = (List)aclMap.apply("operations");
                                List principals = (List)aclMap.apply("principals");
                                String permissionType = aclMap.apply("permissionType").toString();
                                operations.foreach(new Serializable(this, hosts, principals, permissionType){
                                    public static final long serialVersionUID = 0L;
                                    private final /* synthetic */ anonfun$upgradeAclsToNewFormat$1$$anonfun$apply$11$$anonfun$apply$12 $outer;
                                    private final List hosts$1;
                                    public final List principals$1;
                                    public final String permissionType$1;

                                    public final void apply(String operation) {
                                        this.hosts$1.foreach(new Serializable(this, operation){
                                            public static final long serialVersionUID = 0L;
                                            private final /* synthetic */ anonfun$upgradeAclsToNewFormat$1$$anonfun$apply$11$$anonfun$apply$12$$anonfun$apply$13 $outer;
                                            public final String operation$1;

                                            public final void apply(String host) {
                                                this.$outer.principals$1.foreach(new Serializable(this, host){
                                                    public static final long serialVersionUID = 0L;
                                                    private final /* synthetic */ anonfun$upgradeAclsToNewFormat$1$$anonfun$apply$11$$anonfun$apply$12$$anonfun$apply$13$$anonfun$apply$14 $outer;
                                                    private final String host$1;

                                                    public final void apply(String principal) {
                                                        this.$outer.kafka$admin$AclCommand$$anonfun$$anonfun$$anonfun$$anonfun$$anonfun$$$outer().kafka$admin$AclCommand$$anonfun$$anonfun$$anonfun$$anonfun$$$outer().acls$1.elem = (Set)((Set)this.$outer.kafka$admin$AclCommand$$anonfun$$anonfun$$anonfun$$anonfun$$anonfun$$$outer().kafka$admin$AclCommand$$anonfun$$anonfun$$anonfun$$anonfun$$$outer().acls$1.elem).$plus(new Acl(AclCommand$.MODULE$.kafka$admin$AclCommand$$getUpgradePrincipal(principal), AclCommand$.MODULE$.kafka$admin$AclCommand$$getUpgradePermissionType(this.$outer.kafka$admin$AclCommand$$anonfun$$anonfun$$anonfun$$anonfun$$anonfun$$$outer().permissionType$1), this.host$1, AclCommand$.MODULE$.kafka$admin$AclCommand$$getUpgradeOpertion(this.$outer.operation$1)));
                                                    }
                                                    {
                                                        if ($outer == null) {
                                                            throw new NullPointerException();
                                                        }
                                                        this.$outer = $outer;
                                                        this.host$1 = host$1;
                                                    }
                                                });
                                            }

                                            public /* synthetic */ anonfun$upgradeAclsToNewFormat$1$$anonfun$apply$11$$anonfun$apply$12$$anonfun$apply$13 kafka$admin$AclCommand$$anonfun$$anonfun$$anonfun$$anonfun$$anonfun$$$outer() {
                                                return this.$outer;
                                            }
                                            {
                                                if ($outer == null) {
                                                    throw new NullPointerException();
                                                }
                                                this.$outer = $outer;
                                                this.operation$1 = operation$1;
                                            }
                                        });
                                    }

                                    public /* synthetic */ anonfun$upgradeAclsToNewFormat$1$$anonfun$apply$11$$anonfun$apply$12 kafka$admin$AclCommand$$anonfun$$anonfun$$anonfun$$anonfun$$$outer() {
                                        return this.$outer;
                                    }
                                    {
                                        if ($outer == null) {
                                            throw new NullPointerException();
                                        }
                                        this.$outer = $outer;
                                        this.hosts$1 = hosts$1;
                                        this.principals$1 = principals$1;
                                        this.permissionType$1 = permissionType$1;
                                    }
                                });
                            }
                            {
                                this.acls$1 = acls$1;
                            }
                        });
                        this.$outer.zkUtils$1.createPersistentPath(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", "/", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{SimpleAclAuthorizer$.MODULE$.AclZkPath(), this.resourceType$1, resourceName})), Json$.MODULE$.encode(Acl$.MODULE$.toJsonCompatibleMap((Set)acls.elem)), this.$outer.zkUtils$1.createPersistentPath$default$3());
                        Predef$.MODULE$.println(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"migrated acls from ", "-", " to ", "-", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{this.oldResourceType$1, resourceName, this.resourceType$1, resourceName})));
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.oldResourceType$1 = oldResourceType$1;
                        this.resourceType$1 = resourceType$1;
                    }
                });
            }
            {
                this.zkUtils$1 = zkUtils$1;
            }
        });
        Predef$.MODULE$.println("Done Migrating all old acls to new acls, will now attempt to delete the old acls.");
        oldResourceTypes.foreach(new Serializable(zkUtils){
            public static final long serialVersionUID = 0L;
            private final ZkUtils zkUtils$1;

            public final void apply(String invalidResourceType) {
                this.zkUtils$1.deletePathRecursive(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{SimpleAclAuthorizer$.MODULE$.AclZkPath(), invalidResourceType})));
            }
            {
                this.zkUtils$1 = zkUtils$1;
            }
        });
        Predef$.MODULE$.println("All old acls are now deleted and migrated to new version of acl.");
        System.exit(0);
    }

    private void downgradeAclsToOldFormat(Map<String, Object> configs, Authorizer authorizer) {
        ZkUtils zkUtils = this.getZkUtil(configs);
        scala.collection.immutable.Map<Resource, Set<Acl>> resourceToAcls = authorizer.getAcls();
        resourceToAcls.withFilter((Function1<Resource, Object>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Resource, Set<Acl>> check$ifrefutable$4) {
                Tuple2<Resource, Set<Acl>> tuple2 = check$ifrefutable$4;
                boolean bl = tuple2 != null;
                return bl;
            }
        })).foreach(new Serializable(zkUtils){
            public static final long serialVersionUID = 0L;
            private final ZkUtils zkUtils$2;

            public final void apply(Tuple2<Resource, Set<Acl>> x$9) {
                Tuple2<Resource, Set<Acl>> tuple2 = x$9;
                if (tuple2 != null) {
                    Resource resource = tuple2._1();
                    Set<Acl> acls = tuple2._2();
                    String resourceName = resource.name();
                    String resourceType = AclCommand$.MODULE$.kafka$admin$AclCommand$$getDowngradeResourceType(resource.resourceType());
                    ObjectRef<GenTraversable> downgradeAcls = new ObjectRef<GenTraversable>(Predef$.MODULE$.Set().empty());
                    Predef$.MODULE$.println(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"migration of acls for ", "-", " is in progress"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{resource.resourceType(), resourceName})));
                    acls.foreach(new Serializable(this, downgradeAcls){
                        public static final long serialVersionUID = 0L;
                        private final ObjectRef downgradeAcls$1;

                        public final void apply(Acl acl) {
                            String host = acl.host();
                            String principal = acl.principal().toString();
                            String permissionType = AclCommand$.MODULE$.kafka$admin$AclCommand$$getDowngradePermissionType(acl.permissionType());
                            String operation = AclCommand$.MODULE$.kafka$admin$AclCommand$$getDowngradeOpertion(acl.operation());
                            this.downgradeAcls$1.elem = (Set)((Set)this.downgradeAcls$1.elem).$plus(Map$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc("hosts"), List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{host}))), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc("principals"), List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{principal}))), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc("operations"), List$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{operation}))), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc("permissionType"), permissionType)})));
                        }
                        {
                            this.downgradeAcls$1 = downgradeAcls$1;
                        }
                    });
                    String json = Json$.MODULE$.encode(Map$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc(Acl$.MODULE$.VersionKey()), BoxesRunTime.boxToInteger(Acl$.MODULE$.CurrentVersion())), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc(Acl$.MODULE$.AclsKey()), (Set)downgradeAcls.elem)})));
                    this.zkUtils$2.createPersistentPath(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", "/", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{SimpleAclAuthorizer$.MODULE$.AclZkPath(), resourceType, resourceName})), json, this.zkUtils$2.createPersistentPath$default$3());
                    Predef$.MODULE$.println(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"migrated acls from ", "-", " to ", "-", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{resource.resourceType(), resourceName, resourceType, resourceName})));
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.zkUtils$2 = zkUtils$2;
            }
        });
        Predef$.MODULE$.println("Done Migrating all new acls to old acls, will now attempt to delete the new acls.");
        Seq<String> validResourceTypeNames = ResourceType$.MODULE$.values().map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(ResourceType x$10) {
                return x$10.name();
            }
        }, Seq$.MODULE$.canBuildFrom());
        validResourceTypeNames.foreach(new Serializable(zkUtils){
            public static final long serialVersionUID = 0L;
            private final ZkUtils zkUtils$2;

            public final void apply(String resourceType) {
                this.zkUtils$2.deletePathRecursive(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", "/", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{SimpleAclAuthorizer$.MODULE$.AclZkPath(), resourceType})));
            }
            {
                this.zkUtils$2 = zkUtils$2;
            }
        });
        Predef$.MODULE$.println("All new acls are now deleted and migrated to old version of acl.");
        System.exit(0);
    }

    public ZkUtils getZkUtil(Map<String, Object> configs) {
        Properties props = new Properties();
        configs.foreach(new Serializable(props){
            public static final long serialVersionUID = 0L;
            private final Properties props$1;

            public final Object apply(Tuple2<String, Object> x0$1) {
                Tuple2<String, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    String key = tuple2._1();
                    Object value2 = tuple2._2();
                    Object object = this.props$1.put(key, value2.toString());
                    return object;
                }
                throw new MatchError(tuple2);
            }
            {
                this.props$1 = props$1;
            }
        });
        KafkaConfig kafkaConfig = KafkaConfig$.MODULE$.fromProps(props);
        String zkUrl = configs.getOrElse(SimpleAclAuthorizer$.MODULE$.ZkUrlProp(), new Serializable(kafkaConfig){
            public static final long serialVersionUID = 0L;
            private final KafkaConfig kafkaConfig$1;

            public final String apply() {
                return this.kafkaConfig$1.zkConnect();
            }
            {
                this.kafkaConfig$1 = kafkaConfig$1;
            }
        }).toString();
        int zkConnectionTimeoutMs = new StringOps(Predef$.MODULE$.augmentString(configs.getOrElse(SimpleAclAuthorizer$.MODULE$.ZkConnectionTimeOutProp(), new Serializable(kafkaConfig){
            public static final long serialVersionUID = 0L;
            private final KafkaConfig kafkaConfig$1;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return this.kafkaConfig$1.zkConnectionTimeoutMs();
            }
            {
                this.kafkaConfig$1 = kafkaConfig$1;
            }
        }).toString())).toInt();
        int zkSessionTimeOutMs = new StringOps(Predef$.MODULE$.augmentString(configs.getOrElse(SimpleAclAuthorizer$.MODULE$.ZkSessionTimeOutProp(), new Serializable(kafkaConfig){
            public static final long serialVersionUID = 0L;
            private final KafkaConfig kafkaConfig$1;

            public final int apply() {
                return this.apply$mcI$sp();
            }

            public int apply$mcI$sp() {
                return this.kafkaConfig$1.zkSessionTimeoutMs();
            }
            {
                this.kafkaConfig$1 = kafkaConfig$1;
            }
        }).toString())).toInt();
        ZkUtils zkUtils = ZkUtils$.MODULE$.apply(zkUrl, zkConnectionTimeoutMs, zkSessionTimeOutMs, JaasUtils.isZkSecurityEnabled());
        return zkUtils;
    }

    public ResourceType kafka$admin$AclCommand$$getUpgradeResourceType(String resourceType) {
        String string2;
        block5: {
            ResourceType resourceType2;
            block3: {
                block4: {
                    block2: {
                        String string3 = string2 = resourceType;
                        if ("TOPIC" != null ? !"TOPIC".equals(string3) : string3 != null) break block2;
                        resourceType2 = Topic$.MODULE$;
                        break block3;
                    }
                    String string4 = string2;
                    if ("CONSUMER_GROUP" != null ? !"CONSUMER_GROUP".equals(string4) : string4 != null) break block4;
                    resourceType2 = Group$.MODULE$;
                    break block3;
                }
                String string5 = string2;
                if ("CLUSTER" != null ? !"CLUSTER".equals(string5) : string5 != null) break block5;
                resourceType2 = Cluster$.MODULE$;
            }
            return resourceType2;
        }
        throw new MatchError((Object)string2);
    }

    public PermissionType kafka$admin$AclCommand$$getUpgradePermissionType(String permissionType) {
        String string2;
        block4: {
            PermissionType permissionType2;
            block3: {
                block2: {
                    String string3 = string2 = permissionType.toUpperCase();
                    if ("ALLOW" != null ? !"ALLOW".equals(string3) : string3 != null) break block2;
                    permissionType2 = Allow$.MODULE$;
                    break block3;
                }
                String string4 = string2;
                if ("DENY" != null ? !"DENY".equals(string4) : string4 != null) break block4;
                permissionType2 = Deny$.MODULE$;
            }
            return permissionType2;
        }
        throw new MatchError((Object)string2);
    }

    public Operation kafka$admin$AclCommand$$getUpgradeOpertion(String operation) {
        String string2;
        block10: {
            Operation operation2;
            block3: {
                block9: {
                    block8: {
                        block7: {
                            block6: {
                                block5: {
                                    block4: {
                                        block2: {
                                            String string3 = string2 = operation.toUpperCase();
                                            if ("READ" != null ? !"READ".equals(string3) : string3 != null) break block2;
                                            operation2 = Read$.MODULE$;
                                            break block3;
                                        }
                                        String string4 = string2;
                                        if ("WRITE" != null ? !"WRITE".equals(string4) : string4 != null) break block4;
                                        operation2 = Write$.MODULE$;
                                        break block3;
                                    }
                                    String string5 = string2;
                                    if ("CLUSTER_ACTION" != null ? !"CLUSTER_ACTION".equals(string5) : string5 != null) break block5;
                                    operation2 = ClusterAction$.MODULE$;
                                    break block3;
                                }
                                String string6 = string2;
                                if ("CREATE" != null ? !"CREATE".equals(string6) : string6 != null) break block6;
                                operation2 = Create$.MODULE$;
                                break block3;
                            }
                            String string7 = string2;
                            if ("DESCRIBE" != null ? !"DESCRIBE".equals(string7) : string7 != null) break block7;
                            operation2 = Describe$.MODULE$;
                            break block3;
                        }
                        String string8 = string2;
                        if ("DELETE" != null ? !"DELETE".equals(string8) : string8 != null) break block8;
                        operation2 = Delete$.MODULE$;
                        break block3;
                    }
                    String string9 = string2;
                    if ("ALTER" != null ? !"ALTER".equals(string9) : string9 != null) break block9;
                    operation2 = Alter$.MODULE$;
                    break block3;
                }
                String string10 = string2;
                if ("ALL" != null ? !"ALL".equals(string10) : string10 != null) break block10;
                operation2 = All$.MODULE$;
            }
            return operation2;
        }
        throw new MatchError((Object)string2);
    }

    public KafkaPrincipal kafka$admin$AclCommand$$getUpgradePrincipal(String principal) {
        return new KafkaPrincipal("User", principal.split(":")[1]);
    }

    public String kafka$admin$AclCommand$$getDowngradeResourceType(ResourceType resourceType) {
        ResourceType resourceType2;
        block5: {
            String string2;
            block3: {
                block4: {
                    block2: {
                        resourceType2 = resourceType;
                        Topic$ topic$ = Topic$.MODULE$;
                        ResourceType resourceType3 = resourceType2;
                        if (topic$ != null ? !topic$.equals(resourceType3) : resourceType3 != null) break block2;
                        string2 = "TOPIC";
                        break block3;
                    }
                    Group$ group$ = Group$.MODULE$;
                    ResourceType resourceType4 = resourceType2;
                    if (group$ != null ? !group$.equals(resourceType4) : resourceType4 != null) break block4;
                    string2 = "CONSUMER_GROUP";
                    break block3;
                }
                Cluster$ cluster$ = Cluster$.MODULE$;
                ResourceType resourceType5 = resourceType2;
                if (cluster$ != null ? !cluster$.equals(resourceType5) : resourceType5 != null) break block5;
                string2 = "CLUSTER";
            }
            return string2;
        }
        throw new MatchError(resourceType2);
    }

    public String kafka$admin$AclCommand$$getDowngradePermissionType(PermissionType permissionType) {
        PermissionType permissionType2;
        block4: {
            String string2;
            block3: {
                block2: {
                    permissionType2 = permissionType;
                    Allow$ allow$ = Allow$.MODULE$;
                    PermissionType permissionType3 = permissionType2;
                    if (allow$ != null ? !allow$.equals(permissionType3) : permissionType3 != null) break block2;
                    string2 = "ALLOW";
                    break block3;
                }
                Deny$ deny$ = Deny$.MODULE$;
                PermissionType permissionType4 = permissionType2;
                if (deny$ != null ? !deny$.equals(permissionType4) : permissionType4 != null) break block4;
                string2 = "DENY";
            }
            return string2;
        }
        throw new MatchError(permissionType2);
    }

    public String kafka$admin$AclCommand$$getDowngradeOpertion(Operation operation) {
        Operation operation2;
        block10: {
            String string2;
            block3: {
                block9: {
                    block8: {
                        block7: {
                            block6: {
                                block5: {
                                    block4: {
                                        block2: {
                                            operation2 = operation;
                                            Read$ read$ = Read$.MODULE$;
                                            Operation operation3 = operation2;
                                            if (read$ != null ? !read$.equals(operation3) : operation3 != null) break block2;
                                            string2 = "READ";
                                            break block3;
                                        }
                                        Write$ write$ = Write$.MODULE$;
                                        Operation operation4 = operation2;
                                        if (write$ != null ? !write$.equals(operation4) : operation4 != null) break block4;
                                        string2 = "WRITE";
                                        break block3;
                                    }
                                    ClusterAction$ clusterAction$ = ClusterAction$.MODULE$;
                                    Operation operation5 = operation2;
                                    if (clusterAction$ != null ? !clusterAction$.equals(operation5) : operation5 != null) break block5;
                                    string2 = "CLUSTER_ACTION";
                                    break block3;
                                }
                                Create$ create$ = Create$.MODULE$;
                                Operation operation6 = operation2;
                                if (create$ != null ? !create$.equals(operation6) : operation6 != null) break block6;
                                string2 = "CREATE";
                                break block3;
                            }
                            Describe$ describe$ = Describe$.MODULE$;
                            Operation operation7 = operation2;
                            if (describe$ != null ? !describe$.equals(operation7) : operation7 != null) break block7;
                            string2 = "DESCRIBE";
                            break block3;
                        }
                        Delete$ delete$ = Delete$.MODULE$;
                        Operation operation8 = operation2;
                        if (delete$ != null ? !delete$.equals(operation8) : operation8 != null) break block8;
                        string2 = "DELETE";
                        break block3;
                    }
                    Alter$ alter$ = Alter$.MODULE$;
                    Operation operation9 = operation2;
                    if (alter$ != null ? !alter$.equals(operation9) : operation9 != null) break block9;
                    string2 = "ALTER";
                    break block3;
                }
                All$ all$ = All$.MODULE$;
                Operation operation10 = operation2;
                if (all$ != null ? !all$.equals(operation10) : operation10 != null) break block10;
                string2 = "ALL";
            }
            return string2;
        }
        throw new MatchError(operation2);
    }

    private ResourceType getValidResourceType(String resourceType) {
        String string2;
        block5: {
            ResourceType resourceType2;
            block3: {
                block4: {
                    block2: {
                        String string3 = string2 = resourceType;
                        if ("TOPIC" != null ? !"TOPIC".equals(string3) : string3 != null) break block2;
                        resourceType2 = Topic$.MODULE$;
                        break block3;
                    }
                    String string4 = string2;
                    if ("CONSUMER_GROUP" != null ? !"CONSUMER_GROUP".equals(string4) : string4 != null) break block4;
                    resourceType2 = Group$.MODULE$;
                    break block3;
                }
                String string5 = string2;
                if ("CLUSTER" != null ? !"CLUSTER".equals(string5) : string5 != null) break block5;
                resourceType2 = Cluster$.MODULE$;
            }
            return resourceType2;
        }
        throw new MatchError((Object)string2);
    }

    private KafkaPrincipal getValidPrincipal(String principal) {
        String principalName = principal.split(":")[1];
        return new KafkaPrincipal("User", principalName);
    }

    private PermissionType getValidPermissionType(String permissionType) {
        String string2;
        block4: {
            PermissionType permissionType2;
            block3: {
                block2: {
                    String string3 = string2 = permissionType.toUpperCase();
                    if ("ALLOW" != null ? !"ALLOW".equals(string3) : string3 != null) break block2;
                    permissionType2 = Allow$.MODULE$;
                    break block3;
                }
                String string4 = string2;
                if ("DENY" != null ? !"DENY".equals(string4) : string4 != null) break block4;
                permissionType2 = Deny$.MODULE$;
            }
            return permissionType2;
        }
        throw new MatchError((Object)string2);
    }

    private Operation getValidOpertion(String operation) {
        String string2;
        block10: {
            Operation operation2;
            block3: {
                block9: {
                    block8: {
                        block7: {
                            block6: {
                                block5: {
                                    block4: {
                                        block2: {
                                            String string3 = string2 = operation.toUpperCase();
                                            if ("READ" != null ? !"READ".equals(string3) : string3 != null) break block2;
                                            operation2 = Read$.MODULE$;
                                            break block3;
                                        }
                                        String string4 = string2;
                                        if ("WRITE" != null ? !"WRITE".equals(string4) : string4 != null) break block4;
                                        operation2 = Write$.MODULE$;
                                        break block3;
                                    }
                                    String string5 = string2;
                                    if ("CLUSTER_ACTION" != null ? !"CLUSTER_ACTION".equals(string5) : string5 != null) break block5;
                                    operation2 = ClusterAction$.MODULE$;
                                    break block3;
                                }
                                String string6 = string2;
                                if ("CREATE" != null ? !"CREATE".equals(string6) : string6 != null) break block6;
                                operation2 = Create$.MODULE$;
                                break block3;
                            }
                            String string7 = string2;
                            if ("DESCRIBE" != null ? !"DESCRIBE".equals(string7) : string7 != null) break block7;
                            operation2 = Describe$.MODULE$;
                            break block3;
                        }
                        String string8 = string2;
                        if ("DELETE" != null ? !"DELETE".equals(string8) : string8 != null) break block8;
                        operation2 = Delete$.MODULE$;
                        break block3;
                    }
                    String string9 = string2;
                    if ("ALTER" != null ? !"ALTER".equals(string9) : string9 != null) break block9;
                    operation2 = Alter$.MODULE$;
                    break block3;
                }
                String string10 = string2;
                if ("ALL" != null ? !"ALL".equals(string10) : string10 != null) break block10;
                operation2 = All$.MODULE$;
            }
            return operation2;
        }
        throw new MatchError((Object)string2);
    }

    public Map<Resource, Set<Acl>> kafka$admin$AclCommand$$getResourceToAcls(AclCommand.AclCommandOptions opts) {
        ObjectRef<GenMap> resourceToAcls = new ObjectRef<GenMap>(Map$.MODULE$.empty());
        if (!opts.options().has(opts.producerOpt()) && !opts.options().has(opts.consumerOpt())) {
            resourceToAcls.elem = ((scala.collection.immutable.Map)resourceToAcls.elem).$plus$plus(this.getCliResourceToAcls(opts));
        }
        if (opts.options().has(opts.producerOpt())) {
            resourceToAcls.elem = ((scala.collection.immutable.Map)resourceToAcls.elem).$plus$plus(this.getProducerResourceToAcls(opts));
        }
        if (opts.options().has(opts.consumerOpt())) {
            resourceToAcls.elem = ((scala.collection.immutable.Map)resourceToAcls.elem).$plus$plus(this.getConsumerResourceToAcls(opts).map((Function1<Resource, Set<Acl>>)((Object)new Serializable(resourceToAcls){
                public static final long serialVersionUID = 0L;
                private final ObjectRef resourceToAcls$1;

                public final Tuple2<Resource, Set<Acl>> apply(Tuple2<Resource, Set<Acl>> x0$2) {
                    Tuple2<Resource, Set<Acl>> tuple2 = x0$2;
                    if (tuple2 != null) {
                        Resource k = tuple2._1();
                        Set<Acl> v = tuple2._2();
                        Tuple2<Resource, Set<Acl>> tuple22 = Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc(k), v.$plus$plus((GenTraversableOnce)((scala.collection.immutable.Map)this.resourceToAcls$1.elem).getOrElse(k, new Serializable(this){
                            public static final long serialVersionUID = 0L;

                            public final Set<Acl> apply() {
                                return Predef$.MODULE$.Set().empty();
                            }
                        })));
                        return tuple22;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    this.resourceToAcls$1 = resourceToAcls$1;
                }
            }), Map$.MODULE$.canBuildFrom()));
        }
        this.validateOperation(opts, (scala.collection.immutable.Map)resourceToAcls.elem);
        return (scala.collection.immutable.Map)resourceToAcls.elem;
    }

    private Map<Resource, Set<Acl>> getProducerResourceToAcls(AclCommand.AclCommandOptions opts) {
        Set topics = (Set)this.kafka$admin$AclCommand$$getResource(opts, this.getResource$default$2()).filter((Function1<Resource, Object>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Resource x$11) {
                ResourceType resourceType = x$11.resourceType();
                Topic$ topic$ = Topic$.MODULE$;
                return !(resourceType != null ? !resourceType.equals(topic$) : topic$ != null);
            }
        }));
        Set<Acl> acls = this.kafka$admin$AclCommand$$getAcl(opts, (Set)Predef$.MODULE$.Set().apply(Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Write$.MODULE$, Describe$.MODULE$})));
        return ((TraversableOnce)topics.map(new Serializable(acls){
            public static final long serialVersionUID = 0L;
            private final Set acls$2;

            public final Tuple2<Resource, Set<Acl>> apply(Resource x$12) {
                return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc(x$12), this.acls$2);
            }
            {
                this.acls$2 = acls$2;
            }
        }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms()).$plus(Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc(Resource$.MODULE$.ClusterResource()), this.kafka$admin$AclCommand$$getAcl(opts, (Set)Predef$.MODULE$.Set().apply(Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Create$.MODULE$})))));
    }

    private Map<Resource, Set<Acl>> getConsumerResourceToAcls(AclCommand.AclCommandOptions opts) {
        Set<Resource> resources = this.kafka$admin$AclCommand$$getResource(opts, this.getResource$default$2());
        Set topics = (Set)this.kafka$admin$AclCommand$$getResource(opts, this.getResource$default$2()).filter((Function1<Resource, Object>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Resource x$13) {
                ResourceType resourceType = x$13.resourceType();
                Topic$ topic$ = Topic$.MODULE$;
                return !(resourceType != null ? !resourceType.equals(topic$) : topic$ != null);
            }
        }));
        Set groups = (Set)resources.filter((Function1<Resource, Object>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Resource x$14) {
                ResourceType resourceType = x$14.resourceType();
                Group$ group$ = Group$.MODULE$;
                return !(resourceType != null ? !resourceType.equals(group$) : group$ != null);
            }
        }));
        Set<Acl> acls = this.kafka$admin$AclCommand$$getAcl(opts, (Set)Predef$.MODULE$.Set().apply(Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Read$.MODULE$, Describe$.MODULE$})));
        return ((TraversableOnce)topics.map(new Serializable(acls){
            public static final long serialVersionUID = 0L;
            private final Set acls$3;

            public final Tuple2<Resource, Set<Acl>> apply(Resource x$15) {
                return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc(x$15), this.acls$3);
            }
            {
                this.acls$3 = acls$3;
            }
        }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms()).$plus$plus(((TraversableOnce)groups.map(new Serializable(opts){
            public static final long serialVersionUID = 0L;
            private final AclCommand.AclCommandOptions opts$4;

            public final Tuple2<Resource, Set<Acl>> apply(Resource x$16) {
                return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc(x$16), AclCommand$.MODULE$.kafka$admin$AclCommand$$getAcl(this.opts$4, (Set)Predef$.MODULE$.Set().apply(Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Read$.MODULE$}))));
            }
            {
                this.opts$4 = opts$4;
            }
        }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms()));
    }

    private Map<Resource, Set<Acl>> getCliResourceToAcls(AclCommand.AclCommandOptions opts) {
        Set<Acl> acls = this.getAcl(opts);
        Set<Resource> resources = this.kafka$admin$AclCommand$$getResource(opts, this.getResource$default$2());
        return ((TraversableOnce)resources.map(new Serializable(acls){
            public static final long serialVersionUID = 0L;
            private final Set acls$4;

            public final Tuple2<Resource, Set<Acl>> apply(Resource x$17) {
                return Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc(x$17), this.acls$4);
            }
            {
                this.acls$4 = acls$4;
            }
        }, Set$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.conforms());
    }

    public Set<Acl> kafka$admin$AclCommand$$getAcl(AclCommand.AclCommandOptions opts, Set<Operation> operations) {
        Set<KafkaPrincipal> allowedPrincipals = this.getPrincipals(opts, opts.allowPrincipalsOpt());
        Set<KafkaPrincipal> deniedPrincipals = this.getPrincipals(opts, opts.denyPrincipalsOpt());
        Set<String> allowedHosts = this.getHosts(opts, opts.allowHostsOpt(), opts.allowPrincipalsOpt());
        Set<String> deniedHosts = this.getHosts(opts, opts.denyHostssOpt(), opts.denyPrincipalsOpt());
        HashSet<Acl> acls = new HashSet<Acl>();
        Object object = allowedHosts.nonEmpty() && allowedPrincipals.nonEmpty() ? acls.$plus$plus$eq(this.getAcls(allowedPrincipals, Allow$.MODULE$, operations, allowedHosts)) : BoxedUnit.UNIT;
        Object object2 = deniedHosts.nonEmpty() && deniedPrincipals.nonEmpty() ? acls.$plus$plus$eq(this.getAcls(deniedPrincipals, Deny$.MODULE$, operations, deniedHosts)) : BoxedUnit.UNIT;
        return acls.toSet();
    }

    private Set<Acl> getAcl(AclCommand.AclCommandOptions opts) {
        Set<Operation> operations = ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(opts.operationsOpt())).asScala()).map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final Operation apply(String operation) {
                return Operation$.MODULE$.fromString(operation.trim());
            }
        }, Buffer$.MODULE$.canBuildFrom())).toSet();
        return this.kafka$admin$AclCommand$$getAcl(opts, operations);
    }

    public Set<Acl> getAcls(Set<KafkaPrincipal> principals, PermissionType permissionType, Set<Operation> operations, Set<String> hosts) {
        return principals.flatMap(new Serializable(permissionType, operations, hosts){
            public static final long serialVersionUID = 0L;
            public final PermissionType permissionType$2;
            private final Set operations$1;
            public final Set hosts$2;

            public final Set<Acl> apply(KafkaPrincipal principal) {
                return this.operations$1.flatMap(new Serializable(this, principal){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ anonfun.getAcls.1 $outer;
                    public final KafkaPrincipal principal$1;

                    public final Set<Acl> apply(Operation operation) {
                        return this.$outer.hosts$2.map(new Serializable(this, operation){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun$getAcls$1$$anonfun$apply$18 $outer;
                            private final Operation operation$2;

                            public final Acl apply(String host) {
                                return new Acl(this.$outer.principal$1, this.$outer.kafka$admin$AclCommand$$anonfun$$anonfun$$$outer().permissionType$2, host, this.operation$2);
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                                this.operation$2 = operation$2;
                            }
                        }, Set$.MODULE$.canBuildFrom());
                    }

                    public /* synthetic */ anonfun.getAcls.1 kafka$admin$AclCommand$$anonfun$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                        this.principal$1 = principal$1;
                    }
                }, Set$.MODULE$.canBuildFrom());
            }
            {
                this.permissionType$2 = permissionType$2;
                this.operations$1 = operations$1;
                this.hosts$2 = hosts$2;
            }
        }, Set$.MODULE$.canBuildFrom());
    }

    private Set<String> getHosts(AclCommand.AclCommandOptions opts, ArgumentAcceptingOptionSpec<String> hostOptionSpec, ArgumentAcceptingOptionSpec<String> principalOptionSpec) {
        return opts.options().has(hostOptionSpec) ? ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(hostOptionSpec)).asScala()).map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(String x$18) {
                return x$18.trim();
            }
        }, Buffer$.MODULE$.canBuildFrom())).toSet() : (opts.options().has(principalOptionSpec) ? (Set)Predef$.MODULE$.Set().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{Acl$.MODULE$.WildCardHost()})) : Predef$.MODULE$.Set().empty());
    }

    private Set<KafkaPrincipal> getPrincipals(AclCommand.AclCommandOptions opts, ArgumentAcceptingOptionSpec<String> principalOptionSpec) {
        return opts.options().has(principalOptionSpec) ? ((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(principalOptionSpec)).asScala()).map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final KafkaPrincipal apply(String s2) {
                return KafkaPrincipal.fromString(s2.trim());
            }
        }, Buffer$.MODULE$.canBuildFrom())).toSet() : Predef$.MODULE$.Set().empty();
    }

    public Set<Resource> kafka$admin$AclCommand$$getResource(AclCommand.AclCommandOptions opts, boolean dieIfNoResourceFound) {
        ObjectRef<GenTraversable> resources = new ObjectRef<GenTraversable>(Predef$.MODULE$.Set().empty());
        if (opts.options().has(opts.topicOpt())) {
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(opts.topicOpt())).asScala()).foreach(new Serializable(resources){
                public static final long serialVersionUID = 0L;
                private final ObjectRef resources$1;

                public final void apply(String topic) {
                    this.resources$1.elem = (Set)((Set)this.resources$1.elem).$plus(new Resource(Topic$.MODULE$, topic.trim()));
                }
                {
                    this.resources$1 = resources$1;
                }
            });
        }
        if (opts.options().has(opts.clusterOpt())) {
            resources.elem = (Set)((Set)resources.elem).$plus(Resource$.MODULE$.ClusterResource());
        }
        if (opts.options().has(opts.groupOpt())) {
            ((IterableLike)JavaConverters$.MODULE$.asScalaBufferConverter(opts.options().valuesOf(opts.groupOpt())).asScala()).foreach(new Serializable(resources){
                public static final long serialVersionUID = 0L;
                private final ObjectRef resources$1;

                public final void apply(String group) {
                    this.resources$1.elem = (Set)((Set)this.resources$1.elem).$plus(new Resource(Group$.MODULE$, group.trim()));
                }
                {
                    this.resources$1 = resources$1;
                }
            });
        }
        if (((Set)resources.elem).isEmpty() && dieIfNoResourceFound) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(opts.parser(), "You must provide at least one resource: --topic <topic> or --cluster or --group <group>");
        }
        return (Set)resources.elem;
    }

    private boolean getResource$default$2() {
        return true;
    }

    public boolean kafka$admin$AclCommand$$confirmAction(String msg) {
        Predef$.MODULE$.println(msg);
        return Console$.MODULE$.readLine().equalsIgnoreCase("y");
    }

    private void validateOperation(AclCommand.AclCommandOptions opts, Map<Resource, Set<Acl>> resourceToAcls) {
        resourceToAcls.withFilter((Function1<Resource, Object>)((Object)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<Resource, Set<Acl>> check$ifrefutable$5) {
                Tuple2<Resource, Set<Acl>> tuple2 = check$ifrefutable$5;
                boolean bl = tuple2 != null;
                return bl;
            }
        })).foreach(new Serializable(opts){
            public static final long serialVersionUID = 0L;
            private final AclCommand.AclCommandOptions opts$5;

            public final void apply(Tuple2<Resource, Set<Acl>> x$20) {
                Tuple2<Resource, Set<Acl>> tuple2 = x$20;
                if (tuple2 != null) {
                    Resource resource = tuple2._1();
                    Set<Acl> acls = tuple2._2();
                    Set validOps = (Set)AclCommand$.MODULE$.ResourceTypeToValidOperations().apply(resource.resourceType());
                    if (((TraversableOnce)((Subtractable)acls.map(new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final Operation apply(Acl x$19) {
                            return x$19.operation();
                        }
                    }, Set$.MODULE$.canBuildFrom())).$minus$minus(validOps)).nonEmpty()) {
                        throw CommandLineUtils$.MODULE$.printUsageAndDie(this.opts$5.parser(), new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"ResourceType ", " only supports operations ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{resource.resourceType(), validOps.mkString(",")})));
                    }
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    return;
                }
                throw new MatchError(tuple2);
            }
            {
                this.opts$5 = opts$5;
            }
        });
    }

    private AclCommand$() {
        MODULE$ = this;
        this.Newline = Properties$.MODULE$.lineSeparator();
        this.ResourceTypeToValidOperations = (Map)Map$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc(Topic$.MODULE$), Predef$.MODULE$.Set().apply(Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Read$.MODULE$, Write$.MODULE$, Describe$.MODULE$, All$.MODULE$}))), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc(Group$.MODULE$), Predef$.MODULE$.Set().apply(Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Read$.MODULE$, All$.MODULE$}))), Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.any2ArrowAssoc(Cluster$.MODULE$), Predef$.MODULE$.Set().apply(Predef$.MODULE$.wrapRefArray((Object[])new Operation[]{Create$.MODULE$, ClusterAction$.MODULE$, All$.MODULE$})))}));
    }
}

