/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.shaded.common.requests;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.kafka.shaded.common.protocol.ApiKeys;
import org.apache.kafka.shaded.common.protocol.Errors;
import org.apache.kafka.shaded.common.protocol.ProtoUtils;
import org.apache.kafka.shaded.common.protocol.types.Schema;
import org.apache.kafka.shaded.common.protocol.types.Struct;
import org.apache.kafka.shaded.common.requests.AbstractRequest;
import org.apache.kafka.shaded.common.requests.AbstractRequestResponse;
import org.apache.kafka.shaded.common.requests.MetadataResponse;

public class MetadataRequest
extends AbstractRequest {
    private static final Schema CURRENT_SCHEMA = ProtoUtils.currentRequestSchema(ApiKeys.METADATA.id);
    private static final String TOPICS_KEY_NAME = "topics";
    private static final MetadataRequest ALL_TOPICS_REQUEST = new MetadataRequest((List<String>)null);
    private final List<String> topics;

    public static MetadataRequest allTopics() {
        return ALL_TOPICS_REQUEST;
    }

    public MetadataRequest(List<String> topics) {
        super(new Struct(CURRENT_SCHEMA));
        if (topics == null) {
            this.struct.set(TOPICS_KEY_NAME, null);
        } else {
            this.struct.set(TOPICS_KEY_NAME, (Object)topics.toArray());
        }
        this.topics = topics;
    }

    public MetadataRequest(Struct struct) {
        super(struct);
        Object[] topicArray = struct.getArray(TOPICS_KEY_NAME);
        if (topicArray != null) {
            this.topics = new ArrayList<String>();
            for (Object topicObj : topicArray) {
                this.topics.add((String)topicObj);
            }
        } else {
            this.topics = null;
        }
    }

    @Override
    public AbstractRequestResponse getErrorResponse(int versionId, Throwable e) {
        ArrayList<MetadataResponse.TopicMetadata> topicMetadatas = new ArrayList<MetadataResponse.TopicMetadata>();
        Errors error = Errors.forException(e);
        List<MetadataResponse.PartitionMetadata> partitions = Collections.emptyList();
        if (this.topics != null) {
            for (String topic : this.topics) {
                topicMetadatas.add(new MetadataResponse.TopicMetadata(error, topic, false, partitions));
            }
        }
        switch (versionId) {
            case 0: 
            case 1: {
                return new MetadataResponse(Collections.emptyList(), -1, topicMetadatas, versionId);
            }
        }
        throw new IllegalArgumentException(String.format("Version %d is not valid. Valid versions for %s are 0 to %d", versionId, this.getClass().getSimpleName(), ProtoUtils.latestVersion(ApiKeys.METADATA.id)));
    }

    public boolean isAllTopics() {
        return this.topics == null;
    }

    public List<String> topics() {
        return this.topics;
    }

    public static MetadataRequest parse(ByteBuffer buffer, int versionId) {
        return new MetadataRequest(ProtoUtils.parseRequest(ApiKeys.METADATA.id, versionId, buffer));
    }

    public static MetadataRequest parse(ByteBuffer buffer) {
        return new MetadataRequest(CURRENT_SCHEMA.read(buffer));
    }
}

