/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.shaded.common.metrics;

import org.apache.kafka.shaded.common.Metric;
import org.apache.kafka.shaded.common.MetricName;
import org.apache.kafka.shaded.common.metrics.Measurable;
import org.apache.kafka.shaded.common.metrics.MetricConfig;
import org.apache.kafka.shaded.common.utils.Time;

public final class KafkaMetric
implements Metric {
    private MetricName metricName;
    private final Object lock;
    private final Time time;
    private final Measurable measurable;
    private MetricConfig config;

    KafkaMetric(Object lock2, MetricName metricName, Measurable measurable, MetricConfig config, Time time) {
        this.metricName = metricName;
        this.lock = lock2;
        this.measurable = measurable;
        this.config = config;
        this.time = time;
    }

    MetricConfig config() {
        return this.config;
    }

    @Override
    public MetricName metricName() {
        return this.metricName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double value() {
        Object object = this.lock;
        synchronized (object) {
            return this.value(this.time.milliseconds());
        }
    }

    public Measurable measurable() {
        return this.measurable;
    }

    double value(long timeMs) {
        return this.measurable.measure(this.config, timeMs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void config(MetricConfig config) {
        Object object = this.lock;
        synchronized (object) {
            this.config = config;
        }
    }
}

