/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.shaded.clients.consumer.internals;

import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.shaded.clients.ClientResponse;
import org.apache.kafka.shaded.clients.Metadata;
import org.apache.kafka.shaded.clients.consumer.ConsumerRecord;
import org.apache.kafka.shaded.clients.consumer.NoOffsetForPartitionException;
import org.apache.kafka.shaded.clients.consumer.OffsetOutOfRangeException;
import org.apache.kafka.shaded.clients.consumer.OffsetResetStrategy;
import org.apache.kafka.shaded.clients.consumer.internals.ConsumerNetworkClient;
import org.apache.kafka.shaded.clients.consumer.internals.RequestFuture;
import org.apache.kafka.shaded.clients.consumer.internals.RequestFutureAdapter;
import org.apache.kafka.shaded.clients.consumer.internals.RequestFutureListener;
import org.apache.kafka.shaded.clients.consumer.internals.StaleMetadataException;
import org.apache.kafka.shaded.clients.consumer.internals.SubscriptionState;
import org.apache.kafka.shaded.common.Cluster;
import org.apache.kafka.shaded.common.KafkaException;
import org.apache.kafka.shaded.common.Node;
import org.apache.kafka.shaded.common.PartitionInfo;
import org.apache.kafka.shaded.common.TopicPartition;
import org.apache.kafka.shaded.common.errors.InvalidMetadataException;
import org.apache.kafka.shaded.common.errors.InvalidTopicException;
import org.apache.kafka.shaded.common.errors.RecordTooLargeException;
import org.apache.kafka.shaded.common.errors.RetriableException;
import org.apache.kafka.shaded.common.errors.SerializationException;
import org.apache.kafka.shaded.common.errors.TimeoutException;
import org.apache.kafka.shaded.common.errors.TopicAuthorizationException;
import org.apache.kafka.shaded.common.metrics.Metrics;
import org.apache.kafka.shaded.common.metrics.Sensor;
import org.apache.kafka.shaded.common.metrics.stats.Avg;
import org.apache.kafka.shaded.common.metrics.stats.Count;
import org.apache.kafka.shaded.common.metrics.stats.Max;
import org.apache.kafka.shaded.common.metrics.stats.Rate;
import org.apache.kafka.shaded.common.protocol.ApiKeys;
import org.apache.kafka.shaded.common.protocol.Errors;
import org.apache.kafka.shaded.common.record.LogEntry;
import org.apache.kafka.shaded.common.record.MemoryRecords;
import org.apache.kafka.shaded.common.record.Record;
import org.apache.kafka.shaded.common.record.TimestampType;
import org.apache.kafka.shaded.common.requests.FetchRequest;
import org.apache.kafka.shaded.common.requests.FetchResponse;
import org.apache.kafka.shaded.common.requests.ListOffsetRequest;
import org.apache.kafka.shaded.common.requests.ListOffsetResponse;
import org.apache.kafka.shaded.common.requests.MetadataRequest;
import org.apache.kafka.shaded.common.requests.MetadataResponse;
import org.apache.kafka.shaded.common.serialization.Deserializer;
import org.apache.kafka.shaded.common.utils.Time;
import org.apache.kafka.shaded.common.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Fetcher<K, V> {
    private static final Logger log = LoggerFactory.getLogger(Fetcher.class);
    private final ConsumerNetworkClient client;
    private final Time time;
    private final int minBytes;
    private final int maxWaitMs;
    private final int fetchSize;
    private final long retryBackoffMs;
    private final int maxPollRecords;
    private final boolean checkCrcs;
    private final Metadata metadata;
    private final FetchManagerMetrics sensors;
    private final SubscriptionState subscriptions;
    private final List<CompletedFetch> completedFetches;
    private final Deserializer<K> keyDeserializer;
    private final Deserializer<V> valueDeserializer;
    private PartitionRecords<K, V> nextInLineRecords = null;

    public Fetcher(ConsumerNetworkClient client, int minBytes, int maxWaitMs, int fetchSize, int maxPollRecords, boolean checkCrcs, Deserializer<K> keyDeserializer, Deserializer<V> valueDeserializer, Metadata metadata, SubscriptionState subscriptions, Metrics metrics, String metricGrpPrefix, Time time, long retryBackoffMs) {
        this.time = time;
        this.client = client;
        this.metadata = metadata;
        this.subscriptions = subscriptions;
        this.minBytes = minBytes;
        this.maxWaitMs = maxWaitMs;
        this.fetchSize = fetchSize;
        this.maxPollRecords = maxPollRecords;
        this.checkCrcs = checkCrcs;
        this.keyDeserializer = keyDeserializer;
        this.valueDeserializer = valueDeserializer;
        this.completedFetches = new ArrayList<CompletedFetch>();
        this.sensors = new FetchManagerMetrics(metrics, metricGrpPrefix);
        this.retryBackoffMs = retryBackoffMs;
    }

    public void sendFetches() {
        for (Map.Entry<Node, FetchRequest> fetchEntry : this.createFetchRequests().entrySet()) {
            final FetchRequest request = fetchEntry.getValue();
            this.client.send(fetchEntry.getKey(), ApiKeys.FETCH, request).addListener(new RequestFutureListener<ClientResponse>(){

                @Override
                public void onSuccess(ClientResponse resp) {
                    FetchResponse response = new FetchResponse(resp.responseBody());
                    HashSet<TopicPartition> partitions = new HashSet<TopicPartition>(response.responseData().keySet());
                    FetchResponseMetricAggregator metricAggregator = new FetchResponseMetricAggregator(Fetcher.this.sensors, partitions);
                    for (Map.Entry<TopicPartition, FetchResponse.PartitionData> entry2 : response.responseData().entrySet()) {
                        TopicPartition partition2 = entry2.getKey();
                        long fetchOffset = request.fetchData().get((Object)partition2).offset;
                        FetchResponse.PartitionData fetchData = entry2.getValue();
                        Fetcher.this.completedFetches.add(new CompletedFetch(partition2, fetchOffset, fetchData, metricAggregator));
                    }
                    ((Fetcher)Fetcher.this).sensors.fetchLatency.record(resp.requestLatencyMs());
                    ((Fetcher)Fetcher.this).sensors.fetchThrottleTimeSensor.record(response.getThrottleTime());
                }

                @Override
                public void onFailure(RuntimeException e) {
                    log.debug("Fetch failed", e);
                }
            });
        }
    }

    public void updateFetchPositions(Set<TopicPartition> partitions) {
        for (TopicPartition tp : partitions) {
            if (!this.subscriptions.isAssigned(tp) || this.subscriptions.isFetchable(tp)) continue;
            if (this.subscriptions.isOffsetResetNeeded(tp)) {
                this.resetOffset(tp);
                continue;
            }
            if (this.subscriptions.committed(tp) == null) {
                this.subscriptions.needOffsetReset(tp);
                this.resetOffset(tp);
                continue;
            }
            long committed = this.subscriptions.committed(tp).offset();
            log.debug("Resetting offset for partition {} to the committed offset {}", (Object)tp, (Object)committed);
            this.subscriptions.seek(tp, committed);
        }
    }

    public Map<String, List<PartitionInfo>> getAllTopicMetadata(long timeout) {
        return this.getTopicMetadata(MetadataRequest.allTopics(), timeout);
    }

    public Map<String, List<PartitionInfo>> getTopicMetadata(MetadataRequest request, long timeout) {
        if (!request.isAllTopics() && request.topics().isEmpty()) {
            return Collections.emptyMap();
        }
        long start = this.time.milliseconds();
        long remaining = timeout;
        do {
            long elapsed;
            RequestFuture<ClientResponse> future = this.sendMetadataRequest(request);
            this.client.poll(future, remaining);
            if (future.failed() && !future.isRetriable()) {
                throw future.exception();
            }
            if (future.succeeded()) {
                MetadataResponse response = new MetadataResponse(future.value().responseBody());
                Cluster cluster = response.cluster();
                Set<String> unauthorizedTopics = cluster.unauthorizedTopics();
                if (!unauthorizedTopics.isEmpty()) {
                    throw new TopicAuthorizationException(unauthorizedTopics);
                }
                boolean shouldRetry = false;
                Map<String, Errors> errors = response.errors();
                if (!errors.isEmpty()) {
                    log.debug("Topic metadata fetch included errors: {}", (Object)errors);
                    for (Map.Entry<String, Errors> errorEntry : errors.entrySet()) {
                        String topic = errorEntry.getKey();
                        Errors error = errorEntry.getValue();
                        if (error == Errors.INVALID_TOPIC_EXCEPTION) {
                            throw new InvalidTopicException("Topic '" + topic + "' is invalid");
                        }
                        if (error == Errors.UNKNOWN_TOPIC_OR_PARTITION) continue;
                        if (error.exception() instanceof RetriableException) {
                            shouldRetry = true;
                            continue;
                        }
                        throw new KafkaException("Unexpected error fetching metadata for topic " + topic, error.exception());
                    }
                }
                if (!shouldRetry) {
                    HashMap<String, List<PartitionInfo>> topicsPartitionInfos = new HashMap<String, List<PartitionInfo>>();
                    for (String topic : cluster.topics()) {
                        topicsPartitionInfos.put(topic, cluster.availablePartitionsForTopic(topic));
                    }
                    return topicsPartitionInfos;
                }
            }
            if ((remaining = timeout - (elapsed = this.time.milliseconds() - start)) <= 0L) continue;
            long backoff2 = Math.min(remaining, this.retryBackoffMs);
            this.time.sleep(backoff2);
            remaining -= backoff2;
        } while (remaining > 0L);
        throw new TimeoutException("Timeout expired while fetching topic metadata");
    }

    private RequestFuture<ClientResponse> sendMetadataRequest(MetadataRequest request) {
        Node node = this.client.leastLoadedNode();
        if (node == null) {
            return RequestFuture.noBrokersAvailable();
        }
        return this.client.send(node, ApiKeys.METADATA, request);
    }

    private void resetOffset(TopicPartition partition2) {
        long timestamp2;
        OffsetResetStrategy strategy = this.subscriptions.resetStrategy(partition2);
        if (strategy == OffsetResetStrategy.EARLIEST) {
            timestamp2 = -2L;
        } else if (strategy == OffsetResetStrategy.LATEST) {
            timestamp2 = -1L;
        } else {
            throw new NoOffsetForPartitionException(partition2);
        }
        log.debug("Resetting offset for partition {} to {} offset.", (Object)partition2, (Object)strategy.name().toLowerCase(Locale.ROOT));
        long offset = this.listOffset(partition2, timestamp2);
        if (this.subscriptions.isAssigned(partition2)) {
            this.subscriptions.seek(partition2, offset);
        }
    }

    private long listOffset(TopicPartition partition2, long timestamp2) {
        while (true) {
            RequestFuture<Long> future = this.sendListOffsetRequest(partition2, timestamp2);
            this.client.poll(future);
            if (future.succeeded()) {
                return future.value();
            }
            if (!future.isRetriable()) {
                throw future.exception();
            }
            if (future.exception() instanceof InvalidMetadataException) {
                this.client.awaitMetadataUpdate();
                continue;
            }
            this.time.sleep(this.retryBackoffMs);
        }
    }

    public Map<TopicPartition, List<ConsumerRecord<K, V>>> fetchedRecords() {
        if (this.subscriptions.partitionAssignmentNeeded()) {
            return Collections.emptyMap();
        }
        HashMap<TopicPartition, List<ConsumerRecord<K, V>>> drained = new HashMap<TopicPartition, List<ConsumerRecord<K, V>>>();
        int recordsRemaining = this.maxPollRecords;
        Iterator<CompletedFetch> completedFetchesIterator = this.completedFetches.iterator();
        while (recordsRemaining > 0) {
            if (this.nextInLineRecords == null || ((PartitionRecords)this.nextInLineRecords).isEmpty()) {
                if (!completedFetchesIterator.hasNext()) break;
                CompletedFetch completion = completedFetchesIterator.next();
                completedFetchesIterator.remove();
                this.nextInLineRecords = this.parseFetchedData(completion);
                continue;
            }
            recordsRemaining -= this.append(drained, this.nextInLineRecords, recordsRemaining);
        }
        return drained;
    }

    private int append(Map<TopicPartition, List<ConsumerRecord<K, V>>> drained, PartitionRecords<K, V> partitionRecords, int maxRecords) {
        if (((PartitionRecords)partitionRecords).isEmpty()) {
            return 0;
        }
        if (!this.subscriptions.isAssigned(((PartitionRecords)partitionRecords).partition)) {
            log.debug("Not returning fetched records for partition {} since it is no longer assigned", (Object)((PartitionRecords)partitionRecords).partition);
        } else {
            long position = this.subscriptions.position(((PartitionRecords)partitionRecords).partition);
            if (!this.subscriptions.isFetchable(((PartitionRecords)partitionRecords).partition)) {
                log.debug("Not returning fetched records for assigned partition {} since it is no longer fetchable", (Object)((PartitionRecords)partitionRecords).partition);
            } else {
                if (((PartitionRecords)partitionRecords).fetchOffset == position) {
                    List partRecords = ((PartitionRecords)partitionRecords).take(maxRecords);
                    long nextOffset = ((ConsumerRecord)partRecords.get(partRecords.size() - 1)).offset() + 1L;
                    log.trace("Returning fetched records at offset {} for assigned partition {} and update position to {}", position, ((PartitionRecords)partitionRecords).partition, nextOffset);
                    List records = drained.get(((PartitionRecords)partitionRecords).partition);
                    if (records == null) {
                        records = partRecords;
                        drained.put(((PartitionRecords)partitionRecords).partition, records);
                    } else {
                        records.addAll(partRecords);
                    }
                    this.subscriptions.position(((PartitionRecords)partitionRecords).partition, nextOffset);
                    return partRecords.size();
                }
                log.debug("Ignoring fetched records for {} at offset {} since the current position is {}", ((PartitionRecords)partitionRecords).partition, ((PartitionRecords)partitionRecords).fetchOffset, position);
            }
        }
        ((PartitionRecords)partitionRecords).discard();
        return 0;
    }

    private RequestFuture<Long> sendListOffsetRequest(final TopicPartition topicPartition, long timestamp2) {
        HashMap<TopicPartition, ListOffsetRequest.PartitionData> partitions = new HashMap<TopicPartition, ListOffsetRequest.PartitionData>(1);
        partitions.put(topicPartition, new ListOffsetRequest.PartitionData(timestamp2, 1));
        PartitionInfo info = this.metadata.fetch().partition(topicPartition);
        if (info == null) {
            this.metadata.add(topicPartition.topic());
            log.debug("Partition {} is unknown for fetching offset, wait for metadata refresh", (Object)topicPartition);
            return RequestFuture.staleMetadata();
        }
        if (info.leader() == null) {
            log.debug("Leader for partition {} unavailable for fetching offset, wait for metadata refresh", (Object)topicPartition);
            return RequestFuture.leaderNotAvailable();
        }
        Node node = info.leader();
        ListOffsetRequest request = new ListOffsetRequest(-1, partitions);
        return this.client.send(node, ApiKeys.LIST_OFFSETS, request).compose(new RequestFutureAdapter<ClientResponse, Long>(){

            @Override
            public void onSuccess(ClientResponse response, RequestFuture<Long> future) {
                Fetcher.this.handleListOffsetResponse(topicPartition, response, future);
            }
        });
    }

    private void handleListOffsetResponse(TopicPartition topicPartition, ClientResponse clientResponse, RequestFuture<Long> future) {
        ListOffsetResponse lor = new ListOffsetResponse(clientResponse.responseBody());
        short errorCode = lor.responseData().get((Object)topicPartition).errorCode;
        if (errorCode == Errors.NONE.code()) {
            List<Long> offsets = lor.responseData().get((Object)topicPartition).offsets;
            if (offsets.size() != 1) {
                throw new IllegalStateException("This should not happen.");
            }
            long offset = offsets.get(0);
            log.debug("Fetched offset {} for partition {}", (Object)offset, (Object)topicPartition);
            future.complete(offset);
        } else if (errorCode == Errors.NOT_LEADER_FOR_PARTITION.code() || errorCode == Errors.UNKNOWN_TOPIC_OR_PARTITION.code()) {
            log.debug("Attempt to fetch offsets for partition {} failed due to obsolete leadership information, retrying.", (Object)topicPartition);
            future.raise(Errors.forCode(errorCode));
        } else {
            log.warn("Attempt to fetch offsets for partition {} failed due to: {}", (Object)topicPartition, (Object)Errors.forCode(errorCode).message());
            future.raise(new StaleMetadataException());
        }
    }

    private Set<TopicPartition> fetchablePartitions() {
        Set<TopicPartition> fetchable = this.subscriptions.fetchablePartitions();
        if (this.nextInLineRecords != null && !((PartitionRecords)this.nextInLineRecords).isEmpty()) {
            fetchable.remove(((PartitionRecords)this.nextInLineRecords).partition);
        }
        for (CompletedFetch completedFetch : this.completedFetches) {
            fetchable.remove(completedFetch.partition);
        }
        return fetchable;
    }

    private Map<Node, FetchRequest> createFetchRequests() {
        Cluster cluster = this.metadata.fetch();
        HashMap fetchable = new HashMap();
        for (TopicPartition partition2 : this.fetchablePartitions()) {
            Node node = cluster.leaderFor(partition2);
            if (node == null) {
                this.metadata.requestUpdate();
                continue;
            }
            if (this.client.pendingRequestCount(node) != 0) continue;
            HashMap<TopicPartition, FetchRequest.PartitionData> fetch2 = (HashMap<TopicPartition, FetchRequest.PartitionData>)fetchable.get(node);
            if (fetch2 == null) {
                fetch2 = new HashMap<TopicPartition, FetchRequest.PartitionData>();
                fetchable.put(node, fetch2);
            }
            long position = this.subscriptions.position(partition2);
            fetch2.put(partition2, new FetchRequest.PartitionData(position, this.fetchSize));
            log.trace("Added fetch request for partition {} at offset {}", (Object)partition2, (Object)position);
        }
        HashMap<Node, FetchRequest> requests = new HashMap<Node, FetchRequest>();
        for (Map.Entry entry2 : fetchable.entrySet()) {
            Node node = (Node)entry2.getKey();
            FetchRequest fetch3 = new FetchRequest(this.maxWaitMs, this.minBytes, (Map)entry2.getValue());
            requests.put(node, fetch3);
        }
        return requests;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PartitionRecords<K, V> parseFetchedData(CompletedFetch completedFetch) {
        PartitionRecords parsedRecords;
        block18: {
            TopicPartition tp = completedFetch.partition;
            FetchResponse.PartitionData partition2 = completedFetch.partitionData;
            long fetchOffset = completedFetch.fetchedOffset;
            int bytes = 0;
            int recordsCount = 0;
            parsedRecords = null;
            try {
                if (!this.subscriptions.isFetchable(tp)) {
                    log.debug("Ignoring fetched records for partition {} since it is no longer fetchable", (Object)tp);
                    break block18;
                }
                if (partition2.errorCode == Errors.NONE.code()) {
                    Long position = this.subscriptions.position(tp);
                    if (position == null || position != fetchOffset) {
                        log.debug("Discarding stale fetch response for partition {} since its offset {} does not match the expected offset {}", tp, fetchOffset, position);
                        PartitionRecords<K, V> partitionRecords = null;
                        return partitionRecords;
                    }
                    ByteBuffer buffer = partition2.recordSet;
                    MemoryRecords records = MemoryRecords.readableRecords(buffer);
                    ArrayList parsed = new ArrayList();
                    boolean skippedRecords = false;
                    for (LogEntry logEntry : records) {
                        if (logEntry.offset() >= position) {
                            parsed.add(this.parseRecord(tp, logEntry));
                            bytes += logEntry.size();
                            continue;
                        }
                        skippedRecords = true;
                    }
                    recordsCount = parsed.size();
                    this.sensors.recordTopicFetchMetrics(tp.topic(), bytes, recordsCount);
                    if (!parsed.isEmpty()) {
                        log.trace("Adding fetched record for partition {} with offset {} to buffered record list", (Object)tp, (Object)position);
                        parsedRecords = new PartitionRecords(fetchOffset, tp, parsed);
                        ConsumerRecord record = (ConsumerRecord)parsed.get(parsed.size() - 1);
                        this.sensors.recordsFetchLag.record(partition2.highWatermark - record.offset());
                    } else if (buffer.limit() > 0 && !skippedRecords) {
                        Map<TopicPartition, Long> recordTooLargePartitions = Collections.singletonMap(tp, fetchOffset);
                        throw new RecordTooLargeException("There are some messages at [Partition=Offset]: " + recordTooLargePartitions + " whose size is larger than the fetch size " + this.fetchSize + " and hence cannot be ever returned." + " Increase the fetch size on the client (using max.partition.fetch.bytes)," + " or decrease the maximum message size the broker will allow (using message.max.bytes).", recordTooLargePartitions);
                    }
                    break block18;
                }
                if (partition2.errorCode == Errors.NOT_LEADER_FOR_PARTITION.code() || partition2.errorCode == Errors.UNKNOWN_TOPIC_OR_PARTITION.code()) {
                    this.metadata.requestUpdate();
                    break block18;
                }
                if (partition2.errorCode == Errors.OFFSET_OUT_OF_RANGE.code()) {
                    if (fetchOffset != this.subscriptions.position(tp)) {
                        log.debug("Discarding stale fetch response for partition {} since the fetched offset {}does not match the current offset {}", tp, fetchOffset, this.subscriptions.position(tp));
                        break block18;
                    }
                    if (this.subscriptions.hasDefaultOffsetResetPolicy()) {
                        log.info("Fetch offset {} is out of range for partition {}, resetting offset", (Object)fetchOffset, (Object)tp);
                        this.subscriptions.needOffsetReset(tp);
                        break block18;
                    }
                    throw new OffsetOutOfRangeException(Collections.singletonMap(tp, fetchOffset));
                }
                if (partition2.errorCode == Errors.TOPIC_AUTHORIZATION_FAILED.code()) {
                    log.warn("Not authorized to read from topic {}.", (Object)tp.topic());
                    throw new TopicAuthorizationException(Collections.singleton(tp.topic()));
                }
                if (partition2.errorCode == Errors.UNKNOWN.code()) {
                    log.warn("Unknown error fetching data for topic-partition {}", (Object)tp);
                    break block18;
                }
                throw new IllegalStateException("Unexpected error code " + partition2.errorCode + " while fetching data");
            }
            finally {
                completedFetch.metricAggregator.record(tp, bytes, recordsCount);
            }
        }
        return parsedRecords;
    }

    private ConsumerRecord<K, V> parseRecord(TopicPartition partition2, LogEntry logEntry) {
        Record record = logEntry.record();
        if (this.checkCrcs && !record.isValid()) {
            throw new KafkaException("Record for partition " + partition2 + " at offset " + logEntry.offset() + " is corrupt (stored crc = " + record.checksum() + ", computed crc = " + record.computeChecksum() + ")");
        }
        try {
            long offset = logEntry.offset();
            long timestamp2 = record.timestamp();
            TimestampType timestampType2 = record.timestampType();
            ByteBuffer keyBytes = record.key();
            byte[] keyByteArray = keyBytes == null ? null : Utils.toArray(keyBytes);
            Object key = keyBytes == null ? null : (Object)this.keyDeserializer.deserialize(partition2.topic(), keyByteArray);
            ByteBuffer valueBytes = record.value();
            byte[] valueByteArray = valueBytes == null ? null : Utils.toArray(valueBytes);
            Object value2 = valueBytes == null ? null : (Object)this.valueDeserializer.deserialize(partition2.topic(), valueByteArray);
            return new ConsumerRecord<Object, Object>(partition2.topic(), partition2.partition(), offset, timestamp2, timestampType2, record.checksum(), keyByteArray == null ? -1 : keyByteArray.length, valueByteArray == null ? -1 : valueByteArray.length, key, value2);
        }
        catch (RuntimeException e) {
            throw new SerializationException("Error deserializing key/value for partition " + partition2 + " at offset " + logEntry.offset(), e);
        }
    }

    private static class FetchManagerMetrics {
        public final Metrics metrics;
        public final String metricGrpName;
        public final Sensor bytesFetched;
        public final Sensor recordsFetched;
        public final Sensor fetchLatency;
        public final Sensor recordsFetchLag;
        public final Sensor fetchThrottleTimeSensor;

        public FetchManagerMetrics(Metrics metrics, String metricGrpPrefix) {
            this.metrics = metrics;
            this.metricGrpName = metricGrpPrefix + "-fetch-manager-metrics";
            this.bytesFetched = metrics.sensor("bytes-fetched");
            this.bytesFetched.add(metrics.metricName("fetch-size-avg", this.metricGrpName, "The average number of bytes fetched per request"), new Avg());
            this.bytesFetched.add(metrics.metricName("fetch-size-max", this.metricGrpName, "The maximum number of bytes fetched per request"), new Max());
            this.bytesFetched.add(metrics.metricName("bytes-consumed-rate", this.metricGrpName, "The average number of bytes consumed per second"), new Rate());
            this.recordsFetched = metrics.sensor("records-fetched");
            this.recordsFetched.add(metrics.metricName("records-per-request-avg", this.metricGrpName, "The average number of records in each request"), new Avg());
            this.recordsFetched.add(metrics.metricName("records-consumed-rate", this.metricGrpName, "The average number of records consumed per second"), new Rate());
            this.fetchLatency = metrics.sensor("fetch-latency");
            this.fetchLatency.add(metrics.metricName("fetch-latency-avg", this.metricGrpName, "The average time taken for a fetch request."), new Avg());
            this.fetchLatency.add(metrics.metricName("fetch-latency-max", this.metricGrpName, "The max time taken for any fetch request."), new Max());
            this.fetchLatency.add(metrics.metricName("fetch-rate", this.metricGrpName, "The number of fetch requests per second."), new Rate(new Count()));
            this.recordsFetchLag = metrics.sensor("records-lag");
            this.recordsFetchLag.add(metrics.metricName("records-lag-max", this.metricGrpName, "The maximum lag in terms of number of records for any partition in this window"), new Max());
            this.fetchThrottleTimeSensor = metrics.sensor("fetch-throttle-time");
            this.fetchThrottleTimeSensor.add(metrics.metricName("fetch-throttle-time-avg", this.metricGrpName, "The average throttle time in ms"), new Avg());
            this.fetchThrottleTimeSensor.add(metrics.metricName("fetch-throttle-time-max", this.metricGrpName, "The maximum throttle time in ms"), new Max());
        }

        public void recordTopicFetchMetrics(String topic, int bytes, int records) {
            String name = "topic." + topic + ".bytes-fetched";
            Sensor bytesFetched = this.metrics.getSensor(name);
            if (bytesFetched == null) {
                HashMap<String, String> metricTags = new HashMap<String, String>(1);
                metricTags.put("topic", topic.replace('.', '_'));
                bytesFetched = this.metrics.sensor(name);
                bytesFetched.add(this.metrics.metricName("fetch-size-avg", this.metricGrpName, "The average number of bytes fetched per request for topic " + topic, metricTags), new Avg());
                bytesFetched.add(this.metrics.metricName("fetch-size-max", this.metricGrpName, "The maximum number of bytes fetched per request for topic " + topic, metricTags), new Max());
                bytesFetched.add(this.metrics.metricName("bytes-consumed-rate", this.metricGrpName, "The average number of bytes consumed per second for topic " + topic, metricTags), new Rate());
            }
            bytesFetched.record(bytes);
            name = "topic." + topic + ".records-fetched";
            Sensor recordsFetched = this.metrics.getSensor(name);
            if (recordsFetched == null) {
                HashMap<String, String> metricTags = new HashMap<String, String>(1);
                metricTags.put("topic", topic.replace('.', '_'));
                recordsFetched = this.metrics.sensor(name);
                recordsFetched.add(this.metrics.metricName("records-per-request-avg", this.metricGrpName, "The average number of records in each request for topic " + topic, metricTags), new Avg());
                recordsFetched.add(this.metrics.metricName("records-consumed-rate", this.metricGrpName, "The average number of records consumed per second for topic " + topic, metricTags), new Rate());
            }
            recordsFetched.record(records);
        }
    }

    private static class FetchResponseMetricAggregator {
        private final FetchManagerMetrics sensors;
        private final Set<TopicPartition> unrecordedPartitions;
        private int totalBytes;
        private int totalRecords;

        public FetchResponseMetricAggregator(FetchManagerMetrics sensors, Set<TopicPartition> partitions) {
            this.sensors = sensors;
            this.unrecordedPartitions = partitions;
        }

        public void record(TopicPartition partition2, int bytes, int records) {
            this.unrecordedPartitions.remove(partition2);
            this.totalBytes += bytes;
            this.totalRecords += records;
            if (this.unrecordedPartitions.isEmpty()) {
                this.sensors.bytesFetched.record(this.totalBytes);
                this.sensors.recordsFetched.record(this.totalRecords);
            }
        }
    }

    private static class CompletedFetch {
        private final TopicPartition partition;
        private final long fetchedOffset;
        private final FetchResponse.PartitionData partitionData;
        private final FetchResponseMetricAggregator metricAggregator;

        public CompletedFetch(TopicPartition partition2, long fetchedOffset, FetchResponse.PartitionData partitionData, FetchResponseMetricAggregator metricAggregator) {
            this.partition = partition2;
            this.fetchedOffset = fetchedOffset;
            this.partitionData = partitionData;
            this.metricAggregator = metricAggregator;
        }
    }

    private static class PartitionRecords<K, V> {
        private long fetchOffset;
        private TopicPartition partition;
        private List<ConsumerRecord<K, V>> records;

        public PartitionRecords(long fetchOffset, TopicPartition partition2, List<ConsumerRecord<K, V>> records) {
            this.fetchOffset = fetchOffset;
            this.partition = partition2;
            this.records = records;
        }

        private boolean isEmpty() {
            return this.records == null || this.records.isEmpty();
        }

        private void discard() {
            this.records = null;
        }

        private List<ConsumerRecord<K, V>> take(int n) {
            if (this.records == null) {
                return new ArrayList<ConsumerRecord<K, V>>();
            }
            if (n >= this.records.size()) {
                List<ConsumerRecord<K, V>> res = this.records;
                this.records = null;
                return res;
            }
            ArrayList<ConsumerRecord<K, V>> res = new ArrayList<ConsumerRecord<K, V>>(n);
            Iterator<ConsumerRecord<K, V>> iterator2 = this.records.iterator();
            for (int i = 0; i < n; ++i) {
                res.add(iterator2.next());
                iterator2.remove();
            }
            if (iterator2.hasNext()) {
                this.fetchOffset = iterator2.next().offset();
            }
            return res;
        }
    }
}

