/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.shaded.retry;

import com.google.common.base.Preconditions;
import java.util.concurrent.TimeUnit;
import org.apache.curator.shaded.RetryPolicy;
import org.apache.curator.shaded.RetrySleeper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryForever
implements RetryPolicy {
    private static final Logger log = LoggerFactory.getLogger(RetryForever.class);
    private final int retryIntervalMs;

    public RetryForever(int retryIntervalMs) {
        Preconditions.checkArgument(retryIntervalMs > 0);
        this.retryIntervalMs = retryIntervalMs;
    }

    @Override
    public boolean allowRetry(int retryCount, long elapsedTimeMs, RetrySleeper sleeper) {
        try {
            sleeper.sleepFor(this.retryIntervalMs, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            log.warn("Error occurred while sleeping", e);
            return false;
        }
        return true;
    }
}

