/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.shaded.framework.listen;

import com.google.common.base.Function;
import com.google.common.collect.Maps;
import com.google.common.util.concurrent.MoreExecutors;
import java.util.Map;
import java.util.concurrent.Executor;
import org.apache.curator.shaded.framework.listen.Listenable;
import org.apache.curator.shaded.framework.listen.ListenerEntry;
import org.apache.curator.shaded.utils.ThreadUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListenerContainer<T>
implements Listenable<T> {
    private final Logger log = LoggerFactory.getLogger(this.getClass());
    private final Map<T, ListenerEntry<T>> listeners = Maps.newConcurrentMap();

    @Override
    public void addListener(T listener) {
        this.addListener(listener, MoreExecutors.sameThreadExecutor());
    }

    @Override
    public void addListener(T listener, Executor executor) {
        this.listeners.put(listener, new ListenerEntry<T>(listener, executor));
    }

    @Override
    public void removeListener(T listener) {
        this.listeners.remove(listener);
    }

    public void clear() {
        this.listeners.clear();
    }

    public int size() {
        return this.listeners.size();
    }

    public void forEach(final Function<T, Void> function) {
        for (final ListenerEntry<T> entry2 : this.listeners.values()) {
            entry2.executor.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        function.apply(entry2.listener);
                    }
                    catch (Throwable e) {
                        ThreadUtils.checkInterrupted(e);
                        ListenerContainer.this.log.error(String.format("Listener (%s) threw an exception", entry2.listener), e);
                    }
                }
            });
        }
    }
}

