/*
 * Decompiled with CFR 0.152.
 */
package org.apache.curator.shaded.framework;

import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.curator.shaded.framework.CuratorFramework;

public class EnsureContainers {
    private final CuratorFramework client;
    private final String path;
    private final AtomicBoolean ensureNeeded = new AtomicBoolean(true);

    public EnsureContainers(CuratorFramework client, String path) {
        this.client = client;
        this.path = path;
    }

    public void ensure() throws Exception {
        if (this.ensureNeeded.get()) {
            this.internalEnsure();
        }
    }

    private synchronized void internalEnsure() throws Exception {
        if (this.ensureNeeded.compareAndSet(true, false)) {
            this.client.createContainers(this.path);
        }
    }
}

