/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli.shaded;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.ListIterator;
import java.util.Properties;
import org.apache.commons.cli.shaded.CommandLine;
import org.apache.commons.cli.shaded.CommandLineParser;
import org.apache.commons.cli.shaded.MissingArgumentException;
import org.apache.commons.cli.shaded.MissingOptionException;
import org.apache.commons.cli.shaded.Option;
import org.apache.commons.cli.shaded.OptionGroup;
import org.apache.commons.cli.shaded.Options;
import org.apache.commons.cli.shaded.ParseException;
import org.apache.commons.cli.shaded.UnrecognizedOptionException;
import org.apache.commons.cli.shaded.Util;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Deprecated
public abstract class Parser
implements CommandLineParser {
    protected CommandLine cmd;
    private Options options;
    private List requiredOptions;

    protected void setOptions(Options options) {
        this.options = options;
        this.requiredOptions = new ArrayList(options.getRequiredOptions());
    }

    protected Options getOptions() {
        return this.options;
    }

    protected List getRequiredOptions() {
        return this.requiredOptions;
    }

    protected abstract String[] flatten(Options var1, String[] var2, boolean var3) throws ParseException;

    @Override
    public CommandLine parse(Options options, String[] arguments) throws ParseException {
        return this.parse(options, arguments, null, false);
    }

    public CommandLine parse(Options options, String[] arguments, Properties properties) throws ParseException {
        return this.parse(options, arguments, properties, false);
    }

    @Override
    public CommandLine parse(Options options, String[] arguments, boolean stopAtNonOption) throws ParseException {
        return this.parse(options, arguments, null, stopAtNonOption);
    }

    public CommandLine parse(Options options, String[] arguments, Properties properties, boolean stopAtNonOption) throws ParseException {
        for (Option opt2 : options.helpOptions()) {
            opt2.clearValues();
        }
        for (OptionGroup group : options.getOptionGroups()) {
            group.setSelected(null);
        }
        this.setOptions(options);
        this.cmd = new CommandLine();
        boolean eatTheRest = false;
        if (arguments == null) {
            arguments = new String[]{};
        }
        List<String> tokenList = Arrays.asList(this.flatten(this.getOptions(), arguments, stopAtNonOption));
        ListIterator<String> iterator2 = tokenList.listIterator();
        while (iterator2.hasNext()) {
            String t = iterator2.next();
            if ("--".equals(t)) {
                eatTheRest = true;
            } else if ("-".equals(t)) {
                if (stopAtNonOption) {
                    eatTheRest = true;
                } else {
                    this.cmd.addArg(t);
                }
            } else if (t.startsWith("-")) {
                if (stopAtNonOption && !this.getOptions().hasOption(t)) {
                    eatTheRest = true;
                    this.cmd.addArg(t);
                } else {
                    this.processOption(t, iterator2);
                }
            } else {
                this.cmd.addArg(t);
                if (stopAtNonOption) {
                    eatTheRest = true;
                }
            }
            if (!eatTheRest) continue;
            while (iterator2.hasNext()) {
                String str = iterator2.next();
                if ("--".equals(str)) continue;
                this.cmd.addArg(str);
            }
        }
        this.processProperties(properties);
        this.checkRequiredOptions();
        return this.cmd;
    }

    protected void processProperties(Properties properties) throws ParseException {
        if (properties == null) {
            return;
        }
        Enumeration<?> e = properties.propertyNames();
        while (e.hasMoreElements()) {
            boolean selected;
            String option = e.nextElement().toString();
            Option opt2 = this.options.getOption(option);
            if (opt2 == null) {
                throw new UnrecognizedOptionException("Default option wasn't defined", option);
            }
            OptionGroup group = this.options.getOptionGroup(opt2);
            boolean bl = selected = group != null && group.getSelected() != null;
            if (this.cmd.hasOption(option) || selected) continue;
            String value2 = properties.getProperty(option);
            if (opt2.hasArg()) {
                if (opt2.getValues() == null || opt2.getValues().length == 0) {
                    try {
                        opt2.addValueForProcessing(value2);
                    }
                    catch (RuntimeException exp) {}
                }
            } else if (!"yes".equalsIgnoreCase(value2) && !"true".equalsIgnoreCase(value2) && !"1".equalsIgnoreCase(value2)) continue;
            this.cmd.addOption(opt2);
            this.updateRequiredOptions(opt2);
        }
    }

    protected void checkRequiredOptions() throws MissingOptionException {
        if (!this.getRequiredOptions().isEmpty()) {
            throw new MissingOptionException(this.getRequiredOptions());
        }
    }

    public void processArgs(Option opt2, ListIterator<String> iter2) throws ParseException {
        while (iter2.hasNext()) {
            String str = iter2.next();
            if (this.getOptions().hasOption(str) && str.startsWith("-")) {
                iter2.previous();
                break;
            }
            try {
                opt2.addValueForProcessing(Util.stripLeadingAndTrailingQuotes(str));
            }
            catch (RuntimeException exp) {
                iter2.previous();
                break;
            }
        }
        if (opt2.getValues() == null && !opt2.hasOptionalArg()) {
            throw new MissingArgumentException(opt2);
        }
    }

    protected void processOption(String arg, ListIterator<String> iter2) throws ParseException {
        boolean hasOption = this.getOptions().hasOption(arg);
        if (!hasOption) {
            throw new UnrecognizedOptionException("Unrecognized option: " + arg, arg);
        }
        Option opt2 = (Option)this.getOptions().getOption(arg).clone();
        this.updateRequiredOptions(opt2);
        if (opt2.hasArg()) {
            this.processArgs(opt2, iter2);
        }
        this.cmd.addOption(opt2);
    }

    private void updateRequiredOptions(Option opt2) throws ParseException {
        if (opt2.isRequired()) {
            this.getRequiredOptions().remove(opt2.getKey());
        }
        if (this.getOptions().getOptionGroup(opt2) != null) {
            OptionGroup group = this.getOptions().getOptionGroup(opt2);
            if (group.isRequired()) {
                this.getRequiredOptions().remove(group);
            }
            group.setSelected(opt2);
        }
    }
}

