/*
 * Decompiled with CFR 0.152.
 */
package org.I0Itec.zkclient;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.I0Itec.zkclient.IZkConnection;
import org.I0Itec.zkclient.exception.ZkException;
import org.I0Itec.zkclient.exception.ZkInterruptedException;
import org.I0Itec.zkclient.exception.ZkNoNodeException;
import org.I0Itec.zkclient.util.ZkPathUtil;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.Op;
import org.apache.zookeeper.OpResult;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Id;
import org.apache.zookeeper.data.Stat;
import org.apache.zookeeper.proto.CheckVersionRequest;
import org.apache.zookeeper.proto.CreateRequest;
import org.apache.zookeeper.proto.DeleteRequest;
import org.apache.zookeeper.proto.SetDataRequest;

public class InMemoryConnection
implements IZkConnection {
    private Lock _lock = new ReentrantLock(true);
    private Map<String, DataAndVersion> _data = new HashMap<String, DataAndVersion>();
    private Map<String, Long> _creationTime = new HashMap<String, Long>();
    private List<Id> _ids = new ArrayList<Id>();
    private final AtomicInteger sequence = new AtomicInteger(0);
    private Set<String> _dataWatches = new HashSet<String>();
    private Set<String> _nodeWatches = new HashSet<String>();
    private EventThread _eventThread;

    public InMemoryConnection() {
        try {
            this.create("/", null, CreateMode.PERSISTENT);
        }
        catch (KeeperException e) {
            throw ZkException.create(e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new ZkInterruptedException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws InterruptedException {
        this._lock.lockInterruptibly();
        try {
            if (this._eventThread != null) {
                this._eventThread.interrupt();
                this._eventThread.join();
                this._eventThread = null;
            }
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void connect(Watcher watcher) {
        this._lock.lock();
        try {
            if (this._eventThread != null) {
                throw new IllegalStateException("Already connected.");
            }
            this._eventThread = new EventThread(watcher);
            this._eventThread.start();
            this._eventThread.send(new WatchedEvent(null, Watcher.Event.KeeperState.SyncConnected, null));
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String create(String path, byte[] data, List<ACL> acl, CreateMode mode) throws KeeperException, InterruptedException {
        this._lock.lock();
        try {
            if (mode.isSequential()) {
                int newSequence = this.sequence.getAndIncrement();
                path = path + ZkPathUtil.leadingZeros(newSequence, 10);
            }
            if (this.exists(path, false)) {
                throw new KeeperException.NodeExistsException();
            }
            String parentPath = this.getParentPath(path);
            this.checkACL(parentPath, 4);
            this._data.put(path, new DataAndVersion(data, 0, acl));
            this._creationTime.put(path, System.currentTimeMillis());
            this.checkWatch(this._nodeWatches, path, Watcher.Event.EventType.NodeCreated);
            if (parentPath != null) {
                this.checkWatch(this._nodeWatches, parentPath, Watcher.Event.EventType.NodeChildrenChanged);
            }
            String string2 = path;
            return string2;
        }
        finally {
            this._lock.unlock();
        }
    }

    @Override
    public String create(String path, byte[] data, CreateMode mode) throws KeeperException, InterruptedException {
        return this.create(path, data, null, mode);
    }

    private String getParentPath(String path) {
        int lastIndexOf2 = path.lastIndexOf("/");
        if (lastIndexOf2 == -1 || lastIndexOf2 == 0) {
            return null;
        }
        return path.substring(0, lastIndexOf2);
    }

    @Override
    public void delete(String path) throws InterruptedException, KeeperException {
        this.delete(path, -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void delete(String path, int version) throws InterruptedException, KeeperException {
        this._lock.lock();
        try {
            DataAndVersion item;
            if (!this.exists(path, false)) {
                throw new KeeperException.NoNodeException();
            }
            String parentPath = this.getParentPath(path);
            this.checkACL(parentPath, 8);
            if (version != -1 && (item = this._data.get(path))._version != version) {
                throw KeeperException.create(KeeperException.Code.BADVERSION);
            }
            this._data.remove(path);
            this._creationTime.remove(path);
            this.checkWatch(this._nodeWatches, path, Watcher.Event.EventType.NodeDeleted);
            if (parentPath != null) {
                this.checkWatch(this._nodeWatches, parentPath, Watcher.Event.EventType.NodeChildrenChanged);
            }
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean exists(String path, boolean watch) throws KeeperException, InterruptedException {
        this._lock.lock();
        try {
            if (watch) {
                this.installWatch(this._nodeWatches, path);
            }
            boolean bl = this._data.containsKey(path);
            return bl;
        }
        finally {
            this._lock.unlock();
        }
    }

    private void installWatch(Set<String> watches, String path) {
        watches.add(path);
    }

    @Override
    public List<String> getChildren(String path, boolean watch) throws KeeperException, InterruptedException {
        if (!this.exists(path, false)) {
            throw KeeperException.create(KeeperException.Code.NONODE, path);
        }
        if (this.exists(path, false) && watch) {
            this.installWatch(this._nodeWatches, path);
        }
        this.checkACL(path, 1);
        ArrayList<String> children = new ArrayList<String>();
        String[] directoryStack = path.split("/");
        Set<String> keySet = this._data.keySet();
        for (String string2 : keySet) {
            String[] stack;
            if (!string2.startsWith(path) || (stack = string2.split("/")).length != directoryStack.length + 1) continue;
            children.add(stack[stack.length - 1]);
        }
        return children;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public ZooKeeper.States getZookeeperState() {
        this._lock.lock();
        try {
            if (this._eventThread == null) {
                ZooKeeper.States states = ZooKeeper.States.CLOSED;
                return states;
            }
            ZooKeeper.States states = ZooKeeper.States.CONNECTED;
            return states;
        }
        finally {
            this._lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] readData(String path, Stat stat, boolean watch) throws KeeperException, InterruptedException {
        if (watch) {
            this.installWatch(this._dataWatches, path);
        }
        this._lock.lock();
        try {
            DataAndVersion dataAndVersion = this._data.get(path);
            if (dataAndVersion == null) {
                throw new ZkNoNodeException(new KeeperException.NoNodeException());
            }
            this.checkACL(path, 1);
            byte[] bs = dataAndVersion.getData();
            if (stat != null) {
                stat.setVersion(dataAndVersion.getVersion());
            }
            byte[] byArray = bs;
            return byArray;
        }
        finally {
            this._lock.unlock();
        }
    }

    @Override
    public void writeData(String path, byte[] data, int expectedVersion) throws KeeperException, InterruptedException {
        this.writeDataReturnStat(path, data, expectedVersion);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Stat writeDataReturnStat(String path, byte[] data, int expectedVersion) throws KeeperException, InterruptedException {
        int newVersion = -1;
        this._lock.lock();
        try {
            this.checkWatch(this._dataWatches, path, Watcher.Event.EventType.NodeDataChanged);
            if (!this.exists(path, false)) {
                throw new KeeperException.NoNodeException();
            }
            this.checkACL(path, 2);
            newVersion = this._data.get(path).getVersion() + 1;
            this._data.put(path, new DataAndVersion(data, newVersion));
            String parentPath = this.getParentPath(path);
            if (parentPath != null) {
                this.checkWatch(this._nodeWatches, parentPath, Watcher.Event.EventType.NodeChildrenChanged);
            }
        }
        finally {
            this._lock.unlock();
        }
        Stat stat = new Stat();
        stat.setVersion(newVersion);
        return stat;
    }

    private void checkWatch(Set<String> watches, String path, Watcher.Event.EventType eventType) {
        if (watches.contains(path)) {
            watches.remove(path);
            this._eventThread.send(new WatchedEvent(eventType, Watcher.Event.KeeperState.SyncConnected, path));
        }
    }

    @Override
    public long getCreateTime(String path) {
        Long time = this._creationTime.get(path);
        if (time == null) {
            return -1L;
        }
        return time;
    }

    @Override
    public String getServers() {
        return "mem";
    }

    @Override
    public List<OpResult> multi(Iterable<Op> ops) throws KeeperException, InterruptedException {
        ArrayList<OpResult> opResults = new ArrayList<OpResult>();
        for (Op op : ops) {
            if (Op.Check.class.isAssignableFrom(op.getClass())) {
                CheckVersionRequest check = (CheckVersionRequest)op.toRequestRecord();
                this.exists(check.getPath(), false);
                opResults.add(new OpResult.CheckResult());
                continue;
            }
            if (Op.Create.class.isAssignableFrom(op.getClass())) {
                CreateRequest create2 = (CreateRequest)op.toRequestRecord();
                String path = this.create(create2.getPath(), create2.getData(), CreateMode.fromFlag(create2.getFlags()));
                opResults.add(new OpResult.CreateResult(path));
                continue;
            }
            if (Op.Delete.class.isAssignableFrom(op.getClass())) {
                DeleteRequest delete2 = (DeleteRequest)op.toRequestRecord();
                this.delete(delete2.getPath());
                opResults.add(new OpResult.DeleteResult());
                continue;
            }
            if (!Op.SetData.class.isAssignableFrom(op.getClass())) continue;
            SetDataRequest setData = (SetDataRequest)op.toRequestRecord();
            this.writeData(setData.getPath(), setData.getData(), setData.getVersion());
            opResults.add(new OpResult.SetDataResult(null));
        }
        return opResults;
    }

    @Override
    public void addAuthInfo(String scheme, byte[] auth) {
        this._ids.add(new Id(scheme, new String(auth)));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAcl(String path, List<ACL> acl, int version) throws KeeperException, InterruptedException {
        if (!this.exists(path, false)) {
            throw new KeeperException.NoNodeException();
        }
        DataAndVersion dataAndVersion = this._data.get(path);
        if (version != dataAndVersion._version) {
            throw new KeeperException.BadVersionException();
        }
        this.checkACL(path, 16);
        this._lock.lock();
        try {
            this._data.put(path, new DataAndVersion(dataAndVersion.getData(), dataAndVersion.getVersion() + 1, acl));
        }
        finally {
            this._lock.unlock();
        }
    }

    @Override
    public Map.Entry<List<ACL>, Stat> getAcl(String path) throws KeeperException, InterruptedException {
        if (!this.exists(path, false)) {
            throw new KeeperException.NoNodeException();
        }
        DataAndVersion dataAndVersion = this._data.get(path);
        Stat stat = new Stat();
        stat.setVersion(dataAndVersion.getVersion());
        stat.setCtime(this._creationTime.get(path));
        return new AbstractMap.SimpleEntry<List<ACL>, Stat>(dataAndVersion.getAcl(), stat);
    }

    private void checkACL(String path, int perm) throws KeeperException.NoAuthException {
        DataAndVersion node = this._data.get(path);
        if (node == null) {
            return;
        }
        List<ACL> acl = node.getAcl();
        if (acl == null || acl.size() == 0) {
            return;
        }
        for (Id authId : this._ids) {
            if (!authId.getScheme().equals("super")) continue;
            return;
        }
        for (ACL a : acl) {
            Id id = a.getId();
            if ((a.getPerms() & perm) == 0) continue;
            if (id.getScheme().equals("world") && id.getId().equals("anyone")) {
                return;
            }
            for (Id authId : this._ids) {
                if (!authId.getScheme().equals(id.getScheme()) || !authId.getId().equals(id.getId())) continue;
                return;
            }
        }
        throw new KeeperException.NoAuthException();
    }

    private class EventThread
    extends Thread {
        private Watcher _watcher;
        private BlockingQueue<WatchedEvent> _blockingQueue = new LinkedBlockingDeque<WatchedEvent>();

        public EventThread(Watcher watcher) {
            this._watcher = watcher;
        }

        @Override
        public void run() {
            try {
                while (true) {
                    this._watcher.process(this._blockingQueue.take());
                }
            }
            catch (InterruptedException interruptedException) {
                return;
            }
        }

        public void send(WatchedEvent event) {
            this._blockingQueue.add(event);
        }
    }

    public static class DataAndVersion {
        private byte[] _data;
        private int _version;
        private List<ACL> _acl;

        public DataAndVersion(byte[] data, int version, List<ACL> acl) {
            this._data = data;
            this._version = version;
            this._acl = acl;
        }

        public DataAndVersion(byte[] data, int version) {
            this(data, version, null);
        }

        public byte[] getData() {
            return this._data;
        }

        public int getVersion() {
            return this._version;
        }

        public List<ACL> getAcl() {
            return this._acl;
        }
    }
}

