/*
 * Decompiled with CFR 0.152.
 */
package kafka.shaded.tools;

import java.util.HashMap;
import joptsimple.ArgumentAcceptingOptionSpec;
import joptsimple.OptionParser;
import joptsimple.OptionSet;
import joptsimple.OptionSpec;
import kafka.shaded.api.OffsetRequest;
import kafka.shaded.api.OffsetRequest$;
import kafka.shaded.api.PartitionMetadata;
import kafka.shaded.api.PartitionOffsetRequestInfo;
import kafka.shaded.api.PartitionOffsetsResponse;
import kafka.shaded.api.TopicMetadata;
import kafka.shaded.client.ClientUtils$;
import kafka.shaded.cluster.BrokerEndPoint;
import kafka.shaded.common.TopicAndPartition;
import kafka.shaded.common.security.LoginManager$;
import kafka.shaded.consumer.SimpleConsumer;
import kafka.shaded.utils.CommandLineUtils$;
import kafka.shaded.utils.CoreUtils$;
import kafka.shaded.utils.ToolsUtils$;
import org.apache.kafka.shaded.common.protocol.SecurityProtocol;
import scala.Array$;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ClassTag$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;

public final class GetOffsetShell$ {
    public static final GetOffsetShell$ MODULE$;

    static {
        new GetOffsetShell$();
    }

    public void main(String[] args) {
        Seq<TopicMetadata> topicsMetadata;
        OptionParser parser = new OptionParser();
        ArgumentAcceptingOptionSpec<String> brokerListOpt = parser.accepts("broker-list", "REQUIRED: The list of hostname and port of the server to connect to.").withRequiredArg().describedAs("hostname:port,...,hostname:port").ofType(String.class);
        ArgumentAcceptingOptionSpec<String> topicOpt = parser.accepts("topic", "REQUIRED: The topic to get offset from.").withRequiredArg().describedAs("topic").ofType(String.class);
        ArgumentAcceptingOptionSpec<String> partitionOpt = parser.accepts("partitions", "comma separated list of partition ids. If not specified, it will find offsets for all partitions").withRequiredArg().describedAs("partition ids").ofType(String.class).defaultsTo("", (String[])((Object[])new String[0]));
        ArgumentAcceptingOptionSpec<Long> timeOpt = parser.accepts("time", "timestamp of the offsets before that").withRequiredArg().describedAs("timestamp/-1(latest)/-2(earliest)").ofType(Long.class).defaultsTo(Predef$.MODULE$.long2Long(-1L), (Long[])((Object[])new Long[0]));
        ArgumentAcceptingOptionSpec<Integer> nOffsetsOpt = parser.accepts("offsets", "number of offsets returned").withRequiredArg().describedAs("count").ofType(Integer.class).defaultsTo(Predef$.MODULE$.int2Integer(1), (Integer[])((Object[])new Integer[0]));
        ArgumentAcceptingOptionSpec<Integer> maxWaitMsOpt = parser.accepts("max-wait-ms", "The max amount of time each fetch request waits.").withRequiredArg().describedAs("ms").ofType(Integer.class).defaultsTo(Predef$.MODULE$.int2Integer(1000), (Integer[])((Object[])new Integer[0]));
        ArgumentAcceptingOptionSpec<String> securityProtocolOpt = parser.accepts("security-protocol", "The security protocol to use to connect to broker.").withRequiredArg().describedAs("security-protocol").ofType(String.class).defaultsTo("PLAINTEXT", (String[])((Object[])new String[0]));
        if (args.length == 0) {
            throw CommandLineUtils$.MODULE$.printUsageAndDie(parser, "An interactive shell for getting consumer offsets.");
        }
        OptionSet options = parser.parse(args);
        CommandLineUtils$.MODULE$.checkRequiredArgs(parser, options, Predef$.MODULE$.wrapRefArray((Object[])new OptionSpec[]{brokerListOpt, topicOpt, timeOpt}));
        String clientId = "GetOffsetShell";
        String brokerList = options.valueOf(brokerListOpt);
        ToolsUtils$.MODULE$.validatePortOrDie(parser, brokerList);
        Seq<BrokerEndPoint> metadataTargetBrokers = ClientUtils$.MODULE$.parseBrokerList(brokerList);
        String topic = options.valueOf(topicOpt);
        String partitionList = options.valueOf(partitionOpt);
        LongRef time = LongRef.create(options.valueOf(timeOpt));
        int nOffsets = options.valueOf(nOffsetsOpt);
        int maxWaitMs = options.valueOf(maxWaitMsOpt);
        SecurityProtocol securityProtocol = SecurityProtocol.valueOf(options.valueOf(securityProtocolOpt).toString());
        if (CoreUtils$.MODULE$.isSaslProtocol(securityProtocol)) {
            HashMap<String, Object> saslConfigs = new HashMap<String, Object>();
            saslConfigs.put("sasl.kerberos.kinit.cmd", "/usr/bin/kinit");
            saslConfigs.put("sasl.kerberos.ticket.renew.jitter", BoxesRunTime.boxToDouble(0.05));
            saslConfigs.put("sasl.kerberos.ticket.renew.window.factor", BoxesRunTime.boxToDouble(0.05));
            saslConfigs.put("sasl.kerberos.min.time.before.relogin", BoxesRunTime.boxToLong(60000L));
            LoginManager$.MODULE$.init("KafkaClient", saslConfigs);
        }
        if ((topicsMetadata = ClientUtils$.MODULE$.fetchTopicMetadata((Set)Predef$.MODULE$.Set().apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})), metadataTargetBrokers, clientId, maxWaitMs, 0, securityProtocol).topicsMetadata()).size() != 1 || !((TopicMetadata)topicsMetadata.apply(false)).topic().equals(topic)) {
            System.err.println(new StringBuilder().append((Object)new StringOps(Predef$.MODULE$.augmentString("Error: no valid topic metadata for topic: %s,  probably the topic does not exist, run ")).format(Predef$.MODULE$.genericWrapArray(new Object[]{topic}))).append((Object)"kafka.shaded-list-topic.sh to verify").toString());
            System.exit(1);
        }
        String string2 = partitionList;
        String string3 = "";
        Seq<Object> partitions = !(string2 != null ? !string2.equals(string3) : string3 != null) ? ((TopicMetadata)topicsMetadata.head()).partitionsMetadata().map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(PartitionMetadata x$1) {
                return x$1.partitionId();
            }
        }, Seq$.MODULE$.canBuildFrom()) : Predef$.MODULE$.intArrayOps((int[])Predef$.MODULE$.refArrayOps((Object[])partitionList.split(",")).map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final int apply(String x$2) {
                return new StringOps(Predef$.MODULE$.augmentString(x$2)).toInt();
            }
        }, Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Int()))).toSeq();
        partitions.foreach(new Serializable(clientId, topic, time, nOffsets, securityProtocol, topicsMetadata){
            public static final long serialVersionUID = 0L;
            private final String clientId$1;
            private final String topic$1;
            private final LongRef time$1;
            private final int nOffsets$1;
            private final SecurityProtocol securityProtocol$1;
            private final Seq topicsMetadata$1;

            public final void apply(int partitionId) {
                this.apply$mcVI$sp(partitionId);
            }

            public void apply$mcVI$sp(int partitionId) {
                Option<PartitionMetadata> option;
                block7: {
                    block6: {
                        block2: {
                            Option<BrokerEndPoint> option2;
                            block5: {
                                block4: {
                                    block3: {
                                        Option<PartitionMetadata> partitionMetadataOpt = ((TopicMetadata)this.topicsMetadata$1.head()).partitionsMetadata().find((Function1<PartitionMetadata, Object>)((Object)new Serializable(this, partitionId){
                                            public static final long serialVersionUID = 0L;
                                            private final int partitionId$1;

                                            public final boolean apply(PartitionMetadata x$3) {
                                                return x$3.partitionId() == this.partitionId$1;
                                            }
                                            {
                                                this.partitionId$1 = partitionId$1;
                                            }
                                        }));
                                        option = partitionMetadataOpt;
                                        if (!(option instanceof Some)) break block2;
                                        Some some = (Some)option;
                                        PartitionMetadata metadata = (PartitionMetadata)some.x();
                                        option2 = metadata.leader();
                                        if (!(option2 instanceof Some)) break block3;
                                        Some some2 = (Some)option2;
                                        BrokerEndPoint leader = (BrokerEndPoint)some2.x();
                                        SimpleConsumer consumer = new SimpleConsumer(leader.host(), leader.port(), 10000, 100000, this.clientId$1, this.securityProtocol$1);
                                        TopicAndPartition topicAndPartition = new TopicAndPartition(this.topic$1, partitionId);
                                        OffsetRequest request = new OffsetRequest((Map)Predef$.MODULE$.Map().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(topicAndPartition), new PartitionOffsetRequestInfo(this.time$1.elem, this.nOffsets$1))})), OffsetRequest$.MODULE$.apply$default$2(), OffsetRequest$.MODULE$.apply$default$3(), OffsetRequest$.MODULE$.apply$default$4(), OffsetRequest$.MODULE$.apply$default$5());
                                        Seq<Object> offsets = ((PartitionOffsetsResponse)consumer.getOffsetsBefore(request).partitionErrorAndOffsets().apply(topicAndPartition)).offsets();
                                        Predef$.MODULE$.println(new StringOps(Predef$.MODULE$.augmentString("%s:%d:%s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.topic$1, BoxesRunTime.boxToInteger(partitionId), offsets.mkString(",")})));
                                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                        break block4;
                                    }
                                    if (!None$.MODULE$.equals(option2)) break block5;
                                    System.err.println(new StringOps(Predef$.MODULE$.augmentString("Error: partition %d does not have a leader. Skip getting offsets")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(partitionId)})));
                                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                }
                                BoxedUnit boxedUnit = BoxedUnit.UNIT;
                                break block6;
                            }
                            throw new MatchError(option2);
                        }
                        if (!None$.MODULE$.equals(option)) break block7;
                        System.err.println(new StringOps(Predef$.MODULE$.augmentString("Error: partition %d does not exist")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(partitionId)})));
                        BoxedUnit boxedUnit = BoxedUnit.UNIT;
                    }
                    return;
                }
                throw new MatchError(option);
            }
            {
                this.clientId$1 = clientId$1;
                this.topic$1 = topic$1;
                this.time$1 = time$1;
                this.nOffsets$1 = nOffsets$1;
                this.securityProtocol$1 = securityProtocol$1;
                this.topicsMetadata$1 = topicsMetadata$1;
            }
        });
        LoginManager$.MODULE$.shutdown();
    }

    private GetOffsetShell$() {
        MODULE$ = this;
    }
}

