/*
 * Decompiled with CFR 0.152.
 */
package kafka.shaded.controller;

import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import kafka.shaded.common.TopicAndPartition;
import kafka.shaded.controller.Callbacks;
import kafka.shaded.controller.ControllerContext;
import kafka.shaded.controller.KafkaController;
import kafka.shaded.controller.NonExistentPartition$;
import kafka.shaded.controller.NonExistentReplica$;
import kafka.shaded.controller.OfflinePartition$;
import kafka.shaded.controller.OfflineReplica$;
import kafka.shaded.controller.PartitionAndReplica;
import kafka.shaded.controller.PartitionStateMachine;
import kafka.shaded.controller.ReplicaDeletionIneligible$;
import kafka.shaded.controller.ReplicaDeletionStarted$;
import kafka.shaded.controller.ReplicaDeletionSuccessful$;
import kafka.shaded.controller.ReplicaStateMachine;
import kafka.shaded.controller.TopicDeletionManager$;
import kafka.shaded.controller.TopicDeletionManager$$anonfun$kafka$controller$TopicDeletionManager$;
import kafka.shaded.controller.TopicDeletionManager$DeleteTopicsThread$;
import kafka.shaded.server.ConfigType$;
import kafka.shaded.utils.CoreUtils$;
import kafka.shaded.utils.Log4jController$;
import kafka.shaded.utils.Logging;
import kafka.shaded.utils.Logging$class;
import kafka.shaded.utils.ShutdownableThread;
import kafka.shaded.utils.ZkUtils;
import kafka.shaded.utils.ZkUtils$;
import org.apache.kafka.shaded.common.TopicPartition;
import org.apache.kafka.shaded.common.protocol.Errors;
import org.apache.kafka.shaded.common.requests.AbstractRequestResponse;
import org.apache.kafka.shaded.common.requests.StopReplicaResponse;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Set;
import scala.collection.Set$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Iterable$;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\t\u0015d\u0001B\u0001\u0003\u0001\u001d\u0011A\u0003V8qS\u000e$U\r\\3uS>tW*\u00198bO\u0016\u0014(BA\u0002\u0005\u0003)\u0019wN\u001c;s_2dWM\u001d\u0006\u0002\u000b\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001\t\u001dA\u0011\u0011\u0002D\u0007\u0002\u0015)\t1\"A\u0003tG\u0006d\u0017-\u0003\u0002\u000e\u0015\t1\u0011I\\=SK\u001a\u0004\"a\u0004\n\u000e\u0003AQ!!\u0005\u0003\u0002\u000bU$\u0018\u000e\\:\n\u0005M\u0001\"a\u0002'pO\u001eLgn\u001a\u0005\t\u0007\u0001\u0011\t\u0011)A\u0005+A\u0011acF\u0007\u0002\u0005%\u0011\u0001D\u0001\u0002\u0010\u0017\u000647.Y\"p]R\u0014x\u000e\u001c7fe\"A!\u0004\u0001B\u0001B\u0003%1$\u0001\rj]&$\u0018.\u00197U_BL7m\u001d+p\u0005\u0016$U\r\\3uK\u0012\u00042\u0001H\u0010\"\u001b\u0005i\"B\u0001\u0010\u000b\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0003Au\u00111aU3u!\t\u0011SE\u0004\u0002\nG%\u0011AEC\u0001\u0007!J,G-\u001a4\n\u0005\u0019:#AB*ue&twM\u0003\u0002%\u0015!A\u0011\u0006\u0001B\u0001B\u0003%1$\u0001\u0012j]&$\u0018.\u00197U_BL7m]%oK2Lw-\u001b2mK\u001a{'\u000fR3mKRLwN\u001c\u0005\u0006W\u0001!\t\u0001L\u0001\u0007y%t\u0017\u000e\u001e \u0015\t5rs\u0006\r\t\u0003-\u0001AQa\u0001\u0016A\u0002UAqA\u0007\u0016\u0011\u0002\u0003\u00071\u0004C\u0004*UA\u0005\t\u0019A\u000e\t\u000fI\u0002!\u0019!C\u0001g\u0005\t2m\u001c8ue>dG.\u001a:D_:$X\r\u001f;\u0016\u0003Q\u0002\"AF\u001b\n\u0005Y\u0012!!E\"p]R\u0014x\u000e\u001c7fe\u000e{g\u000e^3yi\"1\u0001\b\u0001Q\u0001\nQ\n!cY8oiJ|G\u000e\\3s\u0007>tG/\u001a=uA!9!\b\u0001b\u0001\n\u0003Y\u0014!\u00069beRLG/[8o'R\fG/Z'bG\"Lg.Z\u000b\u0002yA\u0011a#P\u0005\u0003}\t\u0011Q\u0003U1si&$\u0018n\u001c8Ti\u0006$X-T1dQ&tW\r\u0003\u0004A\u0001\u0001\u0006I\u0001P\u0001\u0017a\u0006\u0014H/\u001b;j_:\u001cF/\u0019;f\u001b\u0006\u001c\u0007.\u001b8fA!9!\t\u0001b\u0001\n\u0003\u0019\u0015a\u0005:fa2L7-Y*uCR,W*Y2iS:,W#\u0001#\u0011\u0005Y)\u0015B\u0001$\u0003\u0005M\u0011V\r\u001d7jG\u0006\u001cF/\u0019;f\u001b\u0006\u001c\u0007.\u001b8f\u0011\u0019A\u0005\u0001)A\u0005\t\u0006!\"/\u001a9mS\u000e\f7\u000b^1uK6\u000b7\r[5oK\u0002BqA\u0013\u0001C\u0002\u0013\u00051*A\tu_BL7m\u001d+p\u0005\u0016$U\r\\3uK\u0012,\u0012\u0001\u0014\t\u0004\u001bB\u000bS\"\u0001(\u000b\u0005=k\u0012aB7vi\u0006\u0014G.Z\u0005\u0003A9CaA\u0015\u0001!\u0002\u0013a\u0015A\u0005;pa&\u001c7\u000fV8CK\u0012+G.\u001a;fI\u0002Bq\u0001\u0016\u0001C\u0002\u0013\u0005Q+A\u000bqCJ$\u0018\u000e^5p]N$vNQ3EK2,G/\u001a3\u0016\u0003Y\u00032!\u0014)X!\tA6,D\u0001Z\u0015\tQF!\u0001\u0004d_6lwN\\\u0005\u00039f\u0013\u0011\u0003V8qS\u000e\fe\u000e\u001a)beRLG/[8o\u0011\u0019q\u0006\u0001)A\u0005-\u00061\u0002/\u0019:uSRLwN\\:U_\n+G)\u001a7fi\u0016$\u0007\u0005C\u0004a\u0001\t\u0007I\u0011A1\u0002\u0015\u0011,G.\u001a;f\u0019>\u001c7.F\u0001c!\t\u0019G.D\u0001e\u0015\t)g-A\u0003m_\u000e\\7O\u0003\u0002hQ\u0006Q1m\u001c8dkJ\u0014XM\u001c;\u000b\u0005%T\u0017\u0001B;uS2T\u0011a[\u0001\u0005U\u00064\u0018-\u0003\u0002nI\ni!+Z3oiJ\fg\u000e\u001e'pG.Daa\u001c\u0001!\u0002\u0013\u0011\u0017a\u00033fY\u0016$X\rT8dW\u0002Bq!\u001d\u0001C\u0002\u0013\u00051*A\u000eu_BL7m]%oK2Lw-\u001b2mK\u001a{'\u000fR3mKRLwN\u001c\u0005\u0007g\u0002\u0001\u000b\u0011\u0002'\u00029Q|\u0007/[2t\u0013:,G.[4jE2,gi\u001c:EK2,G/[8oA!9Q\u000f\u0001b\u0001\n\u00031\u0018\u0001\u00053fY\u0016$X\rV8qS\u000e\u001c8i\u001c8e+\u00059\bCA2y\u0013\tIHMA\u0005D_:$\u0017\u000e^5p]\"11\u0010\u0001Q\u0001\n]\f\u0011\u0003Z3mKR,Gk\u001c9jGN\u001cuN\u001c3!\u0011\u001di\bA1A\u0005\u0002y\fq\u0003Z3mKR,Gk\u001c9jGN#\u0018\r^3DQ\u0006tw-\u001a3\u0016\u0003}\u0004B!!\u0001\u0002\b5\u0011\u00111\u0001\u0006\u0004\u0003\u000b1\u0017AB1u_6L7-\u0003\u0003\u0002\n\u0005\r!!D!u_6L7MQ8pY\u0016\fg\u000eC\u0004\u0002\u000e\u0001\u0001\u000b\u0011B@\u00021\u0011,G.\u001a;f)>\u0004\u0018nY*uCR,7\t[1oO\u0016$\u0007\u0005C\u0005\u0002\u0012\u0001\u0001\r\u0011\"\u0001\u0002\u0014\u0005\u0011B-\u001a7fi\u0016$v\u000e]5dgRC'/Z1e+\t\t)\u0002\u0005\u0003\u0002\u0018\u0005eQ\"\u0001\u0001\u0007\r\u0005m\u0001\u0001AA\u000f\u0005I!U\r\\3uKR{\u0007/[2t)\"\u0014X-\u00193\u0014\t\u0005e\u0011q\u0004\t\u0004\u001f\u0005\u0005\u0012bAA\u0012!\t\u00112\u000b[;uI><h.\u00192mKRC'/Z1e\u0011\u001dY\u0013\u0011\u0004C\u0001\u0003O!\"!!\u0006\t\u0015\u0005-\u0012\u0011\u0004b\u0001\n\u0003\ti#A\u0004{WV#\u0018\u000e\\:\u0016\u0005\u0005=\u0002cA\b\u00022%\u0019\u00111\u0007\t\u0003\u000fi[W\u000b^5mg\"I\u0011qGA\rA\u0003%\u0011qF\u0001\tu.,F/\u001b7tA!A\u00111HA\r\t\u0003\ni$\u0001\u0004e_^{'o\u001b\u000b\u0003\u0003\u007f\u00012!CA!\u0013\r\t\u0019E\u0003\u0002\u0005+:LG\u000fC\u0005\u0002H\u0001\u0001\r\u0011\"\u0001\u0002J\u00051B-\u001a7fi\u0016$v\u000e]5dgRC'/Z1e?\u0012*\u0017\u000f\u0006\u0003\u0002@\u0005-\u0003BCA'\u0003\u000b\n\t\u00111\u0001\u0002\u0016\u0005\u0019\u0001\u0010J\u0019\t\u0011\u0005E\u0003\u0001)Q\u0005\u0003+\t1\u0003Z3mKR,Gk\u001c9jGN$\u0006N]3bI\u0002B\u0011\"!\u0016\u0001\u0005\u0004%\t!a\u0016\u0002)%\u001cH)\u001a7fi\u0016$v\u000e]5d\u000b:\f'\r\\3e+\t\tI\u0006\u0005\u0003\u0002\\\u0005\u0005TBAA/\u0015\r\tyF[\u0001\u0005Y\u0006tw-\u0003\u0003\u0002d\u0005u#a\u0002\"p_2,\u0017M\u001c\u0005\t\u0003O\u0002\u0001\u0015!\u0003\u0002Z\u0005)\u0012n\u001d#fY\u0016$X\rV8qS\u000e,e.\u00192mK\u0012\u0004\u0003bBA6\u0001\u0011\u0005\u0011QH\u0001\u0006gR\f'\u000f\u001e\u0005\b\u0003_\u0002A\u0011AA\u001f\u0003!\u0019\b.\u001e;e_^t\u0007bBA:\u0001\u0011\u0005\u0011QO\u0001\u0019K:\fX/Z;f)>\u0004\u0018nY:G_J$U\r\\3uS>tG\u0003BA \u0003oBq!!\u001f\u0002r\u0001\u00071$\u0001\u0004u_BL7m\u001d\u0005\b\u0003{\u0002A\u0011AA@\u0003]\u0011Xm];nK\u0012+G.\u001a;j_:4uN\u001d+pa&\u001c7\u000f\u0006\u0003\u0002@\u0005\u0005\u0005\"CA=\u0003w\u0002\n\u00111\u0001\u001c\u0011\u001d\t)\t\u0001C\u0001\u0003\u000f\u000b1CZ1jYJ+\u0007\u000f\\5dC\u0012+G.\u001a;j_:$B!a\u0010\u0002\n\"A\u00111RAB\u0001\u0004\ti)\u0001\u0005sKBd\u0017nY1t!\u0011ar$a$\u0011\u0007Y\t\t*C\u0002\u0002\u0014\n\u00111\u0003U1si&$\u0018n\u001c8B]\u0012\u0014V\r\u001d7jG\u0006Dq!a&\u0001\t\u0003\tI*\u0001\u0010nCJ\\Gk\u001c9jG&sW\r\\5hS\ndWMR8s\t\u0016dW\r^5p]R!\u0011qHAN\u0011\u001d\tI(!&A\u0002mAq!a(\u0001\t\u0003\t\t+\u0001\u000fjgR{\u0007/[2J]\u0016d\u0017nZ5cY\u00164uN\u001d#fY\u0016$\u0018n\u001c8\u0015\t\u0005\r\u0016q\u0015\t\u0004\u0013\u0005\u0015\u0016bAA2\u0015!9\u0011\u0011VAO\u0001\u0004\t\u0013!\u0002;pa&\u001c\u0007bBAW\u0001\u0011\u0005\u0011qV\u0001\u001aSN$v\u000e]5d\t\u0016dW\r^5p]&s\u0007K]8he\u0016\u001c8\u000f\u0006\u0003\u0002$\u0006E\u0006bBAU\u0003W\u0003\r!\t\u0005\b\u0003k\u0003A\u0011AA\\\u0003YI7\u000fU1si&$\u0018n\u001c8U_\n+G)\u001a7fi\u0016$G\u0003BAR\u0003sCq!a/\u00024\u0002\u0007q+A\tu_BL7-\u00118e!\u0006\u0014H/\u001b;j_:Dq!a0\u0001\t\u0003\t\t-\u0001\u000ejgR{\u0007/[2Rk\u0016,X\rZ+q\r>\u0014H)\u001a7fi&|g\u000e\u0006\u0003\u0002$\u0006\r\u0007bBAU\u0003{\u0003\r!\t\u0005\b\u0003\u000f\u0004A\u0011BA\u001f\u0003y\tw/Y5u)>\u0004\u0018n\u0019#fY\u0016$\u0018n\u001c8O_RLg-[2bi&|g\u000eC\u0004\u0002L\u0002!I!!\u0010\u00023I,7/^7f)>\u0004\u0018n\u0019#fY\u0016$\u0018n\u001c8UQJ,\u0017\r\u001a\u0005\b\u0003\u001f\u0004A\u0011BAi\u0003]\u0019w.\u001c9mKR,'+\u001a9mS\u000e\fG)\u001a7fi&|g\u000e\u0006\u0003\u0002@\u0005M\u0007\u0002CAF\u0003\u001b\u0004\r!!$\t\u000f\u0005]\u0007\u0001\"\u0003\u0002Z\u0006Q\u0012n\u001d+pa&\u001cW\t\\5hS\ndWMR8s\t\u0016dW\r^5p]R!\u00111UAn\u0011\u001d\tI+!6A\u0002\u0005Bq!a8\u0001\t\u0013\t\t/A\rnCJ\\Gk\u001c9jG\u001a{'\u000fR3mKRLwN\u001c*fiJLH\u0003BA \u0003GDq!!+\u0002^\u0002\u0007\u0011\u0005C\u0004\u0002h\u0002!I!!;\u0002'\r|W\u000e\u001d7fi\u0016$U\r\\3uKR{\u0007/[2\u0015\t\u0005}\u00121\u001e\u0005\b\u0003S\u000b)\u000f1\u0001\"\u0011\u001d\ty\u000f\u0001C\u0005\u0003c\fqb\u001c8U_BL7\rR3mKRLwN\u001c\u000b\u0005\u0003\u007f\t\u0019\u0010C\u0004\u0002z\u00055\b\u0019A\u000e\t\u000f\u0005]\b\u0001\"\u0003\u0002z\u0006!2\u000f^1siJ+\u0007\u000f\\5dC\u0012+G.\u001a;j_:$B!a\u0010\u0002|\"A\u0011Q`A{\u0001\u0004\ti)\u0001\u000fsKBd\u0017nY1t\r>\u0014Hk\u001c9jGN$vNQ3EK2,G/\u001a3\t\u000f\t\u0005\u0001\u0001\"\u0003\u0003\u0004\u0005\u0019rN\u001c)beRLG/[8o\t\u0016dW\r^5p]R!\u0011q\bB\u0003\u0011\u001d!\u0016q a\u0001\u0005\u000f\u00012\u0001H\u0010X\u0011\u001d\u0011Y\u0001\u0001C\u0005\u0005\u001b\ta\u0004Z3mKR,Gk\u001c9jGN#x\u000e\u001d*fa2L7-Y\"bY2\u0014\u0017mY6\u0015\r\u0005}\"q\u0002B\u0016\u0011!\u0011\tB!\u0003A\u0002\tM\u0011AF:u_B\u0014V\r\u001d7jG\u0006\u0014Vm\u001d9p]N,wJ\u00196\u0011\t\tU!qE\u0007\u0003\u0005/QAA!\u0007\u0003\u001c\u0005A!/Z9vKN$8OC\u0002[\u0005;Q1!\u0002B\u0010\u0015\u0011\u0011\tCa\t\u0002\r\u0005\u0004\u0018m\u00195f\u0015\t\u0011)#A\u0002pe\u001eLAA!\u000b\u0003\u0018\t9\u0012IY:ue\u0006\u001cGOU3rk\u0016\u001cHOU3ta>t7/\u001a\u0005\t\u0005[\u0011I\u00011\u0001\u00030\u0005I!/\u001a9mS\u000e\f\u0017\n\u001a\t\u0004\u0013\tE\u0012b\u0001B\u001a\u0015\t\u0019\u0011J\u001c;\t\u0013\t]\u0002!%A\u0005\u0002\te\u0012!\t:fgVlW\rR3mKRLwN\u001c$peR{\u0007/[2tI\u0011,g-Y;mi\u0012\nTC\u0001B\u001eU\rY\"QH\u0016\u0003\u0005\u007f\u0001BA!\u0011\u0003L5\u0011!1\t\u0006\u0005\u0005\u000b\u00129%A\u0005v]\u000eDWmY6fI*\u0019!\u0011\n\u0006\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003N\t\r#!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u001eI!\u0011\u000b\u0002\u0002\u0002#\u0005!1K\u0001\u0015)>\u0004\u0018n\u0019#fY\u0016$\u0018n\u001c8NC:\fw-\u001a:\u0011\u0007Y\u0011)F\u0002\u0005\u0002\u0005\u0005\u0005\t\u0012\u0001B,'\r\u0011)\u0006\u0003\u0005\bW\tUC\u0011\u0001B.)\t\u0011\u0019\u0006\u0003\u0006\u0003`\tU\u0013\u0013!C\u0001\u0005s\t1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\u0012\u0004B\u0003B2\u0005+\n\n\u0011\"\u0001\u0003:\u0005YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIM\u0002")
public class TopicDeletionManager
implements Logging {
    public final KafkaController kafka$controller$TopicDeletionManager$$controller;
    private final ControllerContext controllerContext;
    private final PartitionStateMachine partitionStateMachine;
    private final ReplicaStateMachine replicaStateMachine;
    private final scala.collection.mutable.Set<String> topicsToBeDeleted;
    private final scala.collection.mutable.Set<TopicAndPartition> partitionsToBeDeleted;
    private final ReentrantLock deleteLock;
    private final scala.collection.mutable.Set<String> topicsIneligibleForDeletion;
    private final Condition deleteTopicsCond;
    private final AtomicBoolean deleteTopicStateChanged;
    private DeleteTopicsThread deleteTopicsThread;
    private final Boolean isDeleteTopicEnabled;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static Set<String> $lessinit$greater$default$3() {
        return TopicDeletionManager$.MODULE$.$lessinit$greater$default$3();
    }

    public static Set<String> $lessinit$greater$default$2() {
        return TopicDeletionManager$.MODULE$.$lessinit$greater$default$2();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        TopicDeletionManager topicDeletionManager = this;
        synchronized (topicDeletionManager) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public ControllerContext controllerContext() {
        return this.controllerContext;
    }

    public PartitionStateMachine partitionStateMachine() {
        return this.partitionStateMachine;
    }

    public ReplicaStateMachine replicaStateMachine() {
        return this.replicaStateMachine;
    }

    public scala.collection.mutable.Set<String> topicsToBeDeleted() {
        return this.topicsToBeDeleted;
    }

    public scala.collection.mutable.Set<TopicAndPartition> partitionsToBeDeleted() {
        return this.partitionsToBeDeleted;
    }

    public ReentrantLock deleteLock() {
        return this.deleteLock;
    }

    public scala.collection.mutable.Set<String> topicsIneligibleForDeletion() {
        return this.topicsIneligibleForDeletion;
    }

    public Condition deleteTopicsCond() {
        return this.deleteTopicsCond;
    }

    public AtomicBoolean deleteTopicStateChanged() {
        return this.deleteTopicStateChanged;
    }

    public DeleteTopicsThread deleteTopicsThread() {
        return this.deleteTopicsThread;
    }

    public void deleteTopicsThread_$eq(DeleteTopicsThread x$1) {
        this.deleteTopicsThread = x$1;
    }

    public Boolean isDeleteTopicEnabled() {
        return this.isDeleteTopicEnabled;
    }

    public void start() {
        if (Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled())) {
            this.deleteTopicsThread_$eq(new DeleteTopicsThread());
            if (this.topicsToBeDeleted().size() > 0) {
                this.deleteTopicStateChanged().set(true);
            }
            this.deleteTopicsThread().start();
        }
    }

    public void shutdown() {
        if (Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled()) && this.deleteTopicsThread().initiateShutdown()) {
            this.resumeTopicDeletionThread();
            this.deleteTopicsThread().awaitShutdown();
            this.topicsToBeDeleted().clear();
            this.partitionsToBeDeleted().clear();
            this.topicsIneligibleForDeletion().clear();
        }
    }

    public void enqueueTopicsForDeletion(Set<String> topics) {
        if (Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled())) {
            this.topicsToBeDeleted().$plus$plus$eq(topics);
            this.partitionsToBeDeleted().$plus$plus$eq(topics.flatMap(new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ TopicDeletionManager $outer;

                public final Set<TopicAndPartition> apply(String topic) {
                    return this.$outer.controllerContext().partitionsForTopic(topic);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                }
            }, Set$.MODULE$.canBuildFrom()));
            this.resumeTopicDeletionThread();
        }
    }

    public void resumeDeletionForTopics(Set<String> topics) {
        Set topicsToResumeDeletion;
        if (Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled()) && (topicsToResumeDeletion = (Set)topics.$amp(this.topicsToBeDeleted())).size() > 0) {
            this.topicsIneligibleForDeletion().$minus$minus$eq(topicsToResumeDeletion);
            this.resumeTopicDeletionThread();
        }
    }

    public Set<String> resumeDeletionForTopics$default$1() {
        return Set$.MODULE$.empty();
    }

    public void failReplicaDeletion(Set<PartitionAndReplica> replicas) {
        Set replicasThatFailedToDelete;
        if (Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled()) && (replicasThatFailedToDelete = (Set)replicas.filter((Function1<PartitionAndReplica, Object>)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicDeletionManager $outer;

            public final boolean apply(PartitionAndReplica r) {
                return this.$outer.isTopicQueuedUpForDeletion(r.topic());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }))).size() > 0) {
            Set<String> topics = replicasThatFailedToDelete.map(new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply(PartitionAndReplica x$1) {
                    return x$1.topic();
                }
            }, Set$.MODULE$.canBuildFrom());
            this.debug((Function0<String>)((Object)new Serializable(this, replicasThatFailedToDelete, topics){
                public static final long serialVersionUID = 0L;
                private final Set replicasThatFailedToDelete$1;
                private final Set topics$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Deletion failed for replicas %s. Halting deletion for topics %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.replicasThatFailedToDelete$1.mkString(","), this.topics$1}));
                }
                {
                    this.replicasThatFailedToDelete$1 = replicasThatFailedToDelete$1;
                    this.topics$1 = topics$1;
                }
            }));
            this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges(replicasThatFailedToDelete, ReplicaDeletionIneligible$.MODULE$, this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges$default$3());
            this.markTopicIneligibleForDeletion(topics);
            this.resumeTopicDeletionThread();
        }
    }

    public void markTopicIneligibleForDeletion(Set<String> topics) {
        if (Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled())) {
            scala.collection.mutable.Set newTopicsToHaltDeletion = (scala.collection.mutable.Set)this.topicsToBeDeleted().$amp(topics);
            this.topicsIneligibleForDeletion().$plus$plus$eq(newTopicsToHaltDeletion);
            if (newTopicsToHaltDeletion.size() > 0) {
                this.info((Function0<String>)((Object)new Serializable(this, newTopicsToHaltDeletion){
                    public static final long serialVersionUID = 0L;
                    private final scala.collection.mutable.Set newTopicsToHaltDeletion$1;

                    public final String apply() {
                        return new StringOps(Predef$.MODULE$.augmentString("Halted deletion of topics %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.newTopicsToHaltDeletion$1.mkString(",")}));
                    }
                    {
                        this.newTopicsToHaltDeletion$1 = newTopicsToHaltDeletion$1;
                    }
                }));
            }
        }
    }

    public boolean isTopicIneligibleForDeletion(String topic) {
        return Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled()) ? this.topicsIneligibleForDeletion().contains(topic) : true;
    }

    public boolean isTopicDeletionInProgress(String topic) {
        return Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled()) ? this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().isAtLeastOneReplicaInDeletionStartedState(topic) : false;
    }

    public boolean isPartitionToBeDeleted(TopicAndPartition topicAndPartition) {
        return Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled()) ? this.partitionsToBeDeleted().contains(topicAndPartition) : false;
    }

    public boolean isTopicQueuedUpForDeletion(String topic) {
        return Predef$.MODULE$.Boolean2boolean(this.isDeleteTopicEnabled()) ? this.topicsToBeDeleted().contains(topic) : false;
    }

    public void kafka$controller$TopicDeletionManager$$awaitTopicDeletionNotification() {
        CoreUtils$.MODULE$.inLock(this.deleteLock(), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicDeletionManager $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                while (this.$outer.deleteTopicsThread().isRunning().get() && !this.$outer.deleteTopicStateChanged().compareAndSet(true, false)) {
                    this.$outer.debug((Function0<String>)((Object)new Serializable(this){
                        public static final long serialVersionUID = 0L;

                        public final String apply() {
                            return "Waiting for signal to start or continue topic deletion";
                        }
                    }));
                    this.$outer.deleteTopicsCond().await();
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    private void resumeTopicDeletionThread() {
        this.deleteTopicStateChanged().set(true);
        CoreUtils$.MODULE$.inLock(this.deleteLock(), new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicDeletionManager $outer;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.deleteTopicsCond().signal();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void kafka$controller$TopicDeletionManager$$completeReplicaDeletion(Set<PartitionAndReplica> replicas) {
        Set successfullyDeletedReplicas = (Set)replicas.filter((Function1<PartitionAndReplica, Object>)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicDeletionManager $outer;

            public final boolean apply(PartitionAndReplica r) {
                return this.$outer.isTopicQueuedUpForDeletion(r.topic());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
        this.debug((Function0<String>)((Object)new Serializable(this, successfullyDeletedReplicas){
            public static final long serialVersionUID = 0L;
            private final Set successfullyDeletedReplicas$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Deletion successfully completed for replicas %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.successfullyDeletedReplicas$1.mkString(",")}));
            }
            {
                this.successfullyDeletedReplicas$1 = successfullyDeletedReplicas$1;
            }
        }));
        this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges(successfullyDeletedReplicas, ReplicaDeletionSuccessful$.MODULE$, this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges$default$3());
        this.resumeTopicDeletionThread();
    }

    public boolean kafka$controller$TopicDeletionManager$$isTopicEligibleForDeletion(String topic) {
        return this.topicsToBeDeleted().contains(topic) && !this.isTopicDeletionInProgress(topic) && !this.isTopicIneligibleForDeletion(topic);
    }

    public void kafka$controller$TopicDeletionManager$$markTopicForDeletionRetry(String topic) {
        Set<PartitionAndReplica> failedReplicas = this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().replicasInState(topic, ReplicaDeletionIneligible$.MODULE$);
        this.info((Function0<String>)((Object)new Serializable(this, topic, failedReplicas){
            public static final long serialVersionUID = 0L;
            private final String topic$1;
            private final Set failedReplicas$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Retrying delete topic for topic %s since replicas %s were not successfully deleted")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.topic$1, this.failedReplicas$1.mkString(",")}));
            }
            {
                this.topic$1 = topic$1;
                this.failedReplicas$1 = failedReplicas$1;
            }
        }));
        this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges(failedReplicas, OfflineReplica$.MODULE$, this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges$default$3());
    }

    public void kafka$controller$TopicDeletionManager$$completeDeleteTopic(String topic) {
        this.partitionStateMachine().deregisterPartitionChangeListener(topic);
        Set<PartitionAndReplica> replicasForDeletedTopic = this.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().replicasInState(topic, ReplicaDeletionSuccessful$.MODULE$);
        this.replicaStateMachine().handleStateChanges(replicasForDeletedTopic, NonExistentReplica$.MODULE$, this.replicaStateMachine().handleStateChanges$default$3());
        Set<TopicAndPartition> partitionsForDeletedTopic = this.controllerContext().partitionsForTopic(topic);
        this.partitionStateMachine().handleStateChanges(partitionsForDeletedTopic, OfflinePartition$.MODULE$, this.partitionStateMachine().handleStateChanges$default$3(), this.partitionStateMachine().handleStateChanges$default$4());
        this.partitionStateMachine().handleStateChanges(partitionsForDeletedTopic, NonExistentPartition$.MODULE$, this.partitionStateMachine().handleStateChanges$default$3(), this.partitionStateMachine().handleStateChanges$default$4());
        this.topicsToBeDeleted().$minus$eq(topic);
        this.partitionsToBeDeleted().retain((Function1<TopicAndPartition, Object>)((Object)new Serializable(this, topic){
            public static final long serialVersionUID = 0L;
            private final String topic$2;

            public final boolean apply(TopicAndPartition x$2) {
                String string2 = x$2.topic();
                String string3 = this.topic$2;
                return string2 != null ? !string2.equals(string3) : string3 != null;
            }
            {
                this.topic$2 = topic$2;
            }
        }));
        ZkUtils zkUtils = this.controllerContext().zkUtils();
        zkUtils.zkClient().deleteRecursive(ZkUtils$.MODULE$.getTopicPath(topic));
        zkUtils.zkClient().deleteRecursive(ZkUtils$.MODULE$.getEntityConfigPath(ConfigType$.MODULE$.Topic(), topic));
        zkUtils.zkClient().delete(ZkUtils$.MODULE$.getDeleteTopicPath(topic));
        this.controllerContext().removeTopic(topic);
    }

    public void kafka$controller$TopicDeletionManager$$onTopicDeletion(Set<String> topics) {
        this.info((Function0<String>)((Object)new Serializable(this, topics){
            public static final long serialVersionUID = 0L;
            private final Set topics$2;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Topic deletion callback for %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.topics$2.mkString(",")}));
            }
            {
                this.topics$2 = topics$2;
            }
        }));
        Set<TopicAndPartition> partitions = topics.flatMap(new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicDeletionManager $outer;

            public final Set<TopicAndPartition> apply(String topic) {
                return this.$outer.controllerContext().partitionsForTopic(topic);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, Set$.MODULE$.canBuildFrom());
        this.kafka$controller$TopicDeletionManager$$controller.sendUpdateMetadataRequest(this.controllerContext().liveOrShuttingDownBrokerIds().toSeq(), partitions);
        Map partitionReplicaAssignmentByTopic = this.controllerContext().partitionReplicaAssignment().groupBy(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(Tuple2<TopicAndPartition, Seq<Object>> p) {
                return p._1().topic();
            }
        });
        topics.foreach(new Serializable(this, partitionReplicaAssignmentByTopic){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicDeletionManager $outer;
            private final Map partitionReplicaAssignmentByTopic$1;

            public final void apply(String topic) {
                this.$outer.kafka$controller$TopicDeletionManager$$onPartitionDeletion(((TraversableOnce)((TraversableLike)this.partitionReplicaAssignmentByTopic$1.apply(topic)).map(new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final TopicAndPartition apply(Tuple2<TopicAndPartition, Seq<Object>> x$3) {
                        return x$3._1();
                    }
                }, Iterable$.MODULE$.canBuildFrom())).toSet());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.partitionReplicaAssignmentByTopic$1 = partitionReplicaAssignmentByTopic$1;
            }
        });
    }

    private void startReplicaDeletion(Set<PartitionAndReplica> replicasForTopicsToBeDeleted) {
        replicasForTopicsToBeDeleted.groupBy(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final String apply(PartitionAndReplica x$4) {
                return x$4.topic();
            }
        }).foreach(new Serializable(this, replicasForTopicsToBeDeleted){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicDeletionManager $outer;
            private final Set replicasForTopicsToBeDeleted$1;

            public final void apply(Tuple2<String, Set<PartitionAndReplica>> x0$1) {
                Tuple2<String, Set<PartitionAndReplica>> tuple2 = x0$1;
                if (tuple2 != null) {
                    BoxedUnit boxedUnit;
                    String topic = tuple2._1();
                    Set aliveReplicasForTopic = (Set)this.$outer.controllerContext().allLiveReplicas().filter((Function1<PartitionAndReplica, Object>)((Object)new Serializable(this, topic){
                        public static final long serialVersionUID = 0L;
                        private final String topic$3;

                        public final boolean apply(PartitionAndReplica p) {
                            return p.topic().equals(this.topic$3);
                        }
                        {
                            this.topic$3 = topic$3;
                        }
                    }));
                    Set deadReplicasForTopic = (Set)this.replicasForTopicsToBeDeleted$1.$minus$minus(aliveReplicasForTopic);
                    Set<PartitionAndReplica> successfullyDeletedReplicas = this.$outer.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().replicasInState(topic, ReplicaDeletionSuccessful$.MODULE$);
                    Set replicasForDeletionRetry = (Set)aliveReplicasForTopic.$minus$minus(successfullyDeletedReplicas);
                    this.$outer.replicaStateMachine().handleStateChanges(deadReplicasForTopic, ReplicaDeletionIneligible$.MODULE$, this.$outer.replicaStateMachine().handleStateChanges$default$3());
                    this.$outer.replicaStateMachine().handleStateChanges(replicasForDeletionRetry, OfflineReplica$.MODULE$, this.$outer.replicaStateMachine().handleStateChanges$default$3());
                    this.$outer.debug((Function0<String>)((Object)new Serializable(this, replicasForDeletionRetry){
                        public static final long serialVersionUID = 0L;
                        private final Set replicasForDeletionRetry$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Deletion started for replicas %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.replicasForDeletionRetry$1.mkString(",")}));
                        }
                        {
                            this.replicasForDeletionRetry$1 = replicasForDeletionRetry$1;
                        }
                    }));
                    this.$outer.kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().handleStateChanges(replicasForDeletionRetry, ReplicaDeletionStarted$.MODULE$, new Callbacks.CallbackBuilder().stopReplicaCallback((Function2<AbstractRequestResponse, Object, BoxedUnit>)((Object)new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$startReplicaDeletion$2 $outer;

                        public final void apply(AbstractRequestResponse stopReplicaResponseObj, int replicaId) {
                            this.$outer.kafka$controller$TopicDeletionManager$$anonfun$$$outer().kafka$controller$TopicDeletionManager$$deleteTopicStopReplicaCallback(stopReplicaResponseObj, replicaId);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    })).build());
                    if (deadReplicasForTopic.size() > 0) {
                        this.$outer.debug((Function0<String>)((Object)new Serializable(this, topic, deadReplicasForTopic){
                            public static final long serialVersionUID = 0L;
                            private final String topic$3;
                            private final Set deadReplicasForTopic$1;

                            public final String apply() {
                                return new StringOps(Predef$.MODULE$.augmentString("Dead Replicas (%s) found for topic %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.deadReplicasForTopic$1.mkString(","), this.topic$3}));
                            }
                            {
                                this.topic$3 = topic$3;
                                this.deadReplicasForTopic$1 = deadReplicasForTopic$1;
                            }
                        }));
                        this.$outer.markTopicIneligibleForDeletion((Set)Set$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    BoxedUnit boxedUnit2 = boxedUnit;
                    return;
                }
                throw new MatchError(tuple2);
            }

            public /* synthetic */ TopicDeletionManager kafka$controller$TopicDeletionManager$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.replicasForTopicsToBeDeleted$1 = replicasForTopicsToBeDeleted$1;
            }
        });
    }

    public void kafka$controller$TopicDeletionManager$$onPartitionDeletion(Set<TopicAndPartition> partitionsToBeDeleted) {
        this.info((Function0<String>)((Object)new Serializable(this, partitionsToBeDeleted){
            public static final long serialVersionUID = 0L;
            private final Set partitionsToBeDeleted$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Partition deletion callback for %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.partitionsToBeDeleted$1.mkString(",")}));
            }
            {
                this.partitionsToBeDeleted$1 = partitionsToBeDeleted$1;
            }
        }));
        Set<PartitionAndReplica> replicasPerPartition = this.controllerContext().replicasForPartition(partitionsToBeDeleted);
        this.startReplicaDeletion(replicasPerPartition);
    }

    public void kafka$controller$TopicDeletionManager$$deleteTopicStopReplicaCallback(AbstractRequestResponse stopReplicaResponseObj, int replicaId) {
        StopReplicaResponse stopReplicaResponse = (StopReplicaResponse)stopReplicaResponseObj;
        this.debug((Function0<String>)((Object)new Serializable(this, stopReplicaResponse){
            public static final long serialVersionUID = 0L;
            private final StopReplicaResponse stopReplicaResponse$1;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Delete topic callback invoked for %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.stopReplicaResponse$1}));
            }
            {
                this.stopReplicaResponse$1 = stopReplicaResponse$1;
            }
        }));
        scala.collection.mutable.Map<TopicPartition, Short> responseMap = JavaConverters$.MODULE$.mapAsScalaMapConverter(stopReplicaResponse.responses()).asScala();
        Set<TopicPartition> partitionsInError = stopReplicaResponse.errorCode() != Errors.NONE.code() ? responseMap.keySet() : ((TraversableOnce)((TraversableLike)responseMap.filter((Function1<TopicPartition, Object>)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Tuple2<TopicPartition, Short> x0$2) {
                Tuple2<TopicPartition, Short> tuple2 = x0$2;
                if (tuple2 != null) {
                    Short error = tuple2._2();
                    boolean bl = !BoxesRunTime.equalsNumObject(error, BoxesRunTime.boxToShort(Errors.NONE.code()));
                    return bl;
                }
                throw new MatchError(tuple2);
            }
        }))).map(new Serializable(this){
            public static final long serialVersionUID = 0L;

            public final TopicPartition apply(Tuple2<TopicPartition, Short> x$5) {
                return x$5._1();
            }
        }, Iterable$.MODULE$.canBuildFrom())).toSet();
        Set replicasInError = partitionsInError.map(new Serializable(this, replicaId){
            public static final long serialVersionUID = 0L;
            private final int replicaId$1;

            public final PartitionAndReplica apply(TopicPartition p) {
                return new PartitionAndReplica(p.topic(), p.partition(), this.replicaId$1);
            }
            {
                this.replicaId$1 = replicaId$1;
            }
        }, Set$.MODULE$.canBuildFrom());
        CoreUtils$.MODULE$.inLock(this.controllerContext().controllerLock(), new Serializable(this, replicaId, responseMap, partitionsInError, replicasInError){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicDeletionManager $outer;
            public final int replicaId$1;
            private final scala.collection.mutable.Map responseMap$1;
            private final Set partitionsInError$1;
            private final Set replicasInError$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.$outer.failReplicaDeletion(this.replicasInError$1);
                if (this.replicasInError$1.size() != this.responseMap$1.size()) {
                    Set deletedReplicas = (Set)this.responseMap$1.keySet().$minus$minus(this.partitionsInError$1);
                    this.$outer.kafka$controller$TopicDeletionManager$$completeReplicaDeletion(deletedReplicas.map(new Serializable(this){
                        public static final long serialVersionUID = 0L;
                        private final /* synthetic */ $anonfun$kafka$controller$TopicDeletionManager$$deleteTopicStopReplicaCallback$1 $outer;

                        public final PartitionAndReplica apply(TopicPartition p) {
                            return new PartitionAndReplica(p.topic(), p.partition(), this.$outer.replicaId$1);
                        }
                        {
                            if ($outer == null) {
                                throw null;
                            }
                            this.$outer = $outer;
                        }
                    }, Set$.MODULE$.canBuildFrom()));
                }
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.replicaId$1 = replicaId$1;
                this.responseMap$1 = responseMap$1;
                this.partitionsInError$1 = partitionsInError$1;
                this.replicasInError$1 = replicasInError$1;
            }
        });
    }

    public TopicDeletionManager(KafkaController controller, Set<String> initialTopicsToBeDeleted, Set<String> initialTopicsIneligibleForDeletion) {
        this.kafka$controller$TopicDeletionManager$$controller = controller;
        Logging$class.$init$(this);
        this.logIdent_$eq(new StringBuilder().append((Object)"[Topic Deletion Manager ").append(BoxesRunTime.boxToInteger(controller.config().brokerId())).append((Object)"], ").toString());
        this.controllerContext = controller.controllerContext();
        this.partitionStateMachine = controller.partitionStateMachine();
        this.replicaStateMachine = controller.replicaStateMachine();
        this.topicsToBeDeleted = scala.collection.mutable.Set$.MODULE$.empty().$plus$plus(initialTopicsToBeDeleted);
        this.partitionsToBeDeleted = this.topicsToBeDeleted().flatMap(new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ TopicDeletionManager $outer;

            public final Set<TopicAndPartition> apply(String topic) {
                return this.$outer.controllerContext().partitionsForTopic(topic);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, scala.collection.mutable.Set$.MODULE$.canBuildFrom());
        this.deleteLock = new ReentrantLock();
        this.topicsIneligibleForDeletion = scala.collection.mutable.Set$.MODULE$.empty().$plus$plus((GenTraversableOnce)initialTopicsIneligibleForDeletion.$amp(initialTopicsToBeDeleted));
        this.deleteTopicsCond = this.deleteLock().newCondition();
        this.deleteTopicStateChanged = new AtomicBoolean(false);
        this.deleteTopicsThread = null;
        this.isDeleteTopicEnabled = controller.config().deleteTopicEnable();
    }

    public class DeleteTopicsThread
    extends ShutdownableThread {
        private final ZkUtils zkUtils;

        public ZkUtils zkUtils() {
            return this.zkUtils;
        }

        @Override
        public void doWork() {
            this.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().kafka$controller$TopicDeletionManager$$awaitTopicDeletionNotification();
            if (this.isRunning().get()) {
                CoreUtils$.MODULE$.inLock(this.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().controllerContext().controllerLock(), new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ DeleteTopicsThread $outer;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        This topicsQueuedForDeletion = Set$.MODULE$.empty().$plus$plus(this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().topicsToBeDeleted());
                        if (!topicsQueuedForDeletion.isEmpty()) {
                            this.$outer.info((Function0<String>)((Object)new Serializable(this, (Set)topicsQueuedForDeletion){
                                public static final long serialVersionUID = 0L;
                                private final Set topicsQueuedForDeletion$1;

                                public final String apply() {
                                    return new StringBuilder().append((Object)"Handling deletion for topics ").append((Object)this.topicsQueuedForDeletion$1.mkString(",")).toString();
                                }
                                {
                                    this.topicsQueuedForDeletion$1 = topicsQueuedForDeletion$1;
                                }
                            }));
                        }
                        topicsQueuedForDeletion.foreach((Function1<String, BoxedUnit>)((Object)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ DeleteTopicsThread$$anonfun$doWork$1 $outer;

                            public final void apply(String topic) {
                                if (this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer().kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().areAllReplicasForTopicDeleted(topic)) {
                                    this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer().kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().kafka$controller$TopicDeletionManager$$completeDeleteTopic(topic);
                                    this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer().info((Function0<String>)((Object)new Serializable(this, topic){
                                        public static final long serialVersionUID = 0L;
                                        private final String topic$4;

                                        public final String apply() {
                                            return new StringOps(Predef$.MODULE$.augmentString("Deletion of topic %s successfully completed")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.topic$4}));
                                        }
                                        {
                                            this.topic$4 = topic$4;
                                        }
                                    }));
                                } else if (this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer().kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().isAtLeastOneReplicaInDeletionStartedState(topic)) {
                                    Set<PartitionAndReplica> replicasInDeletionStartedState = this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer().kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().replicasInState(topic, ReplicaDeletionStarted$.MODULE$);
                                    Set<A> replicaIds = replicasInDeletionStartedState.map(new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final int apply(PartitionAndReplica x$6) {
                                            return x$6.replica();
                                        }
                                    }, Set$.MODULE$.canBuildFrom());
                                    Set<A> partitions = replicasInDeletionStartedState.map(new Serializable(this){
                                        public static final long serialVersionUID = 0L;

                                        public final TopicAndPartition apply(PartitionAndReplica r) {
                                            return new TopicAndPartition(r.topic(), r.partition());
                                        }
                                    }, Set$.MODULE$.canBuildFrom());
                                    this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer().info((Function0<String>)((Object)new Serializable(this, replicaIds, partitions, topic){
                                        public static final long serialVersionUID = 0L;
                                        private final Set replicaIds$1;
                                        private final Set partitions$1;
                                        private final String topic$4;

                                        public final String apply() {
                                            return new StringOps(Predef$.MODULE$.augmentString("Deletion for replicas %s for partition %s of topic %s in progress")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.replicaIds$1.mkString(","), this.partitions$1.mkString(","), this.topic$4}));
                                        }
                                        {
                                            this.replicaIds$1 = replicaIds$1;
                                            this.partitions$1 = partitions$1;
                                            this.topic$4 = topic$4;
                                        }
                                    }));
                                } else if (this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer().kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().kafka$controller$TopicDeletionManager$$controller.replicaStateMachine().isAnyReplicaInState(topic, ReplicaDeletionIneligible$.MODULE$)) {
                                    this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer().kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().kafka$controller$TopicDeletionManager$$markTopicForDeletionRetry(topic);
                                }
                                if (this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer().kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().kafka$controller$TopicDeletionManager$$isTopicEligibleForDeletion(topic)) {
                                    this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer().info((Function0<String>)((Object)new Serializable(this, topic){
                                        public static final long serialVersionUID = 0L;
                                        private final String topic$4;

                                        public final String apply() {
                                            return new StringOps(Predef$.MODULE$.augmentString("Deletion of topic %s (re)started")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.topic$4}));
                                        }
                                        {
                                            this.topic$4 = topic$4;
                                        }
                                    }));
                                    this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer().kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().kafka$controller$TopicDeletionManager$$onTopicDeletion((Set)Set$.MODULE$.apply(Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
                                } else if (this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer().kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer().isTopicIneligibleForDeletion(topic)) {
                                    this.$outer.kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer().info((Function0<String>)((Object)new Serializable(this, topic){
                                        public static final long serialVersionUID = 0L;
                                        private final String topic$4;

                                        public final String apply() {
                                            return new StringOps(Predef$.MODULE$.augmentString("Not retrying deletion of topic %s at this time since it is marked ineligible for deletion")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.topic$4}));
                                        }
                                        {
                                            this.topic$4 = topic$4;
                                        }
                                    }));
                                }
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        }));
                    }

                    public /* synthetic */ DeleteTopicsThread kafka$controller$TopicDeletionManager$DeleteTopicsThread$$anonfun$$$outer() {
                        return this.$outer;
                    }
                    {
                        if ($outer == null) {
                            throw null;
                        }
                        this.$outer = $outer;
                    }
                });
                return;
            }
        }

        public /* synthetic */ TopicDeletionManager kafka$controller$TopicDeletionManager$DeleteTopicsThread$$$outer() {
            return TopicDeletionManager.this;
        }

        public DeleteTopicsThread() {
            if (TopicDeletionManager.this == null) {
                throw null;
            }
            super(new StringBuilder().append((Object)"delete-topics-thread-").append(BoxesRunTime.boxToInteger(TopicDeletionManager.this.kafka$controller$TopicDeletionManager$$controller.config().brokerId())).toString(), false);
            this.zkUtils = TopicDeletionManager.this.controllerContext().zkUtils();
        }
    }
}

