/*
 * Decompiled with CFR 0.152.
 */
package kafka.shaded.cluster;

import java.io.Serializable;
import java.util.concurrent.atomic.AtomicLong;
import kafka.shaded.cluster.Partition;
import kafka.shaded.cluster.Replica$;
import kafka.shaded.common.KafkaException;
import kafka.shaded.log.Log;
import kafka.shaded.server.LogOffsetMetadata;
import kafka.shaded.server.LogOffsetMetadata$;
import kafka.shaded.server.LogReadResult;
import kafka.shaded.utils.Log4jController$;
import kafka.shaded.utils.Logging;
import kafka.shaded.utils.Logging$class;
import kafka.shaded.utils.Time;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005\u0015e\u0001B\u0001\u0003\u0001\u001d\u0011qAU3qY&\u001c\u0017M\u0003\u0002\u0004\t\u000591\r\\;ti\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001M\u0019\u0001\u0001\u0003\b\u0011\u0005%aQ\"\u0001\u0006\u000b\u0003-\tQa]2bY\u0006L!!\u0004\u0006\u0003\r\u0005s\u0017PU3g!\ty!#D\u0001\u0011\u0015\t\tB!A\u0003vi&d7/\u0003\u0002\u0014!\t9Aj\\4hS:<\u0007\u0002C\u000b\u0001\u0005\u000b\u0007I\u0011\u0001\f\u0002\u0011\t\u0014xn[3s\u0013\u0012,\u0012a\u0006\t\u0003\u0013aI!!\u0007\u0006\u0003\u0007%sG\u000f\u0003\u0005\u001c\u0001\t\u0005\t\u0015!\u0003\u0018\u0003%\u0011'o\\6fe&#\u0007\u0005\u0003\u0005\u001e\u0001\t\u0015\r\u0011\"\u0001\u001f\u0003%\u0001\u0018M\u001d;ji&|g.F\u0001 !\t\u0001\u0013%D\u0001\u0003\u0013\t\u0011#AA\u0005QCJ$\u0018\u000e^5p]\"AA\u0005\u0001B\u0001B\u0003%q$\u0001\u0006qCJ$\u0018\u000e^5p]\u0002B\u0001B\n\u0001\u0003\u0002\u0003\u0006IaJ\u0001\u0005i&lW\r\u0005\u0002\u0010Q%\u0011\u0011\u0006\u0005\u0002\u0005)&lW\r\u0003\u0005,\u0001\t\u0005\t\u0015!\u0003-\u0003eIg.\u001b;jC2D\u0015n\u001a5XCR,'/\\1sWZ\u000bG.^3\u0011\u0005%i\u0013B\u0001\u0018\u000b\u0005\u0011auN\\4\t\u0011A\u0002!Q1A\u0005\u0002E\n1\u0001\\8h+\u0005\u0011\u0004cA\u00054k%\u0011AG\u0003\u0002\u0007\u001fB$\u0018n\u001c8\u0011\u0005YBT\"A\u001c\u000b\u0005A\"\u0011BA\u001d8\u0005\raun\u001a\u0005\tw\u0001\u0011\t\u0011)A\u0005e\u0005!An\\4!\u0011\u0015i\u0004\u0001\"\u0001?\u0003\u0019a\u0014N\\5u}Q1q\bQ!C\u0007\u0012\u0003\"\u0001\t\u0001\t\u000bUa\u0004\u0019A\f\t\u000bua\u0004\u0019A\u0010\t\u000f\u0019b\u0004\u0013!a\u0001O!91\u0006\u0010I\u0001\u0002\u0004a\u0003b\u0002\u0019=!\u0003\u0005\rA\r\u0005\u0007\r\u0002\u0001\u000b\u0015B$\u0002+!Lw\r[,bi\u0016\u0014X.\u0019:l\u001b\u0016$\u0018\rZ1uCB\u0011\u0001jS\u0007\u0002\u0013*\u0011!\nB\u0001\u0007g\u0016\u0014h/\u001a:\n\u00051K%!\u0005'pO>3gm]3u\u001b\u0016$\u0018\rZ1uC\"\u0012QI\u0014\t\u0003\u0013=K!\u0001\u0015\u0006\u0003\u0011Y|G.\u0019;jY\u0016DaA\u0015\u0001!B\u00139\u0015\u0001\u00067pO\u0016sGm\u00144gg\u0016$X*\u001a;bI\u0006$\u0018\r\u000b\u0002R\u001d\"9Q\u000b\u0001b\u0001\n\u00031\u0016!\u0002;pa&\u001cW#A,\u0011\u0005a[fBA\u0005Z\u0013\tQ&\"\u0001\u0004Qe\u0016$WMZ\u0005\u00039v\u0013aa\u0015;sS:<'B\u0001.\u000b\u0011\u0019y\u0006\u0001)A\u0005/\u00061Ao\u001c9jG\u0002Bq!\u0019\u0001C\u0002\u0013\u0005a#A\u0006qCJ$\u0018\u000e^5p]&#\u0007BB2\u0001A\u0003%q#\u0001\u0007qCJ$\u0018\u000e^5p]&#\u0007\u0005C\u0003f\u0001\u0011\u0005a-A\u0004jg2{7-\u00197\u0016\u0003\u001d\u0004\"!\u00035\n\u0005%T!a\u0002\"p_2,\u0017M\u001c\u0005\u0007W\u0002\u0001\u000b\u0011\u00027\u000291\f7\u000f^\"bk\u001eDG/\u00169US6,Wj]+oI\u0016\u0014H._5oOB\u0011QN^\u0007\u0002]*\u0011q\u000e]\u0001\u0007CR|W.[2\u000b\u0005E\u0014\u0018AC2p]\u000e,(O]3oi*\u00111\u000f^\u0001\u0005kRLGNC\u0001v\u0003\u0011Q\u0017M^1\n\u0005]t'AC!u_6L7\rT8oO\")\u0011\u0010\u0001C\u0001u\u0006\u0011B.Y:u\u0007\u0006,x\r\u001b;VaRKW.Z't+\u0005a\u0003\"\u0002?\u0001\t\u0003i\u0018aE;qI\u0006$X\rT8h%\u0016\fGMU3tk2$Hc\u0001@\u0002\u0004A\u0011\u0011b`\u0005\u0004\u0003\u0003Q!\u0001B+oSRDq!!\u0002|\u0001\u0004\t9!A\u0007m_\u001e\u0014V-\u00193SKN,H\u000e\u001e\t\u0004\u0011\u0006%\u0011bAA\u0006\u0013\niAj\\4SK\u0006$'+Z:vYRDq!a\u0004\u0001\t\u0013\t\t\"\u0001\tm_\u001e,e\u000eZ(gMN,Go\u0018\u0013fcR\u0019a0a\u0005\t\u000f\u0005U\u0011Q\u0002a\u0001\u000f\u0006ya.Z<M_\u001e,e\u000eZ(gMN,G\u000fC\u0004\u0002\u001a\u0001!\t!a\u0007\u0002\u00191|w-\u00128e\u001f\u001a47/\u001a;\u0016\u0003\u001dCq!a\b\u0001\t\u0003\t\t#A\tiS\u001eDw+\u0019;fe6\f'o[0%KF$2A`A\u0012\u0011\u001d\t)#!\bA\u0002\u001d\u000b\u0001C\\3x\u0011&<\u0007nV1uKJl\u0017M]6\t\u000f\u0005%\u0002\u0001\"\u0001\u0002\u001c\u0005i\u0001.[4i/\u0006$XM]7be.Dq!!\f\u0001\t\u0003\ty#\u0001\u0010d_:4XM\u001d;I/R{Gj\\2bY>3gm]3u\u001b\u0016$\u0018\rZ1uCR\ta\u0010C\u0004\u00024\u0001!\t%!\u000e\u0002\r\u0015\fX/\u00197t)\r9\u0017q\u0007\u0005\t\u0003s\t\t\u00041\u0001\u0002<\u0005!A\u000f[1u!\rI\u0011QH\u0005\u0004\u0003\u007fQ!aA!os\"9\u00111\t\u0001\u0005B\u0005\u0015\u0013\u0001\u00035bg\"\u001cu\u000eZ3\u0015\u0003]Aq!!\u0013\u0001\t\u0003\nY%\u0001\u0005u_N#(/\u001b8h)\u00059v!CA(\u0005\u0005\u0005\t\u0012AA)\u0003\u001d\u0011V\r\u001d7jG\u0006\u00042\u0001IA*\r!\t!!!A\t\u0002\u0005U3cAA*\u0011!9Q(a\u0015\u0005\u0002\u0005eCCAA)\u0011)\ti&a\u0015\u0012\u0002\u0013\u0005\u0011qL\u0001\u001cI1,7o]5oSR$sM]3bi\u0016\u0014H\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005\u0005$fA\u0014\u0002d-\u0012\u0011Q\r\t\u0005\u0003O\n\t(\u0004\u0002\u0002j)!\u00111NA7\u0003%)hn\u00195fG.,GMC\u0002\u0002p)\t!\"\u00198o_R\fG/[8o\u0013\u0011\t\u0019(!\u001b\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW\r\u0003\u0006\u0002x\u0005M\u0013\u0013!C\u0001\u0003s\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\"TCAA>U\ra\u00131\r\u0005\u000b\u0003\u007f\n\u0019&%A\u0005\u0002\u0005\u0005\u0015a\u0007\u0013mKN\u001c\u0018N\\5uI\u001d\u0014X-\u0019;fe\u0012\"WMZ1vYR$S'\u0006\u0002\u0002\u0004*\u001a!'a\u0019")
public class Replica
implements Logging {
    private final int brokerId;
    private final Partition partition;
    private final Time time;
    private final Option<Log> log;
    private volatile LogOffsetMetadata highWatermarkMetadata;
    public volatile LogOffsetMetadata kafka$cluster$Replica$$logEndOffsetMetadata;
    private final String topic;
    private final int partitionId;
    private final AtomicLong lastCaughtUpTimeMsUnderlying;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static Option<Log> $lessinit$greater$default$5() {
        return Replica$.MODULE$.$lessinit$greater$default$5();
    }

    public static long $lessinit$greater$default$4() {
        return Replica$.MODULE$.$lessinit$greater$default$4();
    }

    public static Time $lessinit$greater$default$3() {
        return Replica$.MODULE$.$lessinit$greater$default$3();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        Replica replica = this;
        synchronized (replica) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public int brokerId() {
        return this.brokerId;
    }

    public Partition partition() {
        return this.partition;
    }

    public Option<Log> log() {
        return this.log;
    }

    public String topic() {
        return this.topic;
    }

    public int partitionId() {
        return this.partitionId;
    }

    public boolean isLocal() {
        Option<Log> option;
        block4: {
            boolean bl;
            block3: {
                block2: {
                    option = this.log();
                    if (!(option instanceof Some)) break block2;
                    bl = true;
                    break block3;
                }
                if (!None$.MODULE$.equals(option)) break block4;
                bl = false;
            }
            return bl;
        }
        throw new MatchError(option);
    }

    public long lastCaughtUpTimeMs() {
        return this.lastCaughtUpTimeMsUnderlying.get();
    }

    public void updateLogReadResult(LogReadResult logReadResult) {
        this.logEndOffset_$eq(logReadResult.info().fetchOffsetMetadata());
        if (logReadResult.isReadFromLogEnd()) {
            this.lastCaughtUpTimeMsUnderlying.set(this.time.milliseconds());
        }
    }

    private void logEndOffset_$eq(LogOffsetMetadata newLogEndOffset) {
        if (this.isLocal()) {
            throw new KafkaException(new StringOps(Predef$.MODULE$.augmentString("Should not set log end offset on partition [%s,%d]'s local replica %d")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.topic(), BoxesRunTime.boxToInteger(this.partitionId()), BoxesRunTime.boxToInteger(this.brokerId())})));
        }
        this.kafka$cluster$Replica$$logEndOffsetMetadata = newLogEndOffset;
        this.trace((Function0<String>)((Object)new scala.Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ Replica $outer;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Setting log end offset for replica %d for partition [%s,%d] to [%s]")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.$outer.brokerId()), this.$outer.topic(), BoxesRunTime.boxToInteger(this.$outer.partitionId()), this.$outer.kafka$cluster$Replica$$logEndOffsetMetadata}));
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }));
    }

    public LogOffsetMetadata logEndOffset() {
        return this.isLocal() ? this.log().get().logEndOffsetMetadata() : this.kafka$cluster$Replica$$logEndOffsetMetadata;
    }

    public void highWatermark_$eq(LogOffsetMetadata newHighWatermark) {
        if (this.isLocal()) {
            this.highWatermarkMetadata = newHighWatermark;
            this.trace((Function0<String>)((Object)new scala.Serializable(this, newHighWatermark){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ Replica $outer;
                private final LogOffsetMetadata newHighWatermark$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Setting high watermark for replica %d partition [%s,%d] on broker %d to [%s]")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.$outer.brokerId()), this.$outer.topic(), BoxesRunTime.boxToInteger(this.$outer.partitionId()), BoxesRunTime.boxToInteger(this.$outer.brokerId()), this.newHighWatermark$1}));
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.newHighWatermark$1 = newHighWatermark$1;
                }
            }));
            return;
        }
        throw new KafkaException(new StringOps(Predef$.MODULE$.augmentString("Should not set high watermark on partition [%s,%d]'s non-local replica %d")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.topic(), BoxesRunTime.boxToInteger(this.partitionId()), BoxesRunTime.boxToInteger(this.brokerId())})));
    }

    public LogOffsetMetadata highWatermark() {
        return this.highWatermarkMetadata;
    }

    public void convertHWToLocalOffsetMetadata() {
        if (this.isLocal()) {
            this.highWatermarkMetadata = this.log().get().convertToOffsetMetadata(this.highWatermarkMetadata.messageOffset());
            return;
        }
        throw new KafkaException(new StringOps(Predef$.MODULE$.augmentString("Should not construct complete high watermark on partition [%s,%d]'s non-local replica %d")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.topic(), BoxesRunTime.boxToInteger(this.partitionId()), BoxesRunTime.boxToInteger(this.brokerId())})));
    }

    public boolean equals(Object that) {
        if (that instanceof Replica) {
            Replica other = (Replica)that;
            return this.topic().equals(other.topic()) && this.brokerId() == other.brokerId() && this.partition().equals(other.partition());
        }
        return false;
    }

    public int hashCode() {
        return 31 + this.topic().hashCode() + 17 * this.brokerId() + this.partition().hashCode();
    }

    public String toString() {
        StringBuilder replicaString = new StringBuilder();
        replicaString.append(new StringBuilder().append((Object)"ReplicaId: ").append(BoxesRunTime.boxToInteger(this.brokerId())).toString());
        replicaString.append(new StringBuilder().append((Object)"; Topic: ").append((Object)this.topic()).toString());
        replicaString.append(new StringBuilder().append((Object)"; Partition: ").append(BoxesRunTime.boxToInteger(this.partition().partitionId())).toString());
        replicaString.append(new StringBuilder().append((Object)"; isLocal: ").append(BoxesRunTime.boxToBoolean(this.isLocal())).toString());
        Serializable serializable = this.isLocal() ? replicaString.append(new StringBuilder().append((Object)"; Highwatermark: ").append(this.highWatermark()).toString()) : BoxedUnit.UNIT;
        return replicaString.toString();
    }

    public Replica(int brokerId, Partition partition2, Time time, long initialHighWatermarkValue, Option<Log> log2) {
        this.brokerId = brokerId;
        this.partition = partition2;
        this.time = time;
        this.log = log2;
        Logging$class.$init$(this);
        this.highWatermarkMetadata = new LogOffsetMetadata(initialHighWatermarkValue, LogOffsetMetadata$.MODULE$.$lessinit$greater$default$2(), LogOffsetMetadata$.MODULE$.$lessinit$greater$default$3());
        this.kafka$cluster$Replica$$logEndOffsetMetadata = LogOffsetMetadata$.MODULE$.UnknownOffsetMetadata();
        this.topic = partition2.topic();
        this.partitionId = partition2.partitionId();
        this.lastCaughtUpTimeMsUnderlying = new AtomicLong(time.milliseconds());
    }
}

