/*
 * Decompiled with CFR 0.152.
 */
package kafka.shaded.cluster;

import kafka.shaded.cluster.Broker;
import kafka.shaded.cluster.EndPoint;
import kafka.shaded.cluster.EndPoint$;
import kafka.shaded.common.BrokerNotAvailableException;
import kafka.shaded.common.KafkaException;
import kafka.shaded.utils.Json$;
import org.apache.kafka.shaded.common.protocol.SecurityProtocol;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Predef$ArrowAssoc$;
import scala.Serializable;
import scala.Some;
import scala.StringContext;
import scala.Tuple2;
import scala.Tuple3;
import scala.collection.Map;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.List$;
import scala.runtime.BoxesRunTime;

public final class Broker$
implements Serializable {
    public static final Broker$ MODULE$;

    static {
        new Broker$();
    }

    public Broker createBroker(int id, String brokerInfoString) {
        if (brokerInfoString == null) {
            throw new BrokerNotAvailableException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Broker id ", " does not exist"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(id)})));
        }
        try {
            Option<Object> option = Json$.MODULE$.parseFull(brokerInfoString);
            if (option instanceof Some) {
                scala.collection.immutable.Map map2;
                Some some = (Some)option;
                Object m = some.x();
                scala.collection.immutable.Map brokerInfo = (scala.collection.immutable.Map)m;
                int version = BoxesRunTime.unboxToInt(brokerInfo.apply("version"));
                if (version < 1) {
                    throw new KafkaException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unsupported version of broker registration: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{brokerInfoString})));
                }
                if (version == 1) {
                    String host = (String)brokerInfo.apply("host");
                    int port = BoxesRunTime.unboxToInt(brokerInfo.apply("port"));
                    map2 = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply(Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef$ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(SecurityProtocol.PLAINTEXT), new EndPoint(host, port, SecurityProtocol.PLAINTEXT))}));
                } else {
                    List listeners = (List)brokerInfo.apply("endpoints");
                    map2 = ((TraversableOnce)listeners.map(new Serializable(){
                        public static final long serialVersionUID = 0L;

                        public final Tuple2<SecurityProtocol, EndPoint> apply(String listener) {
                            EndPoint ep = EndPoint$.MODULE$.createEndPoint(listener);
                            return new Tuple2<SecurityProtocol, EndPoint>(ep.protocolType(), ep);
                        }
                    }, List$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
                }
                scala.collection.immutable.Map endpoints = map2;
                Option<String> rack = brokerInfo.get("rack").filter(new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final boolean apply(Object x$1) {
                        return x$1 != null;
                    }
                }).map(new Serializable(){
                    public static final long serialVersionUID = 0L;

                    public final String apply(Object x$2) {
                        return (String)x$2;
                    }
                });
                Broker broker = new Broker(id, endpoints, rack);
                return broker;
            }
            if (None$.MODULE$.equals(option)) {
                throw new BrokerNotAvailableException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Broker id ", " does not exist"})).s(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(id)})));
            }
            throw new MatchError(option);
        }
        catch (Throwable throwable) {
            throw new KafkaException(new StringContext(Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Failed to parse the broker info from zookeeper: ", ""})).s(Predef$.MODULE$.genericWrapArray(new Object[]{brokerInfoString})), throwable);
        }
    }

    public Broker apply(int id, Map<SecurityProtocol, EndPoint> endPoints, Option<String> rack) {
        return new Broker(id, endPoints, rack);
    }

    public Option<Tuple3<Object, Map<SecurityProtocol, EndPoint>, Option<String>>> unapply(Broker x$0) {
        return x$0 == null ? None$.MODULE$ : new Some<Tuple3<Integer, Map<SecurityProtocol, EndPoint>, Option<String>>>(new Tuple3<Integer, Map<SecurityProtocol, EndPoint>, Option<String>>(BoxesRunTime.boxToInteger(x$0.id()), x$0.endPoints(), x$0.rack()));
    }

    public SecurityProtocol $lessinit$greater$default$4() {
        return SecurityProtocol.PLAINTEXT;
    }

    private Object readResolve() {
        return MODULE$;
    }

    private Broker$() {
        MODULE$ = this;
    }
}

