/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.clients.consumer.internals;

import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.apache.kafka.clients.consumer.ConsumerRebalanceListener;
import org.apache.kafka.clients.consumer.OffsetAndMetadata;
import org.apache.kafka.clients.consumer.OffsetResetStrategy;
import org.apache.kafka.common.TopicPartition;

public class SubscriptionState {
    private SubscriptionType subscriptionType;
    private Pattern subscribedPattern;
    private final Set<String> subscription;
    private final Set<String> groupSubscription;
    private final Set<TopicPartition> userAssignment;
    private final Map<TopicPartition, TopicPartitionState> assignment;
    private boolean needsPartitionAssignment;
    private boolean needsFetchCommittedOffsets;
    private final OffsetResetStrategy defaultResetStrategy;
    private ConsumerRebalanceListener listener;
    private static final String SUBSCRIPTION_EXCEPTION_MESSAGE = "Subscription to topics, partitions and pattern are mutually exclusive";

    private void setSubscriptionType(SubscriptionType type) {
        if (this.subscriptionType == SubscriptionType.NONE) {
            this.subscriptionType = type;
        } else if (this.subscriptionType != type) {
            throw new IllegalStateException(SUBSCRIPTION_EXCEPTION_MESSAGE);
        }
    }

    public SubscriptionState(OffsetResetStrategy defaultResetStrategy) {
        this.defaultResetStrategy = defaultResetStrategy;
        this.subscription = new HashSet<String>();
        this.userAssignment = new HashSet<TopicPartition>();
        this.assignment = new HashMap<TopicPartition, TopicPartitionState>();
        this.groupSubscription = new HashSet<String>();
        this.needsPartitionAssignment = false;
        this.needsFetchCommittedOffsets = true;
        this.subscribedPattern = null;
        this.subscriptionType = SubscriptionType.NONE;
    }

    public void subscribe(Collection<String> topics, ConsumerRebalanceListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("RebalanceListener cannot be null");
        }
        this.setSubscriptionType(SubscriptionType.AUTO_TOPICS);
        this.listener = listener;
        this.changeSubscription(topics);
    }

    public void changeSubscription(Collection<String> topicsToSubscribe) {
        if (!this.subscription.equals(new HashSet<String>(topicsToSubscribe))) {
            this.subscription.clear();
            this.subscription.addAll(topicsToSubscribe);
            this.groupSubscription.addAll(topicsToSubscribe);
            this.needsPartitionAssignment = true;
            Iterator<TopicPartition> it = this.assignment.keySet().iterator();
            while (it.hasNext()) {
                TopicPartition tp = it.next();
                if (this.subscription.contains(tp.topic())) continue;
                it.remove();
            }
        }
    }

    public void groupSubscribe(Collection<String> topics) {
        if (this.subscriptionType == SubscriptionType.USER_ASSIGNED) {
            throw new IllegalStateException(SUBSCRIPTION_EXCEPTION_MESSAGE);
        }
        this.groupSubscription.addAll(topics);
    }

    public void needReassignment() {
        this.groupSubscription.retainAll(this.subscription);
        this.needsPartitionAssignment = true;
    }

    public void assignFromUser(Collection<TopicPartition> partitions) {
        this.setSubscriptionType(SubscriptionType.USER_ASSIGNED);
        this.userAssignment.clear();
        this.userAssignment.addAll(partitions);
        for (TopicPartition partition2 : partitions) {
            if (this.assignment.containsKey(partition2)) continue;
            this.addAssignedPartition(partition2);
        }
        this.assignment.keySet().retainAll(this.userAssignment);
        this.needsPartitionAssignment = false;
        this.needsFetchCommittedOffsets = true;
    }

    public void assignFromSubscribed(Collection<TopicPartition> assignments) {
        for (TopicPartition tp : assignments) {
            if (this.subscription.contains(tp.topic())) continue;
            throw new IllegalArgumentException("Assigned partition " + tp + " for non-subscribed topic.");
        }
        this.assignment.clear();
        for (TopicPartition tp : assignments) {
            this.addAssignedPartition(tp);
        }
        this.needsPartitionAssignment = false;
    }

    public void subscribe(Pattern pattern, ConsumerRebalanceListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("RebalanceListener cannot be null");
        }
        this.setSubscriptionType(SubscriptionType.AUTO_PATTERN);
        this.listener = listener;
        this.subscribedPattern = pattern;
    }

    public boolean hasPatternSubscription() {
        return this.subscriptionType == SubscriptionType.AUTO_PATTERN;
    }

    public void unsubscribe() {
        this.subscription.clear();
        this.userAssignment.clear();
        this.assignment.clear();
        this.needsPartitionAssignment = true;
        this.subscribedPattern = null;
        this.subscriptionType = SubscriptionType.NONE;
    }

    public Pattern getSubscribedPattern() {
        return this.subscribedPattern;
    }

    public Set<String> subscription() {
        return this.subscription;
    }

    public Set<TopicPartition> pausedPartitions() {
        HashSet<TopicPartition> paused = new HashSet<TopicPartition>();
        for (Map.Entry<TopicPartition, TopicPartitionState> entry2 : this.assignment.entrySet()) {
            TopicPartition tp = entry2.getKey();
            TopicPartitionState state = entry2.getValue();
            if (!state.paused) continue;
            paused.add(tp);
        }
        return paused;
    }

    public Set<String> groupSubscription() {
        return this.groupSubscription;
    }

    private TopicPartitionState assignedState(TopicPartition tp) {
        TopicPartitionState state = this.assignment.get(tp);
        if (state == null) {
            throw new IllegalStateException("No current assignment for partition " + tp);
        }
        return state;
    }

    public void committed(TopicPartition tp, OffsetAndMetadata offset) {
        this.assignedState(tp).committed(offset);
    }

    public OffsetAndMetadata committed(TopicPartition tp) {
        return this.assignedState(tp).committed;
    }

    public void needRefreshCommits() {
        this.needsFetchCommittedOffsets = true;
    }

    public boolean refreshCommitsNeeded() {
        return this.needsFetchCommittedOffsets;
    }

    public void commitsRefreshed() {
        this.needsFetchCommittedOffsets = false;
    }

    public void seek(TopicPartition tp, long offset) {
        this.assignedState(tp).seek(offset);
    }

    public Set<TopicPartition> assignedPartitions() {
        return this.assignment.keySet();
    }

    public Set<TopicPartition> fetchablePartitions() {
        HashSet<TopicPartition> fetchable = new HashSet<TopicPartition>();
        for (Map.Entry<TopicPartition, TopicPartitionState> entry2 : this.assignment.entrySet()) {
            if (!entry2.getValue().isFetchable()) continue;
            fetchable.add(entry2.getKey());
        }
        return fetchable;
    }

    public boolean partitionsAutoAssigned() {
        return this.subscriptionType == SubscriptionType.AUTO_TOPICS || this.subscriptionType == SubscriptionType.AUTO_PATTERN;
    }

    public void position(TopicPartition tp, long offset) {
        this.assignedState(tp).position(offset);
    }

    public Long position(TopicPartition tp) {
        return this.assignedState(tp).position;
    }

    public Map<TopicPartition, OffsetAndMetadata> allConsumed() {
        HashMap<TopicPartition, OffsetAndMetadata> allConsumed = new HashMap<TopicPartition, OffsetAndMetadata>();
        for (Map.Entry<TopicPartition, TopicPartitionState> entry2 : this.assignment.entrySet()) {
            TopicPartitionState state = entry2.getValue();
            if (!state.hasValidPosition()) continue;
            allConsumed.put(entry2.getKey(), new OffsetAndMetadata(state.position));
        }
        return allConsumed;
    }

    public void needOffsetReset(TopicPartition partition2, OffsetResetStrategy offsetResetStrategy) {
        this.assignedState(partition2).awaitReset(offsetResetStrategy);
    }

    public void needOffsetReset(TopicPartition partition2) {
        this.needOffsetReset(partition2, this.defaultResetStrategy);
    }

    public boolean hasDefaultOffsetResetPolicy() {
        return this.defaultResetStrategy != OffsetResetStrategy.NONE;
    }

    public boolean isOffsetResetNeeded(TopicPartition partition2) {
        return this.assignedState(partition2).awaitingReset();
    }

    public OffsetResetStrategy resetStrategy(TopicPartition partition2) {
        return this.assignedState(partition2).resetStrategy;
    }

    public boolean hasAllFetchPositions() {
        for (TopicPartitionState state : this.assignment.values()) {
            if (state.hasValidPosition()) continue;
            return false;
        }
        return true;
    }

    public Set<TopicPartition> missingFetchPositions() {
        HashSet<TopicPartition> missing = new HashSet<TopicPartition>();
        for (Map.Entry<TopicPartition, TopicPartitionState> entry2 : this.assignment.entrySet()) {
            if (entry2.getValue().hasValidPosition()) continue;
            missing.add(entry2.getKey());
        }
        return missing;
    }

    public boolean partitionAssignmentNeeded() {
        return this.needsPartitionAssignment;
    }

    public boolean isAssigned(TopicPartition tp) {
        return this.assignment.containsKey(tp);
    }

    public boolean isPaused(TopicPartition tp) {
        return this.isAssigned(tp) && this.assignedState(tp).paused;
    }

    public boolean isFetchable(TopicPartition tp) {
        return this.isAssigned(tp) && this.assignedState(tp).isFetchable();
    }

    public void pause(TopicPartition tp) {
        this.assignedState(tp).pause();
    }

    public void resume(TopicPartition tp) {
        this.assignedState(tp).resume();
    }

    private void addAssignedPartition(TopicPartition tp) {
        this.assignment.put(tp, new TopicPartitionState());
    }

    public ConsumerRebalanceListener listener() {
        return this.listener;
    }

    private static class TopicPartitionState {
        private Long position = null;
        private OffsetAndMetadata committed = null;
        private boolean paused = false;
        private OffsetResetStrategy resetStrategy = null;

        private void awaitReset(OffsetResetStrategy strategy) {
            this.resetStrategy = strategy;
            this.position = null;
        }

        public boolean awaitingReset() {
            return this.resetStrategy != null;
        }

        public boolean hasValidPosition() {
            return this.position != null;
        }

        private void seek(long offset) {
            this.position = offset;
            this.resetStrategy = null;
        }

        private void position(long offset) {
            if (!this.hasValidPosition()) {
                throw new IllegalStateException("Cannot set a new position without a valid current position");
            }
            this.position = offset;
        }

        private void committed(OffsetAndMetadata offset) {
            this.committed = offset;
        }

        private void pause() {
            this.paused = true;
        }

        private void resume() {
            this.paused = false;
        }

        private boolean isFetchable() {
            return !this.paused && this.hasValidPosition();
        }
    }

    private static enum SubscriptionType {
        NONE,
        AUTO_TOPICS,
        AUTO_PATTERN,
        USER_ASSIGNED;

    }
}

