/*
 * Decompiled with CFR 0.152.
 */
package org.I0Itec.zkclient;

import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.I0Itec.zkclient.Holder;
import org.I0Itec.zkclient.IZkDataListener;
import org.I0Itec.zkclient.ZkClient;
import org.I0Itec.zkclient.exception.ZkNoNodeException;
import org.apache.log4j.Logger;

public final class ContentWatcher<T>
implements IZkDataListener {
    private static final Logger LOG = Logger.getLogger(ContentWatcher.class);
    private Lock _contentLock = new ReentrantLock(true);
    private Condition _contentAvailable = this._contentLock.newCondition();
    private Holder<T> _content;
    private String _fileName;
    private ZkClient _zkClient;

    public ContentWatcher(ZkClient zkClient, String fileName) {
        this._fileName = fileName;
        this._zkClient = zkClient;
    }

    public void start() {
        this._zkClient.subscribeDataChanges(this._fileName, this);
        this.readData();
        LOG.debug((Object)"Started ContentWatcher");
    }

    private void readData() {
        try {
            this.setContent(this._zkClient.readData(this._fileName));
        }
        catch (ZkNoNodeException zkNoNodeException) {
            // empty catch block
        }
    }

    public void stop() {
        this._zkClient.unsubscribeDataChanges(this._fileName, this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setContent(T data2) {
        LOG.debug((Object)("Received new data: " + data2));
        this._contentLock.lock();
        try {
            this._content = new Holder<T>(data2);
            this._contentAvailable.signalAll();
        }
        finally {
            this._contentLock.unlock();
        }
    }

    @Override
    public void handleDataChange(String dataPath, Object data2) {
        this.setContent(data2);
    }

    @Override
    public void handleDataDeleted(String dataPath) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T getContent() throws InterruptedException {
        this._contentLock.lock();
        try {
            while (this._content == null) {
                this._contentAvailable.await();
            }
            T t = this._content.get();
            return t;
        }
        finally {
            this._contentLock.unlock();
        }
    }
}

