/*
 * Decompiled with CFR 0.152.
 */
package kafka.utils.timer;

import java.io.Serializable;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import kafka.utils.SystemTime$;
import kafka.utils.timer.TimerTask;
import kafka.utils.timer.TimerTaskEntry;
import scala.Function1;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001Q4Q!\u0001\u0002\u0001\u0005!\u0011Q\u0002V5nKJ$\u0016m]6MSN$(BA\u0002\u0005\u0003\u0015!\u0018.\\3s\u0015\t)a!A\u0003vi&d7OC\u0001\b\u0003\u0015Y\u0017MZ6b'\r\u0001\u0011\"\u0005\t\u0003\u0015=i\u0011a\u0003\u0006\u0003\u00195\tA\u0001\\1oO*\ta\"\u0001\u0003kCZ\f\u0017B\u0001\t\f\u0005\u0019y%M[3diB\u0011!cF\u0007\u0002')\u0011A#F\u0001\u000bG>t7-\u001e:sK:$(B\u0001\f\u000e\u0003\u0011)H/\u001b7\n\u0005a\u0019\"a\u0002#fY\u0006LX\r\u001a\u0005\t5\u0001\u0011\t\u0011)A\u00059\u0005YA/Y:l\u0007>,h\u000e^3s\u0007\u0001\u0001\"!\b\u0011\u000e\u0003yQ!aH\n\u0002\r\u0005$x.\\5d\u0013\t\tcDA\u0007Bi>l\u0017nY%oi\u0016<WM\u001d\u0005\u0006G\u0001!\t\u0001J\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\u0015:\u0003C\u0001\u0014\u0001\u001b\u0005\u0011\u0001\"\u0002\u000e#\u0001\u0004a\u0002BB\u0015\u0001A\u0003%!&\u0001\u0003s_>$\bC\u0001\u0014,\u0013\ta#A\u0001\bUS6,'\u000fV1tW\u0016sGO]=\t\r9\u0002\u0001\u0015!\u00030\u0003))\u0007\u0010]5sCRLwN\u001c\t\u0003;AJ!!\r\u0010\u0003\u0015\u0005#x.\\5d\u0019>tw\rC\u00034\u0001\u0011\u0005A'A\u0007tKR,\u0005\u0010]5sCRLwN\u001c\u000b\u0003km\u0002\"AN\u001d\u000e\u0003]R\u0011\u0001O\u0001\u0006g\u000e\fG.Y\u0005\u0003u]\u0012qAQ8pY\u0016\fg\u000eC\u0003=e\u0001\u0007Q(\u0001\u0007fqBL'/\u0019;j_:l5\u000f\u0005\u00027}%\u0011qh\u000e\u0002\u0005\u0019>tw\rC\u0003B\u0001\u0011\u0005!)A\u0007hKR,\u0005\u0010]5sCRLwN\u001c\u000b\u0002{!)A\t\u0001C\u0001\u000b\u00069am\u001c:fC\u000eDGC\u0001$J!\t1t)\u0003\u0002Io\t!QK\\5u\u0011\u0015Q5\t1\u0001L\u0003\u00051\u0007\u0003\u0002\u001cM\u001d\u001aK!!T\u001c\u0003\u0013\u0019+hn\u0019;j_:\f\u0004C\u0001\u0014P\u0013\t\u0001&AA\u0005US6,'\u000fV1tW\")!\u000b\u0001C\u0001'\u0006\u0019\u0011\r\u001a3\u0015\u0005\u0019#\u0006\"B+R\u0001\u0004Q\u0013A\u0004;j[\u0016\u0014H+Y:l\u000b:$(/\u001f\u0005\u0006/\u0002!\t\u0001W\u0001\u0007e\u0016lwN^3\u0015\u0005\u0019K\u0006\"B+W\u0001\u0004Q\u0003\"B.\u0001\t\u0003a\u0016!\u00024mkNDGC\u0001$^\u0011\u0015Q%\f1\u0001_!\u00111DJ\u000b$\t\u000b\u0001\u0004A\u0011A1\u0002\u0011\u001d,G\u000fR3mCf$\"!\u00102\t\u000b\r|\u0006\u0019\u00013\u0002\tUt\u0017\u000e\u001e\t\u0003%\u0015L!AZ\n\u0003\u0011QKW.Z+oSRDQ\u0001\u001b\u0001\u0005\u0002%\f\u0011bY8na\u0006\u0014X\rV8\u0015\u0005)l\u0007C\u0001\u001cl\u0013\tawGA\u0002J]RDQA\\4A\u0002E\t\u0011\u0001\u001a\u0015\u0003\u0001A\u0004\"!\u001d:\u000e\u0003\u0011I!a\u001d\u0003\u0003\u0015QD'/Z1eg\u00064W\r")
public class TimerTaskList
implements Delayed {
    private final AtomicInteger taskCounter;
    private final TimerTaskEntry root;
    private final AtomicLong expiration;

    public boolean setExpiration(long expirationMs) {
        return this.expiration.getAndSet(expirationMs) != expirationMs;
    }

    public long getExpiration() {
        return this.expiration.get();
    }

    public synchronized void foreach(Function1<TimerTask, BoxedUnit> f) {
        TimerTaskEntry entry2 = this.root.next();
        while (entry2 != this.root) {
            TimerTaskEntry nextEntry = entry2.next();
            BoxedUnit boxedUnit = entry2.cancelled() ? BoxedUnit.UNIT : f.apply(entry2.timerTask());
            entry2 = nextEntry;
        }
    }

    public void add(TimerTaskEntry timerTaskEntry) {
        boolean done = false;
        while (!done) {
            timerTaskEntry.remove();
            TimerTaskList timerTaskList = this;
            synchronized (timerTaskList) {
                TimerTaskEntry timerTaskEntry2 = timerTaskEntry;
                synchronized (timerTaskEntry2) {
                    BoxedUnit boxedUnit;
                    if (timerTaskEntry.list() == null) {
                        TimerTaskEntry tail = this.root.prev();
                        timerTaskEntry.next_$eq(this.root);
                        timerTaskEntry.prev_$eq(tail);
                        timerTaskEntry.list_$eq(this);
                        tail.next_$eq(timerTaskEntry);
                        this.root.prev_$eq(timerTaskEntry);
                        this.taskCounter.incrementAndGet();
                        done = true;
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                }
            }
        }
        return;
    }

    public void remove(TimerTaskEntry timerTaskEntry) {
        TimerTaskList timerTaskList = this;
        synchronized (timerTaskList) {
            TimerTaskEntry timerTaskEntry2 = timerTaskEntry;
            synchronized (timerTaskEntry2) {
                Serializable serializable2;
                if (timerTaskEntry.list() == this) {
                    timerTaskEntry.next().prev_$eq(timerTaskEntry.prev());
                    timerTaskEntry.prev().next_$eq(timerTaskEntry.next());
                    timerTaskEntry.next_$eq(null);
                    timerTaskEntry.prev_$eq(null);
                    timerTaskEntry.list_$eq(null);
                    serializable2 = BoxesRunTime.boxToInteger(this.taskCounter.decrementAndGet());
                } else {
                    serializable2 = BoxedUnit.UNIT;
                }
                return;
            }
        }
    }

    public synchronized void flush(Function1<TimerTaskEntry, BoxedUnit> f) {
        TimerTaskEntry head2 = this.root.next();
        while (head2 != this.root) {
            this.remove(head2);
            f.apply(head2);
            head2 = this.root.next();
        }
        this.expiration.set(-1L);
    }

    @Override
    public long getDelay(TimeUnit unit) {
        return unit.convert(package$.MODULE$.max(this.getExpiration() - SystemTime$.MODULE$.milliseconds(), 0L), TimeUnit.MILLISECONDS);
    }

    @Override
    public int compareTo(Delayed d) {
        TimerTaskList other = (TimerTaskList)d;
        return this.getExpiration() < other.getExpiration() ? -1 : (this.getExpiration() > other.getExpiration() ? 1 : 0);
    }

    public TimerTaskList(AtomicInteger taskCounter) {
        this.taskCounter = taskCounter;
        this.root = new TimerTaskEntry(null, -1L);
        this.root.next_$eq(this.root);
        this.root.prev_$eq(this.root);
        this.expiration = new AtomicLong(-1L);
    }
}

