/*
 * Decompiled with CFR 0.152.
 */
package kafka.producer;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Random;
import java.util.concurrent.TimeUnit;
import kafka.api.ProducerRequest;
import kafka.api.ProducerRequest$;
import kafka.api.ProducerResponse;
import kafka.api.ProducerResponse$;
import kafka.api.RequestOrResponse;
import kafka.api.TopicMetadataRequest;
import kafka.api.TopicMetadataResponse;
import kafka.api.TopicMetadataResponse$;
import kafka.metrics.KafkaTimer;
import kafka.network.BlockingChannel;
import kafka.network.BlockingChannel$;
import kafka.network.RequestOrResponseSend;
import kafka.producer.ProducerRequestStats;
import kafka.producer.ProducerRequestStatsRegistry$;
import kafka.producer.SyncProducer$;
import kafka.producer.SyncProducerConfig;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import org.apache.kafka.common.network.NetworkReceive;
import org.apache.kafka.common.protocol.ApiKeys;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.utils.Utils;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.Predef$;
import scala.Serializable;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
@ScalaSignature(bytes="\u0006\u0001\u0005\u001dv!B\u0001\u0003\u0011\u00039\u0011\u0001D*z]\u000e\u0004&o\u001c3vG\u0016\u0014(BA\u0002\u0005\u0003!\u0001(o\u001c3vG\u0016\u0014(\"A\u0003\u0002\u000b-\fgm[1\u0004\u0001A\u0011\u0001\"C\u0007\u0002\u0005\u0019)!B\u0001E\u0001\u0017\ta1+\u001f8d!J|G-^2feN\u0011\u0011\u0002\u0004\t\u0003\u001bAi\u0011A\u0004\u0006\u0002\u001f\u0005)1oY1mC&\u0011\u0011C\u0004\u0002\u0007\u0003:L(+\u001a4\t\u000bMIA\u0011\u0001\u000b\u0002\rqJg.\u001b;?)\u00059\u0001b\u0002\f\n\u0005\u0004%\taF\u0001\u000b%\u0016\fX/Z:u\u0017\u0016LX#\u0001\r\u0011\u00055I\u0012B\u0001\u000e\u000f\u0005\u0015\u0019\u0006n\u001c:u\u0011\u0019a\u0012\u0002)A\u00051\u0005Y!+Z9vKN$8*Z=!\u0011\u001dq\u0012B1A\u0005\u0002}\tqB]1oI>lw)\u001a8fe\u0006$xN]\u000b\u0002AA\u0011\u0011EJ\u0007\u0002E)\u00111\u0005J\u0001\u0005kRLGNC\u0001&\u0003\u0011Q\u0017M^1\n\u0005\u001d\u0012#A\u0002*b]\u0012|W\u000e\u0003\u0004*\u0013\u0001\u0006I\u0001I\u0001\u0011e\u0006tGm\\7HK:,'/\u0019;pe\u0002BC!C\u0016/aA\u0011Q\u0002L\u0005\u0003[9\u0011!\u0002Z3qe\u0016\u001c\u0017\r^3eC\u0005y\u0013!!\u0007UQ&\u001c\be\u001c2kK\u000e$\b\u0005[1tA\t,WM\u001c\u0011eKB\u0014XmY1uK\u0012\u0004\u0013M\u001c3!o&dG\u000e\t2fAI,Wn\u001c<fI\u0002Jg\u000eI1!MV$XO]3!e\u0016dW-Y:f]\u0001\u0002F.Z1tK\u0002*8/\u001a\u0011pe\u001et\u0013\r]1dQ\u0016t3.\u00194lC:\u001aG.[3oiNt\u0003O]8ek\u000e,'OL&bM.\f\u0007K]8ek\u000e,'\u000fI5ogR,\u0017\r\u001a\u0018\"\u0003E\n\u0001\u0002\r\u00182a9\u0002d\u0006\r\u0015\u0005\u0013-\u001a\u0004'I\u00015\u0003\u0005]A\u000b[5tA\rd\u0017m]:!Q\u0006\u001c\bEY3f]\u0002\"W\r\u001d:fG\u0006$X\r\u001a\u0011b]\u0012\u0004s/\u001b7mA\t,\u0007E]3n_Z,G\rI5oA\u0005\u0004c-\u001e;ve\u0016\u0004#/\u001a7fCN,g\u0006\t)mK\u0006\u001cX\rI;tK\u0002z'o\u001a\u0018ba\u0006\u001c\u0007.\u001a\u0018lC\u001a\\\u0017ML2mS\u0016tGo\u001d\u0018qe>$WoY3s]-\u000bgm[1Qe>$WoY3sA%t7\u000f^3bI:BC\u0001A\u0016/a\u0019!!B\u0001\u00018'\r1D\u0002\u000f\t\u0003sqj\u0011A\u000f\u0006\u0003w\u0011\tQ!\u001e;jYNL!!\u0010\u001e\u0003\u000f1{wmZ5oO\"AqH\u000eBC\u0002\u0013\u0005\u0001)\u0001\u0004d_:4\u0017nZ\u000b\u0002\u0003B\u0011\u0001BQ\u0005\u0003\u0007\n\u0011!cU=oGB\u0013x\u000eZ;dKJ\u001cuN\u001c4jO\"AQI\u000eB\u0001B\u0003%\u0011)A\u0004d_:4\u0017n\u001a\u0011\t\u000bM1D\u0011A$\u0015\u0005!K\u0005C\u0001\u00057\u0011\u0015yd\t1\u0001B\u0011\u001dYeG1A\u0005\n1\u000bA\u0001\\8dWV\tQ\n\u0005\u0002O#6\tqJ\u0003\u0002QI\u0005!A.\u00198h\u0013\t\u0011vJ\u0001\u0004PE*,7\r\u001e\u0005\u0007)Z\u0002\u000b\u0011B'\u0002\u000b1|7m\u001b\u0011\t\u000fY3\u0004\u0019!C\u0005/\u0006A1\u000f[;uI><h.F\u0001Y!\ti\u0011,\u0003\u0002[\u001d\t9!i\\8mK\u0006t\u0007b\u0002/7\u0001\u0004%I!X\u0001\rg\",H\u000fZ8x]~#S-\u001d\u000b\u0003=\u0006\u0004\"!D0\n\u0005\u0001t!\u0001B+oSRDqAY.\u0002\u0002\u0003\u0007\u0001,A\u0002yIEBa\u0001\u001a\u001c!B\u0013A\u0016!C:ikR$wn\u001e8!Q\t\u0019g\r\u0005\u0002\u000eO&\u0011\u0001N\u0004\u0002\tm>d\u0017\r^5mK\"9!N\u000eb\u0001\n\u0013Y\u0017\u0001\u00039s_R|7m\u001c7\u0016\u00031\u0004\"!\u001c<\u000e\u00039T!A[8\u000b\u0005A\f\u0018AB2p[6|gN\u0003\u0002\u0006e*\u00111\u000f^\u0001\u0007CB\f7\r[3\u000b\u0003U\f1a\u001c:h\u0013\t9hN\u0001\tTK\u000e,(/\u001b;z!J|Go\\2pY\"1\u0011P\u000eQ\u0001\n1\f\u0011\u0002\u001d:pi>\u001cw\u000e\u001c\u0011\t\u000fm4$\u0019!C\u0005y\u0006y!\r\\8dW&twm\u00115b]:,G.F\u0001~!\rq\u00181A\u0007\u0002\u007f*\u0019\u0011\u0011\u0001\u0003\u0002\u000f9,Go^8sW&\u0019\u0011QA@\u0003\u001f\tcwnY6j]\u001e\u001c\u0005.\u00198oK2Dq!!\u00037A\u0003%Q0\u0001\tcY>\u001c7.\u001b8h\u0007\"\fgN\\3mA!I\u0011Q\u0002\u001cC\u0002\u0013\u0005\u0011qB\u0001\u0015aJ|G-^2feJ+\u0017/^3tiN#\u0018\r^:\u0016\u0005\u0005E\u0001c\u0001\u0005\u0002\u0014%\u0019\u0011Q\u0003\u0002\u0003)A\u0013x\u000eZ;dKJ\u0014V-];fgR\u001cF/\u0019;t\u0011!\tIB\u000eQ\u0001\n\u0005E\u0011!\u00069s_\u0012,8-\u001a:SKF,Xm\u001d;Ti\u0006$8\u000f\t\u0005\b\u0003;1D\u0011BA\u0010\u000351XM]5gsJ+\u0017/^3tiR\u0019a,!\t\t\u0011\u0005\r\u00121\u0004a\u0001\u0003K\tqA]3rk\u0016\u001cH\u000f\u0005\u0003\u0002(\u00055RBAA\u0015\u0015\r\tY\u0003B\u0001\u0004CBL\u0017\u0002BA\u0018\u0003S\u0011\u0011CU3rk\u0016\u001cHo\u0014:SKN\u0004xN\\:f\u0011\u001d\t\u0019D\u000eC\u0005\u0003k\ta\u0001Z8TK:$GCBA\u001c\u0003\u0003\n\u0019\u0005\u0005\u0003\u0002:\u0005uRBAA\u001e\u0015\r\t\ta\\\u0005\u0005\u0003\u007f\tYD\u0001\bOKR<xN]6SK\u000e,\u0017N^3\t\u0011\u0005\r\u0012\u0011\u0007a\u0001\u0003KA\u0011\"!\u0012\u00022A\u0005\t\u0019\u0001-\u0002\u0019I,\u0017\r\u001a*fgB|gn]3\t\u000f\u0005%c\u0007\"\u0001\u0002L\u0005!1/\u001a8e)\u0011\ti%a\u0015\u0011\t\u0005\u001d\u0012qJ\u0005\u0005\u0003#\nIC\u0001\tQe>$WoY3s%\u0016\u001c\bo\u001c8tK\"A\u0011QKA$\u0001\u0004\t9&A\bqe>$WoY3s%\u0016\fX/Z:u!\u0011\t9#!\u0017\n\t\u0005m\u0013\u0011\u0006\u0002\u0010!J|G-^2feJ+\u0017/^3ti\"9\u0011\u0011\n\u001c\u0005\u0002\u0005}C\u0003BA1\u0003O\u0002B!a\n\u0002d%!\u0011QMA\u0015\u0005U!v\u000e]5d\u001b\u0016$\u0018\rZ1uCJ+7\u000f]8og\u0016D\u0001\"a\t\u0002^\u0001\u0007\u0011\u0011\u000e\t\u0005\u0003O\tY'\u0003\u0003\u0002n\u0005%\"\u0001\u0006+pa&\u001cW*\u001a;bI\u0006$\u0018MU3rk\u0016\u001cH\u000fC\u0004\u0002rY\"\t!a\u001d\u0002\u000b\rdwn]3\u0015\u0003yCq!a\u001e7\t\u0013\t\u0019(\u0001\u0006eSN\u001cwN\u001c8fGRDq!a\u001f7\t\u0013\ti(A\u0004d_:tWm\u0019;\u0015\u0003uDq!!!7\t\u0013\t\u0019(A\nhKR|%/T1lK\u000e{gN\\3di&|g\u000eC\u0005\u0002\u0006Z\n\n\u0011\"\u0003\u0002\b\u0006\u0001Bm\\*f]\u0012$C-\u001a4bk2$HEM\u000b\u0003\u0003\u0013S3\u0001WAFW\t\ti\t\u0005\u0003\u0002\u0010\u0006eUBAAI\u0015\u0011\t\u0019*!&\u0002\u0013Ut7\r[3dW\u0016$'bAAL\u001d\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005m\u0015\u0011\u0013\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0007\u0006\u0002\u001c,gAB3ANAQ!\rI\u00141U\u0005\u0004\u0003KS$A\u0003;ie\u0016\fGm]1gK\u0002")
public class SyncProducer
implements Logging {
    private final SyncProducerConfig config;
    private final Object lock;
    private volatile boolean shutdown;
    private final SecurityProtocol protocol;
    private final BlockingChannel blockingChannel;
    private final ProducerRequestStats producerRequestStats;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    public static Random randomGenerator() {
        return SyncProducer$.MODULE$.randomGenerator();
    }

    public static short RequestKey() {
        return SyncProducer$.MODULE$.RequestKey();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        SyncProducer syncProducer = this;
        synchronized (syncProducer) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    public SyncProducerConfig config() {
        return this.config;
    }

    private Object lock() {
        return this.lock;
    }

    private boolean shutdown() {
        return this.shutdown;
    }

    private void shutdown_$eq(boolean x$1) {
        this.shutdown = x$1;
    }

    private SecurityProtocol protocol() {
        return this.protocol;
    }

    private BlockingChannel blockingChannel() {
        return this.blockingChannel;
    }

    public ProducerRequestStats producerRequestStats() {
        return this.producerRequestStats;
    }

    private void verifyRequest(RequestOrResponse request) {
        if (this.logger().isDebugEnabled()) {
            ByteBuffer buffer = new RequestOrResponseSend("", request).buffer();
            this.trace((Function0<String>)((Object)new Serializable(this, buffer){
                public static final long serialVersionUID = 0L;
                private final ByteBuffer buffer$1;

                public final String apply() {
                    return new StringBuilder().append((Object)"verifying sendbuffer of size ").append(BoxesRunTime.boxToInteger(this.buffer$1.limit())).toString();
                }
                {
                    this.buffer$1 = buffer$1;
                }
            }));
            short requestTypeId = buffer.getShort();
            if (requestTypeId == ApiKeys.PRODUCE.id) {
                ProducerRequest request2 = ProducerRequest$.MODULE$.readFrom(buffer);
                this.trace((Function0<String>)((Object)new Serializable(this, request2){
                    public static final long serialVersionUID = 0L;
                    private final ProducerRequest request$1;

                    public final String apply() {
                        return this.request$1.toString();
                    }
                    {
                        this.request$1 = request$1;
                    }
                }));
            }
        }
    }

    public NetworkReceive kafka$producer$SyncProducer$$doSend(RequestOrResponse request, boolean readResponse) {
        Object object = this.lock();
        synchronized (object) {
            this.verifyRequest(request);
            this.getOrMakeConnection();
            ObjectRef<Object> response = new ObjectRef<Object>(null);
            this.liftedTree1$1(request, readResponse, response);
            NetworkReceive networkReceive = (NetworkReceive)response.elem;
            return networkReceive;
        }
    }

    private boolean doSend$default$2() {
        return true;
    }

    public ProducerResponse send(ProducerRequest producerRequest) {
        ProducerResponse producerResponse;
        int requestSize = producerRequest.sizeInBytes();
        this.producerRequestStats().getProducerRequestStats(this.config().host(), this.config().port()).requestSizeHist().update(requestSize);
        this.producerRequestStats().getProducerRequestAllBrokersStats().requestSizeHist().update(requestSize);
        ObjectRef<Object> response = new ObjectRef<Object>(null);
        KafkaTimer specificTimer = this.producerRequestStats().getProducerRequestStats(this.config().host(), this.config().port()).requestTimer();
        KafkaTimer aggregateTimer = this.producerRequestStats().getProducerRequestAllBrokersStats().requestTimer();
        aggregateTimer.time(new Serializable(this, producerRequest, response, specificTimer){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SyncProducer $outer;
            public final ProducerRequest producerRequest$1;
            public final ObjectRef response$2;
            private final KafkaTimer specificTimer$1;

            public final void apply() {
                this.apply$mcV$sp();
            }

            public void apply$mcV$sp() {
                this.specificTimer$1.time(new Serializable(this){
                    public static final long serialVersionUID = 0L;
                    private final /* synthetic */ $anonfun$send$1 $outer;

                    public final void apply() {
                        this.apply$mcV$sp();
                    }

                    public void apply$mcV$sp() {
                        this.$outer.response$2.elem = this.$outer.kafka$producer$SyncProducer$$anonfun$$$outer().kafka$producer$SyncProducer$$doSend(this.$outer.producerRequest$1, this.$outer.producerRequest$1.requiredAcks() != 0);
                    }
                    {
                        if ($outer == null) {
                            throw new NullPointerException();
                        }
                        this.$outer = $outer;
                    }
                });
            }

            public /* synthetic */ SyncProducer kafka$producer$SyncProducer$$anonfun$$$outer() {
                return this.$outer;
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
                this.producerRequest$1 = producerRequest$1;
                this.response$2 = response$2;
                this.specificTimer$1 = specificTimer$1;
            }
        });
        if (producerRequest.requiredAcks() != 0) {
            ProducerResponse producerResponse2 = ProducerResponse$.MODULE$.readFrom(((NetworkReceive)response.elem).payload());
            this.producerRequestStats().getProducerRequestStats(this.config().host(), this.config().port()).throttleTimeStats().update(producerResponse2.throttleTime(), TimeUnit.MILLISECONDS);
            this.producerRequestStats().getProducerRequestAllBrokersStats().throttleTimeStats().update(producerResponse2.throttleTime(), TimeUnit.MILLISECONDS);
            producerResponse = producerResponse2;
        } else {
            producerResponse = null;
        }
        return producerResponse;
    }

    public TopicMetadataResponse send(TopicMetadataRequest request) {
        NetworkReceive response = this.kafka$producer$SyncProducer$$doSend(request, this.doSend$default$2());
        return TopicMetadataResponse$.MODULE$.readFrom(response.payload());
    }

    public void close() {
        Object object = this.lock();
        synchronized (object) {
            this.disconnect();
            this.shutdown_$eq(true);
            return;
        }
    }

    private void disconnect() {
        try {
            this.info((Function0<String>)((Object)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SyncProducer $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)"Disconnecting from ").append((Object)Utils.formatAddress(this.$outer.config().host(), Predef$.MODULE$.int2Integer(this.$outer.config().port()))).toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }));
            this.blockingChannel().disconnect();
        }
        catch (Exception exception) {
            this.error((Function0<String>)((Object)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return "Error on disconnect: ";
                }
            }), (Function0<Throwable>)((Object)new Serializable(this, exception){
                public static final long serialVersionUID = 0L;
                private final Exception e$1;

                public final Exception apply() {
                    return this.e$1;
                }
                {
                    this.e$1 = e$1;
                }
            }));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private BlockingChannel connect() {
        if (this.blockingChannel().isConnected() || this.shutdown()) return this.blockingChannel();
        try {
            this.blockingChannel().connect();
            this.info((Function0<String>)((Object)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SyncProducer $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)"Connected to ").append((Object)Utils.formatAddress(this.$outer.config().host(), Predef$.MODULE$.int2Integer(this.$outer.config().port()))).append((Object)" for producing").toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }));
        }
        catch (Exception exception) {
            this.disconnect();
            this.error((Function0<String>)((Object)new Serializable(this){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ SyncProducer $outer;

                public final String apply() {
                    return new StringBuilder().append((Object)"Producer connection to ").append((Object)Utils.formatAddress(this.$outer.config().host(), Predef$.MODULE$.int2Integer(this.$outer.config().port()))).append((Object)" unsuccessful").toString();
                }
                {
                    if ($outer == null) {
                        throw new NullPointerException();
                    }
                    this.$outer = $outer;
                }
            }), (Function0<Throwable>)((Object)new Serializable(this, exception){
                public static final long serialVersionUID = 0L;
                private final Exception e$2;

                public final Exception apply() {
                    return this.e$2;
                }
                {
                    this.e$2 = e$2;
                }
            }));
            throw exception;
        }
        return this.blockingChannel();
    }

    private void getOrMakeConnection() {
        if (!this.blockingChannel().isConnected()) {
            this.connect();
        }
    }

    private final void liftedTree1$1(RequestOrResponse request$2, boolean readResponse$1, ObjectRef response$1) {
        try {
            this.blockingChannel().send(request$2);
            if (readResponse$1) {
                response$1.elem = this.blockingChannel().receive();
            } else {
                this.trace((Function0<String>)((Object)new Serializable(this){
                    public static final long serialVersionUID = 0L;

                    public final String apply() {
                        return "Skipping reading response";
                    }
                }));
            }
            return;
        }
        catch (Throwable throwable) {
            throw throwable;
        }
        catch (IOException iOException) {
            this.disconnect();
            throw iOException;
        }
    }

    public SyncProducer(SyncProducerConfig config) {
        this.config = config;
        Logging$class.$init$(this);
        this.lock = new Object();
        this.shutdown = false;
        this.protocol = SecurityProtocol.valueOf(config.securityProtocol());
        this.blockingChannel = new BlockingChannel(config.host(), config.port(), BlockingChannel$.MODULE$.UseDefaultBufferSize(), config.sendBufferBytes(), config.requestTimeoutMs(), this.protocol());
        this.producerRequestStats = ProducerRequestStatsRegistry$.MODULE$.getProducerRequestStats(config.clientId());
        this.trace((Function0<String>)((Object)new Serializable(this){
            public static final long serialVersionUID = 0L;
            private final /* synthetic */ SyncProducer $outer;

            public final String apply() {
                return new StringOps(Predef$.MODULE$.augmentString("Instantiating Scala Sync Producer with properties: %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.$outer.config().props()}));
            }
            {
                if ($outer == null) {
                    throw new NullPointerException();
                }
                this.$outer = $outer;
            }
        }));
    }
}

