/*
 * Decompiled with CFR 0.152.
 */
package kafka.client;

import java.io.IOException;
import java.util.Properties;
import kafka.api.GroupCoordinatorRequest;
import kafka.api.GroupCoordinatorRequest$;
import kafka.api.GroupCoordinatorResponse;
import kafka.api.GroupCoordinatorResponse$;
import kafka.api.TopicMetadataRequest;
import kafka.api.TopicMetadataRequest$;
import kafka.api.TopicMetadataResponse;
import kafka.client.ClientUtils$;
import kafka.cluster.BrokerEndPoint;
import kafka.cluster.BrokerEndPoint$;
import kafka.common.ErrorMapping$;
import kafka.common.KafkaException;
import kafka.network.BlockingChannel;
import kafka.network.BlockingChannel$;
import kafka.producer.ProducerConfig;
import kafka.producer.ProducerPool$;
import kafka.producer.SyncProducer;
import kafka.utils.CoreUtils$;
import kafka.utils.Log4jController$;
import kafka.utils.Logging;
import kafka.utils.Logging$class;
import kafka.utils.ZkUtils;
import org.apache.kafka.common.network.NetworkReceive;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.log4j.Logger;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Serializable;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.StringBuilder;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ObjectRef;
import scala.util.Random$;

/*
 * Duplicate member names - consider using --renamedupmembers true
 */
public final class ClientUtils$
implements Logging {
    public static final ClientUtils$ MODULE$;
    private final String loggerName;
    private final Logger logger;
    private String logIdent;
    private final Log4jController$ kafka$utils$Logging$$log4jController;
    private volatile boolean bitmap$0;

    static {
        new ClientUtils$();
    }

    @Override
    public String loggerName() {
        return this.loggerName;
    }

    private Logger logger$lzycompute() {
        ClientUtils$ clientUtils$ = this;
        synchronized (clientUtils$) {
            if (!this.bitmap$0) {
                this.logger = Logging$class.logger(this);
                this.bitmap$0 = true;
            }
            return this.logger;
        }
    }

    @Override
    public Logger logger() {
        return this.bitmap$0 ? this.logger : this.logger$lzycompute();
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public Log4jController$ kafka$utils$Logging$$log4jController() {
        return this.kafka$utils$Logging$$log4jController;
    }

    @Override
    public void kafka$utils$Logging$_setter_$loggerName_$eq(String x$1) {
        this.loggerName = x$1;
    }

    @Override
    public void kafka$utils$Logging$_setter_$kafka$utils$Logging$$log4jController_$eq(Log4jController$ x$1) {
        this.kafka$utils$Logging$$log4jController = x$1;
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging$class.trace(this, msg);
    }

    @Override
    public Object trace(Function0<Throwable> e) {
        return Logging$class.trace(this, e);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.trace(this, msg, e);
    }

    @Override
    public void swallowTrace(Function0<BoxedUnit> action) {
        Logging$class.swallowTrace(this, action);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging$class.debug(this, msg);
    }

    @Override
    public Object debug(Function0<Throwable> e) {
        return Logging$class.debug(this, e);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.debug(this, msg, e);
    }

    @Override
    public void swallowDebug(Function0<BoxedUnit> action) {
        Logging$class.swallowDebug(this, action);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging$class.info(this, msg);
    }

    @Override
    public Object info(Function0<Throwable> e) {
        return Logging$class.info(this, e);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.info(this, msg, e);
    }

    @Override
    public void swallowInfo(Function0<BoxedUnit> action) {
        Logging$class.swallowInfo(this, action);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging$class.warn(this, msg);
    }

    @Override
    public Object warn(Function0<Throwable> e) {
        return Logging$class.warn(this, e);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.warn(this, msg, e);
    }

    @Override
    public void swallowWarn(Function0<BoxedUnit> action) {
        Logging$class.swallowWarn(this, action);
    }

    @Override
    public void swallow(Function0<BoxedUnit> action) {
        Logging$class.swallow(this, action);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging$class.error(this, msg);
    }

    @Override
    public Object error(Function0<Throwable> e) {
        return Logging$class.error(this, e);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.error(this, msg, e);
    }

    @Override
    public void swallowError(Function0<BoxedUnit> action) {
        Logging$class.swallowError(this, action);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging$class.fatal(this, msg);
    }

    @Override
    public Object fatal(Function0<Throwable> e) {
        return Logging$class.fatal(this, e);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging$class.fatal(this, msg, e);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TopicMetadataResponse fetchTopicMetadata(Set<String> topics, Seq<BrokerEndPoint> brokers, ProducerConfig producerConfig, int correlationId) {
        void var9_9;
        void var10_10;
        boolean fetchMetaDataSucceeded = false;
        IntRef i = new IntRef(0);
        TopicMetadataRequest topicMetadataRequest = new TopicMetadataRequest(TopicMetadataRequest$.MODULE$.CurrentVersion(), correlationId, producerConfig.clientId(), topics.toSeq());
        TopicMetadataResponse topicMetadataResponse = null;
        Throwable t = null;
        Seq shuffledBrokers = Random$.MODULE$.shuffle(brokers, Seq$.MODULE$.canBuildFrom());
        while (i.elem < shuffledBrokers.size() && !fetchMetaDataSucceeded) {
            SyncProducer producer = ProducerPool$.MODULE$.createSyncProducer(producerConfig, (BrokerEndPoint)shuffledBrokers.apply(i.elem));
            this.info((Function0<String>)((Object)new Serializable(topics, correlationId, i, shuffledBrokers){
                public static final long serialVersionUID = 0L;
                private final Set topics$1;
                private final int correlationId$1;
                private final IntRef i$1;
                private final Seq shuffledBrokers$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Fetching metadata from broker %s with correlation id %d for %d topic(s) %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.shuffledBrokers$1.apply(this.i$1.elem), BoxesRunTime.boxToInteger(this.correlationId$1), BoxesRunTime.boxToInteger(this.topics$1.size()), this.topics$1}));
                }
                {
                    this.topics$1 = topics$1;
                    this.correlationId$1 = correlationId$1;
                    this.i$1 = i$1;
                    this.shuffledBrokers$1 = shuffledBrokers$1;
                }
            }));
            {
                topicMetadataResponse = producer.send(topicMetadataRequest);
                fetchMetaDataSucceeded = true;
                ++i.elem;
                producer.close();
            }
        }
        if (fetchMetaDataSucceeded) {
            this.debug((Function0<String>)((Object)new Serializable(topics){
                public static final long serialVersionUID = 0L;
                private final Set topics$1;

                public final String apply() {
                    return new StringOps(Predef$.MODULE$.augmentString("Successfully fetched metadata for %d topic(s) %s")).format(Predef$.MODULE$.genericWrapArray(new Object[]{BoxesRunTime.boxToInteger(this.topics$1.size()), this.topics$1}));
                }
                {
                    this.topics$1 = topics$1;
                }
            }));
            return topicMetadataResponse;
        }
        throw new KafkaException(new StringOps(Predef$.MODULE$.augmentString("fetching topic metadata for topics [%s] from broker [%s] failed")).format(Predef$.MODULE$.genericWrapArray(new Object[]{topics, var10_10})), (Throwable)var9_9);
    }

    public TopicMetadataResponse fetchTopicMetadata(Set<String> topics, Seq<BrokerEndPoint> brokers, String clientId, int timeoutMs, int correlationId, SecurityProtocol securityProtocol) {
        Properties props = new Properties();
        props.put("metadata.broker.list", ((TraversableOnce)brokers.map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply(BrokerEndPoint x$1) {
                return x$1.connectionString();
            }
        }, Seq$.MODULE$.canBuildFrom())).mkString(","));
        props.put("client.id", clientId);
        props.put("request.timeout.ms", ((Object)BoxesRunTime.boxToInteger(timeoutMs)).toString());
        props.put("security.protocol", securityProtocol.toString());
        Predef$.MODULE$.println(props);
        ProducerConfig producerConfig = new ProducerConfig(props);
        return this.fetchTopicMetadata(topics, brokers, producerConfig, correlationId);
    }

    public int fetchTopicMetadata$default$5() {
        return 0;
    }

    public SecurityProtocol fetchTopicMetadata$default$6() {
        return SecurityProtocol.PLAINTEXT;
    }

    public Seq<BrokerEndPoint> parseBrokerList(String brokerListStr) {
        Seq<String> brokersStr = CoreUtils$.MODULE$.parseCsvList(brokerListStr);
        return ((TraversableLike)brokersStr.zipWithIndex(Seq$.MODULE$.canBuildFrom())).map(new Serializable(){
            public static final long serialVersionUID = 0L;

            public final BrokerEndPoint apply(Tuple2<String, Object> x0$1) {
                Tuple2<String, Object> tuple2 = x0$1;
                if (tuple2 != null) {
                    String address = tuple2._1();
                    int brokerId = tuple2._2$mcI$sp();
                    BrokerEndPoint brokerEndPoint = BrokerEndPoint$.MODULE$.createBrokerEndPoint(brokerId, address);
                    return brokerEndPoint;
                }
                throw new MatchError(tuple2);
            }
        }, Seq$.MODULE$.canBuildFrom());
    }

    /*
     * WARNING - void declaration
     */
    public BlockingChannel channelToAnyBroker(ZkUtils zkUtils, int socketTimeoutMs, SecurityProtocol protocol) {
        ObjectRef<Object> channel = new ObjectRef<Object>(null);
        boolean connected = false;
        while (!connected) {
            void var4_4;
            Seq<BrokerEndPoint> allBrokers = zkUtils.getAllBrokerEndPointsForChannel(protocol);
            ((IterableLike)Random$.MODULE$.shuffle(allBrokers, Seq$.MODULE$.canBuildFrom())).find(new Serializable(socketTimeoutMs, protocol, (ObjectRef)var4_4){
                public static final long serialVersionUID = 0L;
                private final int socketTimeoutMs$1;
                private final SecurityProtocol protocol$1;
                public final ObjectRef channel$1;

                public final boolean apply(BrokerEndPoint broker) {
                    boolean bl;
                    ClientUtils$.MODULE$.trace((Function0<String>)((Object)new Serializable(this, broker){
                        public static final long serialVersionUID = 0L;
                        private final BrokerEndPoint broker$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Connecting to broker %s:%d.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.broker$1.host(), BoxesRunTime.boxToInteger(this.broker$1.port())}));
                        }
                        {
                            this.broker$1 = broker$1;
                        }
                    }));
                    try {
                        this.channel$1.elem = new BlockingChannel(broker.host(), broker.port(), BlockingChannel$.MODULE$.UseDefaultBufferSize(), BlockingChannel$.MODULE$.UseDefaultBufferSize(), this.socketTimeoutMs$1, this.protocol$1);
                        ((BlockingChannel)this.channel$1.elem).connect();
                        ClientUtils$.MODULE$.debug((Function0<String>)((Object)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ anonfun.channelToAnyBroker.1 $outer;

                            public final String apply() {
                                return new StringOps(Predef$.MODULE$.augmentString("Created channel to broker %s:%d.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{((BlockingChannel)this.$outer.channel$1.elem).host(), BoxesRunTime.boxToInteger(((BlockingChannel)this.$outer.channel$1.elem).port())}));
                            }
                            {
                                if ($outer == null) {
                                    throw new NullPointerException();
                                }
                                this.$outer = $outer;
                            }
                        }));
                        bl = true;
                    }
                    catch (Exception exception) {
                        if ((BlockingChannel)this.channel$1.elem != null) {
                            ((BlockingChannel)this.channel$1.elem).disconnect();
                        }
                        this.channel$1.elem = null;
                        ClientUtils$.MODULE$.info((Function0<String>)((Object)new Serializable(this, broker){
                            public static final long serialVersionUID = 0L;
                            private final BrokerEndPoint broker$1;

                            public final String apply() {
                                return new StringOps(Predef$.MODULE$.augmentString("Error while creating channel to %s:%d.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.broker$1.host(), BoxesRunTime.boxToInteger(this.broker$1.port())}));
                            }
                            {
                                this.broker$1 = broker$1;
                            }
                        }));
                        bl = false;
                    }
                    return bl;
                }
                {
                    this.socketTimeoutMs$1 = socketTimeoutMs$1;
                    this.protocol$1 = protocol$1;
                    this.channel$1 = channel$1;
                }
            });
            boolean bl = (BlockingChannel)var4_4.elem != null;
        }
        return (BlockingChannel)channel.elem;
    }

    public int channelToAnyBroker$default$2() {
        return 3000;
    }

    public SecurityProtocol channelToAnyBroker$default$3() {
        return SecurityProtocol.PLAINTEXT;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public BlockingChannel channelToOffsetManager(String group, ZkUtils zkUtils, int socketTimeoutMs, int retryBackOffMs, SecurityProtocol protocol) {
        ZkUtils x$2 = zkUtils;
        SecurityProtocol x$3 = protocol;
        int x$4 = this.channelToAnyBroker$default$2();
        ObjectRef<BlockingChannel> queryChannel = new ObjectRef<BlockingChannel>(this.channelToAnyBroker(x$2, x$4, x$3));
        None$ offsetManagerChannelOpt = None$.MODULE$;
        block4: while (!offsetManagerChannelOpt.isDefined()) {
            Option coordinatorOpt = None$.MODULE$;
            while (true) {
                void var6_9;
                if (coordinatorOpt.isDefined()) {
                    Some<BlockingChannel> some;
                    BrokerEndPoint coordinator = (BrokerEndPoint)((Option)coordinatorOpt).get();
                    String string2 = coordinator.host();
                    String string3 = ((BlockingChannel)var6_9.elem).host();
                    if (!(string2 != null ? !string2.equals(string3) : string3 != null) && coordinator.port() == ((BlockingChannel)var6_9.elem).port()) {
                        some = new Some<BlockingChannel>((BlockingChannel)var6_9.elem);
                        continue block4;
                    }
                    String connectString = new StringOps(Predef$.MODULE$.augmentString("%s:%d")).format(Predef$.MODULE$.genericWrapArray(new Object[]{coordinator.host(), BoxesRunTime.boxToInteger(coordinator.port())}));
                    BlockingChannel offsetManagerChannel = null;
                    {
                        this.debug((Function0<String>)((Object)new Serializable(connectString){
                            public static final long serialVersionUID = 0L;
                            private final String connectString$1;

                            public final String apply() {
                                return new StringOps(Predef$.MODULE$.augmentString("Connecting to offset manager %s.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{this.connectString$1}));
                            }
                            {
                                this.connectString$1 = connectString$1;
                            }
                        }));
                        offsetManagerChannel = new BlockingChannel(coordinator.host(), coordinator.port(), BlockingChannel$.MODULE$.UseDefaultBufferSize(), BlockingChannel$.MODULE$.UseDefaultBufferSize(), socketTimeoutMs, protocol);
                        offsetManagerChannel.connect();
                        some = new Some<BlockingChannel>(offsetManagerChannel);
                        ((BlockingChannel)var6_9.elem).disconnect();
                        continue block4;
                    }
                }
                try {
                    if (!((BlockingChannel)var6_9.elem).isConnected()) {
                        ZkUtils x$5 = zkUtils;
                        SecurityProtocol x$6 = protocol;
                        int x$7 = this.channelToAnyBroker$default$2();
                        var6_9.elem = this.channelToAnyBroker(x$5, x$7, x$6);
                    }
                    this.debug((Function0<String>)((Object)new Serializable(group, (ObjectRef)var6_9){
                        public static final long serialVersionUID = 0L;
                        private final String group$1;
                        private final ObjectRef queryChannel$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Querying %s:%d to locate offset manager for %s.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{((BlockingChannel)this.queryChannel$1.elem).host(), BoxesRunTime.boxToInteger(((BlockingChannel)this.queryChannel$1.elem).port()), this.group$1}));
                        }
                        {
                            this.group$1 = group$1;
                            this.queryChannel$1 = queryChannel$1;
                        }
                    }));
                    ((BlockingChannel)var6_9.elem).send(new GroupCoordinatorRequest(group, GroupCoordinatorRequest$.MODULE$.apply$default$2(), GroupCoordinatorRequest$.MODULE$.apply$default$3(), GroupCoordinatorRequest$.MODULE$.apply$default$4()));
                    NetworkReceive response = ((BlockingChannel)var6_9.elem).receive();
                    GroupCoordinatorResponse consumerMetadataResponse = GroupCoordinatorResponse$.MODULE$.readFrom(response.payload());
                    this.debug((Function0<String>)((Object)new Serializable(consumerMetadataResponse){
                        public static final long serialVersionUID = 0L;
                        private final GroupCoordinatorResponse consumerMetadataResponse$1;

                        public final String apply() {
                            return new StringBuilder().append((Object)"Consumer metadata response: ").append((Object)((Object)this.consumerMetadataResponse$1).toString()).toString();
                        }
                        {
                            this.consumerMetadataResponse$1 = consumerMetadataResponse$1;
                        }
                    }));
                    if (consumerMetadataResponse.errorCode() == ErrorMapping$.MODULE$.NoError()) {
                        coordinatorOpt = consumerMetadataResponse.coordinatorOpt();
                        continue;
                    }
                    this.debug((Function0<String>)((Object)new Serializable(group, retryBackOffMs, (ObjectRef)var6_9){
                        public static final long serialVersionUID = 0L;
                        private final String group$1;
                        private final int retryBackOffMs$1;
                        private final ObjectRef queryChannel$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Query to %s:%d to locate offset manager for %s failed - will retry in %d milliseconds.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{((BlockingChannel)this.queryChannel$1.elem).host(), BoxesRunTime.boxToInteger(((BlockingChannel)this.queryChannel$1.elem).port()), this.group$1, BoxesRunTime.boxToInteger(this.retryBackOffMs$1)}));
                        }
                        {
                            this.group$1 = group$1;
                            this.retryBackOffMs$1 = retryBackOffMs$1;
                            this.queryChannel$1 = queryChannel$1;
                        }
                    }));
                    Thread.sleep(retryBackOffMs);
                    continue;
                }
                catch (IOException iOException) {
                    this.info((Function0<String>)((Object)new Serializable((ObjectRef)var6_9){
                        public static final long serialVersionUID = 0L;
                        private final ObjectRef queryChannel$1;

                        public final String apply() {
                            return new StringOps(Predef$.MODULE$.augmentString("Failed to fetch consumer metadata from %s:%d.")).format(Predef$.MODULE$.genericWrapArray(new Object[]{((BlockingChannel)this.queryChannel$1.elem).host(), BoxesRunTime.boxToInteger(((BlockingChannel)this.queryChannel$1.elem).port())}));
                        }
                        {
                            this.queryChannel$1 = queryChannel$1;
                        }
                    }));
                    ((BlockingChannel)var6_9.elem).disconnect();
                    continue;
                }
                break;
            }
            break;
        }
        return (BlockingChannel)((Option)offsetManagerChannelOpt).get();
    }

    public int channelToOffsetManager$default$3() {
        return 3000;
    }

    public int channelToOffsetManager$default$4() {
        return 1000;
    }

    public SecurityProtocol channelToOffsetManager$default$5() {
        return SecurityProtocol.PLAINTEXT;
    }

    private ClientUtils$() {
        MODULE$ = this;
        Logging$class.$init$(this);
    }
}

