/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.impl.plan;

import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pig.impl.plan.Operator;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.PlanException;
import org.apache.pig.impl.util.MultiMap;

public abstract class OperatorPlan<E extends Operator>
implements Iterable<E>,
Serializable,
Cloneable {
    private static final long serialVersionUID = 1L;
    protected Map<E, OperatorKey> mOps;
    protected Map<OperatorKey, E> mKeys;
    protected MultiMap<E, E> mFromEdges;
    protected MultiMap<E, E> mToEdges;
    protected MultiMap<E, E> mSoftFromEdges;
    protected MultiMap<E, E> mSoftToEdges;
    private List<E> mRoots = new ArrayList();
    private List<E> mLeaves = new ArrayList();
    protected static final Log log = LogFactory.getLog(OperatorPlan.class);

    public OperatorPlan() {
        this.mOps = new HashMap<E, OperatorKey>();
        this.mKeys = new HashMap<OperatorKey, E>();
        this.mFromEdges = new MultiMap();
        this.mToEdges = new MultiMap();
        this.mSoftFromEdges = new MultiMap();
        this.mSoftToEdges = new MultiMap();
    }

    public List<E> getRoots() {
        if (this.mRoots.size() == 0 && this.mOps.size() > 0) {
            for (Operator op : this.mOps.keySet()) {
                if (this.mToEdges.get(op) != null) continue;
                this.mRoots.add(op);
            }
        }
        return this.mRoots;
    }

    public List<E> getLeaves() {
        if (this.mLeaves.size() == 0 && this.mOps.size() > 0) {
            for (Operator op : this.mOps.keySet()) {
                if (this.mFromEdges.get(op) != null) continue;
                this.mLeaves.add(op);
            }
        }
        return this.mLeaves;
    }

    public OperatorKey getOperatorKey(E op) {
        return this.mOps.get(op);
    }

    public E getOperator(OperatorKey opKey) {
        return (E)((Operator)this.mKeys.get(opKey));
    }

    public Map<OperatorKey, E> getKeys() {
        return this.mKeys;
    }

    public void add(E op) {
        this.markDirty();
        this.mOps.put(op, ((Operator)op).getOperatorKey());
        this.mKeys.put(((Operator)op).getOperatorKey(), op);
    }

    public void connect(E from, E to) throws PlanException {
        this.markDirty();
        this.checkInPlan(from);
        this.checkInPlan(to);
        if (this.mFromEdges.get(from) != null && !((Operator)from).supportsMultipleOutputs()) {
            PlanException pe = new PlanException("Attempt to give operator of type " + from.getClass().getName() + " multiple outputs.  This operator does not support multiple outputs.");
            log.error((Object)pe.getMessage());
            throw pe;
        }
        if (this.mToEdges.get(to) != null && !((Operator)to).supportsMultipleInputs()) {
            PlanException pe = new PlanException("Attempt to give operator of type " + to.getClass().getName() + " multiple inputs.  This operator does not support multiple inputs.");
            log.error((Object)pe.getMessage());
            throw pe;
        }
        this.mFromEdges.put(from, to);
        this.mToEdges.put(to, from);
    }

    public void createSoftLink(E from, E to) throws PlanException {
        this.checkInPlan(from);
        this.checkInPlan(to);
        this.mSoftFromEdges.put(from, to);
        this.mSoftToEdges.put(to, from);
    }

    public void removeSoftLink(E from, E to) {
        this.mSoftFromEdges.remove(from, to);
        this.mSoftToEdges.remove(to, from);
    }

    public boolean disconnect(E from, E to) {
        this.markDirty();
        boolean sawNull = false;
        if (this.mFromEdges.remove(from, to) == null) {
            sawNull = true;
        }
        if (this.mToEdges.remove(to, from) == null) {
            sawNull = true;
        }
        return !sawNull;
    }

    public void remove(E op) {
        this.markDirty();
        this.removeEdges(op, this.mFromEdges, this.mToEdges);
        this.removeEdges(op, this.mToEdges, this.mFromEdges);
        this.removeEdges(op, this.mSoftFromEdges, this.mSoftToEdges);
        this.removeEdges(op, this.mSoftToEdges, this.mSoftFromEdges);
        this.mOps.remove(op);
        this.mKeys.remove(((Operator)op).getOperatorKey());
    }

    public void trimBelow(E op) {
        this.trimBelow(this.getSuccessors(op));
    }

    private void trimBelow(List<E> ops) {
        if (ops != null) {
            ArrayList<E> copy = new ArrayList<E>(ops);
            for (Operator op : copy) {
                this.trimBelow(this.getSuccessors(op));
                this.remove(op);
            }
        }
    }

    public void trimAbove(E op) {
        ArrayList<E> predecessors = new ArrayList<E>(this.getPredecessors(op));
        IndexHelper<Operator> indexHelper = new IndexHelper<Operator>(predecessors);
        this.trimAbove(predecessors);
        for (Operator predecessor : predecessors) {
            try {
                ((Operator)op).rewire(predecessor, indexHelper.getIndex(predecessor), null, true);
            }
            catch (PlanException pe) {
                throw new RuntimeException("Encountered problems with rewiring operators.", pe);
            }
        }
    }

    private void trimAbove(List<E> ops) {
        if (ops != null) {
            ArrayList<E> copy = new ArrayList<E>(ops);
            for (Operator op : copy) {
                this.trimAbove(this.getPredecessors(op));
                this.remove(op);
            }
        }
    }

    public List<E> getPredecessors(E op) {
        return this.mToEdges.get(op);
    }

    public List<E> getSuccessors(E op) {
        return this.mFromEdges.get(op);
    }

    public List<E> getSoftLinkPredecessors(E op) {
        return this.mSoftToEdges.get(op);
    }

    public List<E> getSoftLinkSuccessors(E op) {
        return this.mSoftFromEdges.get(op);
    }

    public boolean pathExists(E from, E to) {
        List<E> successors = this.getSuccessors(from);
        if (successors == null || successors.size() == 0) {
            return false;
        }
        for (Operator successor : successors) {
            if (!successor.equals(to) && !this.pathExists(successor, to)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<E> iterator() {
        return this.mOps.keySet().iterator();
    }

    private void markDirty() {
        this.mRoots.clear();
        this.mLeaves.clear();
    }

    private void removeEdges(E op, MultiMap<E, E> fromMap, MultiMap<E, E> toMap) {
        List<E> c = fromMap.get(op);
        if (c == null) {
            return;
        }
        ArrayList<E> al = new ArrayList<E>(c);
        for (Operator to : al) {
            toMap.remove(to, op);
            fromMap.remove(op, to);
        }
    }

    private void checkInPlan(E op) throws PlanException {
        if (this.mOps.get(op) == null) {
            PlanException pe = new PlanException("Attempt to connect operator " + ((Operator)op).name() + " which is not in the plan.");
            log.error((Object)pe.getMessage());
            throw pe;
        }
    }

    public OperatorPlan<E> merge(OperatorPlan<E> inpPlan) throws PlanException {
        return this.doMerge(inpPlan, false);
    }

    public OperatorPlan<E> mergeSharedPlan(OperatorPlan<E> inpPlan) throws PlanException {
        return this.doMerge(inpPlan, true);
    }

    private OperatorPlan<E> doMerge(OperatorPlan<E> inpPlan, boolean allowSharedPlan) throws PlanException {
        Map<E, OperatorKey> inpOps = inpPlan.mOps;
        Set<E> curOpsKeySet = this.mOps.keySet();
        for (Map.Entry<E, OperatorKey> mapEnt : inpOps.entrySet()) {
            if (curOpsKeySet.contains(mapEnt.getKey())) {
                if (allowSharedPlan) continue;
                PlanException pe = new PlanException("There are operators that are shared across the plans. Merge of mutually exclusive plans is the only supported merge.");
                log.error((Object)pe.getMessage());
                throw pe;
            }
            this.mOps.put(mapEnt.getKey(), mapEnt.getValue());
        }
        Map<OperatorKey, E> inpKeys = inpPlan.mKeys;
        Set<OperatorKey> curOKKeySet = this.mKeys.keySet();
        for (Map.Entry<OperatorKey, E> mapEnt : inpKeys.entrySet()) {
            if (curOKKeySet.contains(mapEnt.getKey())) {
                if (allowSharedPlan) continue;
                PlanException pe = new PlanException("There are operators that are shared across the plans. Merge of mutually exclusive plans is the only supported merge.");
                log.error((Object)pe.getMessage());
                throw pe;
            }
            this.mKeys.put(mapEnt.getKey(), mapEnt.getValue());
        }
        MultiMap<E, E> inpFromEdges = inpPlan.mFromEdges;
        Set<E> curFEKeySet = this.mFromEdges.keySet();
        for (Operator fromEdg : inpFromEdges.keySet()) {
            if (curFEKeySet.contains(fromEdg) && !allowSharedPlan) {
                PlanException pe = new PlanException("There are operators that are shared across the plans. Merge of mutually exclusive plans is the only supported merge.");
                log.error((Object)pe.getMessage());
                throw pe;
            }
            for (Operator e : inpFromEdges.get(fromEdg)) {
                if (this.mFromEdges.get(fromEdg) != null && this.mFromEdges.get(fromEdg).contains(e)) continue;
                this.mFromEdges.put(fromEdg, e);
            }
        }
        MultiMap<E, E> inpToEdges = inpPlan.mToEdges;
        Set<E> curTEKeySet = this.mToEdges.keySet();
        for (Operator toEdg : inpToEdges.keySet()) {
            if (curTEKeySet.contains(toEdg) && !allowSharedPlan) {
                PlanException pe = new PlanException("There are operators that are shared across the plans. Merge of mutually exclusive plans is the only supported merge.");
                log.error((Object)pe.getMessage());
                throw pe;
            }
            for (Operator e : inpToEdges.get(toEdg)) {
                if (this.mToEdges.get(toEdg) != null && this.mToEdges.get(toEdg).contains(e)) continue;
                this.mToEdges.put(toEdg, e);
            }
        }
        this.markDirty();
        return this;
    }

    public void addAsLeaf(E leaf) throws PlanException {
        ArrayList<Operator> ret = new ArrayList<Operator>();
        for (Operator operator : this.getLeaves()) {
            ret.add(operator);
        }
        this.add(leaf);
        for (Operator oper : ret) {
            this.connect(oper, leaf);
        }
    }

    public boolean isSingleLeafPlan() {
        List<E> tmpList = this.getLeaves();
        return tmpList.size() == 1;
    }

    public int size() {
        return this.mKeys.size();
    }

    public void insertBetween(E after, E newNode, E before) throws PlanException {
        this.doInsertBetween(after, newNode, before, true);
    }

    public void doInsertBetween(E after, E newNode, E before, boolean rewire) throws PlanException {
        Operator newNodePred;
        this.checkInPlan(newNode);
        List<E> newNodePreds = this.getPredecessors(newNode);
        Operator operator = newNodePred = newNodePreds == null ? null : (Operator)newNodePreds.get(0);
        if (!this.replaceNode(after, newNode, before, this.mFromEdges) || !this.replaceNode(before, newNode, after, this.mToEdges)) {
            int errCode = 1094;
            String msg = "Attempt to insert between two nodes that were not connected.";
            PlanException pe = new PlanException(msg, errCode, 2);
            throw pe;
        }
        this.mFromEdges.put(newNode, before);
        this.mToEdges.put(newNode, after);
        if (rewire) {
            if (newNodePred != null && !newNodePred.equals(after)) {
                newNodePred.regenerateProjectionMap();
                ((Operator)newNode).rewire(newNodePred, 0, after, true);
            }
            ((Operator)newNode).regenerateProjectionMap();
            IndexHelper<E> indexHelper = new IndexHelper<E>(this.getPredecessors(newNode));
            ((Operator)before).rewire(after, indexHelper.getIndex(after), newNode, false);
        }
    }

    private boolean replaceNode(E src, E replacement, E dst, MultiMap<E, E> multiMap) {
        if (multiMap == null) {
            return false;
        }
        if (src == null) {
            return false;
        }
        ArrayList nodes = (ArrayList)multiMap.get(src);
        if (nodes == null) {
            if (replacement == null) {
                return false;
            }
            if (dst == null) {
                ArrayList<E> replacementNodes = new ArrayList<E>();
                replacementNodes.add(replacement);
                multiMap.put(src, replacementNodes);
                return true;
            }
            return false;
        }
        if (dst == null) {
            return false;
        }
        boolean replaced = false;
        ArrayList<E> replacementNodes = new ArrayList<E>();
        for (int i = 0; i < nodes.size(); ++i) {
            Operator to = (Operator)nodes.get(i);
            if (to.equals(dst)) {
                replaced = true;
                if (replacement == null) continue;
                replacementNodes.add(replacement);
                continue;
            }
            replacementNodes.add(to);
        }
        if (replaced) {
            multiMap.removeKey(src);
            if (replacementNodes.size() > 0) {
                multiMap.put(src, replacementNodes);
            }
        }
        return replaced;
    }

    public void replace(E oldNode, E newNode) throws PlanException {
        Operator oldNodeSucc;
        int i;
        this.checkInPlan(oldNode);
        this.add(newNode);
        ArrayList<E> oldNodeSuccs = this.getSuccessors(oldNode) == null ? null : new ArrayList<E>(this.getSuccessors(oldNode));
        ArrayList<IndexHelper<Operator>> indexHelpers = new ArrayList<IndexHelper<Operator>>();
        if (oldNodeSuccs != null) {
            for (i = 0; i < oldNodeSuccs.size(); ++i) {
                oldNodeSucc = (Operator)oldNodeSuccs.get(i);
                indexHelpers.add(new IndexHelper<Operator>(new ArrayList<Operator>(this.getPredecessors(oldNodeSucc))));
            }
        }
        this.mToEdges = this.generateNewMap(oldNode, newNode, this.mToEdges);
        this.mFromEdges = this.generateNewMap(oldNode, newNode, this.mFromEdges);
        if (oldNodeSuccs != null) {
            for (i = 0; i < oldNodeSuccs.size(); ++i) {
                oldNodeSucc = (Operator)oldNodeSuccs.get(i);
                oldNodeSucc.rewire(oldNode, ((IndexHelper)indexHelpers.get(i)).getIndex(oldNode), newNode, true);
            }
        }
        this.remove(oldNode);
    }

    private MultiMap<E, E> generateNewMap(E oldNode, E newNode, MultiMap<E, E> mm) {
        List<E> targets = mm.get(oldNode);
        if (targets != null) {
            mm.removeKey(oldNode);
            mm.put(newNode, targets);
        }
        MultiMap<Operator, E> newMap = new MultiMap<Operator, E>(mm.size());
        for (Operator key : mm.keySet()) {
            List<E> c = mm.get(key);
            ArrayList<E> al = new ArrayList<E>(c);
            for (int i = 0; i < al.size(); ++i) {
                if (al.get(i) != oldNode) continue;
                al.set(i, newNode);
            }
            newMap.put(key, al);
        }
        return newMap;
    }

    public void removeAndReconnect(E node) throws PlanException {
        int i;
        List<Operator> plst;
        List<E> preds = this.getPredecessors(node);
        Operator pred = null;
        if (preds != null) {
            if (preds.size() > 1) {
                int errCode = 1095;
                String msg = "Attempt to remove  and reconnect for node with multiple predecessors.";
                PlanException pe = new PlanException(msg, errCode, 2);
                throw pe;
            }
            pred = (Operator)preds.get(0);
            this.disconnect(pred, node);
        }
        int oldPos = -1;
        int newPos = -1;
        List<E> succs = this.getSuccessors(node);
        Operator succ = null;
        if (succs != null) {
            if (succs.size() > 1) {
                int errCode = 1095;
                String msg = "Attempt to remove  and reconnect for node with multiple successors.";
                PlanException pe = new PlanException(msg, errCode, 2);
                throw pe;
            }
            succ = (Operator)succs.get(0);
            plst = this.getPredecessors(succ);
            for (i = 0; i < plst.size(); ++i) {
                if (!plst.get(i).equals(node)) continue;
                oldPos = i;
            }
            this.disconnect(node, succ);
        }
        this.remove(node);
        if (pred != null && succ != null) {
            this.connect(pred, succ);
            plst = this.getPredecessors(succ);
            for (i = 0; i < plst.size(); ++i) {
                if (!plst.get(i).equals(pred)) continue;
                newPos = i;
            }
            if (oldPos < 0 || newPos < 0) {
                throw new PlanException("Invalid position index: " + oldPos + " : " + newPos);
            }
            if (oldPos != newPos) {
                ArrayList<Operator> nlst = new ArrayList<Operator>();
                for (int i2 = 0; i2 < plst.size(); ++i2) {
                    Operator nod = plst.get(i2);
                    if (i2 == oldPos) {
                        nlst.add(pred);
                    }
                    if (i2 == newPos) continue;
                    nlst.add(nod);
                }
                if (nlst.size() != plst.size()) {
                    throw new PlanException("Invalid list size: " + nlst.size() + " : " + plst.size());
                }
                this.mToEdges.removeKey(succ);
                this.mToEdges.put((E)succ, nlst);
            }
            succ.rewire(node, oldPos, pred, true);
        }
    }

    private void reconnectSuccessors(E node, boolean successorRequired, boolean removeNode) throws PlanException {
        Operator c;
        int i;
        ArrayList<E> nodeC;
        E nodeB = node;
        List<E> preds = this.getPredecessors(nodeB);
        if (preds == null || preds.size() != 1) {
            Integer size = null;
            if (preds != null) {
                size = preds.size();
            }
            int errCode = 1096;
            String msg = "Attempt to remove  and reconnect for node with  " + size + " predecessors.";
            PlanException pe = new PlanException(msg, errCode, 2);
            throw pe;
        }
        Operator nodeA = (Operator)preds.get(0);
        ArrayList<E> arrayList = nodeC = this.mFromEdges.get(nodeB) == null ? null : new ArrayList<E>(this.mFromEdges.get(nodeB));
        if (successorRequired && (nodeC == null || nodeC.size() == 0)) {
            int errCode = 1096;
            String msg = "Attempt to remove  and reconnect for node with no successors.";
            PlanException pe = new PlanException(msg, errCode, 2);
            throw pe;
        }
        ArrayList<IndexHelper<Operator>> indexHelpers = new ArrayList<IndexHelper<Operator>>();
        if (nodeC != null) {
            for (i = 0; i < nodeC.size(); ++i) {
                c = (Operator)((List)nodeC).get(i);
                indexHelpers.add(new IndexHelper<Operator>(new ArrayList<Operator>(this.getPredecessors(c))));
            }
        }
        this.replaceAndAddSucessors(nodeA, nodeB);
        if (nodeC != null) {
            for (i = 0; i < nodeC.size(); ++i) {
                c = (Operator)((List)nodeC).get(i);
                List<E> sPreds = this.mToEdges.get(c);
                ArrayList<Operator> newPreds = new ArrayList<Operator>(sPreds.size());
                for (Operator p : sPreds) {
                    if (p == nodeB) {
                        newPreds.add(nodeA);
                        continue;
                    }
                    newPreds.add(p);
                }
                this.mToEdges.removeKey(c);
                this.mToEdges.put((E)c, newPreds);
            }
        }
        if (removeNode) {
            this.remove(nodeB);
        } else {
            this.mFromEdges.removeKey(nodeB);
            this.mToEdges.removeKey(nodeB);
        }
        if (nodeC != null) {
            for (i = 0; i < nodeC.size(); ++i) {
                c = (Operator)((List)nodeC).get(i);
                c.rewire(nodeB, ((IndexHelper)indexHelpers.get(i)).getIndex(nodeB), nodeA, true);
            }
        }
    }

    private void reconnectPredecessors(E node, boolean predecessorRequired, boolean removeNode) throws PlanException {
        ArrayList<E> nodeC;
        E nodeB = node;
        List<E> nodeBsuccessors = this.getSuccessors(nodeB);
        if (nodeBsuccessors == null || nodeBsuccessors.size() != 1) {
            Integer size = null;
            if (nodeBsuccessors != null) {
                size = nodeBsuccessors.size();
            }
            int errCode = 1096;
            String msg = "Attempt to remove  and reconnect for node with  " + size + " successors.";
            PlanException pe = new PlanException(msg, errCode, 2);
            throw pe;
        }
        Operator nodeA = (Operator)nodeBsuccessors.get(0);
        ArrayList<E> arrayList = nodeC = this.mToEdges.get(nodeB) == null ? null : new ArrayList<E>(this.mToEdges.get(nodeB));
        if (predecessorRequired && (nodeC == null || nodeC.size() == 0)) {
            int errCode = 1096;
            String msg = "Attempt to remove  and reconnect for node with no predecessors.";
            PlanException pe = new PlanException(msg, errCode, 2);
            throw pe;
        }
        this.replaceAndAddPredecessors(nodeA, nodeB);
        if (nodeC != null) {
            for (Operator c : nodeC) {
                List<E> sPreds = this.mFromEdges.get(c);
                ArrayList<Operator> newPreds = new ArrayList<Operator>(sPreds.size());
                for (Operator p : sPreds) {
                    if (p == nodeB) {
                        newPreds.add(nodeA);
                        continue;
                    }
                    newPreds.add(p);
                }
                this.mFromEdges.removeKey(c);
                this.mFromEdges.put((E)c, newPreds);
                nodeA.rewire(nodeB, 0, c, true);
            }
        }
        if (removeNode) {
            this.remove(nodeB);
        } else {
            this.mFromEdges.removeKey(nodeB);
            this.mToEdges.removeKey(nodeB);
        }
    }

    private void replaceAndAddSucessors(E node, E successor) throws PlanException {
        List<E> oldSuccessors = this.mFromEdges.get(node);
        List<E> replacementSuccessors = this.mFromEdges.get(successor);
        ArrayList<E> newSuccessors = new ArrayList<E>();
        for (Operator s : oldSuccessors) {
            if (s == successor) {
                if (replacementSuccessors == null) continue;
                newSuccessors.addAll(replacementSuccessors);
                continue;
            }
            newSuccessors.add(s);
        }
        this.mFromEdges.removeKey(node);
        if (!newSuccessors.isEmpty()) {
            this.mFromEdges.put(node, newSuccessors);
        }
    }

    private void replaceAndAddPredecessors(E node, E predecessor) throws PlanException {
        List<E> oldPredecessors = this.mToEdges.get(node);
        List<E> replacementPredecessors = this.mToEdges.get(predecessor);
        ArrayList<E> newPredecessors = new ArrayList<E>();
        for (Operator p : oldPredecessors) {
            if (p == predecessor) {
                if (replacementPredecessors == null) continue;
                newPredecessors.addAll(replacementPredecessors);
                continue;
            }
            newPredecessors.add(p);
        }
        this.mToEdges.removeKey(node);
        if (!newPredecessors.isEmpty()) {
            this.mToEdges.put(node, newPredecessors);
        }
    }

    public void removeAndReconnectMultiSucc(E node) throws PlanException {
        this.reconnectSuccessors(node, true, true);
    }

    public void dump(PrintStream ps) {
        ps.println("Ops");
        for (Operator op : this.mOps.keySet()) {
            ps.println(op.name());
        }
        ps.println("from edges");
        for (Operator op : this.mFromEdges.keySet()) {
            for (Operator to : this.mFromEdges.get(op)) {
                ps.println(op.name() + " -> " + to.name());
            }
        }
        ps.println("to edges");
        for (Operator op : this.mToEdges.keySet()) {
            for (Operator to : this.mToEdges.get(op)) {
                ps.println(op.name() + " -> " + to.name());
            }
        }
    }

    public void swap(E first, E second) throws PlanException {
        E firstNode = first;
        E secondNode = second;
        if (firstNode == null) {
            int errCode = 1092;
            String msg = "First operator in swap is null. Cannot swap null operators.";
            throw new PlanException(msg, errCode, 2);
        }
        if (secondNode == null) {
            int errCode = 1092;
            String msg = "Second operator in swap is null. Cannot swap null operators.";
            throw new PlanException(msg, errCode, 2);
        }
        this.checkInPlan(firstNode);
        this.checkInPlan(secondNode);
        ArrayList firstNodePredecessors = (ArrayList)this.mToEdges.get(firstNode);
        if (firstNodePredecessors != null && firstNodePredecessors.size() > 1) {
            int errCode = 1093;
            String msg = "Swap supports swap of operators with at most one input. Found first operator with " + firstNodePredecessors.size() + " inputs.";
            throw new PlanException(msg, errCode, 2);
        }
        ArrayList firstNodeSuccessors = (ArrayList)this.mFromEdges.get(firstNode);
        if (firstNodeSuccessors != null && firstNodeSuccessors.size() > 1) {
            int errCode = 1093;
            String msg = "Swap supports swap of operators with at most one output. Found first operator with " + firstNodeSuccessors.size() + " outputs.";
            throw new PlanException(msg, errCode, 2);
        }
        ArrayList secondNodePredecessors = (ArrayList)this.mToEdges.get(secondNode);
        if (secondNodePredecessors != null && secondNodePredecessors.size() > 1) {
            int errCode = 1093;
            String msg = "Swap supports swap of operators with at most one input. Found second operator with " + secondNodePredecessors.size() + " inputs.";
            throw new PlanException(msg, errCode, 2);
        }
        ArrayList secondNodeSuccessors = (ArrayList)this.mFromEdges.get(secondNode);
        if (secondNodeSuccessors != null && secondNodeSuccessors.size() > 1) {
            int errCode = 1093;
            String msg = "Swap supports swap of operators with at most one output. Found second operator with " + secondNodeSuccessors.size() + " outputs.";
            throw new PlanException(msg, errCode, 2);
        }
        Operator firstNodePredecessor = null;
        Operator firstNodeSuccessor = null;
        Operator<Object> secondNodePredecessor = null;
        Operator<Object> secondNodeSuccessor = null;
        if (firstNodePredecessors != null) {
            firstNodePredecessor = (Operator)firstNodePredecessors.get(0);
        }
        if (firstNodeSuccessors != null) {
            firstNodeSuccessor = (Operator)firstNodeSuccessors.get(0);
        }
        if (secondNodePredecessors != null) {
            secondNodePredecessor = (Operator)secondNodePredecessors.get(0);
        }
        if (secondNodeSuccessors != null) {
            secondNodeSuccessor = (Operator)secondNodeSuccessors.get(0);
        }
        boolean immediateNodes = false;
        if (firstNodeSuccessor == secondNode && secondNodePredecessor == firstNode) {
            immediateNodes = true;
        } else if (secondNodeSuccessor == firstNode && firstNodePredecessor == secondNode) {
            immediateNodes = true;
            Object tmpNode = firstNode;
            firstNode = secondNode;
            secondNode = tmpNode;
            tmpNode = firstNodePredecessor;
            firstNodePredecessor = secondNodePredecessor;
            secondNodePredecessor = tmpNode;
            tmpNode = firstNodeSuccessor;
            firstNodeSuccessor = secondNodeSuccessor;
            secondNodeSuccessor = tmpNode;
        }
        if (immediateNodes) {
            this.replaceNode(firstNode, secondNodeSuccessor, firstNodeSuccessor, this.mFromEdges);
            this.replaceNode(firstNode, secondNode, firstNodePredecessor, this.mToEdges);
            this.replaceNode(secondNode, firstNode, secondNodeSuccessor, this.mFromEdges);
            this.replaceNode(secondNode, firstNodePredecessor, secondNodePredecessor, this.mToEdges);
            ((Operator)secondNode).rewire(firstNode, 0, firstNodePredecessor, true);
            ((Operator)secondNode).regenerateProjectionMap();
            ((Operator)firstNode).rewire(firstNodePredecessor, 0, secondNode, false);
        } else {
            this.replaceNode(firstNode, secondNodeSuccessor, firstNodeSuccessor, this.mFromEdges);
            this.replaceNode(firstNode, secondNodePredecessor, firstNodePredecessor, this.mToEdges);
            this.replaceNode(secondNode, firstNodeSuccessor, secondNodeSuccessor, this.mFromEdges);
            this.replaceNode(secondNode, firstNodePredecessor, secondNodePredecessor, this.mToEdges);
            ((Operator)firstNode).rewire(firstNodePredecessor, 0, secondNodePredecessor, true);
            ((Operator)secondNode).rewire(secondNodePredecessor, 0, firstNodePredecessor, true);
        }
        this.replaceNode(firstNodePredecessor, secondNode, firstNode, this.mFromEdges);
        this.replaceNode(firstNodeSuccessor, secondNode, firstNode, this.mToEdges);
        this.replaceNode(secondNodePredecessor, firstNode, secondNode, this.mFromEdges);
        this.replaceNode(secondNodeSuccessor, firstNode, secondNode, this.mToEdges);
        if (firstNodeSuccessor != null) {
            firstNodeSuccessor.rewire(firstNode, 0, secondNode, true);
        }
        if (secondNodeSuccessor != null) {
            secondNodeSuccessor.rewire((Operator<Object>)secondNode, 0, (Operator<Object>)firstNode, true);
        }
        this.markDirty();
    }

    public void pushBefore(E first, E second, int inputNum) throws PlanException {
        String msg;
        ArrayList<E> secondNodePredecessors;
        ArrayList<E> firstNodeSuccessors;
        ArrayList<E> firstNodePredecessors;
        E firstNode = first;
        E secondNode = second;
        if (firstNode == null) {
            int errCode = 1085;
            String msg2 = "First operator in pushBefore is null. Cannot pushBefore null operators.";
            throw new PlanException(msg2, errCode, 2);
        }
        if (secondNode == null) {
            int errCode = 1085;
            String msg3 = "Second operator in pushBefore is null. Cannot pushBefore null operators.";
            throw new PlanException(msg3, errCode, 2);
        }
        this.checkInPlan(firstNode);
        this.checkInPlan(secondNode);
        ArrayList<E> arrayList = firstNodePredecessors = this.mToEdges.get(firstNode) == null ? null : new ArrayList<E>(this.mToEdges.get(firstNode));
        if (firstNodePredecessors == null || firstNodePredecessors.size() <= 1) {
            int size = firstNodePredecessors == null ? 0 : firstNodePredecessors.size();
            int errCode = 1086;
            String msg4 = "First operator in pushBefore should have multiple inputs. Found first operator with " + size + " inputs.";
            throw new PlanException(msg4, errCode, 2);
        }
        if (inputNum >= firstNodePredecessors.size()) {
            int errCode = 1087;
            String msg5 = "The inputNum " + inputNum + " should be lesser than the number of inputs of the first operator. Found first operator with " + firstNodePredecessors.size() + " inputs.";
            throw new PlanException(msg5, errCode, 2);
        }
        ArrayList<E> arrayList2 = firstNodeSuccessors = this.mFromEdges.get(firstNode) == null ? null : new ArrayList<E>(this.mFromEdges.get(firstNode));
        if (firstNodeSuccessors == null) {
            int errCode = 1088;
            String msg6 = "First operator in pushBefore should have at least one output. Found first operator with no outputs.";
            throw new PlanException(msg6, errCode, 2);
        }
        ArrayList<E> arrayList3 = secondNodePredecessors = this.mToEdges.get(secondNode) == null ? null : new ArrayList<E>(this.mToEdges.get(secondNode));
        if (secondNodePredecessors == null || secondNodePredecessors.size() > 1) {
            int size = secondNodePredecessors == null ? 0 : secondNodePredecessors.size();
            int errCode = 1088;
            String msg7 = "Second operator in pushBefore should have one input. Found second operator with " + size + " inputs.";
            throw new PlanException(msg7, errCode, 2);
        }
        ArrayList<E> secondNodeSuccessors = this.mFromEdges.get(secondNode) == null ? null : new ArrayList<E>(this.mFromEdges.get(secondNode));
        int edgesFromFirstToSecond = 0;
        for (Operator node : firstNodeSuccessors) {
            if (node != secondNode) continue;
            ++edgesFromFirstToSecond;
        }
        if (edgesFromFirstToSecond == 0) {
            int errCode = 1089;
            msg = "Second operator in pushBefore should be the successor of the First operator.";
            throw new PlanException(msg, errCode, 2);
        }
        if (edgesFromFirstToSecond > 1) {
            int errCode = 1090;
            msg = "Second operator can have at most one incoming edge from First operator. Found " + edgesFromFirstToSecond + " edges.";
            throw new PlanException(msg, errCode, 2);
        }
        if (!((Operator)firstNode).supportsMultipleOutputs()) {
            int numSecondNodeSuccessors;
            int n = numSecondNodeSuccessors = secondNodeSuccessors == null ? 0 : secondNodeSuccessors.size();
            if (firstNodeSuccessors.size() > 0 || numSecondNodeSuccessors > 0) {
                int errCode = 1091;
                String msg8 = "First operator does not support multiple outputs. On completing the pushBefore operation First operator will end up with " + (firstNodeSuccessors.size() + numSecondNodeSuccessors) + " edges.";
                throw new PlanException(msg8, errCode, 2);
            }
        }
        this.reconnectSuccessors(secondNode, false, false);
        this.doInsertBetween((Operator)firstNodePredecessors.get(inputNum), secondNode, firstNode, false);
        ((Operator)secondNode).rewire(firstNode, inputNum, (Operator)firstNodePredecessors.get(inputNum), true);
        ((Operator)secondNode).regenerateProjectionMap();
        ((Operator)firstNode).rewire((Operator)firstNodePredecessors.get(inputNum), 0, secondNode, false);
        this.markDirty();
    }

    public void pushAfter(E first, E second, int outputNum) throws PlanException {
        String msg;
        ArrayList<E> secondNodeSuccessors;
        ArrayList<E> firstNodeSuccessors;
        ArrayList<E> firstNodePredecessors;
        E firstNode = first;
        E secondNode = second;
        if (firstNode == null) {
            int errCode = 1085;
            String msg2 = "First operator in pushAfter is null. Cannot pushBefore null operators.";
            throw new PlanException(msg2, errCode, 2);
        }
        if (secondNode == null) {
            int errCode = 1085;
            String msg3 = "Second operator in pushAfter is null. Cannot pushBefore null operators.";
            throw new PlanException(msg3, errCode, 2);
        }
        this.checkInPlan(firstNode);
        this.checkInPlan(secondNode);
        ArrayList<E> arrayList = firstNodePredecessors = this.mToEdges.get(firstNode) == null ? null : new ArrayList<E>(this.mToEdges.get(firstNode));
        if (firstNodePredecessors == null) {
            int errCode = 1088;
            String msg4 = "First operator in pushAfter should have at least one input. Found first operator with no inputs.";
            throw new PlanException(msg4, errCode, 2);
        }
        ArrayList<E> arrayList2 = firstNodeSuccessors = this.mFromEdges.get(firstNode) == null ? null : new ArrayList<E>(this.mFromEdges.get(firstNode));
        if (firstNodeSuccessors == null || firstNodeSuccessors.size() <= 1) {
            int size = firstNodeSuccessors == null ? 0 : firstNodeSuccessors.size();
            int errCode = 1086;
            String msg5 = "First operator in pushAfter should have multiple outputs. Found first operator with " + size + " outputs.";
            throw new PlanException(msg5, errCode, 2);
        }
        if (outputNum >= firstNodeSuccessors.size()) {
            int errCode = 1087;
            String msg6 = "The outputNum " + outputNum + " should be lesser than the number of outputs of the first operator. Found first operator with " + firstNodeSuccessors.size() + " outputs.";
            throw new PlanException(msg6, errCode, 2);
        }
        ArrayList<E> secondNodePredecessors = this.mToEdges.get(secondNode) == null ? null : new ArrayList<E>(this.mToEdges.get(secondNode));
        ArrayList<E> arrayList3 = secondNodeSuccessors = this.mFromEdges.get(secondNode) == null ? null : new ArrayList<E>(this.mFromEdges.get(secondNode));
        if (secondNodeSuccessors == null || secondNodeSuccessors.size() > 1) {
            int size = secondNodeSuccessors == null ? 0 : secondNodeSuccessors.size();
            int errCode = 1088;
            String msg7 = "Second operator in pushAfter should have one output. Found second operator with " + size + " outputs.";
            throw new PlanException(msg7, errCode, 2);
        }
        int edgesFromSecondToFirst = 0;
        for (Operator node : secondNodeSuccessors) {
            if (node != firstNode) continue;
            ++edgesFromSecondToFirst;
        }
        if (edgesFromSecondToFirst == 0) {
            int errCode = 1089;
            msg = "Second operator in pushAfter should be the predecessor of the First operator.";
            throw new PlanException(msg, errCode, 2);
        }
        if (edgesFromSecondToFirst > 1) {
            int errCode = 1090;
            msg = "Second operator can have at most one outgoing edge from First operator. Found " + edgesFromSecondToFirst + " edges.";
            throw new PlanException(msg, errCode, 2);
        }
        if (!((Operator)firstNode).supportsMultipleInputs()) {
            int numSecondNodePredecessors;
            int n = numSecondNodePredecessors = secondNodePredecessors == null ? 0 : secondNodePredecessors.size();
            if (numSecondNodePredecessors > 1) {
                int errCode = 1091;
                String msg8 = "First operator does not support multiple inputs. On completing the pushAfter operation First operator will end up with " + (firstNodePredecessors.size() + numSecondNodePredecessors) + " edges.";
                throw new PlanException(msg8, errCode, 2);
            }
        }
        this.reconnectPredecessors(secondNode, false, false);
        this.doInsertBetween(firstNode, secondNode, (Operator)firstNodeSuccessors.get(outputNum), false);
        if (secondNodePredecessors != null) {
            for (int i = 0; i < secondNodePredecessors.size(); ++i) {
                Operator secondNodePred = (Operator)secondNodePredecessors.get(i);
                ((Operator)secondNode).rewire(secondNodePred, i, firstNode, true);
            }
        }
        ((Operator)secondNode).regenerateProjectionMap();
        ((Operator)firstNodeSuccessors.get(outputNum)).rewire(firstNode, 0, secondNode, false);
        this.markDirty();
    }

    public static class IndexHelper<E> {
        private Map<E, Integer> mIndex = null;

        public IndexHelper(List<E> list) {
            if (list != null && list.size() != 0) {
                this.mIndex = new HashMap<E, Integer>();
                for (int i = 0; i < list.size(); ++i) {
                    this.mIndex.put(list.get(i), i);
                }
            }
        }

        public int getIndex(E e) {
            if (this.mIndex == null || this.mIndex.size() == 0) {
                return -1;
            }
            return this.mIndex.get(e);
        }
    }
}

