/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig.backend.hadoop.executionengine.tez.plan;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.PrintStream;
import java.net.URI;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.hadoop.yarn.api.records.LocalResource;
import org.apache.pig.backend.hadoop.executionengine.tez.TezResourceManager;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOpPlanVisitor;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOperPlan;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezOperator;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezPlanContainerNode;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezPlanContainerPrinter;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezPlanContainerUDFCollector;
import org.apache.pig.backend.hadoop.executionengine.tez.plan.TezPlanContainerVisitor;
import org.apache.pig.impl.PigContext;
import org.apache.pig.impl.plan.DependencyOrderWalker;
import org.apache.pig.impl.plan.OperatorKey;
import org.apache.pig.impl.plan.OperatorPlan;
import org.apache.pig.impl.plan.PlanException;
import org.apache.pig.impl.plan.PlanWalker;
import org.apache.pig.impl.plan.VisitorException;
import org.apache.pig.impl.util.JarManager;

public class TezPlanContainer
extends OperatorPlan<TezPlanContainerNode> {
    private static final long serialVersionUID = 1L;
    private PigContext pigContext;
    private String jobName;
    private long dagId = 0L;
    private static long scopeId = 0L;

    public TezPlanContainer(PigContext pigContext) {
        this.pigContext = pigContext;
        this.jobName = pigContext.getProperties().getProperty("jobName", "pig");
    }

    public Map<String, LocalResource> getLocalResources() throws Exception {
        HashSet<URI> jarLists = new HashSet<URI>();
        for (String string : JarManager.getDefaultJars()) {
            jarLists.add(new File(string).toURI());
        }
        for (URL uRL : this.pigContext.extraJars) {
            jarLists.add(uRL.toURI());
        }
        for (String string : this.pigContext.scriptJars) {
            jarLists.add(new File(string).toURI());
        }
        for (Map.Entry entry : this.pigContext.getScriptFiles().entrySet()) {
            if (!((String)entry.getKey()).endsWith(".groovy")) continue;
            jarLists.add(((File)entry.getValue()).toURI());
        }
        TezPlanContainerUDFCollector tezPlanContainerUDFCollector = new TezPlanContainerUDFCollector(this);
        tezPlanContainerUDFCollector.visit();
        Set<String> set = tezPlanContainerUDFCollector.getUdfs();
        for (String func : set) {
            String jarName;
            Class clazz = this.pigContext.getClassForAlias(func);
            if (clazz == null || (jarName = JarManager.findContainingJar(clazz)) == null) continue;
            URI jarUri = new File(jarName).toURI();
            jarLists.add(jarUri);
        }
        File scriptUDFJarFile = JarManager.createPigScriptUDFJar(this.pigContext);
        if (scriptUDFJarFile != null) {
            jarLists.add(scriptUDFJarFile.toURI());
        }
        return TezResourceManager.getInstance().addTezResources(jarLists);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public TezPlanContainerNode getNextPlan(List<TezOperPlan> processedPlans) {
        TezPlanContainer tezPlanContainer = this;
        synchronized (tezPlanContainer) {
            while (this.getRoots() != null) {
                if (this.getRoots().isEmpty()) return null;
                TezPlanContainerNode currentPlan = null;
                for (TezPlanContainerNode plan : this.getRoots()) {
                    if (processedPlans.contains(plan.getTezOperPlan())) continue;
                    currentPlan = plan;
                    break;
                }
                if (currentPlan != null) {
                    return currentPlan;
                }
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
            return null;
        }
    }

    public void addPlan(TezOperPlan plan) throws PlanException {
        TezPlanContainerNode node = new TezPlanContainerNode(this.generateNodeOperatorKey(), plan);
        this.add(node);
        this.split(node);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updatePlan(TezOperPlan plan, boolean succ) {
        TezPlanContainerNode tezPlanContainerNode = new TezPlanContainerNode(this.generateNodeOperatorKey(), plan);
        TezPlanContainer tezPlanContainer = this;
        synchronized (tezPlanContainer) {
            if (succ) {
                this.remove(tezPlanContainerNode);
            } else {
                this.trimBelow(tezPlanContainerNode);
                this.remove(tezPlanContainerNode);
            }
            this.notify();
        }
    }

    public void split(TezPlanContainerNode planNode) throws PlanException {
        TezOperPlan tezOperPlan = planNode.getTezOperPlan();
        if (tezOperPlan.size() == 1) {
            return;
        }
        TezOperator operToSegment = null;
        ArrayList<TezOperator> succs = new ArrayList<TezOperator>();
        try {
            SegmentOperatorFinder finder = new SegmentOperatorFinder(tezOperPlan);
            finder.visit();
            operToSegment = finder.getOperatorToSegment();
        }
        catch (VisitorException e) {
            throw new PlanException(e);
        }
        if (operToSegment != null && tezOperPlan.getSuccessors(operToSegment) != null) {
            succs.addAll(tezOperPlan.getSuccessors(operToSegment));
            for (TezOperator succ : succs) {
                tezOperPlan.disconnect(operToSegment, succ);
            }
            for (TezOperator succ : succs) {
                try {
                    if (tezOperPlan.getOperator(succ.getOperatorKey()) == null) {
                        TezOperatorFinder finder = new TezOperatorFinder(this, succ);
                        finder.visit();
                        this.connect(planNode, finder.getPlanContainerNode());
                        continue;
                    }
                    TezOperPlan newOperPlan = new TezOperPlan();
                    tezOperPlan.moveTree(succ, newOperPlan);
                    TezPlanContainerNode newPlanNode = new TezPlanContainerNode(this.generateNodeOperatorKey(), newOperPlan);
                    this.add(newPlanNode);
                    this.connect(planNode, newPlanNode);
                    this.split(newPlanNode);
                    if (newPlanNode.getTezOperPlan().getOperator(succ.getOperatorKey()) != null) continue;
                    TezOperatorFinder finder = new TezOperatorFinder(this, succ);
                    finder.visit();
                    this.disconnect(planNode, newPlanNode);
                    this.connect(planNode, finder.getPlanContainerNode());
                }
                catch (VisitorException e) {
                    throw new PlanException(e);
                }
            }
            this.split(planNode);
        }
    }

    private synchronized OperatorKey generateNodeOperatorKey() {
        OperatorKey opKey = new OperatorKey(this.jobName + "-" + this.dagId + "_scope", scopeId);
        ++scopeId;
        ++this.dagId;
        return opKey;
    }

    public static void resetScope() {
        scopeId = 0L;
    }

    public String toString() {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        TezPlanContainerPrinter printer = new TezPlanContainerPrinter(ps, this);
        printer.setVerbose(true);
        try {
            printer.visit();
        }
        catch (VisitorException e) {
            throw new RuntimeException(e);
        }
        return baos.toString();
    }

    private static class TezOperatorFinder
    extends TezPlanContainerVisitor {
        private TezPlanContainerNode planContainerNode;
        private TezOperator operatorToFind;

        public TezOperatorFinder(TezPlanContainer plan, TezOperator operatorToFind) {
            super(plan, (PlanWalker<TezPlanContainerNode, TezPlanContainer>)new DependencyOrderWalker<TezPlanContainerNode, TezPlanContainer>(plan));
            this.operatorToFind = operatorToFind;
        }

        public TezPlanContainerNode getPlanContainerNode() {
            return this.planContainerNode;
        }

        @Override
        public void visitTezPlanContainerNode(TezPlanContainerNode tezPlanContainerNode) throws VisitorException {
            if (tezPlanContainerNode.getTezOperPlan().getOperatorKey(this.operatorToFind) != null) {
                this.planContainerNode = tezPlanContainerNode;
            }
        }
    }

    private static class SegmentOperatorFinder
    extends TezOpPlanVisitor {
        private TezOperator operToSegment;

        public SegmentOperatorFinder(TezOperPlan plan) {
            super(plan, (PlanWalker<TezOperator, TezOperPlan>)new DependencyOrderWalker<TezOperator, TezOperPlan>(plan));
        }

        public TezOperator getOperatorToSegment() {
            return this.operToSegment;
        }

        @Override
        public void visitTezOp(TezOperator tezOperator) throws VisitorException {
            if (tezOperator.needSegmentBelow() && this.operToSegment == null) {
                this.operToSegment = tezOperator;
            }
        }
    }
}

