/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pig;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Counter;
import org.apache.pig.ErrorHandler;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.util.UDFContext;
import org.apache.pig.tools.pigstats.PigStatusReporter;

public class CounterBasedErrorHandler
implements ErrorHandler {
    public static final String STORER_ERROR_HANDLER_COUNTER_GROUP = "storer_Error_Handler";
    public static final String STORER_ERROR_COUNT = "bad_record_count";
    public static final String STORER_RECORD_COUNT = "record__count";
    private final long minErrors;
    private final float errorThreshold;

    public CounterBasedErrorHandler() {
        Configuration conf = UDFContext.getUDFContext().getJobConf();
        this.minErrors = conf.getLong("pig.error-handling.min.error.records", 0L);
        this.errorThreshold = conf.getFloat("pig.error-handling.error.threshold", 0.0f);
    }

    @Override
    public void onSuccess(String uniqueSignature) {
        this.incAndGetCounter(uniqueSignature, STORER_RECORD_COUNT);
    }

    @Override
    public void onError(String uniqueSignature, Exception e, Tuple inputTuple) {
        long numRecords;
        long numErrors = this.incAndGetCounter(uniqueSignature, STORER_ERROR_COUNT);
        boolean exceedThreshold = this.hasErrorExceededThreshold(numErrors, numRecords = this.incAndGetCounter(uniqueSignature, STORER_RECORD_COUNT));
        if (exceedThreshold) {
            throw new RuntimeException("Exceeded the error rate while writing records. The latest error seen  ", e);
        }
    }

    private boolean hasErrorExceededThreshold(long numErrors, long numRecords) {
        if (numErrors > 0L && this.errorThreshold <= 0.0f) {
            return true;
        }
        double errRate = (double)numErrors / (double)numRecords;
        return numErrors >= this.minErrors && errRate > (double)this.errorThreshold;
    }

    public long getRecordCount(String storeSignature) {
        Counter counter = this.getCounter(storeSignature, STORER_RECORD_COUNT);
        return counter.getValue();
    }

    private long incAndGetCounter(String storeSignature, String counterName) {
        Counter counter = this.getCounter(storeSignature, counterName);
        counter.increment(1L);
        return counter.getValue();
    }

    private Counter getCounter(String storeSignature, String counterName) {
        PigStatusReporter reporter = PigStatusReporter.getInstance();
        Counter counter = reporter.getCounter(STORER_ERROR_HANDLER_COUNTER_GROUP, this.getCounterNameForStore(counterName, storeSignature));
        return counter;
    }

    private String getCounterNameForStore(String counterNamePrefix, String storeSignature) {
        StringBuilder counterName = new StringBuilder().append(counterNamePrefix).append("_").append(storeSignature);
        return counterName.toString();
    }
}

