/*
 * Decompiled with CFR 0.152.
 */
package sqlline;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import jline.TerminalFactory;
import jline.console.completer.Completer;
import jline.console.completer.StringsCompleter;
import sqlline.Commands;
import sqlline.SqlLine;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class SqlLineOpts
implements Completer {
    public static final String PROPERTY_PREFIX = "sqlline.";
    public static final String PROPERTY_NAME_EXIT = "sqlline.system.exit";
    private SqlLine sqlLine;
    private boolean autoSave = false;
    private boolean silent = false;
    private boolean color = false;
    private boolean showHeader = true;
    private int headerInterval = 100;
    private boolean fastConnect = true;
    private boolean autoCommit = true;
    private boolean verbose = false;
    private boolean force = false;
    private boolean incremental = true;
    private boolean showElapsedTime = true;
    private boolean showWarnings = true;
    private boolean showNestedErrs = false;
    private String numberFormat = "default";
    private int maxWidth = TerminalFactory.get().getWidth();
    private int maxHeight = TerminalFactory.get().getHeight();
    private int maxColumnWidth = 15;
    int rowLimit = 0;
    int timeout = -1;
    private String isolation = "TRANSACTION_REPEATABLE_READ";
    private String outputFormat = "table";
    private boolean trimScripts = true;
    private File rcFile = new File(this.saveDir(), "sqlline.properties");
    private String historyFile = new File(this.saveDir(), "history").getAbsolutePath();
    private String runFile;

    public SqlLineOpts(SqlLine sqlLine, Properties props) {
        this.sqlLine = sqlLine;
        this.loadProperties(props);
    }

    public List<Completer> optionCompleters() {
        return Collections.singletonList(this);
    }

    public List<String> possibleSettingValues() {
        return Arrays.asList("yes", "no");
    }

    public File saveDir() {
        String dir = System.getProperty("sqlline.rcfile");
        if (dir != null && dir.length() > 0) {
            return new File(dir);
        }
        String baseDir = System.getProperty("x.sqlline.basedir");
        if (baseDir != null && baseDir.length() > 0) {
            File saveDir = new File(baseDir).getAbsoluteFile();
            saveDir.mkdirs();
            return saveDir;
        }
        File f = new File(System.getProperty("user.home"), (System.getProperty("os.name").toLowerCase().indexOf("windows") != -1 ? "" : ".") + "sqlline").getAbsoluteFile();
        try {
            f.mkdirs();
        }
        catch (Exception e) {
            // empty catch block
        }
        return f;
    }

    @Override
    public int complete(String buf, int pos, List<CharSequence> candidates) {
        try {
            return new StringsCompleter(this.propertyNames()).complete(buf, pos, candidates);
        }
        catch (Throwable t) {
            return -1;
        }
    }

    public void save() throws IOException {
        FileOutputStream out = new FileOutputStream(this.rcFile);
        this.save(out);
        ((OutputStream)out).close();
    }

    public void save(OutputStream out) throws IOException {
        try {
            Properties props = this.toProperties();
            props.remove("sqlline.maxwidth");
            props.store(out, this.sqlLine.getApplicationTitle());
        }
        catch (Exception e) {
            this.sqlLine.handleException(e);
        }
    }

    Set<String> propertyNames() throws IllegalAccessException, InvocationTargetException {
        TreeSet<String> set = new TreeSet<String>();
        for (String s : this.propertyNamesMixed()) {
            set.add(s.toLowerCase());
        }
        return set;
    }

    Set<String> propertyNamesMixed() throws IllegalAccessException, InvocationTargetException {
        TreeSet<String> names = new TreeSet<String>();
        for (Method method : this.getClass().getDeclaredMethods()) {
            String propName;
            if (!method.getName().startsWith("get") || method.getParameterTypes().length != 0 || (propName = SqlLineOpts.deCamel(method.getName().substring(3))).equals("run") || propName.equals("autosave")) continue;
            names.add(propName);
        }
        return names;
    }

    private static String deCamel(String s) {
        return s.substring(0, 1).toLowerCase() + s.substring(1);
    }

    public Properties toProperties() throws IllegalAccessException, InvocationTargetException, ClassNotFoundException {
        Properties props = new Properties();
        for (String name : this.propertyNames()) {
            props.setProperty(PROPERTY_PREFIX + name, this.sqlLine.getReflector().invoke((Object)this, "get" + name, new Object[0]).toString());
        }
        this.sqlLine.debug("properties: " + props.toString());
        return props;
    }

    public void load() throws IOException {
        if (this.rcFile.exists()) {
            FileInputStream in = new FileInputStream(this.rcFile);
            this.load(in);
            ((InputStream)in).close();
        }
    }

    public void load(InputStream fin) throws IOException {
        Properties p = new Properties();
        p.load(fin);
        this.loadProperties(p);
    }

    public void loadProperties(Properties props) {
        for (String key : Commands.asMap(props).keySet()) {
            if (key.equals(PROPERTY_NAME_EXIT) || !key.startsWith(PROPERTY_PREFIX)) continue;
            this.set(key.substring(PROPERTY_PREFIX.length()), props.getProperty(key));
        }
    }

    public void set(String key, String value) {
        this.set(key, value, false);
    }

    public boolean set(String key, String value, boolean quiet) {
        try {
            this.sqlLine.getReflector().invoke((Object)this, "set" + key, value);
            return true;
        }
        catch (Exception e) {
            if (!quiet) {
                System.err.println(this.sqlLine.loc("error-setting", key, e));
            }
            return false;
        }
    }

    public void setFastConnect(boolean fastConnect) {
        this.fastConnect = fastConnect;
    }

    public boolean getFastConnect() {
        return this.fastConnect;
    }

    public void setAutoCommit(boolean autoCommit) {
        this.autoCommit = autoCommit;
    }

    public boolean getAutoCommit() {
        return this.autoCommit;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public boolean getVerbose() {
        return this.verbose;
    }

    public void setShowElapsedTime(boolean showElapsedTime) {
        this.showElapsedTime = showElapsedTime;
    }

    public boolean getShowElapsedTime() {
        return this.showElapsedTime;
    }

    public void setShowWarnings(boolean showWarnings) {
        this.showWarnings = showWarnings;
    }

    public boolean getShowWarnings() {
        return this.showWarnings;
    }

    public void setShowNestedErrs(boolean showNestedErrs) {
        this.showNestedErrs = showNestedErrs;
    }

    public boolean getShowNestedErrs() {
        return this.showNestedErrs;
    }

    public void setNumberFormat(String numberFormat) {
        this.numberFormat = numberFormat;
    }

    public String getNumberFormat() {
        return this.numberFormat;
    }

    public void setMaxWidth(int maxWidth) {
        this.maxWidth = maxWidth;
    }

    public int getMaxWidth() {
        return this.maxWidth;
    }

    public void setMaxColumnWidth(int maxColumnWidth) {
        this.maxColumnWidth = maxColumnWidth;
    }

    public int getMaxColumnWidth() {
        return this.maxColumnWidth;
    }

    public void setRowLimit(int rowLimit) {
        this.rowLimit = rowLimit;
    }

    public int getRowLimit() {
        return this.rowLimit;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    public void setIsolation(String isolation) {
        this.isolation = isolation;
    }

    public String getIsolation() {
        return this.isolation;
    }

    public void setHistoryFile(String historyFile) {
        this.historyFile = historyFile;
    }

    public String getHistoryFile() {
        return this.historyFile;
    }

    public void setColor(boolean color) {
        this.color = color;
    }

    public boolean getColor() {
        return this.color;
    }

    public void setShowHeader(boolean showHeader) {
        this.showHeader = showHeader;
    }

    public boolean getShowHeader() {
        return this.showHeader;
    }

    public void setHeaderInterval(int headerInterval) {
        this.headerInterval = headerInterval;
    }

    public int getHeaderInterval() {
        return this.headerInterval;
    }

    public void setForce(boolean force) {
        this.force = force;
    }

    public boolean getForce() {
        return this.force;
    }

    public void setIncremental(boolean incremental) {
        this.incremental = incremental;
    }

    public boolean getIncremental() {
        return this.incremental;
    }

    public void setSilent(boolean silent) {
        this.silent = silent;
    }

    public boolean getSilent() {
        return this.silent;
    }

    @Deprecated
    public void setAutosave(boolean autoSave) {
        this.setAutoSave(autoSave);
    }

    @Deprecated
    public boolean getAutosave() {
        return this.getAutoSave();
    }

    public void setAutoSave(boolean autoSave) {
        this.autoSave = autoSave;
    }

    public boolean getAutoSave() {
        return this.autoSave;
    }

    public void setOutputFormat(String outputFormat) {
        this.outputFormat = outputFormat;
    }

    public String getOutputFormat() {
        return this.outputFormat;
    }

    public void setTrimScripts(boolean trimScripts) {
        this.trimScripts = trimScripts;
    }

    public boolean getTrimScripts() {
        return this.trimScripts;
    }

    public void setMaxHeight(int maxHeight) {
        this.maxHeight = maxHeight;
    }

    public int getMaxHeight() {
        return this.maxHeight;
    }

    public File getPropertiesFile() {
        return this.rcFile;
    }

    public void setRun(String runFile) {
        this.runFile = runFile;
    }

    public String getRun() {
        return this.runFile;
    }
}

