/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.remote;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.avatica.ColumnMetaData;
import org.apache.calcite.avatica.proto.Common;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.calcite.avatica.util.DateTimeUtils;

public class TypedValue {
    public static final TypedValue NULL = new TypedValue(ColumnMetaData.Rep.OBJECT, null);
    public final ColumnMetaData.Rep type;
    public final Object value;

    private TypedValue(ColumnMetaData.Rep rep, Object value) {
        this.type = rep;
        this.value = value;
        assert (this.isSerial(rep, value)) : "rep: " + (Object)((Object)rep) + ", value: " + value;
    }

    private boolean isSerial(ColumnMetaData.Rep rep, Object value) {
        if (value == null) {
            return true;
        }
        switch (rep) {
            case BYTE_STRING: {
                return value instanceof String;
            }
            case JAVA_SQL_DATE: 
            case JAVA_SQL_TIME: {
                return value instanceof Integer;
            }
            case JAVA_SQL_TIMESTAMP: 
            case JAVA_UTIL_DATE: {
                return value instanceof Long;
            }
        }
        return true;
    }

    @JsonCreator
    public static TypedValue create(@JsonProperty(value="type") String type, @JsonProperty(value="value") Object value) {
        if (value == null) {
            return NULL;
        }
        ColumnMetaData.Rep rep = ColumnMetaData.Rep.valueOf(type);
        return TypedValue.ofLocal(rep, TypedValue.serialToLocal(rep, value));
    }

    public static TypedValue ofLocal(ColumnMetaData.Rep rep, Object value) {
        return new TypedValue(rep, TypedValue.localToSerial(rep, value));
    }

    public static TypedValue ofSerial(ColumnMetaData.Rep rep, Object value) {
        return new TypedValue(rep, value);
    }

    public static TypedValue ofJdbc(ColumnMetaData.Rep rep, Object value, Calendar calendar) {
        if (value == null) {
            return NULL;
        }
        return new TypedValue(rep, TypedValue.jdbcToSerial(rep, value, calendar));
    }

    public static TypedValue ofJdbc(Object value, Calendar calendar) {
        if (value == null) {
            return NULL;
        }
        ColumnMetaData.Rep rep = ColumnMetaData.Rep.of(value.getClass());
        return new TypedValue(rep, TypedValue.jdbcToSerial(rep, value, calendar));
    }

    public Object toLocal() {
        if (this.value == null) {
            return null;
        }
        return TypedValue.serialToLocal(this.type, this.value);
    }

    private static Object serialToLocal(ColumnMetaData.Rep rep, Object value) {
        assert (value != null);
        if (value.getClass() == rep.clazz) {
            return value;
        }
        switch (rep) {
            case BYTE: {
                return ((Number)value).byteValue();
            }
            case SHORT: {
                return ((Number)value).shortValue();
            }
            case JAVA_SQL_DATE: 
            case JAVA_SQL_TIME: 
            case INTEGER: {
                return ((Number)value).intValue();
            }
            case JAVA_SQL_TIMESTAMP: 
            case JAVA_UTIL_DATE: 
            case LONG: {
                return ((Number)value).longValue();
            }
            case FLOAT: {
                return Float.valueOf(((Number)value).floatValue());
            }
            case DOUBLE: {
                return ((Number)value).doubleValue();
            }
            case NUMBER: {
                return value instanceof BigDecimal ? value : (value instanceof BigInteger ? new BigDecimal((BigInteger)value) : (value instanceof Double ? new BigDecimal((Double)value) : (value instanceof Float ? new BigDecimal(((Float)value).floatValue()) : new BigDecimal(((Number)value).longValue()))));
            }
            case BYTE_STRING: {
                return ByteString.ofBase64((String)value);
            }
        }
        throw new IllegalArgumentException("cannot convert " + value + " (" + value.getClass() + ") to " + (Object)((Object)rep));
    }

    private static Object protoSerialToLocal(Common.Rep rep, Object value) {
        switch (rep) {
            case BYTE: {
                return ((Number)value).byteValue();
            }
            case SHORT: {
                return ((Number)value).shortValue();
            }
            case INTEGER: 
            case JAVA_SQL_DATE: 
            case JAVA_SQL_TIME: {
                return ((Number)value).intValue();
            }
            case LONG: 
            case JAVA_UTIL_DATE: 
            case JAVA_SQL_TIMESTAMP: {
                return ((Number)value).longValue();
            }
            case FLOAT: {
                return Float.valueOf(((Number)value).floatValue());
            }
            case DOUBLE: {
                return ((Number)value).doubleValue();
            }
            case NUMBER: {
                return value instanceof BigDecimal ? value : (value instanceof BigInteger ? new BigDecimal((BigInteger)value) : (value instanceof Double ? new BigDecimal((Double)value) : (value instanceof Float ? new BigDecimal(((Float)value).floatValue()) : new BigDecimal(((Number)value).longValue()))));
            }
            case BYTE_STRING: {
                return (byte[])value;
            }
            case STRING: {
                return (String)value;
            }
        }
        throw new IllegalArgumentException("cannot convert " + value + " (" + value.getClass() + ") to " + rep);
    }

    public Object toJdbc(Calendar calendar) {
        if (this.value == null) {
            return null;
        }
        return TypedValue.serialToJdbc(this.type, this.value, calendar);
    }

    private static Object serialToJdbc(ColumnMetaData.Rep type, Object value, Calendar calendar) {
        switch (type) {
            case BYTE_STRING: {
                return ByteString.ofBase64((String)value).getBytes();
            }
            case JAVA_UTIL_DATE: {
                return new java.util.Date(TypedValue.adjust((Number)value, calendar));
            }
            case JAVA_SQL_DATE: {
                return new Date(TypedValue.adjust(((Number)value).longValue() * 86400000L, calendar));
            }
            case JAVA_SQL_TIME: {
                return new Time(TypedValue.adjust((Number)value, calendar));
            }
            case JAVA_SQL_TIMESTAMP: {
                return new Timestamp(TypedValue.adjust((Number)value, calendar));
            }
        }
        return TypedValue.serialToLocal(type, value);
    }

    private static Object protoSerialToJdbc(Common.Rep type, Object value, Calendar calendar) {
        switch (type) {
            case JAVA_UTIL_DATE: {
                return new java.util.Date(TypedValue.adjust((Number)value, calendar));
            }
            case JAVA_SQL_DATE: {
                return new Date(TypedValue.adjust(((Number)value).longValue() * 86400000L, calendar));
            }
            case JAVA_SQL_TIME: {
                return new Time(TypedValue.adjust((Number)value, calendar));
            }
            case JAVA_SQL_TIMESTAMP: {
                return new Timestamp(TypedValue.adjust((Number)value, calendar));
            }
        }
        return TypedValue.protoSerialToLocal(type, value);
    }

    private static long adjust(Number number, Calendar calendar) {
        long t = number.longValue();
        if (calendar != null) {
            t -= (long)calendar.getTimeZone().getOffset(t);
        }
        return t;
    }

    private static Object jdbcToSerial(ColumnMetaData.Rep rep, Object value, Calendar calendar) {
        switch (rep) {
            case BYTE_STRING: {
                return new ByteString((byte[])value).toBase64String();
            }
            case JAVA_SQL_DATE: 
            case JAVA_SQL_TIME: 
            case JAVA_SQL_TIMESTAMP: 
            case JAVA_UTIL_DATE: {
                long t = ((java.util.Date)value).getTime();
                if (calendar != null) {
                    t += (long)calendar.getTimeZone().getOffset(t);
                }
                switch (rep) {
                    case JAVA_SQL_DATE: {
                        return (int)DateTimeUtils.floorDiv(t, 86400000L);
                    }
                    case JAVA_SQL_TIME: {
                        return (int)DateTimeUtils.floorMod(t, 86400000L);
                    }
                }
                return t;
            }
        }
        return value;
    }

    private static Object localToSerial(ColumnMetaData.Rep rep, Object value) {
        switch (rep) {
            case BYTE_STRING: {
                return ((ByteString)value).toBase64String();
            }
        }
        return value;
    }

    public static List<Object> values(List<TypedValue> typedValues) {
        ArrayList<Object> list = new ArrayList<Object>();
        for (TypedValue typedValue : typedValues) {
            list.add(typedValue.toLocal());
        }
        return list;
    }

    public Common.TypedValue toProto() {
        Common.TypedValue.Builder builder = Common.TypedValue.newBuilder();
        Common.Rep protoRep = this.type.toProto();
        builder.setType(protoRep);
        switch (protoRep) {
            case BOOLEAN: 
            case PRIMITIVE_BOOLEAN: {
                builder.setBoolValue((Boolean)this.value);
                break;
            }
            case BYTE_STRING: 
            case STRING: {
                builder.setStringValue((String)this.value);
                break;
            }
            case PRIMITIVE_CHAR: 
            case CHARACTER: {
                builder.setStringValue(Character.toString(((Character)this.value).charValue()));
                break;
            }
            case BYTE: 
            case PRIMITIVE_BYTE: {
                builder.setNumberValue(Byte.valueOf((Byte)this.value).longValue());
                break;
            }
            case DOUBLE: 
            case PRIMITIVE_DOUBLE: {
                builder.setDoubleValue((Double)this.value);
                break;
            }
            case FLOAT: 
            case PRIMITIVE_FLOAT: {
                builder.setNumberValue(Float.floatToIntBits(((Float)this.value).floatValue()));
                break;
            }
            case INTEGER: 
            case PRIMITIVE_INT: {
                builder.setNumberValue(Integer.valueOf((Integer)this.value).longValue());
                break;
            }
            case SHORT: 
            case PRIMITIVE_SHORT: {
                builder.setNumberValue(Short.valueOf((Short)this.value).longValue());
                break;
            }
            case LONG: 
            case PRIMITIVE_LONG: {
                builder.setNumberValue((Long)this.value);
                break;
            }
            case JAVA_SQL_DATE: 
            case JAVA_SQL_TIME: {
                builder.setNumberValue(Integer.valueOf((Integer)this.value).longValue());
                break;
            }
            case JAVA_UTIL_DATE: 
            case JAVA_SQL_TIMESTAMP: {
                builder.setNumberValue((Long)this.value);
                break;
            }
            case BIG_INTEGER: {
                byte[] bytes = ((BigInteger)this.value).toByteArray();
                builder.setBytesValues(org.apache.calcite.avatica.com.google.protobuf.ByteString.copyFrom(bytes));
                break;
            }
            case BIG_DECIMAL: {
                BigDecimal bigDecimal = (BigDecimal)this.value;
                int scale = bigDecimal.scale();
                BigInteger bigInt = bigDecimal.toBigInteger();
                builder.setBytesValues(org.apache.calcite.avatica.com.google.protobuf.ByteString.copyFrom(bigInt.toByteArray())).setNumberValue(scale);
                break;
            }
            case NUMBER: {
                builder.setNumberValue(((Number)this.value).longValue());
                break;
            }
            case OBJECT: {
                if (null == this.value) {
                    builder.setNull(true);
                    break;
                }
            }
            case UNRECOGNIZED: {
                throw new RuntimeException("Unhandled value: " + protoRep + " " + this.value.getClass());
            }
            default: {
                throw new RuntimeException("Unknown serialized type: " + protoRep);
            }
        }
        return builder.build();
    }

    public static TypedValue fromProto(Common.TypedValue proto) {
        ColumnMetaData.Rep rep = ColumnMetaData.Rep.fromProto(proto.getType());
        Object value = TypedValue.getValue(proto);
        return new TypedValue(rep, value);
    }

    public static Object getValue(Common.TypedValue protoValue) {
        switch (protoValue.getType()) {
            case BOOLEAN: 
            case PRIMITIVE_BOOLEAN: {
                return protoValue.getBoolValue();
            }
            case BYTE_STRING: 
            case STRING: {
                return protoValue.getStringValue();
            }
            case PRIMITIVE_CHAR: 
            case CHARACTER: {
                return Character.valueOf(protoValue.getStringValue().charAt(0));
            }
            case BYTE: 
            case PRIMITIVE_BYTE: {
                return Long.valueOf(protoValue.getNumberValue()).byteValue();
            }
            case DOUBLE: 
            case PRIMITIVE_DOUBLE: {
                return protoValue.getDoubleValue();
            }
            case FLOAT: 
            case PRIMITIVE_FLOAT: {
                return Float.valueOf(Float.intBitsToFloat((int)protoValue.getNumberValue()));
            }
            case INTEGER: 
            case PRIMITIVE_INT: {
                return Long.valueOf(protoValue.getNumberValue()).intValue();
            }
            case SHORT: 
            case PRIMITIVE_SHORT: {
                return Long.valueOf(protoValue.getNumberValue()).shortValue();
            }
            case LONG: 
            case PRIMITIVE_LONG: {
                return protoValue.getNumberValue();
            }
            case JAVA_SQL_DATE: 
            case JAVA_SQL_TIME: {
                return Long.valueOf(protoValue.getNumberValue()).intValue();
            }
            case JAVA_UTIL_DATE: 
            case JAVA_SQL_TIMESTAMP: {
                return protoValue.getNumberValue();
            }
            case BIG_INTEGER: {
                return new BigInteger(protoValue.getBytesValues().toByteArray());
            }
            case BIG_DECIMAL: {
                BigInteger bigInt = new BigInteger(protoValue.getBytesValues().toByteArray());
                return new BigDecimal(bigInt, (int)protoValue.getNumberValue());
            }
            case NUMBER: {
                return protoValue.getNumberValue();
            }
            case OBJECT: {
                if (protoValue.getNull()) {
                    return null;
                }
            }
            case UNRECOGNIZED: {
                throw new RuntimeException("Unhandled type: " + protoValue.getType());
            }
        }
        throw new RuntimeException("Unknown type: " + protoValue.getType());
    }

    public static Object protoToJdbc(Common.TypedValue protoValue, Calendar calendar) {
        Object o = TypedValue.getValue(Objects.requireNonNull(protoValue));
        if (null == o) {
            return o;
        }
        return TypedValue.protoSerialToJdbc(protoValue.getType(), o, Objects.requireNonNull(calendar));
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        result = 31 * result + (this.value == null ? 0 : this.value.hashCode());
        return result;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TypedValue) {
            TypedValue other = (TypedValue)o;
            if (this.type != other.type) {
                return false;
            }
            if (null == this.value && null != other.value) {
                return false;
            }
            return this.value.equals(other.value);
        }
        return false;
    }
}

