/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.avatica.remote;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import org.apache.calcite.avatica.AvaticaClientRuntimeException;
import org.apache.calcite.avatica.AvaticaConnection;
import org.apache.calcite.avatica.AvaticaSeverity;
import org.apache.calcite.avatica.BuiltInConnectionProperty;
import org.apache.calcite.avatica.ConnectionPropertiesImpl;
import org.apache.calcite.avatica.Meta;
import org.apache.calcite.avatica.QueryState;
import org.apache.calcite.avatica.com.google.protobuf.Descriptors;
import org.apache.calcite.avatica.com.google.protobuf.Message;
import org.apache.calcite.avatica.com.google.protobuf.ProtocolStringList;
import org.apache.calcite.avatica.proto.Common;
import org.apache.calcite.avatica.proto.Requests;
import org.apache.calcite.avatica.proto.Responses;
import org.apache.calcite.avatica.remote.ProtobufService;
import org.apache.calcite.avatica.remote.TypedValue;

public interface Service {
    public ResultSetResponse apply(CatalogsRequest var1);

    public ResultSetResponse apply(SchemasRequest var1);

    public ResultSetResponse apply(TablesRequest var1);

    public ResultSetResponse apply(TableTypesRequest var1);

    public ResultSetResponse apply(TypeInfoRequest var1);

    public ResultSetResponse apply(ColumnsRequest var1);

    public PrepareResponse apply(PrepareRequest var1);

    public ExecuteResponse apply(ExecuteRequest var1);

    public ExecuteResponse apply(PrepareAndExecuteRequest var1);

    public SyncResultsResponse apply(SyncResultsRequest var1);

    public FetchResponse apply(FetchRequest var1);

    public CreateStatementResponse apply(CreateStatementRequest var1);

    public CloseStatementResponse apply(CloseStatementRequest var1);

    public OpenConnectionResponse apply(OpenConnectionRequest var1);

    public CloseConnectionResponse apply(CloseConnectionRequest var1);

    public ConnectionSyncResponse apply(ConnectionSyncRequest var1);

    public DatabasePropertyResponse apply(DatabasePropertyRequest var1);

    public CommitResponse apply(CommitRequest var1);

    public RollbackResponse apply(RollbackRequest var1);

    public ExecuteBatchResponse apply(PrepareAndExecuteBatchRequest var1);

    public ExecuteBatchResponse apply(ExecuteBatchRequest var1);

    public void setRpcMetadata(RpcMetadataResponse var1);

    public static class ExecuteBatchResponse
    extends Response {
        private static final Descriptors.FieldDescriptor RPC_METADATA_DESCRIPTOR = Responses.ExecuteBatchResponse.getDescriptor().findFieldByNumber(5);
        public final String connectionId;
        public final int statementId;
        public final int[] updateCounts;
        public final boolean missingStatement;
        public final RpcMetadataResponse rpcMetadata;

        ExecuteBatchResponse() {
            this.connectionId = null;
            this.statementId = 0;
            this.updateCounts = null;
            this.missingStatement = false;
            this.rpcMetadata = null;
        }

        @JsonCreator
        public ExecuteBatchResponse(@JsonProperty(value="connectionId") String connectionId, @JsonProperty(value="statementId") int statementId, @JsonProperty(value="updateCounts") int[] updateCounts, @JsonProperty(value="missingStatement") boolean missingStatement, @JsonProperty(value="rpcMetadata") RpcMetadataResponse rpcMetadata) {
            this.connectionId = connectionId;
            this.statementId = statementId;
            this.updateCounts = updateCounts;
            this.missingStatement = missingStatement;
            this.rpcMetadata = rpcMetadata;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.connectionId == null ? 0 : this.connectionId.hashCode());
            result = 31 * result + this.statementId;
            result = 31 * result + (this.updateCounts == null ? 0 : this.updateCounts.hashCode());
            result = 31 * result + (this.missingStatement ? 1231 : 1237);
            return result;
        }

        public boolean equals(Object o) {
            return this == o || o instanceof ExecuteBatchResponse && Arrays.equals(this.updateCounts, ((ExecuteBatchResponse)o).updateCounts) && Objects.equals(this.connectionId, ((ExecuteBatchResponse)o).connectionId) && this.statementId == ((ExecuteBatchResponse)o).statementId && this.missingStatement == ((ExecuteBatchResponse)o).missingStatement;
        }

        @Override
        ExecuteBatchResponse deserialize(Message genericMsg) {
            Responses.ExecuteBatchResponse msg = ProtobufService.castProtobufMessage(genericMsg, Responses.ExecuteBatchResponse.class);
            int[] updateCounts = new int[msg.getUpdateCountsCount()];
            int i = 0;
            for (Integer updateCount : msg.getUpdateCountsList()) {
                updateCounts[i++] = updateCount;
            }
            RpcMetadataResponse metadata = null;
            if (msg.hasField(RPC_METADATA_DESCRIPTOR)) {
                metadata = RpcMetadataResponse.fromProto(msg.getMetadata());
            }
            return new ExecuteBatchResponse(msg.getConnectionId(), msg.getStatementId(), updateCounts, msg.getMissingStatement(), metadata);
        }

        @Override
        Responses.ExecuteBatchResponse serialize() {
            Responses.ExecuteBatchResponse.Builder builder = Responses.ExecuteBatchResponse.newBuilder();
            if (null != this.updateCounts) {
                for (int i = 0; i < this.updateCounts.length; ++i) {
                    builder.addUpdateCounts(this.updateCounts[i]);
                }
            }
            if (null != this.rpcMetadata) {
                builder.setMetadata(this.rpcMetadata.serialize());
            }
            return builder.setConnectionId(this.connectionId).setStatementId(this.statementId).build();
        }
    }

    public static class ExecuteBatchRequest
    extends Request {
        public final String connectionId;
        public final int statementId;
        public final List<List<TypedValue>> parameterValues;
        @JsonIgnore
        private List<Requests.UpdateBatch> protoParameterValues = null;

        ExecuteBatchRequest() {
            this.connectionId = null;
            this.statementId = 0;
            this.parameterValues = null;
        }

        @JsonCreator
        public ExecuteBatchRequest(@JsonProperty(value="connectionId") String connectionId, @JsonProperty(value="statementId") int statementId, @JsonProperty(value="parameterValues") List<List<TypedValue>> parameterValues) {
            this.connectionId = connectionId;
            this.statementId = statementId;
            this.parameterValues = parameterValues;
        }

        ExecuteBatchRequest(String connectionId, int statementId) {
            this.connectionId = connectionId;
            this.statementId = statementId;
            this.parameterValues = null;
        }

        public boolean hasProtoUpdateBatches() {
            return null != this.protoParameterValues;
        }

        @JsonIgnore
        public List<Requests.UpdateBatch> getProtoUpdateBatches() {
            return this.protoParameterValues;
        }

        @Override
        public ExecuteBatchResponse accept(Service service) {
            return service.apply(this);
        }

        @Override
        ExecuteBatchRequest deserialize(Message genericMsg) {
            Requests.ExecuteBatchRequest msg = ProtobufService.castProtobufMessage(genericMsg, Requests.ExecuteBatchRequest.class);
            List<Requests.UpdateBatch> updateBatches = msg.getUpdatesList();
            ExecuteBatchRequest pojo = new ExecuteBatchRequest(msg.getConnectionId(), msg.getStatementId());
            pojo.protoParameterValues = updateBatches;
            return pojo;
        }

        @Override
        Requests.ExecuteBatchRequest serialize() {
            Requests.ExecuteBatchRequest.Builder builder = Requests.ExecuteBatchRequest.newBuilder();
            if (this.hasProtoUpdateBatches()) {
                builder.addAllUpdates(this.protoParameterValues);
            } else if (null != this.parameterValues) {
                for (List<TypedValue> updateBatch : this.parameterValues) {
                    Requests.UpdateBatch.Builder batchBuilder = Requests.UpdateBatch.newBuilder();
                    for (TypedValue update : updateBatch) {
                        batchBuilder.addParameterValues(update.toProto());
                    }
                    builder.addUpdates(batchBuilder.build());
                }
            }
            if (null != this.connectionId) {
                builder.setConnectionId(this.connectionId);
            }
            return builder.setStatementId(this.statementId).build();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.connectionId == null ? 0 : this.connectionId.hashCode());
            result = 31 * result + this.statementId;
            result = 31 * result + (this.parameterValues == null ? 0 : this.parameterValues.hashCode());
            return result;
        }

        public boolean equals(Object o) {
            return this == o || o instanceof ExecuteBatchRequest && Objects.equals(this.connectionId, ((ExecuteBatchRequest)o).connectionId) && this.statementId == ((ExecuteBatchRequest)o).statementId && Objects.equals(this.protoParameterValues, ((ExecuteBatchRequest)o).protoParameterValues) && Objects.equals(this.parameterValues, ((ExecuteBatchRequest)o).parameterValues);
        }
    }

    public static class PrepareAndExecuteBatchRequest
    extends Request {
        public final String connectionId;
        public final List<String> sqlCommands;
        public final int statementId;

        PrepareAndExecuteBatchRequest() {
            this.connectionId = null;
            this.statementId = 0;
            this.sqlCommands = null;
        }

        @JsonCreator
        public PrepareAndExecuteBatchRequest(@JsonProperty(value="connectionId") String connectionId, @JsonProperty(value="statementId") int statementId, @JsonProperty(value="sqlCommands") List<String> sqlCommands) {
            this.connectionId = connectionId;
            this.sqlCommands = sqlCommands;
            this.statementId = statementId;
        }

        @Override
        public ExecuteBatchResponse accept(Service service) {
            return service.apply(this);
        }

        @Override
        public Requests.PrepareAndExecuteBatchRequest serialize() {
            Requests.PrepareAndExecuteBatchRequest.Builder builder = Requests.PrepareAndExecuteBatchRequest.newBuilder();
            if (null != this.connectionId) {
                builder.setConnectionId(this.connectionId);
            }
            if (null != this.sqlCommands) {
                builder.addAllSqlCommands(this.sqlCommands);
            }
            return builder.setStatementId(this.statementId).build();
        }

        @Override
        public PrepareAndExecuteBatchRequest deserialize(Message genericMsg) {
            Requests.PrepareAndExecuteBatchRequest msg = ProtobufService.castProtobufMessage(genericMsg, Requests.PrepareAndExecuteBatchRequest.class);
            ArrayList<String> sqlCommands = new ArrayList<String>(msg.getSqlCommandsList());
            return new PrepareAndExecuteBatchRequest(msg.getConnectionId(), msg.getStatementId(), sqlCommands);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.connectionId == null ? 0 : this.connectionId.hashCode());
            result = 31 * result + this.statementId;
            result = 31 * result + (this.sqlCommands == null ? 0 : this.sqlCommands.hashCode());
            return result;
        }

        public boolean equals(Object o) {
            return this == o || o instanceof PrepareAndExecuteBatchRequest && Objects.equals(this.connectionId, ((PrepareAndExecuteBatchRequest)o).connectionId) && this.statementId == ((PrepareAndExecuteBatchRequest)o).statementId && Objects.equals(this.sqlCommands, ((PrepareAndExecuteBatchRequest)o).sqlCommands);
        }
    }

    public static class RollbackResponse
    extends Response {
        RollbackResponse() {
        }

        @Override
        RollbackResponse deserialize(Message genericMsg) {
            ProtobufService.castProtobufMessage(genericMsg, Responses.RollbackResponse.class);
            return new RollbackResponse();
        }

        @Override
        Responses.RollbackResponse serialize() {
            return Responses.RollbackResponse.newBuilder().build();
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object obj) {
            return this == obj || obj instanceof RollbackResponse;
        }
    }

    public static class RollbackRequest
    extends Request {
        public final String connectionId;

        RollbackRequest() {
            this.connectionId = null;
        }

        public RollbackRequest(@JsonProperty(value="connectionId") String connectionId) {
            this.connectionId = connectionId;
        }

        @Override
        RollbackResponse accept(Service service) {
            return service.apply(this);
        }

        @Override
        RollbackRequest deserialize(Message genericMsg) {
            Requests.RollbackRequest msg = ProtobufService.castProtobufMessage(genericMsg, Requests.RollbackRequest.class);
            Descriptors.Descriptor desc = msg.getDescriptorForType();
            String connectionId = null;
            if (ProtobufService.hasField(msg, desc, 1)) {
                connectionId = msg.getConnectionId();
            }
            return new RollbackRequest(connectionId);
        }

        @Override
        Requests.RollbackRequest serialize() {
            Requests.RollbackRequest.Builder builder = Requests.RollbackRequest.newBuilder();
            if (null != this.connectionId) {
                builder.setConnectionId(this.connectionId);
            }
            return builder.build();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.connectionId == null ? 0 : this.connectionId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            return this == obj || obj instanceof RollbackRequest && Objects.equals(this.connectionId, ((RollbackRequest)obj).connectionId);
        }
    }

    public static class CommitResponse
    extends Response {
        CommitResponse() {
        }

        @Override
        CommitResponse deserialize(Message genericMsg) {
            ProtobufService.castProtobufMessage(genericMsg, Responses.CommitResponse.class);
            return new CommitResponse();
        }

        @Override
        Responses.CommitResponse serialize() {
            return Responses.CommitResponse.newBuilder().build();
        }

        public int hashCode() {
            return 0;
        }

        public boolean equals(Object obj) {
            return this == obj || obj instanceof CommitResponse;
        }
    }

    public static class CommitRequest
    extends Request {
        public final String connectionId;

        CommitRequest() {
            this.connectionId = null;
        }

        public CommitRequest(@JsonProperty(value="connectionId") String connectionId) {
            this.connectionId = connectionId;
        }

        @Override
        CommitResponse accept(Service service) {
            return service.apply(this);
        }

        @Override
        CommitRequest deserialize(Message genericMsg) {
            Requests.CommitRequest msg = ProtobufService.castProtobufMessage(genericMsg, Requests.CommitRequest.class);
            Descriptors.Descriptor desc = msg.getDescriptorForType();
            String connectionId = null;
            if (ProtobufService.hasField(msg, desc, 1)) {
                connectionId = msg.getConnectionId();
            }
            return new CommitRequest(connectionId);
        }

        @Override
        Requests.CommitRequest serialize() {
            Requests.CommitRequest.Builder builder = Requests.CommitRequest.newBuilder();
            if (null != this.connectionId) {
                builder.setConnectionId(this.connectionId);
            }
            return builder.build();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.connectionId == null ? 0 : this.connectionId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            return this == obj || obj instanceof CommitRequest && Objects.equals(this.connectionId, ((CommitRequest)obj).connectionId);
        }
    }

    public static class RpcMetadataResponse
    extends Response {
        public final String serverAddress;

        public RpcMetadataResponse() {
            this.serverAddress = null;
        }

        public RpcMetadataResponse(@JsonProperty(value="serverAddress") String serverAddress) {
            this.serverAddress = serverAddress;
        }

        @Override
        RpcMetadataResponse deserialize(Message genericMsg) {
            Responses.RpcMetadata msg = ProtobufService.castProtobufMessage(genericMsg, Responses.RpcMetadata.class);
            return RpcMetadataResponse.fromProto(msg);
        }

        @Override
        Responses.RpcMetadata serialize() {
            return Responses.RpcMetadata.newBuilder().setServerAddress(this.serverAddress).build();
        }

        static RpcMetadataResponse fromProto(Responses.RpcMetadata msg) {
            Descriptors.Descriptor desc = msg.getDescriptorForType();
            String serverAddress = null;
            if (ProtobufService.hasField(msg, desc, 1)) {
                serverAddress = msg.getServerAddress();
            }
            return new RpcMetadataResponse(serverAddress);
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.serverAddress == null ? 0 : this.serverAddress.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            return this == obj || obj instanceof RpcMetadataResponse && Objects.equals(this.serverAddress, ((RpcMetadataResponse)obj).serverAddress);
        }
    }

    public static class SyncResultsResponse
    extends Response {
        public boolean missingStatement = false;
        public final boolean moreResults;
        public final RpcMetadataResponse rpcMetadata;

        SyncResultsResponse() {
            this.moreResults = false;
            this.rpcMetadata = null;
        }

        public SyncResultsResponse(@JsonProperty(value="moreResults") boolean moreResults, @JsonProperty(value="missingStatement") boolean missingStatement, @JsonProperty(value="rpcMetadata") RpcMetadataResponse rpcMetadata) {
            this.moreResults = moreResults;
            this.missingStatement = missingStatement;
            this.rpcMetadata = rpcMetadata;
        }

        @Override
        SyncResultsResponse deserialize(Message genericMsg) {
            Responses.SyncResultsResponse msg = ProtobufService.castProtobufMessage(genericMsg, Responses.SyncResultsResponse.class);
            Descriptors.Descriptor desc = msg.getDescriptorForType();
            RpcMetadataResponse metadata = null;
            if (ProtobufService.hasField(msg, desc, 3)) {
                metadata = RpcMetadataResponse.fromProto(msg.getMetadata());
            }
            return new SyncResultsResponse(msg.getMoreResults(), msg.getMissingStatement(), metadata);
        }

        @Override
        Responses.SyncResultsResponse serialize() {
            Responses.SyncResultsResponse.Builder builder = Responses.SyncResultsResponse.newBuilder();
            if (null != this.rpcMetadata) {
                builder.setMetadata(this.rpcMetadata.serialize());
            }
            return builder.setMoreResults(this.moreResults).setMissingStatement(this.missingStatement).build();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.missingStatement ? 1231 : 1237);
            result = 31 * result + (this.moreResults ? 1231 : 1237);
            result = 31 * result + (this.rpcMetadata == null ? 0 : this.rpcMetadata.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || !(obj instanceof SyncResultsResponse)) {
                return false;
            }
            SyncResultsResponse other = (SyncResultsResponse)obj;
            if (null == this.rpcMetadata ? null != other.rpcMetadata : !this.rpcMetadata.equals(other.rpcMetadata)) {
                return false;
            }
            return this.missingStatement == other.missingStatement && this.moreResults == other.moreResults;
        }
    }

    public static class SyncResultsRequest
    extends Request {
        public final String connectionId;
        public final int statementId;
        public final QueryState state;
        public final long offset;

        SyncResultsRequest() {
            this.connectionId = null;
            this.statementId = 0;
            this.state = null;
            this.offset = 0L;
        }

        public SyncResultsRequest(@JsonProperty(value="connectionId") String connectionId, @JsonProperty(value="statementId") int statementId, @JsonProperty(value="state") QueryState state, @JsonProperty(value="offset") long offset) {
            this.connectionId = connectionId;
            this.statementId = statementId;
            this.state = state;
            this.offset = offset;
        }

        @Override
        SyncResultsResponse accept(Service service) {
            return service.apply(this);
        }

        @Override
        Request deserialize(Message genericMsg) {
            Requests.SyncResultsRequest msg = ProtobufService.castProtobufMessage(genericMsg, Requests.SyncResultsRequest.class);
            Descriptors.Descriptor desc = msg.getDescriptorForType();
            String connectionId = null;
            if (ProtobufService.hasField(msg, desc, 1)) {
                connectionId = msg.getConnectionId();
            }
            int statementId = 0;
            if (ProtobufService.hasField(msg, desc, 2)) {
                statementId = msg.getStatementId();
            }
            Common.QueryState state = null;
            if (ProtobufService.hasField(msg, desc, 3)) {
                state = msg.getState();
            }
            long offset = 0L;
            if (ProtobufService.hasField(msg, desc, 4)) {
                offset = msg.getOffset();
            }
            return new SyncResultsRequest(connectionId, statementId, null == state ? null : QueryState.fromProto(msg.getState()), offset);
        }

        @Override
        Requests.SyncResultsRequest serialize() {
            Requests.SyncResultsRequest.Builder builder = Requests.SyncResultsRequest.newBuilder();
            if (null != this.connectionId) {
                builder.setConnectionId(this.connectionId);
            }
            if (null != this.state) {
                builder.setState(this.state.toProto());
            }
            builder.setStatementId(this.statementId);
            builder.setOffset(this.offset);
            return builder.build();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.connectionId == null ? 0 : this.connectionId.hashCode());
            result = 31 * result + (int)(this.offset ^ this.offset >>> 32);
            result = 31 * result + (this.state == null ? 0 : this.state.hashCode());
            result = 31 * result + this.statementId;
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (null == obj || !(obj instanceof SyncResultsRequest)) {
                return false;
            }
            SyncResultsRequest other = (SyncResultsRequest)obj;
            if (this.connectionId == null ? other.connectionId != null : !this.connectionId.equals(other.connectionId)) {
                return false;
            }
            if (this.offset != other.offset) {
                return false;
            }
            if (this.state == null ? other.state != null : !this.state.equals(other.state)) {
                return false;
            }
            return this.statementId == other.statementId;
        }
    }

    public static class ErrorResponse
    extends Response {
        public static final int UNKNOWN_ERROR_CODE = -1;
        public static final int MISSING_CONNECTION_ERROR_CODE = 1;
        public static final String UNKNOWN_SQL_STATE = "00000";
        public final List<String> exceptions;
        public final String errorMessage;
        public final int errorCode;
        public final String sqlState;
        public final AvaticaSeverity severity;
        public final RpcMetadataResponse rpcMetadata;

        ErrorResponse() {
            this.exceptions = Collections.singletonList("Unhandled exception");
            this.errorMessage = "Unknown message";
            this.errorCode = -1;
            this.sqlState = UNKNOWN_SQL_STATE;
            this.severity = AvaticaSeverity.UNKNOWN;
            this.rpcMetadata = null;
        }

        @JsonCreator
        public ErrorResponse(@JsonProperty(value="exceptions") List<String> exceptions, @JsonProperty(value="errorMessage") String errorMessage, @JsonProperty(value="errorCode") int errorCode, @JsonProperty(value="sqlState") String sqlState, @JsonProperty(value="severity") AvaticaSeverity severity, @JsonProperty(value="rpcMetadata") RpcMetadataResponse rpcMetadata) {
            this.exceptions = exceptions;
            this.errorMessage = errorMessage;
            this.errorCode = errorCode;
            this.sqlState = sqlState;
            this.severity = severity;
            this.rpcMetadata = rpcMetadata;
        }

        protected ErrorResponse(Exception e, String errorMessage, int code, String sqlState, AvaticaSeverity severity, RpcMetadataResponse rpcMetadata) {
            this(errorMessage, code, sqlState, severity, ErrorResponse.toStackTraces(e), rpcMetadata);
        }

        protected ErrorResponse(String errorMessage, int code, String sqlState, AvaticaSeverity severity, List<String> exceptions, RpcMetadataResponse rpcMetadata) {
            this.exceptions = exceptions;
            this.errorMessage = errorMessage;
            this.errorCode = code;
            this.sqlState = sqlState;
            this.severity = severity;
            this.rpcMetadata = rpcMetadata;
        }

        static List<String> toStackTraces(Exception e) {
            ArrayList<String> stackTraces = new ArrayList<String>();
            stackTraces.add(ErrorResponse.toString(e));
            if (e instanceof SQLException) {
                for (SQLException next = ((SQLException)e).getNextException(); null != next; next = next.getNextException()) {
                    stackTraces.add(ErrorResponse.toString(next));
                }
            }
            return stackTraces;
        }

        static String toString(Exception e) {
            StringWriter sw = new StringWriter();
            Objects.requireNonNull(e).printStackTrace(new PrintWriter(sw));
            return sw.toString();
        }

        @Override
        ErrorResponse deserialize(Message genericMsg) {
            Responses.ErrorResponse msg = ProtobufService.castProtobufMessage(genericMsg, Responses.ErrorResponse.class);
            Descriptors.Descriptor desc = msg.getDescriptorForType();
            ProtocolStringList exceptions = null;
            if (msg.getHasExceptions()) {
                exceptions = msg.getExceptionsList();
            }
            String errorMessage = null;
            if (ProtobufService.hasField(msg, desc, 2)) {
                errorMessage = msg.getErrorMessage();
            }
            String sqlState = null;
            if (ProtobufService.hasField(msg, desc, 5)) {
                sqlState = msg.getSqlState();
            }
            AvaticaSeverity severity = null;
            if (ProtobufService.hasField(msg, desc, 3)) {
                severity = AvaticaSeverity.fromProto(msg.getSeverity());
            }
            RpcMetadataResponse metadata = null;
            if (ProtobufService.hasField(msg, desc, 6)) {
                metadata = RpcMetadataResponse.fromProto(msg.getMetadata());
            }
            return new ErrorResponse(exceptions, errorMessage, msg.getErrorCode(), sqlState, severity, metadata);
        }

        @Override
        Responses.ErrorResponse serialize() {
            Responses.ErrorResponse.Builder builder = Responses.ErrorResponse.newBuilder();
            if (null != this.rpcMetadata) {
                builder.setMetadata(this.rpcMetadata.serialize());
            }
            if (null != this.exceptions) {
                builder.setHasExceptions(true);
                builder.addAllExceptions(this.exceptions);
            } else {
                builder.setHasExceptions(false);
            }
            if (null != this.errorMessage) {
                builder.setErrorMessage(this.errorMessage);
            }
            if (null != this.sqlState) {
                builder.setSqlState(this.sqlState);
            }
            if (null != this.severity) {
                builder.setSeverity(this.severity.toProto());
            }
            return builder.setErrorCode(this.errorCode).build();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder(32);
            sb.append("ErrorResponse[errorCode=").append(this.errorCode).append(", sqlState=").append(this.sqlState).append(", severity=").append((Object)this.severity).append(", errorMessage=").append(this.errorMessage).append(", exceptions=").append(this.exceptions);
            return sb.toString();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.exceptions == null ? 0 : this.exceptions.hashCode());
            result = 31 * result + (this.errorMessage == null ? 0 : this.errorMessage.hashCode());
            result = 31 * result + this.errorCode;
            result = 31 * result + (this.sqlState == null ? 0 : this.sqlState.hashCode());
            result = 31 * result + (this.severity == null ? 0 : this.severity.hashCode());
            result = 31 * result + (this.rpcMetadata == null ? 0 : this.rpcMetadata.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (!(obj instanceof ErrorResponse)) {
                return false;
            }
            ErrorResponse other = (ErrorResponse)obj;
            if (this.exceptions == null ? other.exceptions != null : !this.exceptions.equals(other.exceptions)) {
                return false;
            }
            if (this.errorMessage == null ? other.errorMessage != null : !this.errorMessage.equals(other.errorMessage)) {
                return false;
            }
            if (this.errorCode != other.errorCode) {
                return false;
            }
            if (this.sqlState == null ? other.sqlState != null : !this.sqlState.equals(other.sqlState)) {
                return false;
            }
            if (this.severity != other.severity) {
                return false;
            }
            return !(null == this.rpcMetadata ? null != other.rpcMetadata : !this.rpcMetadata.equals(other.rpcMetadata));
        }

        public AvaticaClientRuntimeException toException() {
            return new AvaticaClientRuntimeException("Remote driver error: " + this.errorMessage, this.errorCode, this.sqlState, this.severity, this.exceptions, this.rpcMetadata);
        }
    }

    public static class DatabasePropertyResponse
    extends Response {
        public final Map<Meta.DatabaseProperty, Object> map;
        public final RpcMetadataResponse rpcMetadata;

        DatabasePropertyResponse() {
            this.map = null;
            this.rpcMetadata = null;
        }

        @JsonCreator
        public DatabasePropertyResponse(@JsonProperty(value="map") Map<Meta.DatabaseProperty, Object> map, @JsonProperty(value="rpcMetadata") RpcMetadataResponse rpcMetadata) {
            this.map = map;
            this.rpcMetadata = rpcMetadata;
        }

        @Override
        DatabasePropertyResponse deserialize(Message genericMsg) {
            Responses.DatabasePropertyResponse msg = ProtobufService.castProtobufMessage(genericMsg, Responses.DatabasePropertyResponse.class);
            Descriptors.Descriptor desc = msg.getDescriptorForType();
            HashMap<Meta.DatabaseProperty, Object> properties = new HashMap<Meta.DatabaseProperty, Object>();
            for (Responses.DatabasePropertyElement property : msg.getPropsList()) {
                Object obj;
                Meta.DatabaseProperty dbProp = Meta.DatabaseProperty.fromProto(property.getKey());
                Common.TypedValue value = property.getValue();
                switch (dbProp) {
                    case GET_NUMERIC_FUNCTIONS: 
                    case GET_STRING_FUNCTIONS: 
                    case GET_SYSTEM_FUNCTIONS: 
                    case GET_TIME_DATE_FUNCTIONS: 
                    case GET_S_Q_L_KEYWORDS: {
                        if (Common.Rep.STRING != value.getType()) {
                            throw new IllegalArgumentException("Expected STRING, but got " + value.getType());
                        }
                        obj = value.getStringValue();
                        break;
                    }
                    case GET_DEFAULT_TRANSACTION_ISOLATION: {
                        if (Common.Rep.INTEGER != value.getType()) {
                            throw new IllegalArgumentException("Expected INTEGER, but got " + value.getType());
                        }
                        obj = (int)value.getNumberValue();
                        break;
                    }
                    default: {
                        throw new RuntimeException("Unhandled DatabaseProperty");
                    }
                }
                properties.put(dbProp, obj);
            }
            RpcMetadataResponse metadata = null;
            if (ProtobufService.hasField(msg, desc, 2)) {
                metadata = RpcMetadataResponse.fromProto(msg.getMetadata());
            }
            return new DatabasePropertyResponse(properties, metadata);
        }

        @Override
        Responses.DatabasePropertyResponse serialize() {
            Responses.DatabasePropertyResponse.Builder builder = Responses.DatabasePropertyResponse.newBuilder();
            if (null != this.map) {
                for (Map.Entry<Meta.DatabaseProperty, Object> entry : this.map.entrySet()) {
                    Object obj = entry.getValue();
                    Common.TypedValue.Builder valueBuilder = Common.TypedValue.newBuilder();
                    switch (entry.getKey()) {
                        case GET_NUMERIC_FUNCTIONS: 
                        case GET_STRING_FUNCTIONS: 
                        case GET_SYSTEM_FUNCTIONS: 
                        case GET_TIME_DATE_FUNCTIONS: 
                        case GET_S_Q_L_KEYWORDS: {
                            if (!(obj instanceof String)) {
                                throw new RuntimeException("Expected a String, but got " + obj.getClass());
                            }
                            valueBuilder.setType(Common.Rep.STRING).setStringValue((String)obj);
                            break;
                        }
                        case GET_DEFAULT_TRANSACTION_ISOLATION: {
                            if (!(obj instanceof Integer)) {
                                throw new RuntimeException("Expected an Integer, but got " + obj.getClass());
                            }
                            valueBuilder.setType(Common.Rep.INTEGER).setNumberValue(((Integer)obj).longValue());
                            break;
                        }
                        default: {
                            throw new RuntimeException("Unhandled DatabaseProperty");
                        }
                    }
                    builder.addProps(Responses.DatabasePropertyElement.newBuilder().setKey(entry.getKey().toProto()).setValue(valueBuilder.build()));
                }
            }
            if (null != this.rpcMetadata) {
                builder.setMetadata(this.rpcMetadata.serialize());
            }
            return builder.build();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.map == null ? 0 : this.map.hashCode());
            result = 31 * result + (this.rpcMetadata == null ? 0 : this.rpcMetadata.hashCode());
            return result;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof DatabasePropertyResponse) {
                DatabasePropertyResponse other = (DatabasePropertyResponse)o;
                if (null == this.map ? null != other.map : !this.map.equals(other.map)) {
                    return false;
                }
                return !(null == this.rpcMetadata ? null != other.rpcMetadata : !this.rpcMetadata.equals(other.rpcMetadata));
            }
            return false;
        }
    }

    public static class ConnectionSyncResponse
    extends Response {
        public final Meta.ConnectionProperties connProps;
        public final RpcMetadataResponse rpcMetadata;

        ConnectionSyncResponse() {
            this.connProps = null;
            this.rpcMetadata = null;
        }

        @JsonCreator
        public ConnectionSyncResponse(@JsonProperty(value="connProps") Meta.ConnectionProperties connProps, @JsonProperty(value="rpcMetadata") RpcMetadataResponse rpcMetadata) {
            this.connProps = connProps;
            this.rpcMetadata = rpcMetadata;
        }

        @Override
        ConnectionSyncResponse deserialize(Message genericMsg) {
            Responses.ConnectionSyncResponse msg = ProtobufService.castProtobufMessage(genericMsg, Responses.ConnectionSyncResponse.class);
            Descriptors.Descriptor desc = msg.getDescriptorForType();
            RpcMetadataResponse metadata = null;
            if (ProtobufService.hasField(msg, desc, 2)) {
                metadata = RpcMetadataResponse.fromProto(msg.getMetadata());
            }
            return new ConnectionSyncResponse(ConnectionPropertiesImpl.fromProto(msg.getConnProps()), metadata);
        }

        @Override
        Responses.ConnectionSyncResponse serialize() {
            Responses.ConnectionSyncResponse.Builder builder = Responses.ConnectionSyncResponse.newBuilder();
            if (null != this.connProps) {
                builder.setConnProps(this.connProps.toProto());
            }
            if (null != this.rpcMetadata) {
                builder.setMetadata(this.rpcMetadata.serialize());
            }
            return builder.build();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.connProps == null ? 0 : this.connProps.hashCode());
            result = 31 * result + (this.rpcMetadata == null ? 0 : this.rpcMetadata.hashCode());
            return result;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof ConnectionSyncResponse) {
                ConnectionSyncResponse other = (ConnectionSyncResponse)o;
                if (null == this.connProps ? null != other.connProps : !this.connProps.equals(other.connProps)) {
                    return false;
                }
                return !(null == this.rpcMetadata ? null != other.rpcMetadata : !this.rpcMetadata.equals(other.rpcMetadata));
            }
            return false;
        }
    }

    public static class ConnectionSyncRequest
    extends Request {
        public final String connectionId;
        public final Meta.ConnectionProperties connProps;

        ConnectionSyncRequest() {
            this.connectionId = null;
            this.connProps = null;
        }

        @JsonCreator
        public ConnectionSyncRequest(@JsonProperty(value="connectionId") String connectionId, @JsonProperty(value="connProps") Meta.ConnectionProperties connProps) {
            this.connectionId = connectionId;
            this.connProps = connProps;
        }

        @Override
        ConnectionSyncResponse accept(Service service) {
            return service.apply(this);
        }

        @Override
        ConnectionSyncRequest deserialize(Message genericMsg) {
            Requests.ConnectionSyncRequest msg = ProtobufService.castProtobufMessage(genericMsg, Requests.ConnectionSyncRequest.class);
            Descriptors.Descriptor desc = msg.getDescriptorForType();
            String connectionId = null;
            if (ProtobufService.hasField(msg, desc, 1)) {
                connectionId = msg.getConnectionId();
            }
            ConnectionPropertiesImpl connProps = null;
            if (ProtobufService.hasField(msg, desc, 2)) {
                connProps = ConnectionPropertiesImpl.fromProto(msg.getConnProps());
            }
            return new ConnectionSyncRequest(connectionId, connProps);
        }

        @Override
        Requests.ConnectionSyncRequest serialize() {
            Requests.ConnectionSyncRequest.Builder builder = Requests.ConnectionSyncRequest.newBuilder();
            if (null != this.connectionId) {
                builder.setConnectionId(this.connectionId);
            }
            if (null != this.connProps) {
                builder.setConnProps(this.connProps.toProto());
            }
            return builder.build();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.connProps == null ? 0 : this.connProps.hashCode());
            result = 31 * result + (this.connectionId == null ? 0 : this.connectionId.hashCode());
            return result;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof ConnectionSyncRequest) {
                ConnectionSyncRequest other = (ConnectionSyncRequest)o;
                if (null == this.connectionId ? null != other.connectionId : !this.connectionId.equals(other.connectionId)) {
                    return false;
                }
                return !(null == this.connProps ? null != other.connProps : !this.connProps.equals(other.connProps));
            }
            return false;
        }
    }

    public static class CloseConnectionResponse
    extends Response {
        public final RpcMetadataResponse rpcMetadata;

        public CloseConnectionResponse() {
            this.rpcMetadata = null;
        }

        @JsonCreator
        public CloseConnectionResponse(@JsonProperty(value="rpcMetadata") RpcMetadataResponse rpcMetadata) {
            this.rpcMetadata = rpcMetadata;
        }

        @Override
        CloseConnectionResponse deserialize(Message genericMsg) {
            Responses.CloseConnectionResponse msg = ProtobufService.castProtobufMessage(genericMsg, Responses.CloseConnectionResponse.class);
            Descriptors.Descriptor desc = msg.getDescriptorForType();
            RpcMetadataResponse metadata = null;
            if (ProtobufService.hasField(msg, desc, 1)) {
                metadata = RpcMetadataResponse.fromProto(msg.getMetadata());
            }
            return new CloseConnectionResponse(metadata);
        }

        @Override
        Responses.CloseConnectionResponse serialize() {
            Responses.CloseConnectionResponse.Builder builder = Responses.CloseConnectionResponse.newBuilder();
            if (null != this.rpcMetadata) {
                builder.setMetadata(this.rpcMetadata.serialize());
            }
            return builder.build();
        }

        public int hashCode() {
            return null == this.rpcMetadata ? 0 : this.rpcMetadata.hashCode();
        }

        public boolean equals(Object o) {
            return o == this || o instanceof CloseConnectionResponse && Objects.equals(this.rpcMetadata, ((CloseConnectionResponse)o).rpcMetadata);
        }
    }

    public static class CloseConnectionRequest
    extends Request {
        public final String connectionId;

        CloseConnectionRequest() {
            this.connectionId = null;
        }

        @JsonCreator
        public CloseConnectionRequest(@JsonProperty(value="connectionId") String connectionId) {
            this.connectionId = connectionId;
        }

        @Override
        CloseConnectionResponse accept(Service service) {
            return service.apply(this);
        }

        @Override
        CloseConnectionRequest deserialize(Message genericMsg) {
            Requests.CloseConnectionRequest msg = ProtobufService.castProtobufMessage(genericMsg, Requests.CloseConnectionRequest.class);
            Descriptors.Descriptor desc = msg.getDescriptorForType();
            String connectionId = null;
            if (ProtobufService.hasField(msg, desc, 1)) {
                connectionId = msg.getConnectionId();
            }
            return new CloseConnectionRequest(connectionId);
        }

        @Override
        Requests.CloseConnectionRequest serialize() {
            Requests.CloseConnectionRequest.Builder builder = Requests.CloseConnectionRequest.newBuilder();
            if (null != this.connectionId) {
                builder.setConnectionId(this.connectionId);
            }
            return builder.build();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.connectionId == null ? 0 : this.connectionId.hashCode());
            return result;
        }

        public boolean equals(Object o) {
            return o == this || o instanceof CloseConnectionRequest && Objects.equals(this.connectionId, ((CloseConnectionRequest)o).connectionId);
        }
    }

    public static class OpenConnectionResponse
    extends Response {
        public final RpcMetadataResponse rpcMetadata;

        public OpenConnectionResponse() {
            this.rpcMetadata = null;
        }

        @JsonCreator
        public OpenConnectionResponse(@JsonProperty(value="rpcMetadata") RpcMetadataResponse rpcMetadata) {
            this.rpcMetadata = rpcMetadata;
        }

        @Override
        OpenConnectionResponse deserialize(Message genericMsg) {
            Responses.OpenConnectionResponse msg = ProtobufService.castProtobufMessage(genericMsg, Responses.OpenConnectionResponse.class);
            Descriptors.Descriptor desc = msg.getDescriptorForType();
            RpcMetadataResponse metadata = null;
            if (ProtobufService.hasField(msg, desc, 1)) {
                metadata = RpcMetadataResponse.fromProto(msg.getMetadata());
            }
            return new OpenConnectionResponse(metadata);
        }

        @Override
        Responses.OpenConnectionResponse serialize() {
            Responses.OpenConnectionResponse.Builder builder = Responses.OpenConnectionResponse.newBuilder();
            if (null != this.rpcMetadata) {
                builder.setMetadata(this.rpcMetadata.serialize());
            }
            return builder.build();
        }

        public int hashCode() {
            return null == this.rpcMetadata ? 0 : this.rpcMetadata.hashCode();
        }

        public boolean equals(Object o) {
            return o == this || o instanceof OpenConnectionResponse && Objects.equals(this.rpcMetadata, ((OpenConnectionResponse)o).rpcMetadata);
        }
    }

    public static class OpenConnectionRequest
    extends Request {
        public final String connectionId;
        public final Map<String, String> info;

        public OpenConnectionRequest() {
            this.connectionId = null;
            this.info = null;
        }

        @JsonCreator
        public OpenConnectionRequest(@JsonProperty(value="connectionId") String connectionId, @JsonProperty(value="info") Map<String, String> info) {
            this.connectionId = connectionId;
            this.info = info;
        }

        @Override
        OpenConnectionResponse accept(Service service) {
            return service.apply(this);
        }

        public static Map<String, String> serializeProperties(Properties props) {
            HashMap<String, String> infoAsString = new HashMap<String, String>();
            for (Map.Entry<Object, Object> entry : props.entrySet()) {
                boolean localProperty = false;
                for (BuiltInConnectionProperty prop : BuiltInConnectionProperty.values()) {
                    if (!prop.camelName().equals(entry.getKey())) continue;
                    localProperty = true;
                    break;
                }
                if (localProperty) continue;
                infoAsString.put(entry.getKey().toString(), entry.getValue().toString());
            }
            return infoAsString;
        }

        @Override
        Request deserialize(Message genericMsg) {
            Map<String, String> info;
            Requests.OpenConnectionRequest msg = ProtobufService.castProtobufMessage(genericMsg, Requests.OpenConnectionRequest.class);
            Descriptors.Descriptor desc = msg.getDescriptorForType();
            String connectionId = null;
            if (ProtobufService.hasField(msg, desc, 1)) {
                connectionId = msg.getConnectionId();
            }
            if ((info = msg.getInfo()).isEmpty()) {
                info = null;
            }
            return new OpenConnectionRequest(connectionId, info);
        }

        @Override
        Message serialize() {
            Requests.OpenConnectionRequest.Builder builder = Requests.OpenConnectionRequest.newBuilder();
            if (null != this.connectionId) {
                builder.setConnectionId(this.connectionId);
            }
            if (null != this.info) {
                builder.getMutableInfo().putAll(this.info);
            }
            return builder.build();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.connectionId == null ? 0 : this.connectionId.hashCode());
            result = 31 * result + (this.info == null ? 0 : this.info.hashCode());
            return result;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof OpenConnectionRequest) {
                OpenConnectionRequest other = (OpenConnectionRequest)o;
                if (null == this.connectionId ? null != other.connectionId : !this.connectionId.equals(other.connectionId)) {
                    return false;
                }
                return !(null == this.info ? null != other.info : !this.info.equals(other.info));
            }
            return false;
        }
    }

    public static class CloseStatementResponse
    extends Response {
        public final RpcMetadataResponse rpcMetadata;

        public CloseStatementResponse() {
            this.rpcMetadata = null;
        }

        @JsonCreator
        public CloseStatementResponse(@JsonProperty(value="rpcMetadata") RpcMetadataResponse rpcMetadata) {
            this.rpcMetadata = rpcMetadata;
        }

        @Override
        CloseStatementResponse deserialize(Message genericMsg) {
            Responses.CloseStatementResponse msg = ProtobufService.castProtobufMessage(genericMsg, Responses.CloseStatementResponse.class);
            Descriptors.Descriptor desc = msg.getDescriptorForType();
            RpcMetadataResponse metadata = null;
            if (ProtobufService.hasField(msg, desc, 1)) {
                metadata = RpcMetadataResponse.fromProto(msg.getMetadata());
            }
            return new CloseStatementResponse(metadata);
        }

        @Override
        Responses.CloseStatementResponse serialize() {
            Responses.CloseStatementResponse.Builder builder = Responses.CloseStatementResponse.newBuilder();
            if (null != this.rpcMetadata) {
                builder.setMetadata(this.rpcMetadata.serialize());
            }
            return builder.build();
        }

        public int hashCode() {
            return null == this.rpcMetadata ? 0 : this.rpcMetadata.hashCode();
        }

        public boolean equals(Object o) {
            return o == this || o instanceof CloseStatementResponse && Objects.equals(this.rpcMetadata, ((CloseStatementResponse)o).rpcMetadata);
        }
    }

    public static class CloseStatementRequest
    extends Request {
        public final String connectionId;
        public final int statementId;

        CloseStatementRequest() {
            this.connectionId = null;
            this.statementId = 0;
        }

        @JsonCreator
        public CloseStatementRequest(@JsonProperty(value="connectionId") String connectionId, @JsonProperty(value="statementId") int statementId) {
            this.connectionId = connectionId;
            this.statementId = statementId;
        }

        @Override
        CloseStatementResponse accept(Service service) {
            return service.apply(this);
        }

        @Override
        CloseStatementRequest deserialize(Message genericMsg) {
            Requests.CloseStatementRequest msg = ProtobufService.castProtobufMessage(genericMsg, Requests.CloseStatementRequest.class);
            Descriptors.Descriptor desc = msg.getDescriptorForType();
            String connectionId = null;
            if (ProtobufService.hasField(msg, desc, 1)) {
                connectionId = msg.getConnectionId();
            }
            return new CloseStatementRequest(connectionId, msg.getStatementId());
        }

        @Override
        Requests.CloseStatementRequest serialize() {
            Requests.CloseStatementRequest.Builder builder = Requests.CloseStatementRequest.newBuilder();
            if (null != this.connectionId) {
                builder.setConnectionId(this.connectionId);
            }
            return builder.setStatementId(this.statementId).build();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.connectionId == null ? 0 : this.connectionId.hashCode());
            result = 31 * result + this.statementId;
            return result;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof CloseStatementRequest) {
                CloseStatementRequest other = (CloseStatementRequest)o;
                if (null == this.connectionId ? null != other.connectionId : !this.connectionId.equals(other.connectionId)) {
                    return false;
                }
                return this.statementId == other.statementId;
            }
            return false;
        }
    }

    public static class CreateStatementResponse
    extends Response {
        public final String connectionId;
        public final int statementId;
        public final RpcMetadataResponse rpcMetadata;

        CreateStatementResponse() {
            this.connectionId = null;
            this.statementId = 0;
            this.rpcMetadata = null;
        }

        @JsonCreator
        public CreateStatementResponse(@JsonProperty(value="connectionId") String connectionId, @JsonProperty(value="statementId") int statementId, @JsonProperty(value="rpcMetadata") RpcMetadataResponse rpcMetadata) {
            this.connectionId = connectionId;
            this.statementId = statementId;
            this.rpcMetadata = rpcMetadata;
        }

        @Override
        CreateStatementResponse deserialize(Message genericMsg) {
            Responses.CreateStatementResponse msg = ProtobufService.castProtobufMessage(genericMsg, Responses.CreateStatementResponse.class);
            Descriptors.Descriptor desc = msg.getDescriptorForType();
            String connectionId = null;
            if (ProtobufService.hasField(msg, desc, 1)) {
                connectionId = msg.getConnectionId();
            }
            RpcMetadataResponse metadata = null;
            if (ProtobufService.hasField(msg, desc, 3)) {
                metadata = RpcMetadataResponse.fromProto(msg.getMetadata());
            }
            return new CreateStatementResponse(connectionId, msg.getStatementId(), metadata);
        }

        @Override
        Responses.CreateStatementResponse serialize() {
            Responses.CreateStatementResponse.Builder builder = Responses.CreateStatementResponse.newBuilder();
            if (null != this.connectionId) {
                builder.setConnectionId(this.connectionId);
            }
            if (null != this.rpcMetadata) {
                builder.setMetadata(this.rpcMetadata.serialize());
            }
            builder.setStatementId(this.statementId);
            return builder.build();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.connectionId == null ? 0 : this.connectionId.hashCode());
            result = 31 * result + this.statementId;
            result = 31 * result + (null == this.rpcMetadata ? 0 : this.rpcMetadata.hashCode());
            return result;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof CreateStatementResponse) {
                CreateStatementResponse other = (CreateStatementResponse)o;
                if (this.connectionId == null ? other.connectionId != null : !this.connectionId.equals(other.connectionId)) {
                    return false;
                }
                if (null == this.rpcMetadata ? null != other.rpcMetadata : !this.rpcMetadata.equals(other.rpcMetadata)) {
                    return false;
                }
                return this.statementId == other.statementId;
            }
            return false;
        }
    }

    public static class CreateStatementRequest
    extends Request {
        public final String connectionId;

        CreateStatementRequest() {
            this.connectionId = null;
        }

        @JsonCreator
        public CreateStatementRequest(@JsonProperty(value="signature") String connectionId) {
            this.connectionId = connectionId;
        }

        @Override
        CreateStatementResponse accept(Service service) {
            return service.apply(this);
        }

        @Override
        CreateStatementRequest deserialize(Message genericMsg) {
            Requests.CreateStatementRequest msg = ProtobufService.castProtobufMessage(genericMsg, Requests.CreateStatementRequest.class);
            Descriptors.Descriptor desc = msg.getDescriptorForType();
            String connectionId = null;
            if (ProtobufService.hasField(msg, desc, 1)) {
                connectionId = msg.getConnectionId();
            }
            return new CreateStatementRequest(connectionId);
        }

        @Override
        Requests.CreateStatementRequest serialize() {
            Requests.CreateStatementRequest.Builder builder = Requests.CreateStatementRequest.newBuilder();
            if (null != this.connectionId) {
                builder.setConnectionId(this.connectionId);
            }
            return builder.build();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.connectionId == null ? 0 : this.connectionId.hashCode());
            return result;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof CreateStatementRequest) {
                CreateStatementRequest other = (CreateStatementRequest)o;
                return !(null == this.connectionId ? null != other.connectionId : !this.connectionId.equals(other.connectionId));
            }
            return false;
        }
    }

    public static class FetchResponse
    extends Response {
        public final Meta.Frame frame;
        public boolean missingStatement = false;
        public boolean missingResults = false;
        public final RpcMetadataResponse rpcMetadata;

        FetchResponse() {
            this.frame = null;
            this.rpcMetadata = null;
        }

        @JsonCreator
        public FetchResponse(@JsonProperty(value="frame") Meta.Frame frame, @JsonProperty(value="missingStatement") boolean missingStatement, @JsonProperty(value="missingResults") boolean missingResults, @JsonProperty(value="rpcMetadata") RpcMetadataResponse rpcMetadata) {
            this.frame = frame;
            this.missingStatement = missingStatement;
            this.missingResults = missingResults;
            this.rpcMetadata = rpcMetadata;
        }

        @Override
        FetchResponse deserialize(Message genericMsg) {
            Responses.FetchResponse msg = ProtobufService.castProtobufMessage(genericMsg, Responses.FetchResponse.class);
            Descriptors.Descriptor desc = msg.getDescriptorForType();
            RpcMetadataResponse metadata = null;
            if (ProtobufService.hasField(msg, desc, 4)) {
                metadata = RpcMetadataResponse.fromProto(msg.getMetadata());
            }
            return new FetchResponse(Meta.Frame.fromProto(msg.getFrame()), msg.getMissingStatement(), msg.getMissingResults(), metadata);
        }

        @Override
        Responses.FetchResponse serialize() {
            Responses.FetchResponse.Builder builder = Responses.FetchResponse.newBuilder();
            if (null != this.frame) {
                builder.setFrame(this.frame.toProto());
            }
            if (null != this.rpcMetadata) {
                builder.setMetadata(this.rpcMetadata.serialize());
            }
            return builder.setMissingStatement(this.missingStatement).setMissingResults(this.missingResults).build();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.frame == null ? 0 : this.frame.hashCode());
            result = 31 * result + (null == this.rpcMetadata ? 0 : this.rpcMetadata.hashCode());
            return result;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof FetchResponse) {
                FetchResponse other = (FetchResponse)o;
                if (this.frame == null ? other.frame != null : !this.frame.equals(other.frame)) {
                    return false;
                }
                if (null == this.rpcMetadata ? null != other.rpcMetadata : !this.rpcMetadata.equals(other.rpcMetadata)) {
                    return false;
                }
                return this.missingStatement == other.missingStatement;
            }
            return false;
        }
    }

    public static class FetchRequest
    extends Request {
        public final String connectionId;
        public final int statementId;
        public final long offset;
        public final int fetchMaxRowCount;

        FetchRequest() {
            this.connectionId = null;
            this.statementId = 0;
            this.offset = 0L;
            this.fetchMaxRowCount = 0;
        }

        @JsonCreator
        public FetchRequest(@JsonProperty(value="connectionId") String connectionId, @JsonProperty(value="statementId") int statementId, @JsonProperty(value="offset") long offset, @JsonProperty(value="fetchMaxRowCount") int fetchMaxRowCount) {
            this.connectionId = connectionId;
            this.statementId = statementId;
            this.offset = offset;
            this.fetchMaxRowCount = fetchMaxRowCount;
        }

        @Override
        FetchResponse accept(Service service) {
            return service.apply(this);
        }

        @Override
        FetchRequest deserialize(Message genericMsg) {
            Requests.FetchRequest msg = ProtobufService.castProtobufMessage(genericMsg, Requests.FetchRequest.class);
            Descriptors.Descriptor desc = msg.getDescriptorForType();
            String connectionId = null;
            if (ProtobufService.hasField(msg, desc, 1)) {
                connectionId = msg.getConnectionId();
            }
            return new FetchRequest(connectionId, msg.getStatementId(), msg.getOffset(), msg.getFetchMaxRowCount());
        }

        @Override
        Requests.FetchRequest serialize() {
            Requests.FetchRequest.Builder builder = Requests.FetchRequest.newBuilder();
            if (null != this.connectionId) {
                builder.setConnectionId(this.connectionId);
            }
            builder.setStatementId(this.statementId);
            builder.setOffset(this.offset);
            builder.setFetchMaxRowCount(this.fetchMaxRowCount);
            return builder.build();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.connectionId == null ? 0 : this.connectionId.hashCode());
            result = 31 * result + this.fetchMaxRowCount;
            result = 31 * result + (int)(this.offset ^ this.offset >>> 32);
            result = 31 * result + this.statementId;
            return result;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof FetchRequest) {
                FetchRequest other = (FetchRequest)o;
                if (null == this.connectionId ? null != other.connectionId : !this.connectionId.equals(other.connectionId)) {
                    return false;
                }
                return this.offset == other.offset && this.fetchMaxRowCount == other.fetchMaxRowCount;
            }
            return false;
        }
    }

    public static class PrepareResponse
    extends Response {
        public final Meta.StatementHandle statement;
        public final RpcMetadataResponse rpcMetadata;

        PrepareResponse() {
            this.statement = null;
            this.rpcMetadata = null;
        }

        @JsonCreator
        public PrepareResponse(@JsonProperty(value="statement") Meta.StatementHandle statement, @JsonProperty(value="rpcMetadata") RpcMetadataResponse rpcMetadata) {
            this.statement = statement;
            this.rpcMetadata = rpcMetadata;
        }

        @Override
        PrepareResponse deserialize(Message genericMsg) {
            Responses.PrepareResponse msg = ProtobufService.castProtobufMessage(genericMsg, Responses.PrepareResponse.class);
            Descriptors.Descriptor desc = msg.getDescriptorForType();
            RpcMetadataResponse metadata = null;
            if (ProtobufService.hasField(msg, desc, 2)) {
                metadata = RpcMetadataResponse.fromProto(msg.getMetadata());
            }
            return new PrepareResponse(Meta.StatementHandle.fromProto(msg.getStatement()), metadata);
        }

        @Override
        Responses.PrepareResponse serialize() {
            Responses.PrepareResponse.Builder builder = Responses.PrepareResponse.newBuilder();
            if (null != this.statement) {
                builder.setStatement(this.statement.toProto());
            }
            if (null != this.rpcMetadata) {
                builder.setMetadata(this.rpcMetadata.serialize());
            }
            return builder.build();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.statement == null ? 0 : this.statement.hashCode());
            result = 31 * result + (null == this.rpcMetadata ? 0 : this.rpcMetadata.hashCode());
            return result;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof PrepareResponse) {
                PrepareResponse other = (PrepareResponse)o;
                if (this.statement == null ? other.statement != null : !this.statement.equals(other.statement)) {
                    return false;
                }
                return !(null == this.rpcMetadata ? null != other.rpcMetadata : !this.rpcMetadata.equals(other.rpcMetadata));
            }
            return false;
        }
    }

    public static class PrepareRequest
    extends Request {
        public final String connectionId;
        public final String sql;
        public final long maxRowCount;

        PrepareRequest() {
            this.connectionId = null;
            this.sql = null;
            this.maxRowCount = 0L;
        }

        @JsonCreator
        public PrepareRequest(@JsonProperty(value="connectionId") String connectionId, @JsonProperty(value="sql") String sql, @JsonProperty(value="maxRowCount") long maxRowCount) {
            this.connectionId = connectionId;
            this.sql = sql;
            this.maxRowCount = maxRowCount;
        }

        @Override
        PrepareResponse accept(Service service) {
            return service.apply(this);
        }

        @Override
        PrepareRequest deserialize(Message genericMsg) {
            Requests.PrepareRequest msg = ProtobufService.castProtobufMessage(genericMsg, Requests.PrepareRequest.class);
            Descriptors.Descriptor desc = msg.getDescriptorForType();
            String connectionId = null;
            if (ProtobufService.hasField(msg, desc, 1)) {
                connectionId = msg.getConnectionId();
            }
            String sql = null;
            if (ProtobufService.hasField(msg, desc, 2)) {
                sql = msg.getSql();
            }
            return new PrepareRequest(connectionId, sql, msg.getMaxRowCount());
        }

        @Override
        Requests.PrepareRequest serialize() {
            Requests.PrepareRequest.Builder builder = Requests.PrepareRequest.newBuilder();
            if (null != this.connectionId) {
                builder.setConnectionId(this.connectionId);
            }
            if (null != this.sql) {
                builder.setSql(this.sql);
            }
            return builder.setMaxRowCount(this.maxRowCount).build();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.connectionId == null ? 0 : this.connectionId.hashCode());
            result = 31 * result + (int)(this.maxRowCount ^ this.maxRowCount >>> 32);
            result = 31 * result + (this.sql == null ? 0 : this.sql.hashCode());
            return result;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof PrepareRequest) {
                PrepareRequest other = (PrepareRequest)o;
                if (null == this.connectionId ? null != other.connectionId : !this.connectionId.equals(other.connectionId)) {
                    return false;
                }
                if (null == this.sql ? null != other.sql : !this.sql.equals(other.sql)) {
                    return false;
                }
                return this.maxRowCount == other.maxRowCount;
            }
            return false;
        }
    }

    public static class ExecuteResponse
    extends Response {
        public final List<ResultSetResponse> results;
        public boolean missingStatement = false;
        public final RpcMetadataResponse rpcMetadata;

        ExecuteResponse() {
            this.results = null;
            this.rpcMetadata = null;
        }

        @JsonCreator
        public ExecuteResponse(@JsonProperty(value="resultSets") List<ResultSetResponse> results, @JsonProperty(value="missingStatement") boolean missingStatement, @JsonProperty(value="rpcMetadata") RpcMetadataResponse rpcMetadata) {
            this.results = results;
            this.missingStatement = missingStatement;
            this.rpcMetadata = rpcMetadata;
        }

        @Override
        ExecuteResponse deserialize(Message genericMsg) {
            Responses.ExecuteResponse msg = ProtobufService.castProtobufMessage(genericMsg, Responses.ExecuteResponse.class);
            Descriptors.Descriptor desc = msg.getDescriptorForType();
            List<Responses.ResultSetResponse> msgResults = msg.getResultsList();
            ArrayList<ResultSetResponse> copiedResults = new ArrayList<ResultSetResponse>(msgResults.size());
            for (Responses.ResultSetResponse msgResult : msgResults) {
                copiedResults.add(ResultSetResponse.fromProto(msgResult));
            }
            RpcMetadataResponse metadata = null;
            if (ProtobufService.hasField(msg, desc, 3)) {
                metadata = RpcMetadataResponse.fromProto(msg.getMetadata());
            }
            return new ExecuteResponse(copiedResults, msg.getMissingStatement(), metadata);
        }

        @Override
        Responses.ExecuteResponse serialize() {
            Responses.ExecuteResponse.Builder builder = Responses.ExecuteResponse.newBuilder();
            if (null != this.results) {
                for (ResultSetResponse result : this.results) {
                    builder.addResults(result.serialize());
                }
            }
            if (null != this.rpcMetadata) {
                builder.setMetadata(this.rpcMetadata.serialize());
            }
            return builder.setMissingStatement(this.missingStatement).build();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.results == null ? 0 : this.results.hashCode());
            result = 31 * result + (this.rpcMetadata == null ? 0 : this.rpcMetadata.hashCode());
            return result;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof ExecuteResponse) {
                ExecuteResponse other = (ExecuteResponse)o;
                if (null == this.results ? null != other.results : !this.results.equals(other.results)) {
                    return false;
                }
                return !(null == this.rpcMetadata ? null != other.rpcMetadata : !this.rpcMetadata.equals(other.rpcMetadata));
            }
            return false;
        }
    }

    public static class ExecuteRequest
    extends Request {
        public final Meta.StatementHandle statementHandle;
        public final List<TypedValue> parameterValues;
        public final long maxRowCount;

        ExecuteRequest() {
            this.statementHandle = null;
            this.parameterValues = null;
            this.maxRowCount = 0L;
        }

        @JsonCreator
        public ExecuteRequest(@JsonProperty(value="statementHandle") Meta.StatementHandle statementHandle, @JsonProperty(value="parameterValues") List<TypedValue> parameterValues, @JsonProperty(value="maxRowCount") long maxRowCount) {
            this.statementHandle = statementHandle;
            this.parameterValues = parameterValues;
            this.maxRowCount = maxRowCount;
        }

        @Override
        ExecuteResponse accept(Service service) {
            return service.apply(this);
        }

        @Override
        ExecuteRequest deserialize(Message genericMsg) {
            Requests.ExecuteRequest msg = ProtobufService.castProtobufMessage(genericMsg, Requests.ExecuteRequest.class);
            Descriptors.Descriptor desc = msg.getDescriptorForType();
            Meta.StatementHandle statemetnHandle = null;
            if (ProtobufService.hasField(msg, desc, 1)) {
                statemetnHandle = Meta.StatementHandle.fromProto(msg.getStatementHandle());
            }
            ArrayList<TypedValue> values = null;
            if (msg.getHasParameterValues()) {
                values = new ArrayList<TypedValue>(msg.getParameterValuesCount());
                for (Common.TypedValue valueProto : msg.getParameterValuesList()) {
                    values.add(TypedValue.fromProto(valueProto));
                }
            }
            return new ExecuteRequest(statemetnHandle, values, msg.getMaxRowCount());
        }

        @Override
        Requests.ExecuteRequest serialize() {
            Requests.ExecuteRequest.Builder builder = Requests.ExecuteRequest.newBuilder();
            if (null != this.statementHandle) {
                builder.setStatementHandle(this.statementHandle.toProto());
            }
            if (null != this.parameterValues) {
                builder.setHasParameterValues(true);
                for (TypedValue paramValue : this.parameterValues) {
                    if (paramValue == null) {
                        builder.addParameterValues(TypedValue.NULL.toProto());
                        continue;
                    }
                    builder.addParameterValues(paramValue.toProto());
                }
            } else {
                builder.setHasParameterValues(false);
            }
            builder.setMaxRowCount(this.maxRowCount);
            return builder.build();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.statementHandle == null ? 0 : this.statementHandle.hashCode());
            result = 31 * result + (this.parameterValues == null ? 0 : this.parameterValues.hashCode());
            result = 31 * result + (int)(this.maxRowCount ^ this.maxRowCount >>> 32);
            return result;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof ExecuteRequest) {
                ExecuteRequest other = (ExecuteRequest)o;
                if (this.statementHandle == null ? other.statementHandle != null : !this.statementHandle.equals(other.statementHandle)) {
                    return false;
                }
                if (null == this.parameterValues ? null != other.parameterValues : !this.parameterValues.equals(other.parameterValues)) {
                    return false;
                }
                return this.maxRowCount == other.maxRowCount;
            }
            return false;
        }
    }

    public static class PrepareAndExecuteRequest
    extends Request {
        public final String connectionId;
        public final String sql;
        public final long maxRowCount;
        public final int statementId;

        PrepareAndExecuteRequest() {
            this.connectionId = null;
            this.sql = null;
            this.maxRowCount = 0L;
            this.statementId = 0;
        }

        @JsonCreator
        public PrepareAndExecuteRequest(@JsonProperty(value="connectionId") String connectionId, @JsonProperty(value="statementId") int statementId, @JsonProperty(value="sql") String sql, @JsonProperty(value="maxRowCount") long maxRowCount) {
            this.connectionId = connectionId;
            this.statementId = statementId;
            this.sql = sql;
            this.maxRowCount = maxRowCount;
        }

        @Override
        ExecuteResponse accept(Service service) {
            return service.apply(this);
        }

        @Override
        PrepareAndExecuteRequest deserialize(Message genericMsg) {
            Requests.PrepareAndExecuteRequest msg = ProtobufService.castProtobufMessage(genericMsg, Requests.PrepareAndExecuteRequest.class);
            Descriptors.Descriptor desc = msg.getDescriptorForType();
            String connectionId = null;
            if (ProtobufService.hasField(msg, desc, 1)) {
                connectionId = msg.getConnectionId();
            }
            String sql = null;
            if (ProtobufService.hasField(msg, desc, 2)) {
                sql = msg.getSql();
            }
            return new PrepareAndExecuteRequest(connectionId, msg.getStatementId(), sql, msg.getMaxRowCount());
        }

        @Override
        Requests.PrepareAndExecuteRequest serialize() {
            Requests.PrepareAndExecuteRequest.Builder builder = Requests.PrepareAndExecuteRequest.newBuilder();
            if (null != this.connectionId) {
                builder.setConnectionId(this.connectionId);
            }
            if (null != this.sql) {
                builder.setSql(this.sql);
            }
            builder.setStatementId(this.statementId);
            builder.setMaxRowCount(this.maxRowCount);
            return builder.build();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.connectionId == null ? 0 : this.connectionId.hashCode());
            result = 31 * result + (int)(this.maxRowCount ^ this.maxRowCount >>> 32);
            result = 31 * result + (this.sql == null ? 0 : this.sql.hashCode());
            result = 31 * result + this.statementId;
            return result;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof PrepareAndExecuteRequest) {
                PrepareAndExecuteRequest other = (PrepareAndExecuteRequest)o;
                if (null == this.connectionId ? null != other.connectionId : !this.connectionId.equals(other.connectionId)) {
                    return false;
                }
                if (null == this.sql ? null != other.sql : !this.sql.equals(other.sql)) {
                    return false;
                }
                return this.statementId == other.statementId && this.maxRowCount == other.maxRowCount;
            }
            return false;
        }
    }

    public static class ResultSetResponse
    extends Response {
        public final String connectionId;
        public final int statementId;
        public final boolean ownStatement;
        public final Meta.Signature signature;
        public final Meta.Frame firstFrame;
        public final long updateCount;
        public final RpcMetadataResponse rpcMetadata;

        ResultSetResponse() {
            this.connectionId = null;
            this.statementId = 0;
            this.ownStatement = false;
            this.signature = null;
            this.firstFrame = null;
            this.updateCount = 0L;
            this.rpcMetadata = null;
        }

        @JsonCreator
        public ResultSetResponse(@JsonProperty(value="connectionId") String connectionId, @JsonProperty(value="statementId") int statementId, @JsonProperty(value="ownStatement") boolean ownStatement, @JsonProperty(value="signature") Meta.Signature signature, @JsonProperty(value="firstFrame") Meta.Frame firstFrame, @JsonProperty(value="updateCount") long updateCount, @JsonProperty(value="rpcMetadata") RpcMetadataResponse rpcMetadata) {
            this.connectionId = connectionId;
            this.statementId = statementId;
            this.ownStatement = ownStatement;
            this.signature = signature;
            this.firstFrame = firstFrame;
            this.updateCount = updateCount;
            this.rpcMetadata = rpcMetadata;
        }

        @Override
        ResultSetResponse deserialize(Message genericMsg) {
            Responses.ResultSetResponse msg = ProtobufService.castProtobufMessage(genericMsg, Responses.ResultSetResponse.class);
            return ResultSetResponse.fromProto(msg);
        }

        static ResultSetResponse fromProto(Responses.ResultSetResponse msg) {
            Descriptors.Descriptor desc = msg.getDescriptorForType();
            String connectionId = null;
            if (ProtobufService.hasField(msg, desc, 1)) {
                connectionId = msg.getConnectionId();
            }
            Meta.Signature signature = null;
            if (ProtobufService.hasField(msg, desc, 4)) {
                signature = Meta.Signature.fromProto(msg.getSignature());
            }
            Meta.Frame frame = null;
            if (ProtobufService.hasField(msg, desc, 5)) {
                frame = Meta.Frame.fromProto(msg.getFirstFrame());
            }
            RpcMetadataResponse metadata = null;
            if (ProtobufService.hasField(msg, desc, 7)) {
                metadata = RpcMetadataResponse.fromProto(msg.getMetadata());
            }
            return new ResultSetResponse(connectionId, msg.getStatementId(), msg.getOwnStatement(), signature, frame, msg.getUpdateCount(), metadata);
        }

        @Override
        Responses.ResultSetResponse serialize() {
            Responses.ResultSetResponse.Builder builder = Responses.ResultSetResponse.newBuilder();
            builder.setStatementId(this.statementId).setOwnStatement(this.ownStatement).setUpdateCount(this.updateCount);
            if (null != this.connectionId) {
                builder.setConnectionId(this.connectionId);
            }
            if (null != this.signature) {
                builder.setSignature(this.signature.toProto());
            }
            if (null != this.firstFrame) {
                builder.setFirstFrame(this.firstFrame.toProto());
            }
            if (null != this.rpcMetadata) {
                builder.setMetadata(this.rpcMetadata.serialize());
            }
            return builder.build();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.connectionId == null ? 0 : this.connectionId.hashCode());
            result = 31 * result + (this.firstFrame == null ? 0 : this.firstFrame.hashCode());
            result = 31 * result + (this.ownStatement ? 1231 : 1237);
            result = 31 * result + (this.signature == null ? 0 : this.signature.hashCode());
            result = 31 * result + this.statementId;
            result = 31 * result + (int)(this.updateCount ^ this.updateCount >>> 32);
            result = 31 * result + (this.rpcMetadata == null ? 0 : this.rpcMetadata.hashCode());
            return result;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof ResultSetResponse) {
                ResultSetResponse other = (ResultSetResponse)o;
                if (this.connectionId == null ? other.connectionId != null : !this.connectionId.equals(other.connectionId)) {
                    return false;
                }
                if (this.firstFrame == null ? other.firstFrame != null : !this.firstFrame.equals(other.firstFrame)) {
                    return false;
                }
                if (this.signature == null ? other.signature != null : !this.signature.equals(other.signature)) {
                    return false;
                }
                if (null == this.rpcMetadata ? null != this.rpcMetadata : !this.rpcMetadata.equals(other.rpcMetadata)) {
                    return false;
                }
                return this.ownStatement == other.ownStatement && this.statementId == other.statementId && this.updateCount == other.updateCount;
            }
            return false;
        }
    }

    public static class TypeInfoRequest
    extends Request {
        public final String connectionId;

        public TypeInfoRequest() {
            this.connectionId = null;
        }

        @JsonCreator
        public TypeInfoRequest(@JsonProperty(value="connectionId") String connectionId) {
            this.connectionId = connectionId;
        }

        @Override
        ResultSetResponse accept(Service service) {
            return service.apply(this);
        }

        @Override
        TypeInfoRequest deserialize(Message genericMsg) {
            Requests.TypeInfoRequest msg = ProtobufService.castProtobufMessage(genericMsg, Requests.TypeInfoRequest.class);
            Descriptors.Descriptor desc = msg.getDescriptorForType();
            String connectionId = null;
            if (ProtobufService.hasField(msg, desc, 1)) {
                connectionId = msg.getConnectionId();
            }
            return new TypeInfoRequest(connectionId);
        }

        @Override
        Requests.TypeInfoRequest serialize() {
            Requests.TypeInfoRequest.Builder builder = Requests.TypeInfoRequest.newBuilder();
            if (null != this.connectionId) {
                builder.setConnectionId(this.connectionId);
            }
            return builder.build();
        }

        public int hashCode() {
            return this.connectionId == null ? 0 : this.connectionId.hashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof TypeInfoRequest) {
                TypeInfoRequest other = (TypeInfoRequest)o;
                return !(null == this.connectionId ? null != other.connectionId : !this.connectionId.equals(other.connectionId));
            }
            return false;
        }
    }

    public static class ColumnsRequest
    extends Request {
        public final String connectionId;
        public final String catalog;
        public final String schemaPattern;
        public final String tableNamePattern;
        public final String columnNamePattern;

        ColumnsRequest() {
            this.connectionId = null;
            this.catalog = null;
            this.schemaPattern = null;
            this.tableNamePattern = null;
            this.columnNamePattern = null;
        }

        @JsonCreator
        public ColumnsRequest(@JsonProperty(value="connectionId") String connectionId, @JsonProperty(value="catalog") String catalog, @JsonProperty(value="schemaPattern") String schemaPattern, @JsonProperty(value="tableNamePattern") String tableNamePattern, @JsonProperty(value="columnNamePattern") String columnNamePattern) {
            this.connectionId = connectionId;
            this.catalog = catalog;
            this.schemaPattern = schemaPattern;
            this.tableNamePattern = tableNamePattern;
            this.columnNamePattern = columnNamePattern;
        }

        @Override
        ResultSetResponse accept(Service service) {
            return service.apply(this);
        }

        @Override
        ColumnsRequest deserialize(Message genericMsg) {
            Requests.ColumnsRequest msg = ProtobufService.castProtobufMessage(genericMsg, Requests.ColumnsRequest.class);
            Descriptors.Descriptor desc = msg.getDescriptorForType();
            String connectionId = null;
            if (ProtobufService.hasField(msg, desc, 5)) {
                connectionId = msg.getConnectionId();
            }
            String catalog = null;
            if (ProtobufService.hasField(msg, desc, 1)) {
                catalog = msg.getCatalog();
            }
            String schemaPattern = null;
            if (ProtobufService.hasField(msg, desc, 2)) {
                schemaPattern = msg.getSchemaPattern();
            }
            String tableNamePattern = null;
            if (ProtobufService.hasField(msg, desc, 3)) {
                tableNamePattern = msg.getTableNamePattern();
            }
            String columnNamePattern = null;
            if (ProtobufService.hasField(msg, desc, 4)) {
                columnNamePattern = msg.getColumnNamePattern();
            }
            return new ColumnsRequest(connectionId, catalog, schemaPattern, tableNamePattern, columnNamePattern);
        }

        @Override
        Requests.ColumnsRequest serialize() {
            Requests.ColumnsRequest.Builder builder = Requests.ColumnsRequest.newBuilder();
            if (null != this.connectionId) {
                builder.setConnectionId(this.connectionId);
            }
            if (null != this.catalog) {
                builder.setCatalog(this.catalog);
            }
            if (null != this.schemaPattern) {
                builder.setSchemaPattern(this.schemaPattern);
            }
            if (null != this.tableNamePattern) {
                builder.setTableNamePattern(this.tableNamePattern);
            }
            if (null != this.columnNamePattern) {
                builder.setColumnNamePattern(this.columnNamePattern);
            }
            return builder.build();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.connectionId == null ? 0 : this.connectionId.hashCode());
            result = 31 * result + (this.catalog == null ? 0 : this.catalog.hashCode());
            result = 31 * result + (this.columnNamePattern == null ? 0 : this.columnNamePattern.hashCode());
            result = 31 * result + (this.schemaPattern == null ? 0 : this.schemaPattern.hashCode());
            result = 31 * result + (this.tableNamePattern == null ? 0 : this.tableNamePattern.hashCode());
            return result;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof ColumnsRequest) {
                ColumnsRequest other = (ColumnsRequest)o;
                if (null == this.connectionId ? null != other.connectionId : !this.connectionId.equals(other.connectionId)) {
                    return false;
                }
                if (null == this.catalog ? null != other.catalog : !this.catalog.equals(other.catalog)) {
                    return false;
                }
                if (null == this.schemaPattern ? null != other.schemaPattern : !this.schemaPattern.equals(other.schemaPattern)) {
                    return false;
                }
                if (null == this.tableNamePattern ? null != other.tableNamePattern : !this.tableNamePattern.equals(other.tableNamePattern)) {
                    return false;
                }
                return !(null == this.columnNamePattern ? null != other.columnNamePattern : !this.columnNamePattern.equals(other.columnNamePattern));
            }
            return false;
        }
    }

    public static class TableTypesRequest
    extends Request {
        public final String connectionId;

        public TableTypesRequest() {
            this.connectionId = null;
        }

        @JsonCreator
        public TableTypesRequest(@JsonProperty(value="connectionId") String connectionId) {
            this.connectionId = connectionId;
        }

        @Override
        ResultSetResponse accept(Service service) {
            return service.apply(this);
        }

        @Override
        TableTypesRequest deserialize(Message genericMsg) {
            Requests.TableTypesRequest msg = ProtobufService.castProtobufMessage(genericMsg, Requests.TableTypesRequest.class);
            Descriptors.Descriptor desc = msg.getDescriptorForType();
            String connectionId = null;
            if (ProtobufService.hasField(msg, desc, 1)) {
                connectionId = msg.getConnectionId();
            }
            return new TableTypesRequest(connectionId);
        }

        @Override
        Requests.TableTypesRequest serialize() {
            Requests.TableTypesRequest.Builder builder = Requests.TableTypesRequest.newBuilder();
            if (null != this.connectionId) {
                builder.setConnectionId(this.connectionId);
            }
            return builder.build();
        }

        public int hashCode() {
            return this.connectionId == null ? 0 : this.connectionId.hashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof TableTypesRequest) {
                TableTypesRequest other = (TableTypesRequest)o;
                return !(null == this.connectionId ? null != other.connectionId : !this.connectionId.equals(other.connectionId));
            }
            return false;
        }
    }

    public static class TablesRequest
    extends Request {
        public final String connectionId;
        public final String catalog;
        public final String schemaPattern;
        public final String tableNamePattern;
        public final List<String> typeList;

        TablesRequest() {
            this.connectionId = null;
            this.catalog = null;
            this.schemaPattern = null;
            this.tableNamePattern = null;
            this.typeList = null;
        }

        @JsonCreator
        public TablesRequest(@JsonProperty(value="connectionId") String connectionId, @JsonProperty(value="catalog") String catalog, @JsonProperty(value="schemaPattern") String schemaPattern, @JsonProperty(value="tableNamePattern") String tableNamePattern, @JsonProperty(value="typeList") List<String> typeList) {
            this.connectionId = connectionId;
            this.catalog = catalog;
            this.schemaPattern = schemaPattern;
            this.tableNamePattern = tableNamePattern;
            this.typeList = typeList;
        }

        @Override
        Response accept(Service service) {
            return service.apply(this);
        }

        @Override
        Request deserialize(Message genericMsg) {
            Requests.TablesRequest msg = ProtobufService.castProtobufMessage(genericMsg, Requests.TablesRequest.class);
            Descriptors.Descriptor desc = msg.getDescriptorForType();
            String connectionId = null;
            if (ProtobufService.hasField(msg, desc, 7)) {
                connectionId = msg.getConnectionId();
            }
            String catalog = null;
            if (ProtobufService.hasField(msg, desc, 1)) {
                catalog = msg.getCatalog();
            }
            String schemaPattern = null;
            if (ProtobufService.hasField(msg, desc, 2)) {
                schemaPattern = msg.getSchemaPattern();
            }
            String tableNamePattern = null;
            if (ProtobufService.hasField(msg, desc, 3)) {
                tableNamePattern = msg.getTableNamePattern();
            }
            ProtocolStringList typeList = null;
            if (msg.getHasTypeList()) {
                typeList = msg.getTypeListList();
            }
            return new TablesRequest(connectionId, catalog, schemaPattern, tableNamePattern, typeList);
        }

        @Override
        Requests.TablesRequest serialize() {
            Requests.TablesRequest.Builder builder = Requests.TablesRequest.newBuilder();
            if (null != this.connectionId) {
                builder.setConnectionId(this.connectionId);
            }
            if (null != this.catalog) {
                builder.setCatalog(this.catalog);
            }
            if (null != this.schemaPattern) {
                builder.setSchemaPattern(this.schemaPattern);
            }
            if (null != this.tableNamePattern) {
                builder.setTableNamePattern(this.tableNamePattern);
            }
            if (null != this.typeList) {
                builder.setHasTypeList(true);
                builder.addAllTypeList(this.typeList);
            } else {
                builder.setHasTypeList(false);
            }
            return builder.build();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.connectionId == null ? 0 : this.connectionId.hashCode());
            result = 31 * result + (this.catalog == null ? 0 : this.catalog.hashCode());
            result = 31 * result + (this.schemaPattern == null ? 0 : this.schemaPattern.hashCode());
            result = 31 * result + (this.tableNamePattern == null ? 0 : this.tableNamePattern.hashCode());
            result = 31 * result + (this.typeList == null ? 0 : this.typeList.hashCode());
            return result;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof TablesRequest) {
                TablesRequest other = (TablesRequest)o;
                if (null == this.connectionId ? null != other.connectionId : !this.connectionId.equals(other.connectionId)) {
                    return false;
                }
                if (null == this.catalog ? null != other.catalog : !this.catalog.equals(other.catalog)) {
                    return false;
                }
                if (null == this.schemaPattern ? null != other.schemaPattern : !this.schemaPattern.equals(other.schemaPattern)) {
                    return false;
                }
                if (null == this.tableNamePattern ? null != other.tableNamePattern : !this.tableNamePattern.equals(other.tableNamePattern)) {
                    return false;
                }
                return !(null == this.typeList ? null != other.typeList : null == other.typeList || !this.typeList.equals(other.typeList));
            }
            return false;
        }
    }

    public static class SchemasRequest
    extends Request {
        public final String connectionId;
        public final String catalog;
        public final String schemaPattern;

        SchemasRequest() {
            this.connectionId = null;
            this.catalog = null;
            this.schemaPattern = null;
        }

        @JsonCreator
        public SchemasRequest(@JsonProperty(value="connectionId") String connectionId, @JsonProperty(value="catalog") String catalog, @JsonProperty(value="schemaPattern") String schemaPattern) {
            this.connectionId = connectionId;
            this.catalog = catalog;
            this.schemaPattern = schemaPattern;
        }

        @Override
        ResultSetResponse accept(Service service) {
            return service.apply(this);
        }

        @Override
        SchemasRequest deserialize(Message genericMsg) {
            Requests.SchemasRequest msg = ProtobufService.castProtobufMessage(genericMsg, Requests.SchemasRequest.class);
            Descriptors.Descriptor desc = msg.getDescriptorForType();
            String connectionId = null;
            if (ProtobufService.hasField(msg, desc, 3)) {
                connectionId = msg.getConnectionId();
            }
            String catalog = null;
            if (ProtobufService.hasField(msg, desc, 1)) {
                catalog = msg.getCatalog();
            }
            String schemaPattern = null;
            if (ProtobufService.hasField(msg, desc, 2)) {
                schemaPattern = msg.getSchemaPattern();
            }
            return new SchemasRequest(connectionId, catalog, schemaPattern);
        }

        @Override
        Requests.SchemasRequest serialize() {
            Requests.SchemasRequest.Builder builder = Requests.SchemasRequest.newBuilder();
            if (null != this.connectionId) {
                builder.setConnectionId(this.connectionId);
            }
            if (null != this.catalog) {
                builder.setCatalog(this.catalog);
            }
            if (null != this.schemaPattern) {
                builder.setSchemaPattern(this.schemaPattern);
            }
            return builder.build();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.connectionId == null ? 0 : this.connectionId.hashCode());
            result = 31 * result + (this.catalog == null ? 0 : this.catalog.hashCode());
            result = 31 * result + (this.schemaPattern == null ? 0 : this.schemaPattern.hashCode());
            return result;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof SchemasRequest) {
                SchemasRequest other = (SchemasRequest)o;
                if (null == this.connectionId ? null != other.connectionId : !this.connectionId.equals(other.connectionId)) {
                    return false;
                }
                if (null == this.catalog ? null != other.catalog : !this.catalog.equals(other.catalog)) {
                    return false;
                }
                return !(null == this.schemaPattern ? null != other.schemaPattern : !this.catalog.equals(other.catalog));
            }
            return false;
        }
    }

    public static class DatabasePropertyRequest
    extends Request {
        public final String connectionId;

        public DatabasePropertyRequest() {
            this.connectionId = null;
        }

        @JsonCreator
        public DatabasePropertyRequest(@JsonProperty(value="connectionId") String connectionId) {
            this.connectionId = connectionId;
        }

        @Override
        DatabasePropertyResponse accept(Service service) {
            return service.apply(this);
        }

        @Override
        DatabasePropertyRequest deserialize(Message genericMsg) {
            Requests.DatabasePropertyRequest msg = ProtobufService.castProtobufMessage(genericMsg, Requests.DatabasePropertyRequest.class);
            Descriptors.Descriptor desc = msg.getDescriptorForType();
            String connectionId = null;
            if (ProtobufService.hasField(msg, desc, 1)) {
                connectionId = msg.getConnectionId();
            }
            return new DatabasePropertyRequest(connectionId);
        }

        @Override
        Requests.DatabasePropertyRequest serialize() {
            Requests.DatabasePropertyRequest.Builder builder = Requests.DatabasePropertyRequest.newBuilder();
            if (null != this.connectionId) {
                builder.setConnectionId(this.connectionId);
            }
            return builder.build();
        }

        public int hashCode() {
            return this.connectionId == null ? 0 : this.connectionId.hashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof DatabasePropertyRequest) {
                DatabasePropertyRequest other = (DatabasePropertyRequest)o;
                return !(null == this.connectionId ? null != other.connectionId : !this.connectionId.equals(other.connectionId));
            }
            return false;
        }
    }

    public static class CatalogsRequest
    extends Request {
        public final String connectionId;

        public CatalogsRequest() {
            this.connectionId = null;
        }

        @JsonCreator
        public CatalogsRequest(@JsonProperty(value="connectionId") String connectionId) {
            this.connectionId = connectionId;
        }

        @Override
        ResultSetResponse accept(Service service) {
            return service.apply(this);
        }

        @Override
        CatalogsRequest deserialize(Message genericMsg) {
            Requests.CatalogsRequest msg = ProtobufService.castProtobufMessage(genericMsg, Requests.CatalogsRequest.class);
            Descriptors.Descriptor desc = msg.getDescriptorForType();
            String connectionId = null;
            if (ProtobufService.hasField(msg, desc, 1)) {
                connectionId = msg.getConnectionId();
            }
            return new CatalogsRequest(connectionId);
        }

        @Override
        Requests.CatalogsRequest serialize() {
            Requests.CatalogsRequest.Builder builder = Requests.CatalogsRequest.newBuilder();
            if (null != this.connectionId) {
                builder.setConnectionId(this.connectionId);
            }
            return builder.build();
        }

        public int hashCode() {
            return this.connectionId == null ? 0 : this.connectionId.hashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o instanceof CatalogsRequest) {
                CatalogsRequest other = (CatalogsRequest)o;
                return !(null == this.connectionId ? null != other.connectionId : !this.connectionId.equals(other.connectionId));
            }
            return false;
        }
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="response", defaultImpl=ResultSetResponse.class)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=OpenConnectionResponse.class, name="openConnection"), @JsonSubTypes.Type(value=ResultSetResponse.class, name="resultSet"), @JsonSubTypes.Type(value=PrepareResponse.class, name="prepare"), @JsonSubTypes.Type(value=FetchResponse.class, name="fetch"), @JsonSubTypes.Type(value=CreateStatementResponse.class, name="createStatement"), @JsonSubTypes.Type(value=CloseStatementResponse.class, name="closeStatement"), @JsonSubTypes.Type(value=CloseConnectionResponse.class, name="closeConnection"), @JsonSubTypes.Type(value=ConnectionSyncResponse.class, name="connectionSync"), @JsonSubTypes.Type(value=DatabasePropertyResponse.class, name="databaseProperties"), @JsonSubTypes.Type(value=ExecuteResponse.class, name="executeResults"), @JsonSubTypes.Type(value=ErrorResponse.class, name="error"), @JsonSubTypes.Type(value=SyncResultsResponse.class, name="syncResults"), @JsonSubTypes.Type(value=RpcMetadataResponse.class, name="rpcMetadata"), @JsonSubTypes.Type(value=CommitResponse.class, name="commit"), @JsonSubTypes.Type(value=RollbackResponse.class, name="rollback"), @JsonSubTypes.Type(value=ExecuteBatchResponse.class, name="executeBatch")})
    public static abstract class Response {
        abstract Response deserialize(Message var1);

        abstract Message serialize();
    }

    @JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="request", defaultImpl=SchemasRequest.class)
    @JsonSubTypes(value={@JsonSubTypes.Type(value=CatalogsRequest.class, name="getCatalogs"), @JsonSubTypes.Type(value=SchemasRequest.class, name="getSchemas"), @JsonSubTypes.Type(value=TablesRequest.class, name="getTables"), @JsonSubTypes.Type(value=TableTypesRequest.class, name="getTableTypes"), @JsonSubTypes.Type(value=TypeInfoRequest.class, name="getTypeInfo"), @JsonSubTypes.Type(value=ColumnsRequest.class, name="getColumns"), @JsonSubTypes.Type(value=ExecuteRequest.class, name="execute"), @JsonSubTypes.Type(value=PrepareRequest.class, name="prepare"), @JsonSubTypes.Type(value=PrepareAndExecuteRequest.class, name="prepareAndExecute"), @JsonSubTypes.Type(value=FetchRequest.class, name="fetch"), @JsonSubTypes.Type(value=CreateStatementRequest.class, name="createStatement"), @JsonSubTypes.Type(value=CloseStatementRequest.class, name="closeStatement"), @JsonSubTypes.Type(value=OpenConnectionRequest.class, name="openConnection"), @JsonSubTypes.Type(value=CloseConnectionRequest.class, name="closeConnection"), @JsonSubTypes.Type(value=ConnectionSyncRequest.class, name="connectionSync"), @JsonSubTypes.Type(value=DatabasePropertyRequest.class, name="databaseProperties"), @JsonSubTypes.Type(value=SyncResultsRequest.class, name="syncResults"), @JsonSubTypes.Type(value=CommitRequest.class, name="commit"), @JsonSubTypes.Type(value=RollbackRequest.class, name="rollback"), @JsonSubTypes.Type(value=PrepareAndExecuteBatchRequest.class, name="prepareAndExecuteBatch"), @JsonSubTypes.Type(value=ExecuteBatchRequest.class, name="executeBatch")})
    public static abstract class Request {
        abstract Response accept(Service var1);

        abstract Request deserialize(Message var1);

        abstract Message serialize();
    }

    public static interface Factory {
        public Service create(AvaticaConnection var1);
    }
}

