/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.TableNotFoundException;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.regionserver.LocalIndexSplitter;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PNameFactory;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.SaltingUtil;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.IndexUtil;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.SchemaUtil;
import org.apache.phoenix.util.ServerUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UpgradeUtil {
    private static final Logger logger = LoggerFactory.getLogger(UpgradeUtil.class);
    private static final byte[] SEQ_PREFIX_BYTES = ByteUtil.concat(QueryConstants.SEPARATOR_BYTE_ARRAY, new byte[][]{Bytes.toBytes("_SEQ_")});

    private UpgradeUtil() {
    }

    private static byte[] getSequenceSnapshotName() {
        return Bytes.toBytes("_BAK_" + PhoenixDatabaseMetaData.SEQUENCE_FULLNAME);
    }

    private static void createSequenceSnapshot(HBaseAdmin admin, PhoenixConnection conn) throws SQLException {
        byte[] tableName = UpgradeUtil.getSequenceSnapshotName();
        HColumnDescriptor columnDesc = new HColumnDescriptor(PhoenixDatabaseMetaData.SEQUENCE_FAMILY_BYTES);
        HTableDescriptor desc = new HTableDescriptor(TableName.valueOf(tableName));
        desc.addFamily(columnDesc);
        try {
            admin.createTable(desc);
            UpgradeUtil.copyTable(conn, PhoenixDatabaseMetaData.SEQUENCE_FULLNAME_BYTES, tableName);
        }
        catch (IOException e) {
            throw ServerUtil.parseServerException(e);
        }
    }

    private static void restoreSequenceSnapshot(HBaseAdmin admin, PhoenixConnection conn) throws SQLException {
        byte[] tableName = UpgradeUtil.getSequenceSnapshotName();
        UpgradeUtil.copyTable(conn, tableName, PhoenixDatabaseMetaData.SEQUENCE_FULLNAME_BYTES);
    }

    private static void deleteSequenceSnapshot(HBaseAdmin admin) throws SQLException {
        byte[] tableName = UpgradeUtil.getSequenceSnapshotName();
        try {
            admin.disableTable(tableName);
            admin.deleteTable(tableName);
        }
        catch (IOException e) {
            throw ServerUtil.parseServerException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void copyTable(PhoenixConnection conn, byte[] sourceName, byte[] targetName) throws SQLException {
        batchSizeBytes = 102400;
        sizeBytes = 0;
        mutations = Lists.newArrayListWithExpectedSize(10000);
        scan = new Scan();
        scan.setRaw(true);
        scan.setMaxVersions(1000);
        scanner = null;
        source = null;
        target = null;
        try {
            source = conn.getQueryServices().getTable(sourceName);
            target = conn.getQueryServices().getTable(targetName);
            scanner = source.getScanner(scan);
lbl16:
            // 3 sources

            while (true) {
                result = scanner.next();
                if (result == null) {
                    if (!mutations.isEmpty()) {
                        UpgradeUtil.logger.info("Committing last bactch of temp rows");
                        target.batch(mutations);
                    }
                    UpgradeUtil.logger.info("Successfully completed copy");
                    return;
                }
                var11_16 = result.raw();
                var12_17 = var11_16.length;
                break;
            }
        }
        catch (SQLException e) {
            throw e;
        }
        catch (Exception e) {
            throw ServerUtil.parseServerException(e);
        }
        finally {
            try {
                if (scanner != null) {
                    scanner.close();
                }
            }
            finally {
                try {
                    if (source != null) {
                        source.close();
                    }
                }
                catch (IOException e) {
                    UpgradeUtil.logger.warn("Exception during close of source table", e);
                }
                finally {
                    try {
                        if (target != null) {
                            target.close();
                        }
                    }
                    catch (IOException e) {
                        UpgradeUtil.logger.warn("Exception during close of target table", e);
                    }
                }
            }
        }
        for (var13_18 = 0; var13_18 < var12_17; ++var13_18) {
            keyValue = var11_16[var13_18];
            sizeBytes += keyValue.getLength();
            if (KeyValue.Type.codeToType(keyValue.getType()) == KeyValue.Type.Put) {
                put = new Put(keyValue.getRow());
                put.add(keyValue);
                mutations.add(put);
                continue;
            }
            if (KeyValue.Type.codeToType(keyValue.getType()) != KeyValue.Type.Delete) continue;
            delete = new Delete(keyValue.getRow());
            delete.addDeleteMarker(keyValue);
            mutations.add(delete);
        }
        if (sizeBytes < batchSizeBytes) ** GOTO lbl16
        UpgradeUtil.logger.info("Committing bactch of temp rows");
        target.batch(mutations);
        mutations.clear();
        sizeBytes = 0;
        ** while (true)
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void preSplitSequenceTable(PhoenixConnection conn, int nSaltBuckets) throws SQLException {
        HBaseAdmin admin = conn.getQueryServices().getAdmin();
        boolean snapshotCreated = false;
        boolean success = false;
        try {
            if (nSaltBuckets <= 0) {
                return;
            }
            logger.warn("Pre-splitting SYSTEM.SEQUENCE table " + nSaltBuckets + "-ways. This may take some time - please do not close window.");
            HTableDescriptor desc = admin.getTableDescriptor(PhoenixDatabaseMetaData.SEQUENCE_FULLNAME_BYTES);
            UpgradeUtil.createSequenceSnapshot(admin, conn);
            snapshotCreated = true;
            admin.disableTable(PhoenixDatabaseMetaData.SEQUENCE_FULLNAME);
            admin.deleteTable(PhoenixDatabaseMetaData.SEQUENCE_FULLNAME);
            byte[][] splitPoints = SaltingUtil.getSalteByteSplitPoints(nSaltBuckets);
            admin.createTable(desc, splitPoints);
            UpgradeUtil.restoreSequenceSnapshot(admin, conn);
            success = true;
            logger.warn("Completed pre-splitting SYSTEM.SEQUENCE table");
        }
        catch (IOException e) {
            throw new SQLException("Unable to pre-split SYSTEM.SEQUENCE table", e);
        }
        finally {
            try {
                if (snapshotCreated && success) {
                    try {
                        UpgradeUtil.deleteSequenceSnapshot(admin);
                    }
                    catch (SQLException e) {
                        logger.warn("Exception while deleting SYSTEM.SEQUENCE snapshot during pre-split", e);
                    }
                }
            }
            finally {
                try {
                    admin.close();
                }
                catch (IOException e) {
                    logger.warn("Exception while closing admin during pre-split", e);
                }
            }
        }
    }

    /*
     * Exception decompiling
     */
    public static boolean upgradeSequenceTable(PhoenixConnection conn, int nSaltBuckets, PTable oldTable) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void upgradeLocalIndexes(PhoenixConnection metaConnection) throws SQLException, IOException, TableNotFoundException {
        try (HBaseAdmin admin = null;){
            admin = metaConnection.getQueryServices().getAdmin();
            ResultSet rs = metaConnection.createStatement().executeQuery("SELECT TABLE_SCHEM, TABLE_NAME, DATA_TABLE_NAME FROM SYSTEM.CATALOG        WHERE COLUMN_NAME IS NULL           AND COLUMN_FAMILY IS NULL           AND INDEX_TYPE=2");
            boolean droppedLocalIndexes = false;
            while (rs.next()) {
                int i;
                if (!droppedLocalIndexes) {
                    HTableDescriptor[] localIndexTables = admin.listTables("_LOCAL_IDX_.*");
                    String localIndexSplitter = LocalIndexSplitter.class.getName();
                    for (HTableDescriptor table : localIndexTables) {
                        HTableDescriptor dataTableDesc = admin.getTableDescriptor(TableName.valueOf(MetaDataUtil.getUserTableName(table.getNameAsString())));
                        HColumnDescriptor[] columnFamilies = dataTableDesc.getColumnFamilies();
                        boolean modifyTable = false;
                        for (HColumnDescriptor cf : columnFamilies) {
                            String localIndexCf = "L#" + cf.getNameAsString();
                            if (dataTableDesc.getFamily(Bytes.toBytes(localIndexCf)) != null) continue;
                            HColumnDescriptor colDef = new HColumnDescriptor(localIndexCf);
                            for (Map.Entry<ImmutableBytesWritable, ImmutableBytesWritable> keyValue : cf.getValues().entrySet()) {
                                colDef.setValue(keyValue.getKey().copyBytes(), keyValue.getValue().copyBytes());
                            }
                            dataTableDesc.addFamily(colDef);
                            modifyTable = true;
                        }
                        List<String> coprocessors = dataTableDesc.getCoprocessors();
                        for (String coprocessor : coprocessors) {
                            if (!coprocessor.equals(localIndexSplitter)) continue;
                            dataTableDesc.removeCoprocessor(localIndexSplitter);
                            modifyTable = true;
                        }
                        if (!modifyTable) continue;
                        admin.modifyTable(dataTableDesc.getName(), dataTableDesc);
                    }
                    admin.disableTables("_LOCAL_IDX_.*");
                    admin.deleteTables("_LOCAL_IDX_.*");
                    droppedLocalIndexes = true;
                }
                String getColumns = "SELECT COLUMN_NAME, COLUMN_FAMILY FROM SYSTEM.CATALOG  WHERE TABLE_SCHEM " + (rs.getString(1) == null ? "IS NULL " : "='" + rs.getString(1) + "'") + " and TABLE_NAME='" + rs.getString(2) + "' AND COLUMN_NAME IS NOT NULL";
                ResultSet getColumnsRs = metaConnection.createStatement().executeQuery(getColumns);
                ArrayList<String> indexedColumns = new ArrayList<String>(1);
                ArrayList<String> coveredColumns = new ArrayList<String>(1);
                while (getColumnsRs.next()) {
                    String column = getColumnsRs.getString(1);
                    String columnName = IndexUtil.getDataColumnName(column);
                    if (columnName.equals(MetaDataUtil.getViewIndexIdColumnName())) continue;
                    String columnFamily = IndexUtil.getDataColumnFamilyName(column);
                    if (getColumnsRs.getString(2) == null) {
                        if (columnFamily == null || columnFamily.isEmpty()) continue;
                        if (columnFamily.equals("0")) {
                            indexedColumns.add(columnName);
                            continue;
                        }
                        indexedColumns.add(SchemaUtil.getColumnName(columnFamily, columnName));
                        continue;
                    }
                    coveredColumns.add(SchemaUtil.getColumnName(columnFamily, columnName));
                }
                StringBuilder createIndex = new StringBuilder("CREATE LOCAL INDEX ");
                createIndex.append(rs.getString(2));
                createIndex.append(" ON ");
                createIndex.append(SchemaUtil.getTableName(rs.getString(1), rs.getString(3)));
                createIndex.append("(");
                for (i = 0; i < indexedColumns.size(); ++i) {
                    createIndex.append((String)indexedColumns.get(i));
                    if (i >= indexedColumns.size() - 1) continue;
                    createIndex.append(",");
                }
                createIndex.append(")");
                if (!coveredColumns.isEmpty()) {
                    createIndex.append(" INCLUDE(");
                    for (i = 0; i < coveredColumns.size(); ++i) {
                        createIndex.append((String)coveredColumns.get(i));
                        if (i >= coveredColumns.size() - 1) continue;
                        createIndex.append(",");
                    }
                    createIndex.append(")");
                }
                logger.info("Index creation query is : " + createIndex.toString());
                logger.info("Dropping the index " + rs.getString(2) + " to clean up the index details from SYSTEM.CATALOG.");
                metaConnection.createStatement().execute("DROP INDEX IF EXISTS " + rs.getString(2) + " ON " + SchemaUtil.getTableName(rs.getString(1), rs.getString(3)));
                logger.info("Recreating the index " + rs.getString(2));
                metaConnection.createStatement().execute(createIndex.toString());
                logger.info("Created the index " + rs.getString(2));
            }
            metaConnection.createStatement().execute("DELETE FROM SYSTEM.CATALOG WHERE SUBSTR(TABLE_NAME,0,11)='_LOCAL_IDX_'");
        }
    }

    private static KeyValue addSaltByte(KeyValue keyValue, int nSaltBuckets) {
        byte[] newBuf;
        boolean isViewSeq;
        byte[] buf = keyValue.getBuffer();
        int length = keyValue.getRowLength();
        int offset = keyValue.getRowOffset();
        boolean bl = isViewSeq = length > SEQ_PREFIX_BYTES.length && Bytes.compareTo(SEQ_PREFIX_BYTES, 0, SEQ_PREFIX_BYTES.length, buf, offset, SEQ_PREFIX_BYTES.length) == 0;
        if (!isViewSeq && nSaltBuckets == 0) {
            return null;
        }
        if (isViewSeq) {
            if (buf[length - 1] == 0) {
                --length;
            }
            byte[][] rowKeyMetaData = new byte[3][];
            SchemaUtil.getVarChars(buf, offset, length, 0, rowKeyMetaData);
            byte[] schemaName = rowKeyMetaData[1];
            byte[] unprefixedSchemaName = new byte[schemaName.length - MetaDataUtil.VIEW_INDEX_SEQUENCE_PREFIX_BYTES.length];
            System.arraycopy(schemaName, MetaDataUtil.VIEW_INDEX_SEQUENCE_PREFIX_BYTES.length, unprefixedSchemaName, 0, unprefixedSchemaName.length);
            byte[] tableName = rowKeyMetaData[2];
            PName physicalName = PNameFactory.newName(unprefixedSchemaName);
            newBuf = MetaDataUtil.getViewIndexSequenceKey(tableName == null ? null : Bytes.toString(tableName), physicalName, nSaltBuckets).getKey();
        } else {
            newBuf = new byte[length + 1];
            System.arraycopy(buf, offset, newBuf, 1, length);
            newBuf[0] = SaltingUtil.getSaltingByte(newBuf, 1, length, nSaltBuckets);
        }
        return new KeyValue(newBuf, 0, newBuf.length, buf, keyValue.getFamilyOffset(), keyValue.getFamilyLength(), buf, keyValue.getQualifierOffset(), keyValue.getQualifierLength(), keyValue.getTimestamp(), KeyValue.Type.codeToType(keyValue.getType()), buf, keyValue.getValueOffset(), keyValue.getValueLength());
    }
}

