/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import com.google.common.math.LongMath;
import java.sql.SQLException;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.schema.SequenceInfo;

public class SequenceUtil {
    public static boolean checkIfLimitReached(long currentValue, long minValue, long maxValue, long incrementBy, long cacheSize) throws SQLException {
        long nextValue = 0L;
        boolean increasingSeq = incrementBy > 0L;
        try {
            long incrementValue = LongMath.checkedMultiply(incrementBy, cacheSize);
            nextValue = LongMath.checkedAdd(currentValue, incrementValue);
        }
        catch (ArithmeticException e) {
            return true;
        }
        return increasingSeq && nextValue > maxValue || !increasingSeq && nextValue < minValue;
    }

    public static boolean checkIfLimitReached(SequenceInfo info) throws SQLException {
        return SequenceUtil.checkIfLimitReached(info.sequenceValue, info.minValue, info.maxValue, info.incrementBy, info.cacheSize);
    }

    public static SQLException getException(String schemaName, String tableName, SQLExceptionCode code) {
        return new SQLExceptionInfo.Builder(code).setSchemaName(schemaName).setTableName(tableName).build().buildException();
    }
}

