/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Properties;
import javax.annotation.Nullable;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.encoding.DataBlockEncoding;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.jdbc.PhoenixConnection;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.query.KeyRange;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.AmbiguousColumnException;
import org.apache.phoenix.schema.ColumnFamilyNotFoundException;
import org.apache.phoenix.schema.ColumnNotFoundException;
import org.apache.phoenix.schema.PColumn;
import org.apache.phoenix.schema.PColumnFamily;
import org.apache.phoenix.schema.PDatum;
import org.apache.phoenix.schema.PMetaData;
import org.apache.phoenix.schema.PName;
import org.apache.phoenix.schema.PTable;
import org.apache.phoenix.schema.RowKeySchema;
import org.apache.phoenix.schema.SaltingUtil;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.ValueSchema;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.schema.types.PVarbinary;
import org.apache.phoenix.schema.types.PVarchar;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.StringUtil;

public class SchemaUtil {
    private static final int VAR_LENGTH_ESTIMATE = 10;
    private static final int VAR_KV_LENGTH_ESTIMATE = 50;
    public static final String ESCAPE_CHARACTER = "\"";
    public static final DataBlockEncoding DEFAULT_DATA_BLOCK_ENCODING = DataBlockEncoding.FAST_DIFF;
    public static final PDatum VAR_BINARY_DATUM = new PDatum(){

        @Override
        public boolean isNullable() {
            return false;
        }

        @Override
        public PDataType getDataType() {
            return PVarbinary.INSTANCE;
        }

        @Override
        public Integer getMaxLength() {
            return null;
        }

        @Override
        public Integer getScale() {
            return null;
        }

        @Override
        public SortOrder getSortOrder() {
            return SortOrder.getDefault();
        }
    };
    public static final RowKeySchema VAR_BINARY_SCHEMA = new RowKeySchema.RowKeySchemaBuilder(1).addField(VAR_BINARY_DATUM, false, SortOrder.getDefault()).build();

    private SchemaUtil() {
    }

    public static boolean isPKColumn(PColumn column) {
        return column.getFamilyName() == null;
    }

    public static long estimateRowSize(PTable table) {
        int keyLength = SchemaUtil.estimateKeyLength(table);
        long rowSize = 0L;
        for (PColumn column : table.getColumns()) {
            if (SchemaUtil.isPKColumn(column)) continue;
            PDataType type = column.getDataType();
            Integer maxLength = column.getMaxLength();
            int valueLength = !type.isFixedWidth() ? 50 : (maxLength == null ? type.getByteSize() : maxLength);
            rowSize += KeyValue.getKeyValueDataStructureSize(keyLength, column.getFamilyName().getBytes().length, column.getName().getBytes().length, valueLength);
        }
        return rowSize += KeyValue.getKeyValueDataStructureSize(keyLength, SchemaUtil.getEmptyColumnFamily(table).length, QueryConstants.EMPTY_COLUMN_BYTES.length, 0);
    }

    public static int estimateKeyLength(PTable table) {
        int maxKeyLength = 0;
        int i = 0;
        List<PColumn> columns = table.getPKColumns();
        while (i < columns.size()) {
            PColumn keyColumn = columns.get(i++);
            PDataType type = keyColumn.getDataType();
            Integer maxLength = keyColumn.getMaxLength();
            maxKeyLength += !type.isFixedWidth() ? 10 : (maxLength == null ? type.getByteSize() : maxLength);
        }
        return maxKeyLength;
    }

    public static String normalizeIdentifier(String name) {
        if (name == null) {
            return name;
        }
        if (SchemaUtil.isCaseSensitive(name)) {
            return name.substring(1, name.length() - 1);
        }
        return name.toUpperCase();
    }

    public static String normalizeFullTableName(String fullTableName) {
        String schemaName = SchemaUtil.getSchemaNameFromFullName(fullTableName);
        String tableName = SchemaUtil.getTableNameFromFullName(fullTableName);
        String normalizedTableName = "";
        if (!schemaName.isEmpty()) {
            normalizedTableName = SchemaUtil.normalizeIdentifier(schemaName) + ".";
        }
        return normalizedTableName + SchemaUtil.normalizeIdentifier(tableName);
    }

    public static boolean isCaseSensitive(String name) {
        return name != null && name.length() > 0 && name.charAt(0) == '\"';
    }

    public static <T> List<T> concat(List<T> l1, List<T> l2) {
        int size1 = l1.size();
        if (size1 == 0) {
            return l2;
        }
        int size2 = l2.size();
        if (size2 == 0) {
            return l1;
        }
        ArrayList<T> l3 = new ArrayList<T>(size1 + size2);
        l3.addAll(l1);
        l3.addAll(l2);
        return l3;
    }

    public static byte[] getTableKey(byte[] tenantId, byte[] schemaName, byte[] tableName) {
        return ByteUtil.concat(tenantId, QueryConstants.SEPARATOR_BYTE_ARRAY, schemaName, QueryConstants.SEPARATOR_BYTE_ARRAY, tableName);
    }

    public static byte[] getFunctionKey(byte[] tenantId, byte[] functionName) {
        return ByteUtil.concat(tenantId, QueryConstants.SEPARATOR_BYTE_ARRAY, functionName);
    }

    public static byte[] getTableKey(String tenantId, String schemaName, String tableName) {
        return ByteUtil.concat(tenantId == null ? ByteUtil.EMPTY_BYTE_ARRAY : Bytes.toBytes(tenantId), QueryConstants.SEPARATOR_BYTE_ARRAY, schemaName == null ? ByteUtil.EMPTY_BYTE_ARRAY : Bytes.toBytes(schemaName), QueryConstants.SEPARATOR_BYTE_ARRAY, Bytes.toBytes(tableName));
    }

    public static String getTableName(String schemaName, String tableName) {
        return SchemaUtil.getName(schemaName, tableName, false);
    }

    private static String getName(String optionalQualifier, String name, boolean caseSensitive) {
        String cq;
        String string = cq = caseSensitive ? ESCAPE_CHARACTER + name + ESCAPE_CHARACTER : name;
        if (optionalQualifier == null || optionalQualifier.isEmpty()) {
            return cq;
        }
        String cf = caseSensitive ? ESCAPE_CHARACTER + optionalQualifier + ESCAPE_CHARACTER : optionalQualifier;
        return cf + "." + cq;
    }

    public static String getTableName(byte[] schemaName, byte[] tableName) {
        return SchemaUtil.getName(schemaName, tableName);
    }

    public static String getColumnDisplayName(byte[] cf, byte[] cq) {
        return SchemaUtil.getName(cf == null || cf.length == 0 ? ByteUtil.EMPTY_BYTE_ARRAY : cf, cq);
    }

    public static String getColumnDisplayName(String cf, String cq) {
        return SchemaUtil.getName(cf == null || cf.isEmpty() ? null : cf, cq, false);
    }

    public static String getCaseSensitiveColumnDisplayName(String cf, String cq) {
        return SchemaUtil.getName(cf == null || cf.isEmpty() ? null : cf, cq, true);
    }

    public static String getMetaDataEntityName(String schemaName, String tableName, String familyName, String columnName) {
        if ((schemaName == null || schemaName.isEmpty()) && (tableName == null || tableName.isEmpty())) {
            return SchemaUtil.getName(familyName, columnName, false);
        }
        if ((familyName == null || familyName.isEmpty()) && (columnName == null || columnName.isEmpty())) {
            return SchemaUtil.getName(schemaName, tableName, false);
        }
        return SchemaUtil.getName(SchemaUtil.getName(schemaName, tableName, false), SchemaUtil.getName(familyName, columnName, false), false);
    }

    public static String getColumnName(String familyName, String columnName) {
        return SchemaUtil.getName(familyName, columnName, false);
    }

    public static byte[] getTableNameAsBytes(String schemaName, String tableName) {
        if (schemaName == null || schemaName.length() == 0) {
            return StringUtil.toBytes(tableName);
        }
        return SchemaUtil.getTableNameAsBytes(StringUtil.toBytes(schemaName), StringUtil.toBytes(tableName));
    }

    public static byte[] getTableNameAsBytes(byte[] schemaName, byte[] tableName) {
        return SchemaUtil.getNameAsBytes(schemaName, tableName);
    }

    private static byte[] getNameAsBytes(byte[] nameOne, byte[] nameTwo) {
        if (nameOne == null || nameOne.length == 0) {
            return nameTwo;
        }
        if (nameTwo == null || nameTwo.length == 0) {
            return nameOne;
        }
        return ByteUtil.concat(nameOne, QueryConstants.NAME_SEPARATOR_BYTES, nameTwo);
    }

    public static String getName(byte[] nameOne, byte[] nameTwo) {
        return Bytes.toString(SchemaUtil.getNameAsBytes(nameOne, nameTwo));
    }

    public static int getVarCharLength(byte[] buf, int keyOffset, int maxLength) {
        return SchemaUtil.getVarCharLength(buf, keyOffset, maxLength, 1);
    }

    public static int getVarCharLength(byte[] buf, int keyOffset, int maxLength, int skipCount) {
        int length = 0;
        for (int i = 0; i < skipCount; ++i) {
            while (length < maxLength && buf[keyOffset + length] != 0) {
                ++length;
            }
            if (i == skipCount - 1) continue;
            ++length;
        }
        return length;
    }

    public static int getVarChars(byte[] rowKey, byte[][] rowKeyMetadata) {
        return SchemaUtil.getVarChars(rowKey, 0, rowKey.length, 0, rowKeyMetadata);
    }

    public static int getVarChars(byte[] rowKey, int colMetaDataLength, byte[][] colMetaData) {
        return SchemaUtil.getVarChars(rowKey, 0, rowKey.length, 0, colMetaDataLength, colMetaData);
    }

    public static int getVarChars(byte[] rowKey, int keyOffset, int keyLength, int colMetaDataOffset, byte[][] colMetaData) {
        return SchemaUtil.getVarChars(rowKey, keyOffset, keyLength, colMetaDataOffset, colMetaData.length, colMetaData);
    }

    public static int getVarChars(byte[] rowKey, int keyOffset, int keyLength, int colMetaDataOffset, int colMetaDataLength, byte[][] colMetaData) {
        int i;
        int length;
        int offset = keyOffset;
        for (i = colMetaDataOffset; i < colMetaDataLength && keyLength > 0; keyLength -= length + 1, ++i) {
            length = SchemaUtil.getVarCharLength(rowKey, offset, keyLength);
            byte[] b = new byte[length];
            System.arraycopy(rowKey, offset, b, 0, length);
            offset += length + 1;
            colMetaData[i] = b;
        }
        return i;
    }

    public static String findExistingColumn(PTable table, List<PColumn> columns) {
        for (PColumn column : columns) {
            PName familyName = column.getFamilyName();
            if (familyName == null) {
                try {
                    return table.getPKColumn(column.getName().getString()).getName().getString();
                }
                catch (ColumnNotFoundException e) {
                    continue;
                }
            }
            try {
                return table.getColumnFamily(familyName.getString()).getColumn(column.getName().getString()).getName().getString();
            }
            catch (ColumnFamilyNotFoundException e) {
            }
            catch (ColumnNotFoundException e) {
            }
        }
        return null;
    }

    public static String toString(byte[][] values) {
        if (values == null) {
            return "null";
        }
        StringBuilder buf = new StringBuilder("[");
        for (byte[] value : values) {
            buf.append(Bytes.toStringBinary(value));
            buf.append(',');
        }
        buf.setCharAt(buf.length() - 1, ']');
        return buf.toString();
    }

    public static String toString(PDataType type, byte[] value) {
        boolean isString = type.isCoercibleTo(PVarchar.INSTANCE);
        return isString ? "'" + type.toObject(value).toString() + "'" : type.toObject(value).toString();
    }

    public static byte[] getEmptyColumnFamily(PName defaultColumnFamily, List<PColumnFamily> families) {
        return families.isEmpty() ? (defaultColumnFamily == null ? QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES : defaultColumnFamily.getBytes()) : families.get(0).getName().getBytes();
    }

    public static byte[] getEmptyColumnFamily(PTable table) {
        return SchemaUtil.getEmptyColumnFamily(table.getDefaultFamilyName(), table.getColumnFamilies());
    }

    public static String getEmptyColumnFamilyAsString(PTable table) {
        List<PColumnFamily> families = table.getColumnFamilies();
        return families.isEmpty() ? (table.getDefaultFamilyName() == null ? "0" : table.getDefaultFamilyName().getString()) : families.get(0).getName().getString();
    }

    public static ImmutableBytesPtr getEmptyColumnFamilyPtr(PTable table) {
        List<PColumnFamily> families = table.getColumnFamilies();
        return families.isEmpty() ? (table.getDefaultFamilyName() == null ? QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES_PTR : table.getDefaultFamilyName().getBytesPtr()) : families.get(0).getName().getBytesPtr();
    }

    public static boolean isMetaTable(byte[] tableName) {
        return Bytes.compareTo(tableName, PhoenixDatabaseMetaData.SYSTEM_CATALOG_NAME_BYTES) == 0;
    }

    public static boolean isFunctionTable(byte[] tableName) {
        return Bytes.compareTo(tableName, PhoenixDatabaseMetaData.SYSTEM_FUNCTION_NAME_BYTES) == 0;
    }

    public static boolean isStatsTable(byte[] tableName) {
        return Bytes.compareTo(tableName, PhoenixDatabaseMetaData.SYSTEM_STATS_NAME_BYTES) == 0;
    }

    public static boolean isSequenceTable(byte[] tableName) {
        return Bytes.compareTo(tableName, PhoenixDatabaseMetaData.SEQUENCE_FULLNAME_BYTES) == 0;
    }

    public static boolean isSequenceTable(PTable table) {
        return PhoenixDatabaseMetaData.SEQUENCE_FULLNAME.equals(table.getName().getString());
    }

    public static boolean isMetaTable(PTable table) {
        return "SYSTEM".equals(table.getSchemaName().getString()) && "CATALOG".equals(table.getTableName().getString());
    }

    public static boolean isMetaTable(byte[] schemaName, byte[] tableName) {
        return Bytes.compareTo(schemaName, PhoenixDatabaseMetaData.SYSTEM_CATALOG_SCHEMA_BYTES) == 0 && Bytes.compareTo(tableName, PhoenixDatabaseMetaData.SYSTEM_CATALOG_TABLE_BYTES) == 0;
    }

    public static boolean isMetaTable(String schemaName, String tableName) {
        return "SYSTEM".equals(schemaName) && "CATALOG".equals(tableName);
    }

    public static boolean isSystemTable(byte[] fullTableName) {
        String schemaName = SchemaUtil.getSchemaNameFromFullName(fullTableName);
        return "SYSTEM".equals(schemaName);
    }

    public static byte[][] processSplits(byte[][] splits, LinkedHashSet<PColumn> pkColumns, Integer saltBucketNum, boolean defaultRowKeyOrder) throws SQLException {
        if (splits == null) {
            return null;
        }
        if (splits.length > 0 && saltBucketNum != null && defaultRowKeyOrder) {
            throw new SQLExceptionInfo.Builder(SQLExceptionCode.NO_SPLITS_ON_SALTED_TABLE).build().buildException();
        }
        if (splits.length == 0 && saltBucketNum != null) {
            splits = SaltingUtil.getSalteByteSplitPoints(saltBucketNum);
        }
        byte[][] newSplits = new byte[splits.length][];
        for (int i = 0; i < splits.length; ++i) {
            newSplits[i] = SchemaUtil.processSplit(splits[i], pkColumns);
        }
        return newSplits;
    }

    private static byte[] processSplit(byte[] split, LinkedHashSet<PColumn> pkColumns) {
        int pos = 0;
        int offset = 0;
        int maxOffset = split.length;
        Iterator<PColumn> iterator = pkColumns.iterator();
        while (pos < pkColumns.size()) {
            PColumn column = (PColumn)iterator.next();
            if (column.getDataType().isFixedWidth()) {
                int length = SchemaUtil.getFixedByteSize(column);
                if (maxOffset - offset < length) {
                    int fillInLength = length - (maxOffset - offset);
                    return ByteUtil.fillKey(split, split.length + (fillInLength += SchemaUtil.estimatePartLength(pos + 1, iterator)));
                }
                offset += length;
                ++pos;
                continue;
            }
            if (pos == pkColumns.size() - 1) break;
            while (offset < maxOffset && split[offset] != 0) {
                ++offset;
            }
            if (offset == maxOffset) {
                int fillInLength = 1;
                return ByteUtil.fillKey(split, split.length + (fillInLength += SchemaUtil.estimatePartLength(pos + 1, iterator)));
            }
            ++offset;
            ++pos;
        }
        return split;
    }

    private static int estimatePartLength(int pos, Iterator<PColumn> iterator) {
        int length = 0;
        while (iterator.hasNext()) {
            PColumn column = iterator.next();
            if (column.getDataType().isFixedWidth()) {
                length += SchemaUtil.getFixedByteSize(column);
                continue;
            }
            ++length;
        }
        return length;
    }

    public static String getEscapedTableName(String schemaName, String tableName) {
        if (schemaName == null || schemaName.length() == 0) {
            return ESCAPE_CHARACTER + tableName + ESCAPE_CHARACTER;
        }
        return ESCAPE_CHARACTER + schemaName + "\".\"" + tableName + ESCAPE_CHARACTER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static PhoenixConnection addMetaDataColumn(PhoenixConnection conn, long scn, String columnDef) throws SQLException {
        String url = conn.getURL();
        Properties props = conn.getClientInfo();
        PMetaData metaData = conn.getMetaDataCache();
        props.setProperty("CurrentSCN", Long.toString(scn));
        Statement stmt = null;
        try (PhoenixConnection metaConnection = null;){
            PhoenixConnection phoenixConnection;
            block8: {
                metaConnection = new PhoenixConnection(conn.getQueryServices(), url, props, metaData);
                try {
                    stmt = metaConnection.createStatement();
                    stmt.executeUpdate("ALTER TABLE SYSTEM.\"TABLE\" ADD IF NOT EXISTS " + columnDef);
                    phoenixConnection = metaConnection;
                    if (stmt == null) break block8;
                }
                catch (Throwable throwable) {
                    if (stmt != null) {
                        stmt.close();
                    }
                    throw throwable;
                }
                stmt.close();
            }
            return phoenixConnection;
        }
    }

    public static boolean columnExists(PTable table, String columnName) {
        try {
            table.getColumn(columnName);
            return true;
        }
        catch (ColumnNotFoundException e) {
            return false;
        }
        catch (AmbiguousColumnException e) {
            return true;
        }
    }

    public static String getSchemaNameFromFullName(String tableName) {
        int index = tableName.indexOf(".");
        if (index < 0) {
            return "";
        }
        return tableName.substring(0, index);
    }

    private static int indexOf(byte[] bytes, byte b) {
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] != b) continue;
            return i;
        }
        return -1;
    }

    public static String getSchemaNameFromFullName(byte[] tableName) {
        if (tableName == null) {
            return null;
        }
        int index = SchemaUtil.indexOf(tableName, QueryConstants.NAME_SEPARATOR_BYTE);
        if (index < 0) {
            return "";
        }
        return Bytes.toString(tableName, 0, index);
    }

    public static String getTableNameFromFullName(byte[] tableName) {
        if (tableName == null) {
            return null;
        }
        int index = SchemaUtil.indexOf(tableName, QueryConstants.NAME_SEPARATOR_BYTE);
        if (index < 0) {
            return Bytes.toString(tableName);
        }
        return Bytes.toString(tableName, index + 1, tableName.length - index - 1);
    }

    public static String getTableNameFromFullName(String tableName) {
        int index = tableName.indexOf(".");
        if (index < 0) {
            return tableName;
        }
        return tableName.substring(index + 1, tableName.length());
    }

    public static byte[] getTableKeyFromFullName(String fullTableName) {
        int index = fullTableName.indexOf(".");
        if (index < 0) {
            return SchemaUtil.getTableKey(null, null, fullTableName);
        }
        String schemaName = fullTableName.substring(0, index);
        String tableName = fullTableName.substring(index + 1);
        return SchemaUtil.getTableKey(null, schemaName, tableName);
    }

    private static int getTerminatorCount(RowKeySchema schema) {
        int nTerminators = 0;
        for (int i = 0; i < schema.getFieldCount(); ++i) {
            ValueSchema.Field field = schema.getField(i);
            if (field.getDataType().isFixedWidth()) continue;
            ++nTerminators;
        }
        return nTerminators;
    }

    public static int getMaxKeyLength(RowKeySchema schema, List<List<KeyRange>> slots) {
        int maxKeyLength = SchemaUtil.getTerminatorCount(schema);
        for (List<KeyRange> slot : slots) {
            int maxSlotLength = 0;
            for (KeyRange range : slot) {
                int maxRangeLength = Math.max(range.getLowerRange().length, range.getUpperRange().length);
                if (maxSlotLength >= maxRangeLength) continue;
                maxSlotLength = maxRangeLength;
            }
            maxKeyLength += maxSlotLength;
        }
        return maxKeyLength;
    }

    public static int getFixedByteSize(PDatum e) {
        assert (e.getDataType().isFixedWidth());
        Integer maxLength = e.getMaxLength();
        return maxLength == null ? e.getDataType().getByteSize() : maxLength;
    }

    public static short getMaxKeySeq(PTable table) {
        int offset = 0;
        if (table.getBucketNum() != null) {
            ++offset;
        }
        return (short)(table.getPKColumns().size() - offset);
    }

    public static int getPKPosition(PTable table, PColumn column) {
        return table.getPKColumns().indexOf(column);
    }

    public static String getEscapedFullColumnName(String fullColumnName) {
        if (fullColumnName.startsWith(ESCAPE_CHARACTER)) {
            return fullColumnName;
        }
        int index = fullColumnName.indexOf(".");
        if (index < 0) {
            return SchemaUtil.getEscapedArgument(fullColumnName);
        }
        String columnFamily = fullColumnName.substring(0, index);
        String columnName = fullColumnName.substring(index + 1);
        return SchemaUtil.getEscapedArgument(columnFamily) + "." + SchemaUtil.getEscapedArgument(columnName);
    }

    public static String getEscapedFullTableName(String fullTableName) {
        String schemaName = SchemaUtil.getSchemaNameFromFullName(fullTableName);
        String tableName = SchemaUtil.getTableNameFromFullName(fullTableName);
        return SchemaUtil.getEscapedTableName(schemaName, tableName);
    }

    public static String getEscapedArgument(String argument) {
        Preconditions.checkNotNull(argument, "Argument passed cannot be null");
        return ESCAPE_CHARACTER + argument + ESCAPE_CHARACTER;
    }

    public static String getQuotedFullColumnName(PColumn pCol) {
        Preconditions.checkNotNull(pCol);
        String columnName = pCol.getName().getString();
        String columnFamilyName = pCol.getFamilyName() != null ? pCol.getFamilyName().getString() : null;
        return SchemaUtil.getQuotedFullColumnName(columnFamilyName, columnName);
    }

    public static String getQuotedFullColumnName(@Nullable String columnFamilyName, String columnName) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(columnName), "Column name cannot be null or empty");
        return columnFamilyName == null ? ESCAPE_CHARACTER + columnName + ESCAPE_CHARACTER : ESCAPE_CHARACTER + columnFamilyName + ESCAPE_CHARACTER + "." + ESCAPE_CHARACTER + columnName + ESCAPE_CHARACTER;
    }

    public static String getUnEscapedFullColumnName(String fullColumnName) {
        Preconditions.checkArgument(!Strings.isNullOrEmpty(fullColumnName), "Column name cannot be null or empty");
        fullColumnName = fullColumnName.replaceAll(ESCAPE_CHARACTER, "");
        return fullColumnName.trim();
    }
}

