/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;

public class ResultUtil {
    public static final Result EMPTY_RESULT = new Result(){

        @Override
        public final boolean isEmpty() {
            return true;
        }
    };
    public static final Comparator<Result> KEY_COMPARATOR = new Comparator<Result>(){

        @Override
        public int compare(Result r1, Result r2) {
            byte[] r1Bytes = ResultUtil.getRawBytes(r1);
            byte[] r2Bytes = ResultUtil.getRawBytes(r2);
            return Bytes.compareTo(r1Bytes, ResultUtil.getKeyOffset(r1), ResultUtil.getKeyLength(r1), r2Bytes, ResultUtil.getKeyOffset(r2), ResultUtil.getKeyLength(r2));
        }
    };

    private ResultUtil() {
    }

    public static Result toResult(ImmutableBytesWritable bytes) {
        int keyLength;
        int offset;
        byte[] buf = bytes.get();
        int finalOffset = bytes.getSize() + offset;
        ArrayList<Cell> kvs = new ArrayList<Cell>();
        for (offset = bytes.getOffset(); offset < finalOffset; offset += keyLength) {
            keyLength = Bytes.toInt(buf, offset);
            kvs.add(new KeyValue(buf, offset += 4, keyLength));
        }
        return Result.create(kvs);
    }

    public static ImmutableBytesWritable getKey(Result r) {
        return ResultUtil.getKey(r, 0);
    }

    public static void getKey(Result r, ImmutableBytesWritable key) {
        key.set(r.getRow());
    }

    public static void getKey(KeyValue value, ImmutableBytesWritable key) {
        key.set(value.getBuffer(), value.getRowOffset(), value.getRowLength());
    }

    public static ImmutableBytesWritable getKey(Result r, int offset) {
        return new ImmutableBytesWritable(ResultUtil.getRawBytes(r), ResultUtil.getKeyOffset(r) + offset, ResultUtil.getKeyLength(r) - offset);
    }

    public static void getKey(Result r, int offset, int length, ImmutableBytesWritable key) {
        key.set(ResultUtil.getRawBytes(r), ResultUtil.getKeyOffset(r) + offset, length);
    }

    static int getKeyOffset(Result r) {
        KeyValue firstKV = KeyValueUtil.ensureKeyValue(r.rawCells()[0]);
        return firstKV.getOffset();
    }

    static int getKeyLength(Result r) {
        return Bytes.toShort(ResultUtil.getRawBytes(r), ResultUtil.getKeyOffset(r) - 2);
    }

    static byte[] getRawBytes(Result r) {
        KeyValue firstKV = KeyValueUtil.ensureKeyValue(r.rawCells()[0]);
        return firstKV.getBuffer();
    }

    public static int compareKeys(Result r1, Result r2) {
        return Bytes.compareTo(ResultUtil.getRawBytes(r1), ResultUtil.getKeyOffset(r1), ResultUtil.getKeyLength(r1), ResultUtil.getRawBytes(r2), ResultUtil.getKeyOffset(r2), ResultUtil.getKeyLength(r2));
    }

    public static KeyValue getColumnLatest(Result r, byte[] family, byte[] qualifier) {
        byte[] rbytes = ResultUtil.getRawBytes(r);
        int roffset = ResultUtil.getKeyOffset(r);
        int rlength = ResultUtil.getKeyLength(r);
        return ResultUtil.getColumnLatest(r, rbytes, roffset, rlength, family, 0, family.length, qualifier, 0, qualifier.length);
    }

    public static KeyValue getSearchTerm(Result r, byte[] family, byte[] qualifier) {
        byte[] rbytes = ResultUtil.getRawBytes(r);
        int roffset = ResultUtil.getKeyOffset(r);
        int rlength = ResultUtil.getKeyLength(r);
        return KeyValue.createFirstOnRow(rbytes, roffset, rlength, family, 0, family.length, qualifier, 0, qualifier.length);
    }

    public static KeyValue getColumnLatest(Result r, byte[] row, int roffset, int rlength, byte[] family, int foffset, int flength, byte[] qualifier, int qoffset, int qlength) {
        KeyValue searchTerm = KeyValue.createFirstOnRow(row, roffset, rlength, family, foffset, flength, qualifier, qoffset, qlength);
        return ResultUtil.getColumnLatest(r, searchTerm);
    }

    public static KeyValue getColumnLatest(Result r, KeyValue searchTerm) {
        KeyValue[] kvs = r.raw();
        if (kvs == null || kvs.length == 0) {
            return null;
        }
        int pos = Arrays.binarySearch(kvs, searchTerm, KeyValue.COMPARATOR);
        if (pos < 0) {
            pos = (pos + 1) * -1;
        }
        if (pos == kvs.length) {
            return null;
        }
        KeyValue kv = kvs[pos];
        if (Bytes.compareTo(kv.getBuffer(), kv.getFamilyOffset(), kv.getFamilyLength(), searchTerm.getBuffer(), searchTerm.getFamilyOffset(), searchTerm.getFamilyLength()) != 0) {
            return null;
        }
        if (Bytes.compareTo(kv.getBuffer(), kv.getQualifierOffset(), kv.getQualifierLength(), searchTerm.getBuffer(), searchTerm.getQualifierOffset(), searchTerm.getQualifierLength()) != 0) {
            return null;
        }
        return kv;
    }
}

