/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

public class PhoenixStopWatch {
    private boolean isRunning;
    private long startTime;
    private long elapsedTimeMs;

    public PhoenixStopWatch start() {
        long currentTime = System.currentTimeMillis();
        if (this.isRunning) {
            throw new IllegalStateException("Watch is already running");
        }
        this.startTime = currentTime;
        this.isRunning = true;
        return this;
    }

    public PhoenixStopWatch stop() {
        long currentTime = System.currentTimeMillis();
        if (!this.isRunning) {
            throw new IllegalStateException("Watch wasn't started");
        }
        this.elapsedTimeMs = currentTime - this.startTime;
        this.startTime = 0L;
        this.isRunning = false;
        return this;
    }

    public long elapsedMillis() {
        return this.elapsedTimeMs;
    }

    public boolean isRunning() {
        return this.isRunning;
    }
}

