/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import java.util.Iterator;
import java.util.ServiceLoader;
import java.util.concurrent.ConcurrentHashMap;

public class InstanceResolver {
    private static final ConcurrentHashMap<Class, Object> RESOLVED_SINGLETONS = new ConcurrentHashMap();

    private InstanceResolver() {
    }

    public static <T> T getSingleton(Class<T> clazz, T defaultInstance) {
        Object obj = RESOLVED_SINGLETONS.get(clazz);
        if (obj != null) {
            return (T)obj;
        }
        if (defaultInstance != null && !clazz.isInstance(defaultInstance)) {
            throw new IllegalArgumentException("defaultInstance is not of type " + clazz.getName());
        }
        T o = InstanceResolver.resolveSingleton(clazz, defaultInstance);
        obj = RESOLVED_SINGLETONS.putIfAbsent(clazz, o);
        if (obj == null) {
            obj = o;
        }
        return (T)obj;
    }

    private static synchronized <T> T resolveSingleton(Class<T> clazz, T defaultInstance) {
        ServiceLoader<T> loader = ServiceLoader.load(clazz);
        Iterator<T> iterator = loader.iterator();
        if (iterator.hasNext()) {
            T singleton = iterator.next();
            return singleton;
        }
        return defaultInstance;
    }
}

