/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Map;
import java.util.TreeMap;
import org.apache.hadoop.hbase.util.Bytes;

public class FirstLastNthValueDataContainer {
    protected boolean isAscending = false;
    protected int offset;
    protected TreeMap<byte[], LinkedList<byte[]>> data;
    protected boolean isOrderValuesFixedLength = false;
    protected boolean isDataValuesFixedLength = false;

    public void setIsAscending(boolean ascending) {
        this.isAscending = ascending;
    }

    public void setData(TreeMap<byte[], LinkedList<byte[]>> topValues) {
        this.data = topValues;
    }

    public void setFixedWidthOrderValues(boolean fixedSize) {
        this.isOrderValuesFixedLength = fixedSize;
    }

    public void setFixedWidthDataValues(boolean fixedSize) {
        this.isDataValuesFixedLength = fixedSize;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public void setPayload(byte[] payload) {
        if (payload[0] == 1) {
            this.isAscending = true;
        }
        int lengthOfOrderValues = Bytes.toInt(payload, 1);
        int lengthOfDataValues = Bytes.toInt(payload, 5);
        this.data = new TreeMap(new Bytes.ByteArrayComparator());
        int payloadOffset = 13;
        for (int sizeOfMap = Bytes.toInt(payload, 9); sizeOfMap != 0; --sizeOfMap) {
            byte[] value;
            int l;
            byte[] key;
            if (lengthOfOrderValues != 0) {
                key = Bytes.copy(payload, payloadOffset, lengthOfOrderValues);
                payloadOffset += lengthOfOrderValues;
            } else {
                l = Bytes.toInt(payload, payloadOffset);
                key = Bytes.copy(payload, payloadOffset += 4, l);
                payloadOffset += l;
            }
            if (lengthOfDataValues != 0) {
                value = Bytes.copy(payload, payloadOffset, lengthOfDataValues);
                payloadOffset += lengthOfDataValues;
            } else {
                l = Bytes.toInt(payload, payloadOffset);
                value = Bytes.copy(payload, payloadOffset += 4, l);
                payloadOffset += l;
            }
            if (!this.data.containsKey(key)) {
                this.data.put(key, new LinkedList());
            }
            this.data.get(key).add(value);
        }
    }

    public byte[] getPayload() throws IOException {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        bos.write(this.isAscending ? 1 : 0);
        Map.Entry<byte[], LinkedList<byte[]>> firstEntry = this.data.firstEntry();
        if (this.isOrderValuesFixedLength) {
            bos.write(Bytes.toBytes(firstEntry.getKey().length));
        } else {
            bos.write(Bytes.toBytes(0));
        }
        if (this.isDataValuesFixedLength) {
            bos.write(Bytes.toBytes(firstEntry.getValue().getFirst().length));
        } else {
            bos.write(Bytes.toBytes(0));
        }
        int offsetForDataLength = bos.size();
        bos.write(new byte[4]);
        int valuesCount = 0;
        for (Map.Entry<byte[], LinkedList<byte[]>> entry : this.data.entrySet()) {
            ListIterator it = entry.getValue().listIterator();
            while (it.hasNext()) {
                ++valuesCount;
                byte[] itemValue = (byte[])it.next();
                if (!this.isOrderValuesFixedLength) {
                    bos.write(Bytes.toBytes(entry.getKey().length));
                }
                bos.write(entry.getKey());
                if (!this.isDataValuesFixedLength) {
                    bos.write(Bytes.toBytes(itemValue.length));
                }
                bos.write(itemValue);
            }
        }
        byte[] outputArray = bos.toByteArray();
        System.arraycopy(Bytes.toBytes(valuesCount), 0, outputArray, offsetForDataLength, 4);
        return outputArray;
    }

    public boolean getIsAscending() {
        return this.isAscending;
    }

    public TreeMap<byte[], LinkedList<byte[]>> getData() {
        return this.data;
    }
}

