/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.trace;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.metrics2.MetricsCollector;
import org.apache.hadoop.metrics2.MetricsInfo;
import org.apache.hadoop.metrics2.MetricsRecordBuilder;
import org.apache.hadoop.metrics2.MetricsSource;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.MetricsTag;
import org.apache.hadoop.metrics2.lib.Interns;
import org.apache.htrace.Span;
import org.apache.htrace.SpanReceiver;
import org.apache.htrace.TimelineAnnotation;
import org.apache.phoenix.metrics.MetricInfo;
import org.apache.phoenix.metrics.Metrics;
import org.apache.phoenix.trace.MetricsInfoImpl;
import org.apache.phoenix.trace.TracingUtils;

public class TraceMetricSource
implements SpanReceiver,
MetricsSource {
    private static final String EMPTY_STRING = "";
    private static final String CONTEXT = "tracing";
    private List<Metric> spans = new ArrayList<Metric>();

    public TraceMetricSource() {
        MetricsSystem manager = Metrics.initialize();
        manager.register(CONTEXT, "Phoenix call tracing", this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void receiveSpan(Span span) {
        Metric builder = new Metric(span);
        builder.addCounter(Interns.info(MetricInfo.SPAN.traceName, EMPTY_STRING), span.getSpanId());
        builder.addCounter(Interns.info(MetricInfo.PARENT.traceName, EMPTY_STRING), span.getParentId());
        builder.addCounter(Interns.info(MetricInfo.START.traceName, EMPTY_STRING), span.getStartTimeMillis());
        builder.addCounter(Interns.info(MetricInfo.END.traceName, EMPTY_STRING), span.getStopTimeMillis());
        for (TimelineAnnotation ta : span.getTimelineAnnotations()) {
            builder.add(new MetricsTag(Interns.info(MetricInfo.TAG.traceName, Long.toString(ta.getTime())), ta.getMessage()));
        }
        Map<byte[], byte[]> annotations = span.getKVAnnotations();
        for (Map.Entry<byte[], byte[]> annotation : annotations.entrySet()) {
            Pair<String, String> val = TracingUtils.readAnnotation(annotation.getKey(), annotation.getValue());
            builder.add(new MetricsTag(Interns.info(MetricInfo.ANNOTATION.traceName, val.getFirst()), val.getSecond()));
        }
        TraceMetricSource traceMetricSource = this;
        synchronized (traceMetricSource) {
            this.spans.add(builder);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void getMetrics(MetricsCollector collector, boolean all) {
        MetricsRecordBuilder marker = collector.addRecord("marker");
        marker.add(new MetricsTag(new MetricsInfoImpl("stat", "num spans"), Integer.toString(this.spans.size())));
        TraceMetricSource traceMetricSource = this;
        synchronized (traceMetricSource) {
            for (Metric span : this.spans) {
                MetricsRecordBuilder builder = collector.addRecord(new MetricsInfoImpl(TracingUtils.getTraceMetricName(span.id), span.desc));
                builder.setContext(CONTEXT);
                for (Pair<MetricsInfo, Long> metric : span.counters) {
                    builder.addCounter(metric.getFirst(), metric.getSecond());
                }
                for (MetricsTag tag : span.tags) {
                    builder.add(tag);
                }
            }
            this.spans = new ArrayList<Metric>();
        }
    }

    @Override
    public void close() throws IOException {
    }

    private static class Metric {
        List<Pair<MetricsInfo, Long>> counters = new ArrayList<Pair<MetricsInfo, Long>>();
        List<MetricsTag> tags = new ArrayList<MetricsTag>();
        private String id;
        private String desc;

        public Metric(Span span) {
            this.id = Long.toString(span.getTraceId());
            this.desc = span.getDescription();
        }

        public void addCounter(MetricsInfo metricsInfoImpl, long startTimeMillis) {
            this.counters.add(new Pair<MetricsInfo, Long>(metricsInfoImpl, startTimeMillis));
        }

        public void add(MetricsTag metricsTag) {
            this.tags.add(metricsTag);
        }
    }
}

