/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.tuple;

import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.schema.tuple.BaseTuple;

public class SingleKeyValueTuple
extends BaseTuple {
    private static final byte[] UNITIALIZED_KEY_BUFFER = new byte[0];
    private KeyValue keyValue;
    private ImmutableBytesWritable keyPtr = new ImmutableBytesWritable(UNITIALIZED_KEY_BUFFER);

    public SingleKeyValueTuple() {
    }

    public SingleKeyValueTuple(KeyValue keyValue) {
        if (keyValue == null) {
            throw new NullPointerException();
        }
        this.setKeyValue(keyValue);
    }

    public boolean hasKey() {
        return this.keyPtr.get() != UNITIALIZED_KEY_BUFFER;
    }

    public void reset() {
        this.keyValue = null;
        this.keyPtr.set(UNITIALIZED_KEY_BUFFER);
    }

    public void setKeyValue(KeyValue keyValue) {
        if (keyValue == null) {
            throw new IllegalArgumentException();
        }
        this.keyValue = keyValue;
        this.setKey(keyValue);
    }

    public void setKey(ImmutableBytesWritable ptr) {
        this.keyPtr.set(ptr.get(), ptr.getOffset(), ptr.getLength());
    }

    public void setKey(KeyValue keyValue) {
        if (keyValue == null) {
            throw new IllegalArgumentException();
        }
        this.keyPtr.set(keyValue.getBuffer(), keyValue.getRowOffset(), keyValue.getRowLength());
    }

    @Override
    public void getKey(ImmutableBytesWritable ptr) {
        ptr.set(this.keyPtr.get(), this.keyPtr.getOffset(), this.keyPtr.getLength());
    }

    @Override
    public KeyValue getValue(byte[] cf, byte[] cq) {
        return this.keyValue;
    }

    @Override
    public boolean isImmutable() {
        return true;
    }

    public String toString() {
        return "SingleKeyValueTuple[" + this.keyValue == null ? (this.keyPtr.get() == UNITIALIZED_KEY_BUFFER ? "null" : Bytes.toStringBinary(this.keyPtr.get(), this.keyPtr.getOffset(), this.keyPtr.getLength())) : this.keyValue.toString() + "]";
    }

    @Override
    public int size() {
        return this.keyValue == null ? 0 : 1;
    }

    @Override
    public KeyValue getValue(int index) {
        if (index != 0 || this.keyValue == null) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        return this.keyValue;
    }

    @Override
    public boolean getValue(byte[] family, byte[] qualifier, ImmutableBytesWritable ptr) {
        if (this.keyValue == null) {
            return false;
        }
        ptr.set(this.keyValue.getBuffer(), this.keyValue.getValueOffset(), this.keyValue.getValueLength());
        return true;
    }
}

