/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema.stats;

import java.io.IOException;
import java.util.Arrays;
import java.util.TreeMap;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellScanner;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.ResultScanner;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;
import org.apache.phoenix.jdbc.PhoenixDatabaseMetaData;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.stats.GuidePostsInfo;
import org.apache.phoenix.schema.stats.PTableStats;
import org.apache.phoenix.schema.stats.PTableStatsImpl;
import org.apache.phoenix.schema.types.PLong;
import org.apache.phoenix.util.ByteUtil;
import org.apache.phoenix.util.MetaDataUtil;
import org.apache.phoenix.util.SchemaUtil;

public class StatisticsUtil {
    protected static final int NUM_KEY_PARTS = 3;

    private StatisticsUtil() {
    }

    public static byte[] getRowKey(byte[] table, ImmutableBytesPtr fam, byte[] region) {
        byte[] rowKey = new byte[table.length + fam.getLength() + region.length + 2];
        int offset = 0;
        System.arraycopy(table, 0, rowKey, offset, table.length);
        offset += table.length;
        rowKey[offset++] = 0;
        System.arraycopy(fam.get(), fam.getOffset(), rowKey, offset, fam.getLength());
        offset += fam.getLength();
        rowKey[offset++] = 0;
        System.arraycopy(region, 0, rowKey, offset, region.length);
        return rowKey;
    }

    public static byte[] copyRow(KeyValue kv) {
        return Arrays.copyOfRange(kv.getRowArray(), kv.getRowOffset(), kv.getRowOffset() + kv.getRowLength());
    }

    public static Result readRegionStatistics(HTableInterface statsHTable, byte[] tableNameBytes, ImmutableBytesPtr cf, byte[] regionName, long clientTimeStamp) throws IOException {
        byte[] prefix = StatisticsUtil.getRowKey(tableNameBytes, cf, regionName);
        Get get = new Get(prefix);
        get.setTimeRange(0L, clientTimeStamp);
        get.addColumn(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, PhoenixDatabaseMetaData.GUIDE_POSTS_WIDTH_BYTES);
        get.addColumn(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, PhoenixDatabaseMetaData.GUIDE_POSTS_BYTES);
        get.addColumn(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, PhoenixDatabaseMetaData.GUIDE_POSTS_ROW_COUNT_BYTES);
        get.addColumn(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, PhoenixDatabaseMetaData.MIN_KEY_BYTES);
        return statsHTable.get(get);
    }

    public static PTableStats readStatistics(HTableInterface statsHTable, byte[] tableNameBytes, long clientTimeStamp) throws IOException {
        ImmutableBytesWritable ptr = new ImmutableBytesWritable();
        Scan s = MetaDataUtil.newTableRowsScan(tableNameBytes, 0L, clientTimeStamp);
        s.addColumn(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, PhoenixDatabaseMetaData.GUIDE_POSTS_BYTES);
        s.addColumn(QueryConstants.DEFAULT_COLUMN_FAMILY_BYTES, PhoenixDatabaseMetaData.GUIDE_POSTS_ROW_COUNT_BYTES);
        ResultScanner scanner = statsHTable.getScanner(s);
        Result result = null;
        long timeStamp = 0L;
        TreeMap<byte[], GuidePostsInfo> guidePostsPerCf = new TreeMap<byte[], GuidePostsInfo>(Bytes.BYTES_COMPARATOR);
        while ((result = scanner.next()) != null) {
            GuidePostsInfo newGPInfo;
            GuidePostsInfo oldInfo;
            CellScanner cellScanner = result.cellScanner();
            long rowCount = 0L;
            ImmutableBytesPtr valuePtr = new ImmutableBytesPtr(HConstants.EMPTY_BYTE_ARRAY);
            byte[] cfName = null;
            boolean valuesSet = false;
            while (cellScanner.advance()) {
                Cell current = cellScanner.current();
                if (!valuesSet) {
                    int tableNameLength = tableNameBytes.length + 1;
                    int cfOffset = current.getRowOffset() + tableNameLength;
                    int cfLength = SchemaUtil.getVarCharLength(current.getRowArray(), cfOffset, current.getRowLength() - tableNameLength);
                    ptr.set(current.getRowArray(), cfOffset, cfLength);
                    valuesSet = true;
                }
                cfName = ByteUtil.copyKeyBytesIfNecessary(ptr);
                if (Bytes.equals(current.getQualifierArray(), current.getQualifierOffset(), current.getQualifierLength(), PhoenixDatabaseMetaData.GUIDE_POSTS_ROW_COUNT_BYTES, 0, PhoenixDatabaseMetaData.GUIDE_POSTS_ROW_COUNT_BYTES.length)) {
                    rowCount = PLong.INSTANCE.getCodec().decodeLong(current.getValueArray(), current.getValueOffset(), SortOrder.getDefault());
                } else {
                    valuePtr.set(current.getValueArray(), current.getValueOffset(), current.getValueLength());
                }
                if (current.getTimestamp() <= timeStamp) continue;
                timeStamp = current.getTimestamp();
            }
            if (cfName == null || (oldInfo = guidePostsPerCf.put(cfName, newGPInfo = GuidePostsInfo.deserializeGuidePostsInfo(valuePtr.get(), valuePtr.getOffset(), valuePtr.getLength(), rowCount))) == null) continue;
            newGPInfo.combine(oldInfo);
        }
        if (!guidePostsPerCf.isEmpty()) {
            return new PTableStatsImpl(guidePostsPerCf, timeStamp);
        }
        return PTableStats.EMPTY_STATS;
    }

    public static long getGuidePostDepth(int guidepostPerRegion, long guidepostWidth, HTableDescriptor tableDesc) {
        if (guidepostPerRegion > 0) {
            long tableMaxFileSize;
            long maxFileSize = 0x280000000L;
            if (tableDesc != null && (tableMaxFileSize = tableDesc.getMaxFileSize()) >= 0L) {
                maxFileSize = tableMaxFileSize;
            }
            return maxFileSize / (long)guidepostPerRegion;
        }
        return guidepostWidth;
    }
}

