/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema;

import edu.umd.cs.findbugs.annotations.SuppressWarnings;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.http.annotation.Immutable;
import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.schema.PDatum;
import org.apache.phoenix.schema.SortOrder;
import org.apache.phoenix.schema.ValueBitSet;
import org.apache.phoenix.schema.ValueSchema;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.schema.types.PDataType;
import org.apache.phoenix.util.ByteUtil;

@Immutable
public class KeyValueSchema
extends ValueSchema {
    public KeyValueSchema() {
    }

    protected KeyValueSchema(int minNullable, List<ValueSchema.Field> fields) {
        super(minNullable, fields);
    }

    public boolean isNull(int position, ValueBitSet bitSet) {
        int nBit = position - this.getMinNullable();
        return nBit >= 0 && !bitSet.get(nBit);
    }

    private static byte[] ensureSize(byte[] b, int offset, int size) {
        if (size > b.length) {
            byte[] bBigger = new byte[Math.max(b.length * 2, size)];
            System.arraycopy(b, 0, bBigger, 0, b.length);
            return bBigger;
        }
        return b;
    }

    public byte[] toBytes(Expression[] expressions, ValueBitSet valueSet, ImmutableBytesWritable ptr) {
        return this.toBytes(null, expressions, valueSet, ptr);
    }

    public byte[] toBytes(Tuple tuple, Expression[] expressions, ValueBitSet valueSet, ImmutableBytesWritable ptr) {
        int offset = 0;
        int index = 0;
        valueSet.clear();
        int minNullableIndex = this.getMinNullable();
        byte[] b = new byte[this.getEstimatedValueLength() + valueSet.getEstimatedLength()];
        List<ValueSchema.Field> fields = this.getFields();
        for (int i = 0; i < fields.size(); ++i) {
            ValueSchema.Field field = fields.get(i);
            PDataType type = field.getDataType();
            for (int j = 0; j < field.getCount(); ++j) {
                if (expressions[index].evaluate(tuple, ptr) && ptr.getLength() > 0) {
                    if (index >= minNullableIndex) {
                        valueSet.set(index - minNullableIndex);
                    }
                    if (!type.isFixedWidth()) {
                        b = KeyValueSchema.ensureSize(b, offset, offset + this.getVarLengthBytes(ptr.getLength()));
                        offset = this.writeVarLengthField(ptr, b, offset);
                    } else {
                        int nBytes = ptr.getLength();
                        b = KeyValueSchema.ensureSize(b, offset, offset + nBytes);
                        System.arraycopy(ptr.get(), ptr.getOffset(), b, offset, nBytes);
                        offset += nBytes;
                    }
                }
                ++index;
            }
        }
        if ((offset = valueSet.toBytes(b = KeyValueSchema.ensureSize(b, offset, offset + valueSet.getEstimatedLength()), offset)) == b.length) {
            return b;
        }
        byte[] bExact = new byte[offset];
        System.arraycopy(b, 0, bExact, 0, offset);
        return bExact;
    }

    private int getVarLengthBytes(int length) {
        return length + WritableUtils.getVIntSize(length);
    }

    private int writeVarLengthField(ImmutableBytesWritable ptr, byte[] b, int offset) {
        int length = ptr.getLength();
        offset += ByteUtil.vintToBytes(b, offset, length);
        System.arraycopy(ptr.get(), ptr.getOffset(), b, offset, length);
        return offset += length;
    }

    @SuppressWarnings(value={"NP_BOOLEAN_RETURN_NULL"}, justification="Designed to return null.")
    public Boolean iterator(byte[] src, int srcOffset, int srcLength, ImmutableBytesWritable ptr, int position, ValueBitSet valueBitSet) {
        ptr.set(src, srcOffset, 0);
        int maxOffset = srcOffset + srcLength;
        Boolean hasValue = null;
        for (int i = 0; i < position; ++i) {
            hasValue = this.next(ptr, i, maxOffset, valueBitSet);
        }
        return hasValue;
    }

    public Boolean iterator(ImmutableBytesWritable srcPtr, ImmutableBytesWritable ptr, int position, ValueBitSet valueSet) {
        return this.iterator(srcPtr.get(), srcPtr.getOffset(), srcPtr.getLength(), ptr, position, valueSet);
    }

    public Boolean iterator(ImmutableBytesWritable ptr, int position, ValueBitSet valueSet) {
        return this.iterator(ptr, ptr, position, valueSet);
    }

    public Boolean iterator(ImmutableBytesWritable ptr) {
        return this.iterator(ptr, ptr, 0, ValueBitSet.EMPTY_VALUE_BITSET);
    }

    @SuppressWarnings(value={"NP_BOOLEAN_RETURN_NULL"}, justification="Designed to return null.")
    public Boolean next(ImmutableBytesWritable ptr, int position, int maxOffset, ValueBitSet valueSet) {
        if (ptr.getOffset() + ptr.getLength() >= maxOffset) {
            ptr.set(ptr.get(), maxOffset, 0);
            return null;
        }
        if (position >= this.getFieldCount()) {
            return null;
        }
        ptr.set(ptr.get(), ptr.getOffset() + ptr.getLength(), 0);
        if (!this.isNull(position, valueSet)) {
            int length;
            ValueSchema.Field field = this.getField(position);
            int n = length = field.getDataType().isFixedWidth() ? field.getByteSize() : ByteUtil.vintFromBytes(ptr);
            if (ptr.getOffset() + length > maxOffset) {
                throw new RuntimeException(new SQLExceptionInfo.Builder(SQLExceptionCode.ILLEGAL_DATA).setMessage("Expected length of at least " + length + " bytes, but had " + (maxOffset - ptr.getOffset())).build().buildException());
            }
            ptr.set(ptr.get(), ptr.getOffset(), length);
            return ptr.getLength() > 0;
        }
        return false;
    }

    public static class KeyValueSchemaBuilder
    extends ValueSchema.ValueSchemaBuilder {
        public KeyValueSchemaBuilder(int minNullable) {
            super(minNullable);
        }

        @Override
        public KeyValueSchema build() {
            List<ValueSchema.Field> condensedFields = this.buildFields();
            return new KeyValueSchema(this.minNullable, condensedFields);
        }

        @Override
        public KeyValueSchemaBuilder setMaxFields(int nFields) {
            super.setMaxFields(nFields);
            return this;
        }

        public KeyValueSchemaBuilder addField(PDatum datum) {
            super.addField(datum, this.fields.size() >= this.minNullable, SortOrder.getDefault());
            return this;
        }
    }
}

