/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.schema;

import org.apache.phoenix.exception.SQLExceptionCode;
import org.apache.phoenix.exception.SQLExceptionInfo;
import org.apache.phoenix.schema.MetaDataEntityNotFoundException;

public class FunctionNotFoundException
extends MetaDataEntityNotFoundException {
    private static final long serialVersionUID = 1L;
    private static SQLExceptionCode code = SQLExceptionCode.FUNCTION_UNDEFINED;
    private final String functionName;
    private final long timestamp;

    public FunctionNotFoundException(FunctionNotFoundException e, long timestamp) {
        this(e.functionName, timestamp);
    }

    public FunctionNotFoundException(String functionName) {
        this(functionName, Long.MAX_VALUE);
    }

    public FunctionNotFoundException(String functionName, long timestamp) {
        super(new SQLExceptionInfo.Builder(code).setFunctionName(functionName).build().toString(), code.getSQLState(), code.getErrorCode(), null);
        this.functionName = functionName;
        this.timestamp = timestamp;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public long getTimeStamp() {
        return this.timestamp;
    }
}

