/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.monitoring;

import java.util.concurrent.atomic.AtomicLong;
import org.apache.phoenix.monitoring.Metric;

class SizeStatistic
implements Metric {
    private final AtomicLong total = new AtomicLong(0L);
    private final AtomicLong numSamples = new AtomicLong(0L);
    private final String name;
    private final String description;

    public SizeStatistic(String name, String description) {
        this.name = name;
        this.description = description;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getDescription() {
        return this.description;
    }

    @Override
    public void reset() {
        this.total.set(0L);
        this.numSamples.set(0L);
    }

    @Override
    public String getCurrentMetricState() {
        return "Name:" + this.description + ", Total: " + this.total.get() + ", Number of samples: " + this.numSamples.get();
    }

    @Override
    public long getNumberOfSamples() {
        return this.numSamples.get();
    }

    @Override
    public long getTotalSum() {
        return this.total.get();
    }

    public long add(long value) {
        this.numSamples.incrementAndGet();
        return this.total.addAndGet(value);
    }
}

