/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.metrics;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.metrics2.MetricsSystem;
import org.apache.hadoop.metrics2.lib.DefaultMetricsSystem;

public class Metrics {
    private static final Log LOG = LogFactory.getLog(Metrics.class);
    private static volatile MetricsSystem manager = DefaultMetricsSystem.instance();
    private static boolean initialized;
    public static final String METRICS_SYSTEM_NAME = "phoenix";
    private static volatile boolean sinkInitialized;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static MetricsSystem initialize() {
        if (manager == null) {
            LOG.warn("Phoenix metrics could not be initialized - no MetricsManager found!");
            return null;
        }
        Class<Metrics> clazz = Metrics.class;
        synchronized (Metrics.class) {
            if (!initialized) {
                LOG.info("Initializing metrics system: phoenix");
                manager.init(METRICS_SYSTEM_NAME);
                initialized = true;
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return manager;
        }
    }

    public static void markSinkInitialized() {
        sinkInitialized = true;
    }

    public static void ensureConfigured() {
        if (!sinkInitialized) {
            LOG.warn("Phoenix metrics2/tracing sink was not started. Should be it be?");
        }
    }

    static {
        sinkInitialized = false;
    }
}

