/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce.util;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.lib.db.DBWritable;
import org.apache.phoenix.mapreduce.PhoenixInputFormat;
import org.apache.phoenix.mapreduce.PhoenixOutputFormat;
import org.apache.phoenix.mapreduce.util.PhoenixConfigurationUtil;

public final class PhoenixMapReduceUtil {
    private PhoenixMapReduceUtil() {
    }

    public static void setInput(Job job, Class<? extends DBWritable> inputClass, String tableName, String conditions, String ... fieldNames) {
        job.setInputFormatClass(PhoenixInputFormat.class);
        Configuration configuration = job.getConfiguration();
        PhoenixConfigurationUtil.setInputTableName(configuration, tableName);
        PhoenixConfigurationUtil.setSelectColumnNames(configuration, fieldNames);
        PhoenixConfigurationUtil.setInputClass(configuration, inputClass);
        PhoenixConfigurationUtil.setSchemaType(configuration, PhoenixConfigurationUtil.SchemaType.TABLE);
    }

    public static void setInput(Job job, Class<? extends DBWritable> inputClass, String tableName, String inputQuery) {
        job.setInputFormatClass(PhoenixInputFormat.class);
        Configuration configuration = job.getConfiguration();
        PhoenixConfigurationUtil.setInputTableName(configuration, tableName);
        PhoenixConfigurationUtil.setInputQuery(configuration, inputQuery);
        PhoenixConfigurationUtil.setInputClass(configuration, inputClass);
        PhoenixConfigurationUtil.setSchemaType(configuration, PhoenixConfigurationUtil.SchemaType.QUERY);
    }

    public static void setInputCluster(Job job, String quorum) {
        Configuration configuration = job.getConfiguration();
        PhoenixConfigurationUtil.setInputCluster(configuration, quorum);
    }

    public static void setOutput(Job job, String tableName, String columns) {
        job.setOutputFormatClass(PhoenixOutputFormat.class);
        Configuration configuration = job.getConfiguration();
        PhoenixConfigurationUtil.setOutputTableName(configuration, tableName);
        PhoenixConfigurationUtil.setUpsertColumnNames(configuration, columns.split(","));
    }

    public static void setOutput(Job job, String tableName, String ... fieldNames) {
        job.setOutputFormatClass(PhoenixOutputFormat.class);
        Configuration configuration = job.getConfiguration();
        PhoenixConfigurationUtil.setOutputTableName(configuration, tableName);
        PhoenixConfigurationUtil.setUpsertColumnNames(configuration, fieldNames);
    }

    public static void setOutputCluster(Job job, String quorum) {
        Configuration configuration = job.getConfiguration();
        PhoenixConfigurationUtil.setOutputCluster(configuration, quorum);
    }
}

