/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.mapreduce;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ClientProtos;
import org.apache.hadoop.io.Writable;
import org.apache.hadoop.io.WritableUtils;
import org.apache.hadoop.mapreduce.InputSplit;
import org.apache.phoenix.query.KeyRange;

public class PhoenixInputSplit
extends InputSplit
implements Writable {
    private List<Scan> scans;
    private KeyRange keyRange;

    public PhoenixInputSplit() {
    }

    public PhoenixInputSplit(List<Scan> scans) {
        Preconditions.checkNotNull(scans);
        Preconditions.checkState(!scans.isEmpty());
        this.scans = scans;
        this.init();
    }

    public List<Scan> getScans() {
        return this.scans;
    }

    public KeyRange getKeyRange() {
        return this.keyRange;
    }

    private void init() {
        this.keyRange = KeyRange.getKeyRange(this.scans.get(0).getStartRow(), this.scans.get(this.scans.size() - 1).getStopRow());
    }

    @Override
    public void readFields(DataInput input) throws IOException {
        int count = WritableUtils.readVInt(input);
        this.scans = Lists.newArrayListWithExpectedSize(count);
        for (int i = 0; i < count; ++i) {
            byte[] protoScanBytes = new byte[WritableUtils.readVInt(input)];
            input.readFully(protoScanBytes);
            ClientProtos.Scan protoScan = ClientProtos.Scan.parseFrom(protoScanBytes);
            Scan scan = ProtobufUtil.toScan(protoScan);
            this.scans.add(scan);
        }
        this.init();
    }

    @Override
    public void write(DataOutput output) throws IOException {
        Preconditions.checkNotNull(this.scans);
        WritableUtils.writeVInt(output, this.scans.size());
        for (Scan scan : this.scans) {
            ClientProtos.Scan protoScan = ProtobufUtil.toScan(scan);
            byte[] protoScanBytes = protoScan.toByteArray();
            WritableUtils.writeVInt(output, protoScanBytes.length);
            output.write(protoScanBytes);
        }
    }

    @Override
    public long getLength() throws IOException, InterruptedException {
        return 0L;
    }

    @Override
    public String[] getLocations() throws IOException, InterruptedException {
        return new String[0];
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.keyRange.hashCode();
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof PhoenixInputSplit)) {
            return false;
        }
        PhoenixInputSplit other = (PhoenixInputSplit)obj;
        return !(this.keyRange == null ? other.keyRange != null : !this.keyRange.equals(other.keyRange));
    }
}

