/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.job;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.AbstractQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.FutureTask;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.RunnableFuture;
import java.util.concurrent.SynchronousQueue;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.phoenix.job.AbstractRoundRobinQueue;
import org.apache.phoenix.monitoring.PhoenixMetrics;

public class JobManager<T>
extends AbstractRoundRobinQueue<T> {
    private static final AtomicLong PHOENIX_POOL_INDEX = new AtomicLong(1L);

    public JobManager(int maxSize) {
        super(maxSize, true);
    }

    @Override
    protected Object extractProducer(T o) {
        if (o instanceof JobFutureTask) {
            return ((JobFutureTask)o).getJobId();
        }
        return o;
    }

    public static ThreadPoolExecutor createThreadPoolExec(int keepAliveMs, int size, int queueSize, boolean useInstrumentedThreadPool) {
        AbstractQueue queue = queueSize == 0 ? new SynchronousQueue() : new JobManager(queueSize);
        String name = "phoenix-" + PHOENIX_POOL_INDEX.getAndIncrement();
        ThreadFactory threadFactory = new ThreadFactoryBuilder().setNameFormat(name + "-thread-%s").setDaemon(true).setThreadFactory(new ContextClassLoaderThreadFactory(JobManager.class.getClassLoader())).build();
        ThreadPoolExecutor exec = useInstrumentedThreadPool ? new InstrumentedThreadPoolExecutor(name, size, size, (long)keepAliveMs, TimeUnit.MILLISECONDS, (BlockingQueue)((Object)queue), threadFactory){

            @Override
            protected <T> RunnableFuture<T> newTaskFor(Callable<T> call) {
                return new InstrumentedJobFutureTask<T>(call);
            }

            @Override
            protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
                return new InstrumentedJobFutureTask<T>(runnable, value);
            }
        } : new ThreadPoolExecutor(size, size, (long)keepAliveMs, TimeUnit.MILLISECONDS, (BlockingQueue)((Object)queue), threadFactory){

            @Override
            protected <T> RunnableFuture<T> newTaskFor(Callable<T> call) {
                return new JobFutureTask<T>(call);
            }

            @Override
            protected <T> RunnableFuture<T> newTaskFor(Runnable runnable, T value) {
                return new JobFutureTask<T>(runnable, value);
            }
        };
        exec.allowCoreThreadTimeOut(true);
        return exec;
    }

    private static class InstrumentedThreadPoolExecutor
    extends ThreadPoolExecutor {
        private final RejectedExecutionHandler rejectedExecHandler = new RejectedExecutionHandler(){

            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                PhoenixMetrics.CountMetric.REJECTED_TASK_COUNT.increment();
                throw new RejectedExecutionException("Task " + r.toString() + " rejected from " + executor.toString());
            }
        };

        public InstrumentedThreadPoolExecutor(String threadPoolName, int corePoolSize, int maximumPoolSize, long keepAliveTime, TimeUnit unit, BlockingQueue<Runnable> workQueue, ThreadFactory threadFactory) {
            super(corePoolSize, maximumPoolSize, keepAliveTime, unit, workQueue, threadFactory);
            this.setRejectedExecutionHandler(this.rejectedExecHandler);
        }

        @Override
        public void execute(Runnable task) {
            PhoenixMetrics.CountMetric.TASK_COUNT.increment();
            super.execute(task);
        }

        @Override
        protected void beforeExecute(Thread worker, Runnable task) {
            InstrumentedJobFutureTask instrumentedTask = (InstrumentedJobFutureTask)task;
            PhoenixMetrics.SizeMetric.TASK_QUEUE_WAIT_TIME.update(System.currentTimeMillis() - instrumentedTask.getTaskSubmissionTime());
            super.beforeExecute(worker, instrumentedTask);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void afterExecute(Runnable task, Throwable t) {
            InstrumentedJobFutureTask instrumentedTask = (InstrumentedJobFutureTask)task;
            try {
                super.afterExecute(instrumentedTask, t);
            }
            finally {
                PhoenixMetrics.SizeMetric.TASK_EXECUTION_TIME.update(System.currentTimeMillis() - instrumentedTask.getTaskExecutionStartTime());
                PhoenixMetrics.SizeMetric.TASK_END_TO_END_TIME.update(System.currentTimeMillis() - instrumentedTask.getTaskSubmissionTime());
            }
        }
    }

    static class ContextClassLoaderThreadFactory
    implements ThreadFactory {
        private final ThreadFactory baseFactory = Executors.defaultThreadFactory();
        private final ClassLoader contextClassLoader;

        public ContextClassLoaderThreadFactory(ClassLoader contextClassLoader) {
            this.contextClassLoader = contextClassLoader;
        }

        @Override
        public Thread newThread(Runnable r) {
            Thread t = this.baseFactory.newThread(r);
            t.setContextClassLoader(this.contextClassLoader);
            return t;
        }
    }

    public static interface JobCallable<T>
    extends Callable<T> {
        public Object getJobId();
    }

    private static class InstrumentedJobFutureTask<T>
    extends JobFutureTask<T> {
        private final long taskSubmissionTime = System.currentTimeMillis();
        private long taskExecutionStartTime;

        public InstrumentedJobFutureTask(Runnable r, T t) {
            super(r, t);
        }

        public InstrumentedJobFutureTask(Callable<T> c) {
            super(c);
        }

        @Override
        public void run() {
            this.taskExecutionStartTime = System.currentTimeMillis();
            super.run();
        }

        public long getTaskSubmissionTime() {
            return this.taskSubmissionTime;
        }

        public long getTaskExecutionStartTime() {
            return this.taskExecutionStartTime;
        }
    }

    static class JobFutureTask<T>
    extends FutureTask<T> {
        private final Object jobId;

        public JobFutureTask(Runnable r, T t) {
            super(r, t);
            this.jobId = r instanceof JobRunnable ? ((JobRunnable)r).getJobId() : this;
        }

        public JobFutureTask(Callable<T> c) {
            super(c);
            this.jobId = c instanceof JobCallable ? ((JobCallable)c).getJobId() : this;
        }

        public Object getJobId() {
            return this.jobId;
        }
    }

    public static interface JobRunnable<T>
    extends Runnable {
        public Object getJobId();
    }
}

