/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import java.sql.SQLException;
import java.util.List;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.Expression;
import org.apache.phoenix.expression.OrderByExpression;
import org.apache.phoenix.iterate.MergeSortResultIterator;
import org.apache.phoenix.iterate.ResultIterators;
import org.apache.phoenix.schema.tuple.Tuple;

public class MergeSortTopNResultIterator
extends MergeSortResultIterator {
    private final int limit;
    private int count = 0;
    private final List<OrderByExpression> orderByColumns;
    private final ImmutableBytesWritable ptr1 = new ImmutableBytesWritable();
    private final ImmutableBytesWritable ptr2 = new ImmutableBytesWritable();

    public MergeSortTopNResultIterator(ResultIterators iterators, Integer limit, List<OrderByExpression> orderByColumns) {
        super(iterators);
        this.limit = limit == null ? -1 : limit;
        this.orderByColumns = orderByColumns;
    }

    @Override
    protected int compare(Tuple t1, Tuple t2) {
        for (int i = 0; i < this.orderByColumns.size(); ++i) {
            boolean isNull2;
            OrderByExpression order = this.orderByColumns.get(i);
            Expression orderExpr = order.getExpression();
            boolean isNull1 = !orderExpr.evaluate(t1, this.ptr1) || this.ptr1.getLength() == 0;
            boolean bl = isNull2 = !orderExpr.evaluate(t2, this.ptr2) || this.ptr2.getLength() == 0;
            if (isNull1 && isNull2) continue;
            if (isNull1) {
                return order.isNullsLast() ? 1 : -1;
            }
            if (isNull2) {
                return order.isNullsLast() ? -1 : 1;
            }
            int cmp = this.ptr1.compareTo(this.ptr2);
            if (cmp == 0) continue;
            return order.isAscending() ? cmp : -cmp;
        }
        return 0;
    }

    @Override
    public Tuple peek() throws SQLException {
        if (this.limit >= 0 && this.count >= this.limit) {
            return null;
        }
        return super.peek();
    }

    @Override
    public Tuple next() throws SQLException {
        if (this.limit >= 0 && this.count++ >= this.limit) {
            return null;
        }
        return super.next();
    }

    @Override
    public void explain(List<String> planSteps) {
        this.resultIterators.explain(planSteps);
        planSteps.add("CLIENT MERGE SORT");
    }

    public String toString() {
        return "MergeSortTopNResultIterator [limit=" + this.limit + ", count=" + this.count + ", orderByColumns=" + this.orderByColumns + ", ptr1=" + this.ptr1 + ", ptr2=" + this.ptr2 + "]";
    }
}

