/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.iterate;

import java.sql.SQLException;
import java.util.List;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.phoenix.expression.aggregator.Aggregator;
import org.apache.phoenix.expression.aggregator.Aggregators;
import org.apache.phoenix.iterate.AggregatingResultIterator;
import org.apache.phoenix.iterate.PeekingResultIterator;
import org.apache.phoenix.query.QueryConstants;
import org.apache.phoenix.schema.tuple.Tuple;
import org.apache.phoenix.util.KeyValueUtil;

public abstract class BaseGroupedAggregatingResultIterator
implements AggregatingResultIterator {
    private static final byte[] UNITIALIZED_KEY_BUFFER = new byte[0];
    protected final PeekingResultIterator resultIterator;
    protected final Aggregators aggregators;
    private ImmutableBytesWritable currentKey;
    private ImmutableBytesWritable nextKey;

    public BaseGroupedAggregatingResultIterator(PeekingResultIterator resultIterator, Aggregators aggregators) {
        if (resultIterator == null) {
            throw new NullPointerException();
        }
        if (aggregators == null) {
            throw new NullPointerException();
        }
        this.resultIterator = resultIterator;
        this.aggregators = aggregators;
        this.currentKey = new ImmutableBytesWritable(UNITIALIZED_KEY_BUFFER);
        this.nextKey = new ImmutableBytesWritable(UNITIALIZED_KEY_BUFFER);
    }

    protected abstract ImmutableBytesWritable getGroupingKey(Tuple var1, ImmutableBytesWritable var2) throws SQLException;

    protected abstract Tuple wrapKeyValueAsResult(KeyValue var1) throws SQLException;

    @Override
    public Tuple next() throws SQLException {
        Tuple result = this.resultIterator.next();
        if (result == null) {
            return null;
        }
        if (this.currentKey.get() == UNITIALIZED_KEY_BUFFER) {
            this.getGroupingKey(result, this.currentKey);
        }
        Aggregator[] rowAggregators = this.aggregators.getAggregators();
        this.aggregators.reset(rowAggregators);
        while (true) {
            this.aggregators.aggregate(rowAggregators, result);
            Tuple nextResult = this.resultIterator.peek();
            if (nextResult == null || !this.currentKey.equals(this.getGroupingKey(nextResult, this.nextKey))) break;
            result = this.resultIterator.next();
        }
        byte[] value = this.aggregators.toBytes(rowAggregators);
        Tuple tuple = this.wrapKeyValueAsResult(KeyValueUtil.newKeyValue(this.currentKey, QueryConstants.SINGLE_COLUMN_FAMILY, QueryConstants.SINGLE_COLUMN, Long.MAX_VALUE, value, 0, value.length));
        this.currentKey.set(this.nextKey.get(), this.nextKey.getOffset(), this.nextKey.getLength());
        return tuple;
    }

    @Override
    public void close() throws SQLException {
        this.resultIterator.close();
    }

    @Override
    public void aggregate(Tuple result) {
        Aggregator[] rowAggregators = this.aggregators.getAggregators();
        this.aggregators.reset(rowAggregators);
        this.aggregators.aggregate(rowAggregators, result);
    }

    @Override
    public void explain(List<String> planSteps) {
        this.resultIterator.explain(planSteps);
    }
}

