/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.write;

import com.google.common.collect.Multimap;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.Stoppable;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.HTableInterface;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.phoenix.hbase.index.exception.IndexWriteException;
import org.apache.phoenix.hbase.index.exception.SingleIndexWriteFailureException;
import org.apache.phoenix.hbase.index.parallel.EarlyExitFailure;
import org.apache.phoenix.hbase.index.parallel.QuickFailingTaskRunner;
import org.apache.phoenix.hbase.index.parallel.Task;
import org.apache.phoenix.hbase.index.parallel.TaskBatch;
import org.apache.phoenix.hbase.index.parallel.ThreadPoolBuilder;
import org.apache.phoenix.hbase.index.parallel.ThreadPoolManager;
import org.apache.phoenix.hbase.index.table.CachingHTableFactory;
import org.apache.phoenix.hbase.index.table.HTableFactory;
import org.apache.phoenix.hbase.index.table.HTableInterfaceReference;
import org.apache.phoenix.hbase.index.util.KeyValueBuilder;
import org.apache.phoenix.hbase.index.write.IndexCommitter;
import org.apache.phoenix.hbase.index.write.IndexWriter;
import org.apache.phoenix.hbase.index.write.IndexWriterUtils;

public class ParallelWriterIndexCommitter
implements IndexCommitter {
    public static final String NUM_CONCURRENT_INDEX_WRITER_THREADS_CONF_KEY = "index.writer.threads.max";
    private static final int DEFAULT_CONCURRENT_INDEX_WRITER_THREADS = 10;
    private static final String INDEX_WRITER_KEEP_ALIVE_TIME_CONF_KEY = "index.writer.threads.keepalivetime";
    private static final Log LOG = LogFactory.getLog(ParallelWriterIndexCommitter.class);
    private HTableFactory factory;
    private Stoppable stopped;
    private QuickFailingTaskRunner pool;
    private KeyValueBuilder kvBuilder;
    private RegionCoprocessorEnvironment env;

    public ParallelWriterIndexCommitter() {
    }

    public ParallelWriterIndexCommitter(String hbaseVersion) {
        this.kvBuilder = KeyValueBuilder.get(hbaseVersion);
    }

    @Override
    public void setup(IndexWriter parent, RegionCoprocessorEnvironment env, String name) {
        this.env = env;
        Configuration conf = env.getConfiguration();
        this.setup(IndexWriterUtils.getDefaultDelegateHTableFactory(env), ThreadPoolManager.getExecutor(new ThreadPoolBuilder(name, conf).setMaxThread(NUM_CONCURRENT_INDEX_WRITER_THREADS_CONF_KEY, 10).setCoreTimeout(INDEX_WRITER_KEEP_ALIVE_TIME_CONF_KEY), env), env.getRegionServerServices(), parent, CachingHTableFactory.getCacheSize(conf));
        this.kvBuilder = KeyValueBuilder.get(env.getHBaseVersion());
    }

    void setup(HTableFactory factory, ExecutorService pool, Abortable abortable, Stoppable stop, int cacheSize) {
        this.factory = new CachingHTableFactory(factory, cacheSize);
        this.pool = new QuickFailingTaskRunner(pool);
        this.stopped = stop;
    }

    @Override
    public void write(Multimap<HTableInterfaceReference, Mutation> toWrite) throws IndexWriteException {
        this.write(toWrite, false);
    }

    @Override
    public void write(Multimap<HTableInterfaceReference, Mutation> toWrite, final boolean allowLocalUpdates) throws SingleIndexWriteFailureException {
        Set<Map.Entry<HTableInterfaceReference, Collection<Mutation>>> entries = toWrite.asMap().entrySet();
        TaskBatch<Void> tasks = new TaskBatch<Void>(entries.size());
        for (Map.Entry<HTableInterfaceReference, Collection<Mutation>> entry : entries) {
            final List<Mutation> mutations = this.kvBuilder.cloneIfNecessary((List)entry.getValue());
            final HTableInterfaceReference tableReference = entry.getKey();
            final RegionCoprocessorEnvironment env = this.env;
            tasks.add(new Task<Void>(){

                @Override
                public Void call() throws Exception {
                    this.throwFailureIfDone();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Writing index update:" + mutations + " to table: " + tableReference);
                    }
                    try {
                        block10: {
                            try {
                                if (env != null && tableReference.getTableName().equals(env.getRegion().getTableDesc().getNameAsString())) {
                                    this.throwFailureIfDone();
                                    if (allowLocalUpdates) {
                                        for (Mutation m : mutations) {
                                            m.setDurability(Durability.SKIP_WAL);
                                        }
                                        env.getRegion().batchMutate(mutations.toArray(new Mutation[mutations.size()]), 0L, 0L);
                                    }
                                    return null;
                                }
                            }
                            catch (IOException ignord) {
                                if (!LOG.isDebugEnabled()) break block10;
                                LOG.debug("indexRegion.batchMutate failed and fall back to HTable.batch(). Got error=" + ignord);
                            }
                        }
                        HTableInterface table = ParallelWriterIndexCommitter.this.factory.getTable(tableReference.get());
                        this.throwFailureIfDone();
                        table.batch(mutations);
                    }
                    catch (SingleIndexWriteFailureException e) {
                        throw e;
                    }
                    catch (IOException e) {
                        throw new SingleIndexWriteFailureException(tableReference.toString(), mutations, e);
                    }
                    catch (InterruptedException e) {
                        Thread.currentThread().interrupt();
                        throw new SingleIndexWriteFailureException(tableReference.toString(), mutations, e);
                    }
                    return null;
                }

                private void throwFailureIfDone() throws SingleIndexWriteFailureException {
                    if (this.isBatchFailed() || Thread.currentThread().isInterrupted()) {
                        throw new SingleIndexWriteFailureException("Pool closed, not attempting to write to the index!", null);
                    }
                }
            });
        }
        try {
            this.pool.submitUninterruptible(tasks);
        }
        catch (EarlyExitFailure e) {
            this.propagateFailure(e);
        }
        catch (ExecutionException e) {
            LOG.error("Found a failed index update!");
            this.propagateFailure(e.getCause());
        }
    }

    private void propagateFailure(Throwable throwable) throws SingleIndexWriteFailureException {
        try {
            throw throwable;
        }
        catch (SingleIndexWriteFailureException e1) {
            throw e1;
        }
        catch (Throwable e1) {
            throw new SingleIndexWriteFailureException("Got an abort notification while writing to the index!", e1);
        }
    }

    @Override
    public void stop(String why) {
        LOG.info("Shutting down " + this.getClass().getSimpleName() + " because " + why);
        this.pool.stop(why);
        this.factory.shutdown();
    }

    @Override
    public boolean isStopped() {
        return this.stopped.isStopped();
    }
}

