/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.table;

import org.apache.hadoop.hbase.util.Bytes;
import org.apache.phoenix.hbase.index.util.ImmutableBytesPtr;

public class HTableInterfaceReference {
    private ImmutableBytesPtr tableName;

    public HTableInterfaceReference(ImmutableBytesPtr tableName) {
        this.tableName = tableName;
    }

    public ImmutableBytesPtr get() {
        return this.tableName;
    }

    public String getTableName() {
        return Bytes.toString(this.tableName.get(), this.tableName.getOffset(), this.tableName.getLength());
    }

    public int hashCode() {
        return this.tableName.hashCode();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        HTableInterfaceReference other = (HTableInterfaceReference)obj;
        return this.tableName.equals(other.tableName);
    }

    public String toString() {
        return Bytes.toString(this.tableName.get());
    }
}

