/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.covered.filter;

import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.KeyValueUtil;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.FilterBase;
import org.apache.hadoop.hbase.util.Bytes;

public class MaxTimestampFilter
extends FilterBase {
    private long ts;

    public MaxTimestampFilter(long maxTime) {
        this.ts = maxTime;
    }

    @Override
    public Cell getNextCellHint(Cell currentKV) {
        KeyValue kv = null;
        try {
            kv = KeyValueUtil.ensureKeyValue(currentKV).clone();
        }
        catch (CloneNotSupportedException e) {
            throw new IllegalArgumentException(e);
        }
        int offset = kv.getTimestampOffset();
        byte[] buffer = kv.getBuffer();
        byte[] ts = Bytes.toBytes(this.ts);
        System.arraycopy(ts, 0, buffer, offset, ts.length);
        return kv;
    }

    @Override
    public Filter.ReturnCode filterKeyValue(Cell v) {
        long timestamp = v.getTimestamp();
        if (timestamp > this.ts) {
            return Filter.ReturnCode.SEEK_NEXT_USING_HINT;
        }
        return Filter.ReturnCode.INCLUDE;
    }
}

