/*
 * Decompiled with CFR 0.152.
 */
package org.apache.phoenix.hbase.index.covered.example;

import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import org.apache.hadoop.hbase.HColumnDescriptor;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.client.HBaseAdmin;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.phoenix.hbase.index.covered.Batch;
import org.apache.phoenix.hbase.index.covered.CoveredColumnsIndexBuilder;
import org.apache.phoenix.hbase.index.covered.LocalTableState;
import org.apache.phoenix.hbase.index.covered.example.CoveredColumnIndexCodec;
import org.apache.phoenix.hbase.index.covered.update.IndexUpdateManager;

public class CoveredColumnIndexer
extends CoveredColumnsIndexBuilder {
    public static void createIndexTable(HBaseAdmin admin, String indexTable) throws IOException {
        CoveredColumnIndexer.createIndexTable(admin, new HTableDescriptor(indexTable));
    }

    public static void createIndexTable(HBaseAdmin admin, HTableDescriptor index) throws IOException {
        HColumnDescriptor col = new HColumnDescriptor(CoveredColumnIndexCodec.INDEX_ROW_COLUMN_FAMILY);
        col.setKeepDeletedCells(true);
        index.addFamily(col);
        admin.createTable(index);
    }

    @Override
    public Collection<Pair<Mutation, byte[]>> getIndexUpdateForFilteredRows(Collection<KeyValue> filtered) throws IOException {
        IndexUpdateManager updateMap = new IndexUpdateManager();
        Collection<Batch> batches = this.batchByRow(filtered);
        for (Batch batch : batches) {
            KeyValue curKV = batch.getKvs().iterator().next();
            Put p = new Put(curKV.getRowArray(), curKV.getRowOffset(), curKV.getRowLength());
            for (KeyValue kv : batch.getKvs()) {
                byte type = kv.getTypeByte();
                KeyValue.Type t = KeyValue.Type.codeToType(type);
                if (!t.equals((Object)KeyValue.Type.Put)) continue;
                p.add(kv);
            }
            Collection<Batch> timeBatch = this.createTimestampBatchesFromMutation(p);
            LocalTableState state = new LocalTableState(this.env, this.localTable, p);
            for (Batch entry : timeBatch) {
                state.setCurrentTimestamp(entry.getTimestamp());
                this.addDeleteUpdatesToMap(updateMap, state, entry.getTimestamp());
            }
        }
        return updateMap.toMap();
    }

    private Collection<Batch> batchByRow(Collection<KeyValue> filtered) {
        HashMap<Long, Batch> batches = new HashMap<Long, Batch>();
        this.createTimestampBatchesFromKeyValues(filtered, batches);
        return batches.values();
    }
}

